/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.ResultSet;
import java.sql.SQLWarning;
import org.hsqldb.g.a;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.JDBCUtil;

class JDBCStatementBase {
    volatile boolean isClosed;
    protected boolean isEscapeProcessing = true;
    protected JDBCConnection connection;
    protected int maxRows;
    protected int fetchSize = 0;
    protected int fetchDirection = 1000;
    protected a resultIn;
    protected a errorResult;
    protected a generatedResult;
    protected int rsProperties;
    protected a resultOut;
    protected a batchResultOut;
    protected JDBCResultSet currentResultSet;
    protected JDBCResultSet generatedResultSet;
    protected SQLWarning rootWarning;
    protected int resultSetCounter;
    protected int queryTimeout;
    int connectionIncarnation;
    static final int CLOSE_CURRENT_RESULT = 1;
    static final int KEEP_CURRENT_RESULT = 2;
    static final int CLOSE_ALL_RESULTS = 3;
    static final int SUCCESS_NO_INFO = -2;
    static final int EXECUTE_FAILED = -3;
    static final int RETURN_GENERATED_KEYS = 1;
    static final int NO_GENERATED_KEYS = 2;

    JDBCStatementBase() {
    }

    public synchronized void close() {
    }

    void checkClosed() {
        if (this.isClosed) {
            throw JDBCUtil.sqlException(1251);
        }
        if (this.connection.isClosed) {
            this.close();
            throw JDBCUtil.sqlException(1353);
        }
        if (this.connectionIncarnation != this.connection.incarnation) {
            throw JDBCUtil.sqlException(1353);
        }
    }

    void performPostExecute() {
        this.resultOut.clearLobResults();
        this.generatedResult = null;
        if (this.resultIn == null) {
            return;
        }
        this.rootWarning = null;
        a a2 = this.resultIn;
        while (a2.getChainedResult() != null) {
            if ((a2 = a2.getUnlinkChainedResult()).getType() == 19) {
                SQLWarning sQLWarning = JDBCUtil.sqlWarning(a2);
                if (this.rootWarning == null) {
                    this.rootWarning = sQLWarning;
                    continue;
                }
                this.rootWarning.setNextWarning(sQLWarning);
                continue;
            }
            if (a2.getType() == 2) {
                this.errorResult = a2;
                continue;
            }
            if (a2.getType() == 20) {
                this.generatedResult = a2;
                continue;
            }
            if (a2.getType() != 3) continue;
            this.resultIn.addChainedResult(a2);
        }
        if (this.rootWarning != null) {
            this.connection.setWarnings(this.rootWarning);
        }
    }

    int getUpdateCount() {
        this.checkClosed();
        return this.resultIn == null || this.resultIn.isData() ? -1 : this.resultIn.getUpdateCount();
    }

    ResultSet getResultSet() {
        this.checkClosed();
        JDBCResultSet jDBCResultSet = this.currentResultSet;
        if (!this.connection.isCloseResultSet) {
            this.currentResultSet = null;
        }
        if (jDBCResultSet == null && this.resultOut.getStatementType() == 2) {
            return JDBCResultSet.newEptyResultSet();
        }
        return jDBCResultSet;
    }

    boolean getMoreResults() {
        return this.getMoreResults(1);
    }

    boolean getMoreResults(int n2) {
        this.checkClosed();
        if (this.resultIn == null) {
            return false;
        }
        this.resultIn = this.resultIn.getChainedResult();
        if (this.currentResultSet != null && n2 != 2) {
            this.currentResultSet.close();
        }
        this.currentResultSet = null;
        if (this.resultIn != null) {
            this.currentResultSet = new JDBCResultSet(this.connection, this, this.resultIn, this.resultIn.metaData);
            return true;
        }
        return false;
    }

    ResultSet getGeneratedResultSet() {
        if (this.generatedResultSet != null) {
            this.generatedResultSet.close();
        }
        if (this.generatedResult == null) {
            this.generatedResult = a.emptyGeneratedResult;
        }
        this.generatedResultSet = new JDBCResultSet(this.connection, null, this.generatedResult, this.generatedResult.metaData);
        return this.generatedResultSet;
    }

    void closeResultData() {
        if (this.currentResultSet != null) {
            this.currentResultSet.close();
        }
        if (this.generatedResultSet != null) {
            this.generatedResultSet.close();
        }
        this.generatedResultSet = null;
        this.generatedResult = null;
        this.resultIn = null;
        this.currentResultSet = null;
    }

    public void closeOnCompletion() {
        this.checkClosed();
    }

    public boolean isCloseOnCompletion() {
        this.checkClosed();
        return false;
    }
}

