/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Wrapper;
import org.hsqldb.aa;
import org.hsqldb.d.c;
import org.hsqldb.g.a;
import org.hsqldb.g.d;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.JDBCStatementBase;
import org.hsqldb.jdbc.JDBCUtil;

public class JDBCStatement
extends JDBCStatementBase
implements Statement,
Wrapper {
    boolean poolable = false;

    @Override
    public synchronized ResultSet executeQuery(String string) {
        this.fetchResult(string, 2, 2, null, null);
        return this.getResultSet();
    }

    @Override
    public synchronized int executeUpdate(String string) {
        this.fetchResult(string, 1, 2, null, null);
        return this.resultIn.getUpdateCount();
    }

    @Override
    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.closeResultData();
        this.batchResultOut = null;
        this.connection = null;
        this.resultIn = null;
        this.resultOut = null;
        this.isClosed = true;
    }

    @Override
    public synchronized int getMaxFieldSize() {
        this.checkClosed();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int n2) {
        this.checkClosed();
        if (n2 < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
    }

    @Override
    public synchronized int getMaxRows() {
        this.checkClosed();
        return this.maxRows;
    }

    @Override
    public synchronized void setMaxRows(int n2) {
        this.checkClosed();
        if (n2 < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        this.maxRows = n2;
    }

    @Override
    public void setEscapeProcessing(boolean bl2) {
        this.checkClosed();
        this.isEscapeProcessing = bl2;
    }

    @Override
    public synchronized int getQueryTimeout() {
        this.checkClosed();
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int n2) {
        this.checkClosed();
        if (n2 < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (n2 > Short.MAX_VALUE) {
            n2 = Short.MAX_VALUE;
        }
        this.queryTimeout = n2;
    }

    @Override
    public synchronized void cancel() {
        this.checkClosed();
    }

    @Override
    public synchronized SQLWarning getWarnings() {
        this.checkClosed();
        return this.rootWarning;
    }

    @Override
    public synchronized void clearWarnings() {
        this.checkClosed();
        this.rootWarning = null;
    }

    @Override
    public void setCursorName(String string) {
        this.checkClosed();
    }

    @Override
    public synchronized boolean execute(String string) {
        this.fetchResult(string, 0, 2, null, null);
        return this.currentResultSet != null;
    }

    @Override
    public synchronized ResultSet getResultSet() {
        return super.getResultSet();
    }

    @Override
    public synchronized int getUpdateCount() {
        return super.getUpdateCount();
    }

    @Override
    public synchronized boolean getMoreResults() {
        return this.getMoreResults(1);
    }

    @Override
    public synchronized void setFetchDirection(int n2) {
        this.checkClosed();
        this.checkClosed();
        switch (n2) {
            case 1000: 
            case 1001: 
            case 1002: {
                this.fetchDirection = n2;
                break;
            }
            default: {
                throw JDBCUtil.invalidArgument();
            }
        }
    }

    @Override
    public int getFetchDirection() {
        this.checkClosed();
        return this.fetchDirection;
    }

    @Override
    public synchronized void setFetchSize(int n2) {
        this.checkClosed();
        if (n2 < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        this.fetchSize = n2;
    }

    @Override
    public synchronized int getFetchSize() {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public synchronized int getResultSetConcurrency() {
        this.checkClosed();
        return d.getJDBCConcurrency(this.rsProperties);
    }

    @Override
    public synchronized int getResultSetType() {
        this.checkClosed();
        return d.getJDBCScrollability(this.rsProperties);
    }

    @Override
    public synchronized void addBatch(String string) {
        this.checkClosed();
        if (this.isEscapeProcessing) {
            string = this.connection.nativeSQL(string);
        }
        if (this.batchResultOut == null) {
            this.batchResultOut = a.newBatchedExecuteRequest();
        }
        this.batchResultOut.getNavigator().add(new Object[]{string});
    }

    @Override
    public synchronized void clearBatch() {
        this.checkClosed();
        if (this.batchResultOut != null) {
            this.batchResultOut.getNavigator().clear();
        }
    }

    @Override
    public synchronized int[] executeBatch() {
        this.checkClosed();
        this.generatedResult = null;
        if (this.batchResultOut == null) {
            this.batchResultOut = a.newBatchedExecuteRequest();
        }
        int n2 = this.batchResultOut.getNavigator().getSize();
        try {
            this.resultIn = this.connection.sessionProxy.execute(this.batchResultOut);
            this.performPostExecute();
        }
        catch (aa aa2) {
            this.batchResultOut.getNavigator().clear();
            throw JDBCUtil.sqlException(aa2);
        }
        this.batchResultOut.getNavigator().clear();
        if (this.resultIn.isError()) {
            throw JDBCUtil.sqlException(this.resultIn);
        }
        c c2 = this.resultIn.getNavigator();
        int[] nArray = new int[c2.getSize()];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            Object[] objectArray = c2.getNext();
            nArray[i2] = (Integer)objectArray[0];
        }
        if (nArray.length != n2) {
            if (this.errorResult == null) {
                throw new BatchUpdateException(nArray);
            }
            this.errorResult.getMainString();
            throw new BatchUpdateException(this.errorResult.getMainString(), this.errorResult.getSubString(), this.errorResult.getErrorCode(), nArray);
        }
        return nArray;
    }

    @Override
    public synchronized Connection getConnection() {
        this.checkClosed();
        return this.connection;
    }

    @Override
    public synchronized boolean getMoreResults(int n2) {
        return super.getMoreResults(n2);
    }

    @Override
    public synchronized ResultSet getGeneratedKeys() {
        return this.getGeneratedResultSet();
    }

    @Override
    public synchronized int executeUpdate(String string, int n2) {
        if (n2 != 1 && n2 != 2) {
            throw JDBCUtil.invalidArgument("autoGeneratedKeys");
        }
        this.fetchResult(string, 1, n2, null, null);
        if (this.resultIn.isError()) {
            throw JDBCUtil.sqlException(this.resultIn);
        }
        return this.resultIn.getUpdateCount();
    }

    @Override
    public synchronized int executeUpdate(String string, int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            throw JDBCUtil.invalidArgument("columnIndexes");
        }
        this.fetchResult(string, 1, 21, nArray, null);
        return this.resultIn.getUpdateCount();
    }

    @Override
    public synchronized int executeUpdate(String string, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw JDBCUtil.invalidArgument("columnIndexes");
        }
        this.fetchResult(string, 1, 11, null, stringArray);
        return this.resultIn.getUpdateCount();
    }

    @Override
    public synchronized boolean execute(String string, int n2) {
        if (n2 != 1 && n2 != 2) {
            throw JDBCUtil.invalidArgument("autoGeneratedKeys");
        }
        this.fetchResult(string, 0, n2, null, null);
        return this.resultIn.isData();
    }

    @Override
    public synchronized boolean execute(String string, int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            throw JDBCUtil.invalidArgument("columnIndexes");
        }
        this.fetchResult(string, 0, 21, nArray, null);
        return this.resultIn.isData();
    }

    @Override
    public synchronized boolean execute(String string, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw JDBCUtil.invalidArgument("columnIndexes");
        }
        this.fetchResult(string, 0, 11, null, stringArray);
        return this.resultIn.isData();
    }

    @Override
    public synchronized int getResultSetHoldability() {
        return d.getJDBCHoldability(this.rsProperties);
    }

    @Override
    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public synchronized void setPoolable(boolean bl2) {
        this.checkClosed();
        this.poolable = bl2;
    }

    @Override
    public synchronized boolean isPoolable() {
        this.checkClosed();
        return this.poolable;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    JDBCStatement(JDBCConnection jDBCConnection, int n2) {
        this.resultOut = a.newExecuteDirectRequest();
        this.connection = jDBCConnection;
        this.connectionIncarnation = this.connection.incarnation;
        this.rsProperties = n2;
    }

    private void fetchResult(String string, int n2, int n3, int[] nArray, String[] stringArray) {
        this.checkClosed();
        this.closeResultData();
        if (this.isEscapeProcessing) {
            string = this.connection.nativeSQL(string);
        }
        this.resultOut.setPrepareOrExecuteProperties(string, this.maxRows, this.fetchSize, n2, this.queryTimeout, this.rsProperties, n3, nArray, stringArray);
        try {
            this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
            this.performPostExecute();
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
        if (this.resultIn.isError()) {
            throw JDBCUtil.sqlException(this.resultIn);
        }
        if (this.resultIn.isData()) {
            this.currentResultSet = new JDBCResultSet(this.connection, this, this.resultIn, this.resultIn.metaData);
        } else if (this.resultIn.getStatementType() == 2) {
            this.getMoreResults();
        }
    }
}

