/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.hsqldb.g.c;
import org.hsqldb.jdbc.JDBCColumnMetaData;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.k.ad;
import org.hsqldb.k.r;
import org.hsqldb.k.u;

public class JDBCResultSetMetaData
implements ResultSetMetaData {
    private c resultMetaData;
    private boolean useColumnName;
    private boolean translateTTIType;
    private int columnCount;

    @Override
    public int getColumnCount() {
        return this.resultMetaData.getColumnCount();
    }

    @Override
    public boolean isAutoIncrement(int n2) {
        this.checkColumn(n2);
        return this.resultMetaData.columns[--n2].isIdentity();
    }

    @Override
    public boolean isCaseSensitive(int n2) {
        this.checkColumn(n2);
        ad ad2 = this.translateType(this.resultMetaData.columnTypes[--n2]);
        if (ad2.isCharacterType()) {
            return ad2.getCollation().isCaseSensitive();
        }
        return false;
    }

    @Override
    public boolean isSearchable(int n2) {
        this.checkColumn(n2);
        return this.resultMetaData.columns[--n2].isSearchable();
    }

    @Override
    public boolean isCurrency(int n2) {
        this.checkColumn(n2);
        ad ad2 = this.translateType(this.resultMetaData.columnTypes[--n2]);
        return (ad2.typeCode == 3 || ad2.typeCode == 2) && ad2.scale > 0;
    }

    @Override
    public int isNullable(int n2) {
        this.checkColumn(n2);
        return this.resultMetaData.columns[--n2].getNullability();
    }

    @Override
    public boolean isSigned(int n2) {
        this.checkColumn(n2);
        ad ad2 = this.translateType(this.resultMetaData.columnTypes[--n2]);
        return ad2.isNumberType();
    }

    @Override
    public int getColumnDisplaySize(int n2) {
        this.checkColumn(n2);
        ad ad2 = this.translateType(this.resultMetaData.columnTypes[--n2]);
        return ad2.displaySize();
    }

    @Override
    public String getColumnLabel(int n2) {
        this.checkColumn(n2--);
        String string = this.resultMetaData.columnLabels[n2];
        if (string != null && string.length() > 0) {
            return string;
        }
        return this.resultMetaData.columns[n2].getNameString();
    }

    @Override
    public String getColumnName(int n2) {
        String string;
        this.checkColumn(n2--);
        if (this.useColumnName && (string = this.resultMetaData.columns[n2].getNameString()) != null && string.length() > 0) {
            return string;
        }
        string = this.resultMetaData.columnLabels[n2];
        return string == null ? this.resultMetaData.columns[n2].getNameString() : string;
    }

    @Override
    public String getSchemaName(int n2) {
        this.checkColumn(n2);
        String string = this.resultMetaData.columns[--n2].getSchemaNameString();
        return string == null ? "" : string;
    }

    @Override
    public int getPrecision(int n2) {
        this.checkColumn(n2);
        ad ad2 = this.translateType(this.resultMetaData.columnTypes[--n2]);
        return ad2.getJDBCPrecision();
    }

    @Override
    public int getScale(int n2) {
        this.checkColumn(n2);
        ad ad2 = this.translateType(this.resultMetaData.columnTypes[--n2]);
        return ad2.getJDBCScale();
    }

    @Override
    public String getTableName(int n2) {
        this.checkColumn(n2);
        String string = this.resultMetaData.columns[--n2].getTableNameString();
        return string == null ? "" : string;
    }

    @Override
    public String getCatalogName(int n2) {
        this.checkColumn(n2);
        String string = this.resultMetaData.columns[--n2].getCatalogNameString();
        return string == null ? "" : string;
    }

    @Override
    public int getColumnType(int n2) {
        this.checkColumn(n2);
        ad ad2 = this.translateType(this.resultMetaData.columnTypes[--n2]);
        return ad2.getJDBCTypeCode();
    }

    @Override
    public String getColumnTypeName(int n2) {
        this.checkColumn(n2);
        ad ad2 = this.translateType(this.resultMetaData.columnTypes[--n2]);
        return ad2.getNameString();
    }

    @Override
    public boolean isReadOnly(int n2) {
        this.checkColumn(n2);
        return !this.resultMetaData.columns[--n2].isWriteable();
    }

    @Override
    public boolean isWritable(int n2) {
        this.checkColumn(n2);
        return this.resultMetaData.colIndexes != null && this.resultMetaData.colIndexes[--n2] > -1;
    }

    @Override
    public boolean isDefinitelyWritable(int n2) {
        this.checkColumn(n2);
        return this.resultMetaData.colIndexes != null && this.resultMetaData.colIndexes[--n2] > -1;
    }

    @Override
    public String getColumnClassName(int n2) {
        this.checkColumn(n2);
        ad ad2 = this.translateType(this.resultMetaData.columnTypes[--n2]);
        return ad2.getJDBCClassName();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    JDBCResultSetMetaData(c c2, boolean bl2, boolean bl3, JDBCConnection jDBCConnection) {
        this.init(c2, jDBCConnection);
    }

    void init(c c2, JDBCConnection jDBCConnection) {
        this.resultMetaData = c2;
        this.columnCount = this.resultMetaData.getColumnCount();
        this.useColumnName = true;
        if (jDBCConnection == null) {
            return;
        }
        this.useColumnName = jDBCConnection.isUseColumnName;
        if (jDBCConnection.clientProperties != null) {
            this.translateTTIType = jDBCConnection.clientProperties.isPropertyTrue("jdbc.translate_tti_types");
        }
    }

    private void checkColumn(int n2) {
        if (n2 < 1 || n2 > this.columnCount) {
            throw JDBCUtil.sqlException(421, String.valueOf(n2));
        }
    }

    private ad translateType(ad ad2) {
        if (this.translateTTIType) {
            if (ad2.isIntervalType()) {
                ad2 = ((u)ad2).getCharacterType();
            } else if (ad2.isDateTimeTypeWithZone()) {
                ad2 = ((r)ad2).getDateTimeTypeWithoutZone();
            }
        }
        return ad2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        if (this.columnCount == 0) {
            stringBuffer.append("[columnCount=0]");
            return stringBuffer.toString();
        }
        stringBuffer.append('[');
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            JDBCColumnMetaData jDBCColumnMetaData = this.getColumnMetaData(i2 + 1);
            stringBuffer.append('\n');
            stringBuffer.append("   column_");
            stringBuffer.append(i2 + 1);
            stringBuffer.append('=');
            stringBuffer.append(jDBCColumnMetaData);
            if (i2 + 1 >= this.columnCount) continue;
            stringBuffer.append(',');
            stringBuffer.append(' ');
        }
        stringBuffer.append('\n');
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    JDBCColumnMetaData getColumnMetaData(int n2) {
        JDBCColumnMetaData jDBCColumnMetaData = new JDBCColumnMetaData();
        try {
            jDBCColumnMetaData.catalogName = this.getCatalogName(n2);
            jDBCColumnMetaData.columnClassName = this.getColumnClassName(n2);
            jDBCColumnMetaData.columnDisplaySize = this.getColumnDisplaySize(n2);
            jDBCColumnMetaData.columnLabel = this.getColumnLabel(n2);
            jDBCColumnMetaData.columnName = this.getColumnName(n2);
            jDBCColumnMetaData.columnType = this.getColumnType(n2);
            jDBCColumnMetaData.isAutoIncrement = this.isAutoIncrement(n2);
            jDBCColumnMetaData.isCaseSensitive = this.isCaseSensitive(n2);
            jDBCColumnMetaData.isCurrency = this.isCurrency(n2);
            jDBCColumnMetaData.isDefinitelyWritable = this.isDefinitelyWritable(n2);
            jDBCColumnMetaData.isNullable = this.isNullable(n2);
            jDBCColumnMetaData.isReadOnly = this.isReadOnly(n2);
            jDBCColumnMetaData.isSearchable = this.isSearchable(n2);
            jDBCColumnMetaData.isSigned = this.isSigned(n2);
            jDBCColumnMetaData.isWritable = this.isWritable(n2);
            jDBCColumnMetaData.precision = this.getPrecision(n2);
            jDBCColumnMetaData.scale = this.getScale(n2);
            jDBCColumnMetaData.schemaName = this.getSchemaName(n2);
            jDBCColumnMetaData.tableName = this.getTableName(n2);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return jDBCColumnMetaData;
    }
}

