/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.hsqldb.aa;
import org.hsqldb.bj;
import org.hsqldb.c;
import org.hsqldb.g.a;
import org.hsqldb.g.d;
import org.hsqldb.jdbc.JDBCArray;
import org.hsqldb.jdbc.JDBCBlob;
import org.hsqldb.jdbc.JDBCBlobClient;
import org.hsqldb.jdbc.JDBCClob;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCNClob;
import org.hsqldb.jdbc.JDBCPreparedStatement;
import org.hsqldb.jdbc.JDBCResultSetMetaData;
import org.hsqldb.jdbc.JDBCSQLXML;
import org.hsqldb.jdbc.JDBCStatementBase;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.k.ab;
import org.hsqldb.k.ac;
import org.hsqldb.k.ad;
import org.hsqldb.k.b;
import org.hsqldb.k.f;
import org.hsqldb.k.m;
import org.hsqldb.k.r;
import org.hsqldb.k.u;
import org.hsqldb.k.v;
import org.hsqldb.lib.ah;
import org.hsqldb.lib.bi;
import org.hsqldb.z;

public class JDBCResultSet
implements ResultSet {
    private org.hsqldb.d.c navigator;
    protected org.hsqldb.g.c resultMetaData;
    private boolean translateTTIType;
    private int columnCount;
    private boolean wasNullValue;
    private ResultSetMetaData resultSetMetaData;
    private ah columnMap;
    private SQLWarning rootWarning;
    JDBCStatementBase statement;
    bj session;
    JDBCConnection connection;
    boolean isScrollable;
    boolean isReadOnly;
    boolean isUpdatable;
    boolean isInsertable;
    int rsProperties;
    int fetchSize;
    boolean autoClose;
    public a result;
    public static final int FETCH_FORWARD = 1000;
    public static final int FETCH_REVERSE = 1001;
    public static final int FETCH_UNKNOWN = 1002;
    public static final int TYPE_FORWARD_ONLY = 1003;
    public static final int TYPE_SCROLL_INSENSITIVE = 1004;
    public static final int TYPE_SCROLL_SENSITIVE = 1005;
    public static final int CONCUR_READ_ONLY = 1007;
    public static final int CONCUR_UPDATABLE = 1008;
    public static final int HOLD_CURSORS_OVER_COMMIT = 1;
    public static final int CLOSE_CURSORS_AT_COMMIT = 2;
    JDBCPreparedStatement preparedStatement;
    boolean isRowUpdated;
    boolean isOnInsertRow;
    int currentUpdateRowNumber;

    @Override
    public boolean next() {
        this.checkClosed();
        this.rootWarning = null;
        return this.navigator.next();
    }

    @Override
    public void close() {
        if (this.navigator == null) {
            return;
        }
        if (d.isHeld(this.rsProperties)) {
            this.session.closeNavigator(this.navigator.getId());
        } else {
            this.navigator.release();
        }
        this.navigator = null;
        if (this.autoClose && this.statement != null) {
            this.statement.close();
        }
    }

    @Override
    public boolean wasNull() {
        this.checkClosed();
        return this.wasNullValue;
    }

    @Override
    public String getString(int n2) {
        this.checkColumn(n2);
        ad ad2 = this.resultMetaData.columnTypes[n2 - 1];
        if (ad2.typeCode == 40) {
            m m2 = (m)this.getColumnInType(n2, ad2);
            if (m2 == null) {
                return null;
            }
            long l2 = m2.length(this.session);
            if (l2 > Integer.MAX_VALUE) {
                JDBCUtil.throwError(org.hsqldb.a.a.error(5561));
            }
            return m2.getSubString(this.session, 0L, (int)l2);
        }
        return (String)this.getColumnInType(n2, ad.SQL_VARCHAR);
    }

    @Override
    public boolean getBoolean(int n2) {
        Object object = this.getColumnInType(n2, ad.SQL_BOOLEAN);
        return object == null ? false : (Boolean)object;
    }

    @Override
    public byte getByte(int n2) {
        Object object = this.getColumnInType(n2, ad.TINYINT);
        return object == null ? (byte)0 : ((Number)object).byteValue();
    }

    @Override
    public short getShort(int n2) {
        Object object = this.getColumnInType(n2, ad.SQL_SMALLINT);
        return object == null ? (short)0 : ((Number)object).shortValue();
    }

    @Override
    public int getInt(int n2) {
        Object object = this.getColumnInType(n2, ad.SQL_INTEGER);
        return object == null ? 0 : ((Number)object).intValue();
    }

    @Override
    public long getLong(int n2) {
        Object object = this.getColumnInType(n2, ad.SQL_BIGINT);
        return object == null ? 0L : ((Number)object).longValue();
    }

    @Override
    public float getFloat(int n2) {
        Object object = this.getColumnInType(n2, ad.SQL_DOUBLE);
        return object == null ? 0.0f : ((Number)object).floatValue();
    }

    @Override
    public double getDouble(int n2) {
        Object object = this.getColumnInType(n2, ad.SQL_DOUBLE);
        return object == null ? 0.0 : ((Number)object).doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(int n2, int n3) {
        if (n3 < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        BigDecimal bigDecimal = this.getBigDecimal(n2);
        if (bigDecimal != null) {
            bigDecimal = bigDecimal.setScale(n3, 1);
        }
        return bigDecimal;
    }

    @Override
    public byte[] getBytes(int n2) {
        this.checkColumn(n2);
        ad ad2 = this.resultMetaData.columnTypes[n2 - 1];
        if (ad2.typeCode == 30) {
            f f2 = (f)this.getColumnInType(n2, ad2);
            if (f2 == null) {
                return null;
            }
            long l2 = f2.length(this.session);
            if (l2 > Integer.MAX_VALUE) {
                JDBCUtil.throwError(org.hsqldb.a.a.error(5561));
            }
            return f2.getBytes(this.session, 0L, (int)l2);
        }
        Object object = this.getColumnInType(n2, ad.SQL_VARBINARY);
        if (object == null) {
            return null;
        }
        return ((b)object).getBytes();
    }

    @Override
    public Date getDate(int n2) {
        Object object = this.getColumnInType(n2, ad.SQL_DATE);
        if (object == null) {
            return null;
        }
        return (Date)ad.SQL_DATE.convertSQLToJava(this.session, object);
    }

    @Override
    public Time getTime(int n2) {
        Object object = this.getColumnInType(n2, ad.SQL_TIME);
        if (object == null) {
            return null;
        }
        return (Time)ad.SQL_TIME.convertSQLToJava(this.session, object);
    }

    @Override
    public Timestamp getTimestamp(int n2) {
        Object object = this.getColumnInType(n2, ad.SQL_TIMESTAMP);
        if (object == null) {
            return null;
        }
        return (Timestamp)ad.SQL_TIMESTAMP.convertSQLToJava(this.session, object);
    }

    @Override
    public InputStream getAsciiStream(int n2) {
        String string = this.getString(n2);
        if (string == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(string.getBytes("US-ASCII"));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public InputStream getUnicodeStream(int n2) {
        String string = this.getString(n2);
        if (string == null) {
            return null;
        }
        return new bi(string);
    }

    @Override
    public InputStream getBinaryStream(int n2) {
        this.checkColumn(n2);
        ad ad2 = this.resultMetaData.columnTypes[n2 - 1];
        Object object = this.getColumnInType(n2, ad2);
        if (object == null) {
            return null;
        }
        if (object instanceof f) {
            return ((f)object).getBinaryStream(this.session);
        }
        if (object instanceof Blob) {
            return ((Blob)object).getBinaryStream();
        }
        if (object instanceof b) {
            byte[] byArray = this.getBytes(n2);
            return new ByteArrayInputStream(byArray);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public String getString(String string) {
        return this.getString(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(String string) {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(String string) {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public short getShort(String string) {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public int getInt(String string) {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(String string) {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public float getFloat(String string) {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public double getDouble(String string) {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n2) {
        return this.getBigDecimal(this.findColumn(string), n2);
    }

    @Override
    public byte[] getBytes(String string) {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Date getDate(String string) {
        return this.getDate(this.findColumn(string));
    }

    @Override
    public Time getTime(String string) {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(String string) {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(String string) {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    public InputStream getUnicodeStream(String string) {
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public InputStream getBinaryStream(String string) {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public SQLWarning getWarnings() {
        this.checkClosed();
        return this.rootWarning;
    }

    @Override
    public void clearWarnings() {
        this.checkClosed();
        this.rootWarning = null;
    }

    @Override
    public String getCursorName() {
        this.checkClosed();
        if (this.result == null) {
            return "";
        }
        return this.result.getMainString();
    }

    @Override
    public ResultSetMetaData getMetaData() {
        this.checkClosed();
        if (this.resultSetMetaData == null) {
            this.resultSetMetaData = new JDBCResultSetMetaData(this.resultMetaData, this.isUpdatable, this.isInsertable, this.connection);
        }
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(int n2) {
        this.checkColumn(n2);
        ad ad2 = this.resultMetaData.columnTypes[n2 - 1];
        switch (ad2.typeCode) {
            case 50: {
                return this.getArray(n2);
            }
            case 91: {
                return this.getDate(n2);
            }
            case 92: 
            case 94: {
                return this.getTime(n2);
            }
            case 93: 
            case 95: {
                return this.getTimestamp(n2);
            }
            case 60: 
            case 61: {
                return this.getBytes(n2);
            }
            case 14: {
                boolean bl2 = this.getBoolean(n2);
                return this.wasNull() ? null : (bl2 ? Boolean.TRUE : Boolean.FALSE);
            }
            case 40: {
                return this.getClob(n2);
            }
            case 30: {
                return this.getBlob(n2);
            }
            case 1111: 
            case 2000: {
                Object object = this.getColumnInType(n2, ad2);
                if (object == null) {
                    return null;
                }
                try {
                    return ((v)object).getObject();
                }
                catch (aa aa2) {
                    throw JDBCUtil.sqlException(aa2);
                }
            }
        }
        return this.getColumnInType(n2, ad2);
    }

    @Override
    public Object getObject(String string) {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public int findColumn(String string) {
        int n2;
        int n3;
        this.checkClosed();
        if (string == null) {
            throw JDBCUtil.nullArgument();
        }
        if (this.columnMap != null && (n3 = this.columnMap.get((Object)string, -1)) != -1) {
            return n3;
        }
        String[] stringArray = this.resultMetaData.columnLabels;
        n3 = -1;
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            if (!string.equalsIgnoreCase(stringArray[i2])) continue;
            n3 = i2;
            break;
        }
        c[] cArray = this.resultMetaData.columns;
        if (n3 < 0) {
            for (n2 = 0; n2 < this.columnCount; ++n2) {
                if (!string.equalsIgnoreCase(cArray[n2].getNameString())) continue;
                n3 = n2;
                break;
            }
        }
        if (n3 < 0) {
            n2 = string.indexOf(46);
            if (n2 < 0) {
                throw JDBCUtil.sqlException(421, string);
            }
            for (int i3 = 0; i3 < this.columnCount; ++i3) {
                String string2;
                String string3 = cArray[i3].getTableNameString();
                if (string3 == null || string3.length() == 0) continue;
                String string4 = cArray[i3].getNameString();
                if (string.equalsIgnoreCase(string3 + '.' + string4)) {
                    n3 = i3;
                    break;
                }
                String string5 = cArray[i3].getSchemaNameString();
                if (string5 == null || string5.length() == 0 || !string.equalsIgnoreCase(string2 = new StringBuffer(string5).append('.').append(string3).append('.').append(string4).toString())) continue;
                n3 = i3;
                break;
            }
        }
        if (n3 < 0) {
            throw JDBCUtil.sqlException(421, string);
        }
        ++n3;
        if (this.columnMap == null) {
            this.columnMap = new ah();
        }
        this.columnMap.put(string, n3);
        return n3;
    }

    @Override
    public Reader getCharacterStream(int n2) {
        this.checkColumn(n2);
        ad ad2 = this.resultMetaData.columnTypes[n2 - 1];
        Object object = this.getColumnInType(n2, ad2);
        if (object == null) {
            return null;
        }
        if (object instanceof m) {
            return ((m)object).getCharacterStream(this.session);
        }
        if (object instanceof Clob) {
            return ((Clob)object).getCharacterStream();
        }
        if (object instanceof String) {
            return new StringReader((String)object);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public Reader getCharacterStream(String string) {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n2) {
        this.checkColumn(n2);
        ad ad2 = this.resultMetaData.columnTypes[n2 - 1];
        switch (ad2.typeCode) {
            case 2: 
            case 3: {
                break;
            }
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                ad2 = ad.SQL_DECIMAL;
                break;
            }
            default: {
                ad2 = ad.SQL_DECIMAL_DEFAULT;
            }
        }
        return (BigDecimal)this.getColumnInType(n2, ad2);
    }

    @Override
    public BigDecimal getBigDecimal(String string) {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public boolean isBeforeFirst() {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isAfterLast();
    }

    @Override
    public boolean isFirst() {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isFirst();
    }

    @Override
    public boolean isLast() {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isLast();
    }

    @Override
    public void beforeFirst() {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        this.navigator.beforeFirst();
    }

    @Override
    public void afterLast() {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        this.navigator.afterLast();
    }

    @Override
    public boolean first() {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        return this.navigator.first();
    }

    @Override
    public boolean last() {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        return this.navigator.last();
    }

    @Override
    public int getRow() {
        this.checkClosed();
        if (this.navigator.isAfterLast()) {
            return 0;
        }
        return this.navigator.getRowNumber() + 1;
    }

    @Override
    public boolean absolute(int n2) {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        if (n2 > 0) {
            --n2;
        } else if (n2 == 0) {
            return this.navigator.beforeFirst();
        }
        return this.navigator.absolute(n2);
    }

    @Override
    public boolean relative(int n2) {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        return this.navigator.relative(n2);
    }

    @Override
    public boolean previous() {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        this.rootWarning = null;
        return this.navigator.previous();
    }

    @Override
    public void setFetchDirection(int n2) {
        this.checkClosed();
        switch (n2) {
            case 1000: {
                break;
            }
            case 1001: {
                this.checkNotForwardOnly();
                break;
            }
            case 1002: {
                this.checkNotForwardOnly();
                break;
            }
            default: {
                throw JDBCUtil.notSupported();
            }
        }
    }

    @Override
    public int getFetchDirection() {
        this.checkClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int n2) {
        if (n2 < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
    }

    @Override
    public int getFetchSize() {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public int getType() {
        this.checkClosed();
        return d.getJDBCScrollability(this.rsProperties);
    }

    @Override
    public int getConcurrency() {
        this.checkClosed();
        return d.getJDBCConcurrency(this.rsProperties);
    }

    @Override
    public boolean rowUpdated() {
        this.checkClosed();
        return this.isRowUpdated;
    }

    @Override
    public boolean rowInserted() {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean rowDeleted() {
        this.checkClosed();
        return false;
    }

    @Override
    public void updateNull(int n2) {
        this.startUpdate(n2);
        this.preparedStatement.setParameter(n2, null);
    }

    @Override
    public void updateBoolean(int n2, boolean bl2) {
        Boolean bl3 = bl2 ? Boolean.TRUE : Boolean.FALSE;
        this.startUpdate(n2);
        this.preparedStatement.setParameter(n2, bl3);
    }

    @Override
    public void updateByte(int n2, byte by2) {
        this.startUpdate(n2);
        this.preparedStatement.setIntParameter(n2, by2);
    }

    @Override
    public void updateShort(int n2, short s2) {
        this.startUpdate(n2);
        this.preparedStatement.setIntParameter(n2, s2);
    }

    @Override
    public void updateInt(int n2, int n3) {
        this.startUpdate(n2);
        this.preparedStatement.setIntParameter(n2, n3);
    }

    @Override
    public void updateLong(int n2, long l2) {
        this.startUpdate(n2);
        this.preparedStatement.setLongParameter(n2, l2);
    }

    @Override
    public void updateFloat(int n2, float f2) {
        Double d2 = new Double(f2);
        this.startUpdate(n2);
        this.preparedStatement.setParameter(n2, d2);
    }

    @Override
    public void updateDouble(int n2, double d2) {
        Double d3 = new Double(d2);
        this.startUpdate(n2);
        this.preparedStatement.setParameter(n2, d3);
    }

    @Override
    public void updateBigDecimal(int n2, BigDecimal bigDecimal) {
        this.startUpdate(n2);
        this.preparedStatement.setParameter(n2, bigDecimal);
    }

    @Override
    public void updateString(int n2, String string) {
        this.startUpdate(n2);
        this.preparedStatement.setParameter(n2, string);
    }

    @Override
    public void updateBytes(int n2, byte[] byArray) {
        this.startUpdate(n2);
        this.preparedStatement.setParameter(n2, byArray);
    }

    @Override
    public void updateDate(int n2, Date date) {
        this.startUpdate(n2);
        this.preparedStatement.setParameter(n2, date);
    }

    @Override
    public void updateTime(int n2, Time time) {
        this.startUpdate(n2);
        this.preparedStatement.setParameter(n2, time);
    }

    @Override
    public void updateTimestamp(int n2, Timestamp timestamp) {
        this.startUpdate(n2);
        this.preparedStatement.setParameter(n2, timestamp);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, int n3) {
        this.startUpdate(n2);
        this.preparedStatement.setAsciiStream(n2, inputStream, n3);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, int n3) {
        this.startUpdate(n2);
        this.preparedStatement.setBinaryStream(n2, inputStream, n3);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, int n3) {
        this.startUpdate(n2);
        this.preparedStatement.setCharacterStream(n2, reader, n3);
    }

    @Override
    public void updateObject(int n2, Object object, int n3) {
        this.startUpdate(n2);
        this.preparedStatement.setObject(n2, object, 0, n3);
    }

    @Override
    public void updateObject(int n2, Object object) {
        this.startUpdate(n2);
        this.preparedStatement.setParameter(n2, object);
    }

    @Override
    public void updateNull(String string) {
        this.updateNull(this.findColumn(string));
    }

    @Override
    public void updateBoolean(String string, boolean bl2) {
        this.updateBoolean(this.findColumn(string), bl2);
    }

    @Override
    public void updateByte(String string, byte by2) {
        this.updateByte(this.findColumn(string), by2);
    }

    @Override
    public void updateShort(String string, short s2) {
        this.updateShort(this.findColumn(string), s2);
    }

    @Override
    public void updateInt(String string, int n2) {
        this.updateInt(this.findColumn(string), n2);
    }

    @Override
    public void updateLong(String string, long l2) {
        this.updateLong(this.findColumn(string), l2);
    }

    @Override
    public void updateFloat(String string, float f2) {
        this.updateFloat(this.findColumn(string), f2);
    }

    @Override
    public void updateDouble(String string, double d2) {
        this.updateDouble(this.findColumn(string), d2);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public void updateString(String string, String string2) {
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) {
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public void updateDate(String string, Date date) {
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public void updateTime(String string, Time time) {
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n2) {
        this.updateAsciiStream(this.findColumn(string), inputStream, n2);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n2) {
        this.updateBinaryStream(this.findColumn(string), inputStream, n2);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n2) {
        this.updateCharacterStream(this.findColumn(string), reader, n2);
    }

    @Override
    public void updateObject(String string, Object object, int n2) {
        this.updateObject(this.findColumn(string), object, n2);
    }

    @Override
    public void updateObject(String string, Object object) {
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public void insertRow() {
        this.performInsert();
    }

    @Override
    public void updateRow() {
        this.performUpdate();
    }

    @Override
    public void deleteRow() {
        this.performDelete();
    }

    @Override
    public void refreshRow() {
        this.clearUpdates();
    }

    @Override
    public void cancelRowUpdates() {
        this.clearUpdates();
    }

    @Override
    public void moveToInsertRow() {
        this.startInsert();
    }

    @Override
    public void moveToCurrentRow() {
        this.endInsert();
    }

    @Override
    public Statement getStatement() {
        this.checkClosed();
        return (Statement)((Object)this.statement);
    }

    public Object getObject(int n2, Map map) {
        return this.getObject(n2);
    }

    @Override
    public Ref getRef(int n2) {
        throw JDBCUtil.notSupported();
    }

    @Override
    public Blob getBlob(int n2) {
        this.checkColumn(n2);
        ad ad2 = this.resultMetaData.columnTypes[n2 - 1];
        Object object = this.getColumnInType(n2, ad2);
        if (object == null) {
            return null;
        }
        if (object instanceof f) {
            JDBCBlobClient jDBCBlobClient = new JDBCBlobClient(this.session, (f)object);
            if (this.isUpdatable && this.resultMetaData.colIndexes[n2 - 1] > 0 && this.resultMetaData.columns[n2 - 1].isWriteable()) {
                jDBCBlobClient.setWritable(this, n2 - 1);
            }
            return jDBCBlobClient;
        }
        if (object instanceof Blob) {
            return (Blob)object;
        }
        if (object instanceof b) {
            byte[] byArray = this.getBytes(n2);
            return new JDBCBlob(byArray);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public Clob getClob(int n2) {
        this.checkColumn(n2);
        ad ad2 = this.resultMetaData.columnTypes[n2 - 1];
        Object object = this.getColumnInType(n2, ad2);
        if (object == null) {
            return null;
        }
        if (object instanceof m) {
            JDBCClobClient jDBCClobClient = new JDBCClobClient(this.session, (m)object);
            if (this.isUpdatable && this.resultMetaData.colIndexes[n2 - 1] > 0 && this.resultMetaData.columns[n2 - 1].isWriteable()) {
                jDBCClobClient.setWritable(this, n2 - 1);
            }
            return jDBCClobClient;
        }
        if (object instanceof Clob) {
            return (Clob)object;
        }
        if (object instanceof String) {
            return new JDBCClob((String)object);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public Array getArray(int n2) {
        this.checkColumn(n2);
        ad ad2 = this.resultMetaData.columnTypes[n2 - 1];
        Object[] objectArray = (Object[])this.getCurrent()[n2 - 1];
        if (!ad2.isArrayType()) {
            throw JDBCUtil.sqlException(5561);
        }
        if (this.trackNull(objectArray)) {
            return null;
        }
        return new JDBCArray(objectArray, ad2.collectionBaseType(), ad2, this.connection);
    }

    public Object getObject(String string, Map map) {
        return this.getObject(this.findColumn(string), map);
    }

    @Override
    public Ref getRef(String string) {
        return this.getRef(this.findColumn(string));
    }

    @Override
    public Blob getBlob(String string) {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public Clob getClob(String string) {
        return this.getClob(this.findColumn(string));
    }

    @Override
    public Array getArray(String string) {
        return this.getArray(this.findColumn(string));
    }

    @Override
    public Date getDate(int n2, Calendar calendar) {
        ac ac2 = (ac)this.getColumnInType(n2, ad.SQL_DATE);
        if (ac2 == null) {
            return null;
        }
        long l2 = ac2.getSeconds() * 1000L;
        if (calendar != null) {
            l2 = z.convertMillisToCalendar(calendar, l2);
        }
        return new Date(l2);
    }

    @Override
    public Date getDate(String string, Calendar calendar) {
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public Time getTime(int n2, Calendar calendar) {
        ab ab2 = (ab)this.getColumnInType(n2, ad.SQL_TIME);
        if (ab2 == null) {
            return null;
        }
        long l2 = r.normaliseTime(ab2.getSeconds()) * 1000;
        if (!this.resultMetaData.columnTypes[--n2].isDateTimeTypeWithZone()) {
            Calendar calendar2 = calendar == null ? this.session.getCalendar() : calendar;
            l2 = z.convertMillisToCalendar(calendar2, l2);
            l2 = z.getNormalisedTime(l2);
        }
        return new Time(l2);
    }

    @Override
    public Time getTime(String string, Calendar calendar) {
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) {
        Comparable<Calendar> comparable;
        ac ac2 = (ac)this.getColumnInType(n2, ad.SQL_TIMESTAMP);
        if (ac2 == null) {
            return null;
        }
        long l2 = ac2.getSeconds() * 1000L;
        if (!this.resultMetaData.columnTypes[--n2].isDateTimeTypeWithZone()) {
            Comparable<Calendar> comparable2 = comparable = calendar == null ? this.session.getCalendar() : calendar;
            if (calendar != null) {
                l2 = z.convertMillisToCalendar((Calendar)comparable, l2);
            }
        }
        comparable = new Timestamp(l2);
        ((Timestamp)comparable).setNanos(ac2.getNanos());
        return comparable;
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    @Override
    public URL getURL(int n2) {
        throw JDBCUtil.notSupported();
    }

    @Override
    public URL getURL(String string) {
        throw JDBCUtil.notSupported();
    }

    @Override
    public void updateRef(int n2, Ref ref) {
        throw JDBCUtil.notSupported();
    }

    @Override
    public void updateRef(String string, Ref ref) {
        throw JDBCUtil.notSupported();
    }

    @Override
    public void updateBlob(int n2, Blob blob) {
        this.startUpdate(n2);
        this.preparedStatement.setBlobParameter(n2, blob);
    }

    @Override
    public void updateBlob(String string, Blob blob) {
        int n2 = this.findColumn(string);
        this.updateBlob(n2, blob);
    }

    @Override
    public void updateClob(int n2, Clob clob) {
        this.startUpdate(n2);
        this.preparedStatement.setClobParameter(n2, clob);
    }

    @Override
    public void updateClob(String string, Clob clob) {
        int n2 = this.findColumn(string);
        this.updateClob(n2, clob);
    }

    @Override
    public void updateArray(int n2, Array array) {
        this.startUpdate(n2);
        this.preparedStatement.setParameter(n2, array);
    }

    @Override
    public void updateArray(String string, Array array) {
        int n2 = this.findColumn(string);
        this.updateArray(n2, array);
    }

    @Override
    public RowId getRowId(int n2) {
        throw JDBCUtil.notSupported();
    }

    @Override
    public RowId getRowId(String string) {
        throw JDBCUtil.notSupported();
    }

    @Override
    public void updateRowId(int n2, RowId rowId) {
        throw JDBCUtil.notSupported();
    }

    @Override
    public void updateRowId(String string, RowId rowId) {
        throw JDBCUtil.notSupported();
    }

    @Override
    public int getHoldability() {
        this.checkClosed();
        return d.getJDBCHoldability(this.rsProperties);
    }

    @Override
    public boolean isClosed() {
        return this.navigator == null;
    }

    @Override
    public void updateNString(int n2, String string) {
        this.updateString(n2, string);
    }

    @Override
    public void updateNString(String string, String string2) {
        this.updateString(string, string2);
    }

    @Override
    public void updateNClob(int n2, NClob nClob) {
        this.updateClob(n2, (Clob)nClob);
    }

    @Override
    public void updateNClob(String string, NClob nClob) {
        this.updateClob(string, (Clob)nClob);
    }

    @Override
    public NClob getNClob(int n2) {
        String string = this.getString(n2);
        return string == null ? null : new JDBCNClob(string);
    }

    @Override
    public NClob getNClob(String string) {
        return this.getNClob(this.findColumn(string));
    }

    @Override
    public SQLXML getSQLXML(int n2) {
        SQLXML sQLXML;
        this.checkColumn(n2);
        int n3 = this.resultMetaData.columnTypes[n2 - 1].typeCode;
        switch (n3) {
            case 137: {
                Object object = this.getObject(n2);
                if (object == null) {
                    sQLXML = null;
                    break;
                }
                if (object instanceof SQLXML) {
                    sQLXML = (SQLXML)object;
                    break;
                }
                throw JDBCUtil.notSupported();
            }
            case 40: {
                Clob clob = this.getClob(n2);
                if (clob == null) {
                    sQLXML = null;
                    break;
                }
                sQLXML = new JDBCSQLXML(clob.getCharacterStream());
                break;
            }
            case 1: 
            case 12: {
                Reader reader = this.getCharacterStream(n2);
                if (reader == null) {
                    sQLXML = null;
                    break;
                }
                sQLXML = new JDBCSQLXML(reader);
                break;
            }
            case -9: 
            case -8: {
                Reader reader = this.getNCharacterStream(n2);
                if (reader == null) {
                    sQLXML = null;
                    break;
                }
                sQLXML = new JDBCSQLXML(reader);
                break;
            }
            case 30: {
                Blob blob = this.getBlob(n2);
                if (blob == null) {
                    sQLXML = null;
                    break;
                }
                sQLXML = new JDBCSQLXML(blob.getBinaryStream());
                break;
            }
            case 60: 
            case 61: {
                InputStream inputStream = this.getBinaryStream(n2);
                if (inputStream == null) {
                    sQLXML = null;
                    break;
                }
                sQLXML = new JDBCSQLXML(inputStream);
                break;
            }
            case 1111: 
            case 2000: {
                Object object = this.getObject(n2);
                if (object == null) {
                    sQLXML = null;
                    break;
                }
                if (object instanceof SQLXML) {
                    sQLXML = (SQLXML)object;
                    break;
                }
                if (object instanceof String) {
                    sQLXML = new JDBCSQLXML((String)object);
                    break;
                }
                if (object instanceof byte[]) {
                    sQLXML = new JDBCSQLXML((byte[])object);
                    break;
                }
                if (object instanceof Blob) {
                    Blob blob = (Blob)object;
                    sQLXML = new JDBCSQLXML(blob.getBinaryStream());
                    break;
                }
                if (object instanceof Clob) {
                    Clob clob = (Clob)object;
                    sQLXML = new JDBCSQLXML(clob.getCharacterStream());
                    break;
                }
                throw JDBCUtil.notSupported();
            }
            default: {
                throw JDBCUtil.notSupported();
            }
        }
        return sQLXML;
    }

    @Override
    public SQLXML getSQLXML(String string) {
        return this.getSQLXML(this.findColumn(string));
    }

    @Override
    public void updateSQLXML(int n2, SQLXML sQLXML) {
        this.startUpdate(n2);
        this.preparedStatement.setSQLXML(n2, sQLXML);
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) {
        this.updateSQLXML(this.findColumn(string), sQLXML);
    }

    @Override
    public String getNString(int n2) {
        return this.getString(n2);
    }

    @Override
    public String getNString(String string) {
        return this.getString(this.findColumn(string));
    }

    @Override
    public Reader getNCharacterStream(int n2) {
        return this.getCharacterStream(n2);
    }

    @Override
    public Reader getNCharacterStream(String string) {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader, long l2) {
        this.startUpdate(n2);
        this.preparedStatement.setCharacterStream(n2, reader, l2);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l2) {
        this.updateCharacterStream(string, reader, l2);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, long l2) {
        this.startUpdate(n2);
        this.preparedStatement.setAsciiStream(n2, inputStream, l2);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, long l2) {
        this.startUpdate(n2);
        this.preparedStatement.setBinaryStream(n2, inputStream, l2);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, long l2) {
        this.startUpdate(n2);
        this.preparedStatement.setCharacterStream(n2, reader, l2);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l2) {
        int n2 = this.findColumn(string);
        this.startUpdate(n2);
        this.preparedStatement.setAsciiStream(n2, inputStream, l2);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l2) {
        int n2 = this.findColumn(string);
        this.startUpdate(n2);
        this.preparedStatement.setBinaryStream(n2, inputStream, l2);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l2) {
        int n2 = this.findColumn(string);
        this.startUpdate(n2);
        this.preparedStatement.setCharacterStream(n2, reader, l2);
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream, long l2) {
        this.startUpdate(n2);
        this.preparedStatement.setBlob(n2, inputStream, l2);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l2) {
        int n2 = this.findColumn(string);
        this.startUpdate(n2);
        this.preparedStatement.setBlob(n2, inputStream, l2);
    }

    @Override
    public void updateClob(int n2, Reader reader, long l2) {
        this.startUpdate(n2);
        this.preparedStatement.setClob(n2, reader, l2);
    }

    @Override
    public void updateClob(String string, Reader reader, long l2) {
        int n2 = this.findColumn(string);
        this.startUpdate(n2);
        this.preparedStatement.setClob(n2, reader, l2);
    }

    @Override
    public void updateNClob(int n2, Reader reader, long l2) {
        this.startUpdate(n2);
        this.preparedStatement.setClob(n2, reader, l2);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l2) {
        int n2 = this.findColumn(string);
        this.startUpdate(n2);
        this.preparedStatement.setClob(n2, reader, l2);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader) {
        this.startUpdate(n2);
        this.preparedStatement.setCharacterStream(n2, reader);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) {
        int n2 = this.findColumn(string);
        this.startUpdate(n2);
        this.preparedStatement.setCharacterStream(n2, reader);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream) {
        this.startUpdate(n2);
        this.preparedStatement.setAsciiStream(n2, inputStream);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream) {
        this.startUpdate(n2);
        this.preparedStatement.setBinaryStream(n2, inputStream);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader) {
        this.startUpdate(n2);
        this.preparedStatement.setCharacterStream(n2, reader);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) {
        int n2 = this.findColumn(string);
        this.startUpdate(n2);
        this.preparedStatement.setAsciiStream(n2, inputStream);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) {
        int n2 = this.findColumn(string);
        this.startUpdate(n2);
        this.preparedStatement.setBinaryStream(n2, inputStream);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) {
        int n2 = this.findColumn(string);
        this.startUpdate(n2);
        this.preparedStatement.setCharacterStream(n2, reader);
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream) {
        this.startUpdate(n2);
        this.preparedStatement.setBlob(n2, inputStream);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) {
        int n2 = this.findColumn(string);
        this.startUpdate(n2);
        this.preparedStatement.setBlob(n2, inputStream);
    }

    @Override
    public void updateClob(int n2, Reader reader) {
        this.startUpdate(n2);
        this.preparedStatement.setClob(n2, reader);
    }

    @Override
    public void updateClob(String string, Reader reader) {
        int n2 = this.findColumn(string);
        this.startUpdate(n2);
        this.preparedStatement.setClob(n2, reader);
    }

    @Override
    public void updateNClob(int n2, Reader reader) {
        this.startUpdate(n2);
        this.preparedStatement.setClob(n2, reader);
    }

    @Override
    public void updateNClob(String string, Reader reader) {
        int n2 = this.findColumn(string);
        this.startUpdate(n2);
        this.preparedStatement.setClob(n2, reader);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T getObject(int n2, Class<T> clazz) {
        return (T)this.getObject(n2);
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) {
        return this.getObject(this.findColumn(string), clazz);
    }

    protected Object[] getCurrent() {
        org.hsqldb.d.c c2 = this.navigator;
        if (c2 == null) {
            throw JDBCUtil.sqlException(3601);
        }
        if (c2.isEmpty()) {
            throw JDBCUtil.sqlException(3603, 70);
        }
        if (c2.isBeforeFirst()) {
            throw JDBCUtil.sqlException(3603, 71);
        }
        if (c2.isAfterLast()) {
            throw JDBCUtil.sqlException(3603, 72);
        }
        Object[] objectArray = c2.getCurrent();
        if (objectArray == null) {
            throw JDBCUtil.sqlException(3601);
        }
        return objectArray;
    }

    private void checkClosed() {
        if (this.navigator == null) {
            throw JDBCUtil.sqlException(3601);
        }
    }

    protected void checkColumn(int n2) {
        if (this.navigator == null) {
            throw JDBCUtil.sqlException(3601);
        }
        if (n2 < 1 || n2 > this.columnCount) {
            throw JDBCUtil.sqlException(421, String.valueOf(n2));
        }
    }

    protected boolean trackNull(Object object) {
        this.wasNullValue = object == null;
        return this.wasNullValue;
    }

    protected Object getColumnInType(int n2, ad ad2) {
        Object[] objectArray = this.getCurrent();
        this.checkColumn(n2);
        ad ad3 = this.resultMetaData.columnTypes[--n2];
        Object object = objectArray[n2];
        if (this.trackNull(object)) {
            return null;
        }
        if (this.translateTTIType && ad2.isIntervalType()) {
            ad2 = ((u)ad2).getCharacterType();
        }
        if (ad3.typeCode != ad2.typeCode) {
            try {
                object = ad2.convertToTypeJDBC(this.session, object, ad3);
            }
            catch (Exception exception) {
                String string = object instanceof Number || object instanceof String ? object.toString() : "instance of " + object.getClass().getName();
                String string2 = "from SQL type " + ad3.getNameString() + " to " + ad2.getJDBCClassName() + ", value: " + string;
                JDBCUtil.throwError(org.hsqldb.a.a.error(5561, string2));
            }
        }
        return object;
    }

    private void checkNotForwardOnly() {
        if (!this.isScrollable) {
            throw JDBCUtil.notSupported();
        }
    }

    private void checkUpdatable() {
        this.checkClosed();
        if (!this.isUpdatable) {
            throw JDBCUtil.notUpdatableColumn();
        }
    }

    private void checkUpdatable(int n2) {
        this.checkClosed();
        this.checkColumn(n2);
        if (!this.isUpdatable) {
            throw JDBCUtil.notUpdatableColumn();
        }
        if (this.resultMetaData.colIndexes[--n2] == -1) {
            throw JDBCUtil.notUpdatableColumn();
        }
        if (!this.resultMetaData.columns[n2].isWriteable()) {
            throw JDBCUtil.notUpdatableColumn();
        }
    }

    void startUpdate(int n2) {
        this.checkUpdatable(n2);
        if (this.currentUpdateRowNumber != this.navigator.getRowNumber()) {
            this.preparedStatement.clearParameters();
        }
        this.currentUpdateRowNumber = this.navigator.getRowNumber();
        this.isRowUpdated = true;
    }

    private void clearUpdates() {
        this.checkUpdatable();
        this.preparedStatement.clearParameters();
        this.isRowUpdated = false;
    }

    private void startInsert() {
        this.checkUpdatable();
        this.isOnInsertRow = true;
    }

    private void endInsert() {
        this.checkUpdatable();
        this.preparedStatement.clearParameters();
        this.isOnInsertRow = false;
    }

    private void performUpdate() {
        this.preparedStatement.parameterValues[this.columnCount] = this.getCurrent()[this.columnCount];
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            boolean bl2 = this.preparedStatement.parameterSet[i2] != null;
            this.preparedStatement.resultOut.metaData.columnTypes[i2] = bl2 ? this.preparedStatement.parameterTypes[i2] : ad.SQL_ALL_TYPES;
        }
        this.preparedStatement.resultOut.setActionType(81);
        this.preparedStatement.fetchResult();
        this.preparedStatement.clearParameters();
        this.rootWarning = this.preparedStatement.getWarnings();
        this.preparedStatement.clearWarnings();
        this.isRowUpdated = false;
    }

    private void performInsert() {
        this.checkUpdatable();
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            boolean bl2;
            boolean bl3 = bl2 = this.preparedStatement.parameterSet[i2] != null;
            if (!bl2) {
                throw JDBCUtil.sqlException(3606);
            }
            this.preparedStatement.resultOut.metaData.columnTypes[i2] = this.preparedStatement.parameterTypes[i2];
        }
        this.preparedStatement.resultOut.setActionType(50);
        this.preparedStatement.fetchResult();
        this.preparedStatement.clearParameters();
        this.rootWarning = this.preparedStatement.getWarnings();
        this.preparedStatement.clearWarnings();
    }

    private void performDelete() {
        this.checkUpdatable();
        this.preparedStatement.parameterValues[this.columnCount] = this.getCurrent()[this.columnCount];
        this.preparedStatement.resultOut.metaData.columnTypes[this.columnCount] = this.resultMetaData.columnTypes[this.columnCount];
        this.preparedStatement.resultOut.setActionType(18);
        this.preparedStatement.fetchResult();
        this.preparedStatement.clearParameters();
        this.rootWarning = this.preparedStatement.getWarnings();
        this.preparedStatement.clearWarnings();
    }

    org.hsqldb.d.c getNavigator() {
        return this.navigator;
    }

    void setNavigator(org.hsqldb.d.c c2) {
        this.navigator = c2;
    }

    public JDBCResultSet(JDBCConnection jDBCConnection, JDBCStatementBase jDBCStatementBase, a a2, org.hsqldb.g.c c2) {
        this(jDBCConnection, a2, c2);
        this.statement = jDBCStatementBase;
        this.isScrollable = d.isScrollable(this.rsProperties);
        if (d.isUpdatable(this.rsProperties)) {
            this.isUpdatable = true;
            this.isInsertable = true;
            for (int i2 = 0; i2 < c2.colIndexes.length; ++i2) {
                if (c2.colIndexes[i2] >= 0) continue;
                this.isInsertable = false;
                break;
            }
            this.preparedStatement = new JDBCPreparedStatement(jDBCStatementBase.connection, this.result);
        }
    }

    public JDBCResultSet(JDBCConnection jDBCConnection, a a2, org.hsqldb.g.c c2) {
        this.session = jDBCConnection == null ? null : jDBCConnection.sessionProxy;
        this.result = a2;
        this.connection = jDBCConnection;
        this.rsProperties = a2.rsProperties;
        this.navigator = a2.getNavigator();
        this.resultMetaData = c2;
        this.columnCount = this.resultMetaData.getColumnCount();
        if (jDBCConnection != null && jDBCConnection.clientProperties != null) {
            this.translateTTIType = jDBCConnection.clientProperties.isPropertyTrue("jdbc.translate_tti_types");
        }
    }

    public static JDBCResultSet newJDBCResultSet(a a2, org.hsqldb.g.c c2) {
        return new JDBCResultSetBasic(a2, c2);
    }

    public static JDBCResultSet newEptyResultSet() {
        org.hsqldb.g.c c2 = org.hsqldb.g.c.newResultMetaData(1);
        c c3 = new c(null, null, null, "C1");
        c3.setType(ad.SQL_INTEGER);
        c2.columnTypes[0] = ad.SQL_INTEGER;
        c2.columns[0] = c3;
        a a2 = a.newSingleColumnResult(c2);
        return JDBCResultSet.newJDBCResultSet(a2, c2);
    }

    static class JDBCResultSetBasic
    extends JDBCResultSet {
        JDBCResultSetBasic(a a2, org.hsqldb.g.c c2) {
            super(null, a2, c2);
        }

        @Override
        protected Object getColumnInType(int n2, ad ad2) {
            Object[] objectArray = this.getCurrent();
            this.checkColumn(n2);
            ad ad3 = this.resultMetaData.columnTypes[--n2];
            Object object = objectArray[n2];
            if (this.trackNull(object)) {
                return null;
            }
            if (ad3.typeCode != ad2.typeCode) {
                JDBCUtil.throwError(org.hsqldb.a.a.error(5561));
            }
            return object;
        }

        @Override
        public Date getDate(int n2) {
            return (Date)this.getColumnInType(n2, ad.SQL_DATE);
        }

        @Override
        public Time getTime(int n2) {
            return (Time)this.getColumnInType(n2, ad.SQL_DATE);
        }

        @Override
        public Timestamp getTimestamp(int n2) {
            return (Timestamp)this.getColumnInType(n2, ad.SQL_DATE);
        }

        @Override
        public InputStream getBinaryStream(int n2) {
            throw JDBCUtil.notSupported();
        }

        @Override
        public Reader getCharacterStream(int n2) {
            throw JDBCUtil.notSupported();
        }

        @Override
        public Blob getBlob(int n2) {
            this.checkColumn(n2);
            ad ad2 = this.resultMetaData.columnTypes[n2 - 1];
            Object object = this.getColumnInType(n2, ad2);
            if (object == null) {
                return null;
            }
            if (object instanceof Blob) {
                return (Blob)object;
            }
            if (object instanceof byte[]) {
                return new JDBCBlob((byte[])object);
            }
            throw JDBCUtil.sqlException(5561);
        }

        @Override
        public Clob getClob(int n2) {
            this.checkColumn(n2);
            ad ad2 = this.resultMetaData.columnTypes[n2 - 1];
            Object object = this.getColumnInType(n2, ad2);
            if (object == null) {
                return null;
            }
            if (object instanceof Clob) {
                return (Clob)object;
            }
            if (object instanceof String) {
                return new JDBCClob((String)object);
            }
            throw JDBCUtil.sqlException(5561);
        }

        @Override
        public Time getTime(int n2, Calendar calendar) {
            throw JDBCUtil.notSupported();
        }

        @Override
        public Timestamp getTimestamp(int n2, Calendar calendar) {
            throw JDBCUtil.notSupported();
        }
    }
}

