/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import org.hsqldb.aa;
import org.hsqldb.bj;
import org.hsqldb.g.a;
import org.hsqldb.g.c;
import org.hsqldb.g.d;
import org.hsqldb.jdbc.JDBCArray;
import org.hsqldb.jdbc.JDBCBlob;
import org.hsqldb.jdbc.JDBCBlobClient;
import org.hsqldb.jdbc.JDBCClob;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCParameterMetaData;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.JDBCResultSetMetaData;
import org.hsqldb.jdbc.JDBCStatementBase;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.k.ab;
import org.hsqldb.k.ac;
import org.hsqldb.k.ad;
import org.hsqldb.k.b;
import org.hsqldb.k.f;
import org.hsqldb.k.m;
import org.hsqldb.k.n;
import org.hsqldb.k.v;
import org.hsqldb.k.w;
import org.hsqldb.lib.bh;
import org.hsqldb.lib.g;
import org.hsqldb.lib.k;
import org.hsqldb.lib.x;
import org.hsqldb.z;

public class JDBCPreparedStatement
extends JDBCStatementBase
implements PreparedStatement {
    boolean poolable = true;
    protected Object[] parameterValues;
    protected Boolean[] parameterSet;
    protected ad[] parameterTypes;
    protected byte[] parameterModes;
    protected long[] streamLengths;
    protected boolean hasStreams;
    protected boolean hasLOBs;
    protected boolean isBatch;
    protected c resultMetaData;
    protected c parameterMetaData;
    protected JDBCResultSetMetaData resultSetMetaData;
    protected Object pmd;
    protected String sql;
    protected long statementID;
    protected int statementRetType;
    protected final boolean isResult;
    protected bj session;

    @Override
    public synchronized ResultSet executeQuery() {
        if (this.statementRetType != 2) {
            this.checkStatementType(2);
        }
        this.fetchResult();
        return this.getResultSet();
    }

    @Override
    public synchronized int executeUpdate() {
        if (this.statementRetType != 1) {
            this.checkStatementType(1);
        }
        this.fetchResult();
        return this.resultIn.getUpdateCount();
    }

    @Override
    public synchronized void setNull(int n2, int n3) {
        this.setParameter(n2, null);
    }

    @Override
    public synchronized void setBoolean(int n2, boolean bl2) {
        Boolean bl3 = bl2 ? Boolean.TRUE : Boolean.FALSE;
        this.setParameter(n2, bl3);
    }

    @Override
    public synchronized void setByte(int n2, byte by2) {
        this.setIntParameter(n2, by2);
    }

    @Override
    public synchronized void setShort(int n2, short s2) {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.checkSetParameterIndex(n2);
        if (this.parameterTypes[n2 - 1].typeCode == 5) {
            this.parameterValues[--n2] = (int)s2;
            this.parameterSet[n2] = Boolean.TRUE;
            return;
        }
        this.setIntParameter(n2, s2);
    }

    @Override
    public synchronized void setInt(int n2, int n3) {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.checkSetParameterIndex(n2);
        if (this.parameterTypes[n2 - 1].typeCode == 4) {
            this.parameterValues[--n2] = n3;
            this.parameterSet[n2] = Boolean.TRUE;
            return;
        }
        this.setIntParameter(n2, n3);
    }

    @Override
    public synchronized void setLong(int n2, long l2) {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.checkSetParameterIndex(n2);
        if (this.parameterTypes[n2 - 1].typeCode == 25) {
            this.parameterValues[--n2] = l2;
            this.parameterSet[n2] = Boolean.TRUE;
            return;
        }
        this.setLongParameter(n2, l2);
    }

    @Override
    public synchronized void setFloat(int n2, float f2) {
        this.setDouble(n2, f2);
    }

    @Override
    public synchronized void setDouble(int n2, double d2) {
        Double d3 = new Double(d2);
        this.setParameter(n2, d3);
    }

    @Override
    public synchronized void setBigDecimal(int n2, BigDecimal bigDecimal) {
        this.setParameter(n2, bigDecimal);
    }

    @Override
    public synchronized void setString(int n2, String string) {
        this.setParameter(n2, string);
    }

    @Override
    public synchronized void setBytes(int n2, byte[] byArray) {
        this.setParameter(n2, byArray);
    }

    @Override
    public synchronized void setDate(int n2, Date date) {
        this.setParameter(n2, date);
    }

    @Override
    public synchronized void setTime(int n2, Time time) {
        this.setParameter(n2, time);
    }

    @Override
    public synchronized void setTimestamp(int n2, Timestamp timestamp) {
        this.setParameter(n2, timestamp);
    }

    @Override
    public synchronized void setAsciiStream(int n2, InputStream inputStream, int n3) {
        this.setAsciiStream(n2, inputStream, (long)n3);
    }

    @Override
    public synchronized void setUnicodeStream(int n2, InputStream inputStream, int n3) {
        this.checkSetParameterIndex(n2);
        Object var4_4 = null;
        if (inputStream == null) {
            throw JDBCUtil.nullArgument("x");
        }
        String string = "UTF8";
        StringWriter stringWriter = new StringWriter();
        try {
            int n4;
            k k2 = new k(inputStream);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)k2, string);
            char[] cArray = new char[1024];
            k2.setCount(n3);
            while (-1 != (n4 = inputStreamReader.read(cArray))) {
                stringWriter.write(cArray, 0, n4);
            }
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(401, iOException.toString(), iOException);
        }
        this.setParameter(n2, stringWriter.toString());
    }

    @Override
    public synchronized void setBinaryStream(int n2, InputStream inputStream, int n3) {
        this.setBinaryStream(n2, inputStream, (long)n3);
    }

    @Override
    public synchronized void clearParameters() {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        org.hsqldb.lib.d.fillArray(this.parameterValues, null);
        org.hsqldb.lib.d.fillArray((Object[])this.parameterSet, null);
        org.hsqldb.lib.d.clearArray(74, this.streamLengths, 0, this.streamLengths.length);
    }

    @Override
    public synchronized void setObject(int n2, Object object, int n3, int n4) {
        if (object instanceof InputStream) {
            this.setBinaryStream(n2, (InputStream)object, n4);
        } else if (object instanceof Reader) {
            this.setCharacterStream(n2, (Reader)object, n4);
        } else {
            this.setObject(n2, object);
        }
    }

    @Override
    public synchronized void setObject(int n2, Object object, int n3) {
        this.setObject(n2, object);
    }

    @Override
    public synchronized void setObject(int n2, Object object) {
        this.setParameter(n2, object);
    }

    @Override
    public synchronized boolean execute() {
        this.fetchResult();
        return this.statementRetType == 2;
    }

    @Override
    public synchronized void addBatch() {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.checkParametersSet();
        if (!this.isBatch) {
            this.resultOut.setBatchedPreparedExecuteRequest();
            this.isBatch = true;
        }
        try {
            this.performPreExecute();
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
        int n2 = this.parameterValues.length;
        Object[] objectArray = new Object[n2];
        System.arraycopy(this.parameterValues, 0, objectArray, 0, n2);
        this.resultOut.addBatchedPreparedExecuteRequest(objectArray);
    }

    @Override
    public synchronized void setCharacterStream(int n2, Reader reader, int n3) {
        this.setCharacterStream(n2, reader, (long)n3);
    }

    @Override
    public void setRef(int n2, Ref ref) {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized void setBlob(int n2, Blob blob) {
        this.checkSetParameterIndex(n2);
        ad ad2 = this.parameterTypes[n2 - 1];
        switch (ad2.typeCode) {
            case 60: 
            case 61: {
                this.setBlobForBinaryParameter(n2, blob);
                return;
            }
            case 30: {
                this.setBlobParameter(n2, blob);
                break;
            }
            default: {
                throw JDBCUtil.invalidArgument();
            }
        }
    }

    private void setBlobForBinaryParameter(int n2, Blob blob) {
        if (blob instanceof JDBCBlob) {
            this.setParameter(n2, ((JDBCBlob)blob).data());
            return;
        }
        if (blob == null) {
            this.setParameter(n2, null);
            return;
        }
        long l2 = blob.length();
        if (l2 > Integer.MAX_VALUE) {
            String string = "Maximum Blob input octet length exceeded: " + l2;
            throw JDBCUtil.sqlException(422, string);
        }
        try {
            InputStream inputStream = blob.getBinaryStream();
            x x2 = new x(inputStream, (int)l2);
            this.setParameter(n2, x2.toByteArray());
        }
        catch (Throwable throwable) {
            throw JDBCUtil.sqlException(422, throwable.toString(), throwable);
        }
    }

    @Override
    public synchronized void setClob(int n2, Clob clob) {
        this.checkSetParameterIndex(n2);
        ad ad2 = this.parameterTypes[n2 - 1];
        switch (ad2.typeCode) {
            case 1: 
            case 12: {
                this.setClobForStringParameter(n2, clob);
                return;
            }
            case 40: {
                this.setClobParameter(n2, clob);
                return;
            }
        }
        throw JDBCUtil.invalidArgument();
    }

    private void setClobForStringParameter(int n2, Clob clob) {
        if (clob instanceof JDBCClob) {
            this.setParameter(n2, ((JDBCClob)clob).data());
            return;
        }
        if (clob == null) {
            this.setParameter(n2, null);
            return;
        }
        long l2 = clob.length();
        if (l2 > Integer.MAX_VALUE) {
            String string = "Max Clob input character length exceeded: " + l2;
            throw JDBCUtil.sqlException(422, string);
        }
        try {
            Reader reader = clob.getCharacterStream();
            g g2 = new g(reader, (int)l2);
            this.setParameter(n2, g2.toString());
        }
        catch (Throwable throwable) {
            throw JDBCUtil.sqlException(401, throwable.toString(), throwable);
        }
    }

    @Override
    public synchronized void setArray(int n2, Array array) {
        this.checkParameterIndex(n2);
        ad ad2 = this.parameterMetaData.columnTypes[n2 - 1];
        if (!ad2.isArrayType()) {
            throw JDBCUtil.sqlException(5561);
        }
        if (array == null) {
            this.setParameter(n2, null);
            return;
        }
        Object[] objectArray = null;
        if (array instanceof JDBCArray) {
            objectArray = ((JDBCArray)array).getArrayInternal();
        } else {
            Object object = array.getArray();
            if (object instanceof Object[]) {
                ad ad3 = ad2.collectionBaseType();
                Object[] objectArray2 = (Object[])object;
                objectArray = new Object[objectArray2.length];
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    objectArray[i2] = ad3.convertJavaToSQL(this.session, objectArray2[i2]);
                }
            } else {
                throw JDBCUtil.notSupported();
            }
        }
        this.parameterValues[n2 - 1] = objectArray;
        this.parameterSet[n2 - 1] = Boolean.TRUE;
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (this.statementRetType != 2) {
            return null;
        }
        if (this.resultSetMetaData == null) {
            boolean bl2 = d.isUpdatable(this.rsProperties);
            boolean bl3 = bl2;
            if (bl3) {
                for (int i2 = 0; i2 < this.resultMetaData.colIndexes.length; ++i2) {
                    if (this.resultMetaData.colIndexes[i2] >= 0) continue;
                    bl3 = false;
                    break;
                }
            }
            this.resultSetMetaData = new JDBCResultSetMetaData(this.resultMetaData, bl2, bl3, this.connection);
        }
        return this.resultSetMetaData;
    }

    @Override
    public synchronized void setDate(int n2, Date date, Calendar calendar) {
        this.checkSetParameterIndex(n2);
        int n3 = n2 - 1;
        if (date == null) {
            this.parameterValues[n3] = null;
            this.parameterSet[n3] = Boolean.TRUE;
            return;
        }
        ad ad2 = this.parameterTypes[n3];
        Calendar calendar2 = calendar == null ? this.session.getCalendar() : calendar;
        long l2 = z.convertMillisFromCalendar(calendar2, date.getTime());
        l2 = z.getNormalisedDate(l2);
        switch (ad2.typeCode) {
            case 91: 
            case 93: {
                this.parameterValues[n3] = new ac(l2 / 1000L);
                break;
            }
            case 95: {
                int n4 = z.getZoneMillis(calendar2, l2);
                this.parameterValues[n3] = new ac(l2 / 1000L, 0, n4 / 1000);
                break;
            }
            default: {
                throw JDBCUtil.sqlException(5561);
            }
        }
        this.parameterSet[n3] = Boolean.TRUE;
    }

    @Override
    public synchronized void setTime(int n2, Time time, Calendar calendar) {
        this.checkSetParameterIndex(n2);
        int n3 = n2 - 1;
        if (time == null) {
            this.parameterValues[n3] = null;
            this.parameterSet[n3] = Boolean.TRUE;
            return;
        }
        ad ad2 = this.parameterTypes[n3];
        long l2 = time.getTime();
        int n4 = 0;
        Calendar calendar2 = calendar == null ? this.session.getCalendar() : calendar;
        l2 = z.convertMillisFromCalendar(calendar2, l2);
        l2 = z.convertToNormalisedTime(l2);
        switch (ad2.typeCode) {
            case 92: {
                break;
            }
            case 94: {
                n4 = z.getZoneMillis(calendar2, l2);
                break;
            }
            default: {
                throw JDBCUtil.sqlException(5561);
            }
        }
        this.parameterValues[n3] = new ab((int)(l2 / 1000L), 0, n4 / 1000);
        this.parameterSet[n3] = Boolean.TRUE;
    }

    @Override
    public synchronized void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) {
        this.checkSetParameterIndex(n2);
        int n3 = n2 - 1;
        if (timestamp == null) {
            this.parameterValues[n3] = null;
            this.parameterSet[n3] = Boolean.TRUE;
            return;
        }
        ad ad2 = this.parameterTypes[n3];
        long l2 = timestamp.getTime();
        int n4 = 0;
        Calendar calendar2 = calendar == null ? this.session.getCalendar() : calendar;
        l2 = z.convertMillisFromCalendar(calendar2, l2);
        switch (ad2.typeCode) {
            case 95: {
                n4 = z.getZoneMillis(calendar2, l2);
            }
            case 93: {
                this.parameterValues[n3] = new ac(l2 / 1000L, timestamp.getNanos(), n4 / 1000);
                break;
            }
            case 92: {
                l2 = z.getNormalisedTime(l2);
                this.parameterValues[n3] = new ab((int)(l2 / 1000L), timestamp.getNanos(), 0);
                break;
            }
            case 94: {
                n4 = z.getZoneMillis(calendar2, l2);
                this.parameterValues[n3] = new ab((int)(l2 / 1000L), timestamp.getNanos(), n4 / 1000);
                break;
            }
            case 91: {
                l2 = z.getNormalisedDate(l2);
                this.parameterValues[n3] = new ac(l2 / 1000L);
                break;
            }
            default: {
                throw JDBCUtil.sqlException(5561);
            }
        }
        this.parameterSet[n3] = Boolean.TRUE;
    }

    @Override
    public synchronized void setNull(int n2, int n3, String string) {
        this.setParameter(n2, null);
    }

    @Override
    public synchronized int[] executeBatch() {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.checkStatementType(1);
        if (!this.isBatch) {
            throw JDBCUtil.sqlExceptionSQL(1256);
        }
        this.generatedResult = null;
        int n2 = this.resultOut.getNavigator().getSize();
        this.resultIn = null;
        try {
            this.resultIn = this.session.execute(this.resultOut);
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
        finally {
            this.performPostExecute();
            this.resultOut.getNavigator().clear();
            this.isBatch = false;
        }
        if (this.resultIn.mode == 2) {
            throw JDBCUtil.sqlException(this.resultIn);
        }
        org.hsqldb.d.c c2 = this.resultIn.getNavigator();
        int[] nArray = new int[c2.getSize()];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            Object[] objectArray = c2.getNext();
            nArray[i2] = (Integer)objectArray[0];
        }
        if (nArray.length != n2) {
            if (this.errorResult == null) {
                throw new BatchUpdateException(nArray);
            }
            this.errorResult.getMainString();
            throw new BatchUpdateException(this.errorResult.getMainString(), this.errorResult.getSubString(), this.errorResult.getErrorCode(), nArray);
        }
        return nArray;
    }

    @Override
    public void setEscapeProcessing(boolean bl2) {
        this.checkClosed();
    }

    @Override
    public void addBatch(String string) {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized ResultSet executeQuery(String string) {
        throw JDBCUtil.notSupported();
    }

    @Override
    public boolean execute(String string) {
        throw JDBCUtil.notSupported();
    }

    @Override
    public int executeUpdate(String string) {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        this.closeResultData();
        aa aa2 = null;
        try {
            if (!this.connection.isClosed) {
                this.session.execute(a.newFreeStmtRequest(this.statementID));
            }
        }
        catch (aa aa3) {
            aa2 = aa3;
        }
        this.parameterValues = null;
        this.parameterSet = null;
        this.parameterTypes = null;
        this.parameterModes = null;
        this.resultMetaData = null;
        this.parameterMetaData = null;
        this.resultSetMetaData = null;
        this.pmd = null;
        this.connection = null;
        this.session = null;
        this.resultIn = null;
        this.resultOut = null;
        this.isClosed = true;
        if (aa2 != null) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        String string = this.sql;
        Object[] objectArray = this.parameterValues;
        if (string == null || objectArray == null) {
            stringBuffer.append("[closed]");
            return stringBuffer.toString();
        }
        stringBuffer.append("[sql=[").append(string).append("]");
        if (objectArray.length > 0) {
            stringBuffer.append(", parameters=[");
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                stringBuffer.append('[');
                stringBuffer.append(objectArray[i2]);
                stringBuffer.append("], ");
            }
            stringBuffer.setLength(stringBuffer.length() - 2);
            stringBuffer.append(']');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    @Override
    public void setURL(int n2, URL uRL) {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized ParameterMetaData getParameterMetaData() {
        this.checkClosed();
        if (this.pmd == null) {
            this.pmd = new JDBCParameterMetaData(this.connection, this.parameterMetaData);
        }
        return (ParameterMetaData)this.pmd;
    }

    @Override
    public int executeUpdate(String string, int n2) {
        throw JDBCUtil.notSupported();
    }

    @Override
    public boolean execute(String string, int n2) {
        throw JDBCUtil.notSupported();
    }

    @Override
    public int executeUpdate(String string, int[] nArray) {
        throw JDBCUtil.notSupported();
    }

    @Override
    public boolean execute(String string, int[] nArray) {
        throw JDBCUtil.notSupported();
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) {
        throw JDBCUtil.notSupported();
    }

    @Override
    public boolean execute(String string, String[] stringArray) {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized boolean getMoreResults(int n2) {
        return super.getMoreResults(n2);
    }

    @Override
    public synchronized ResultSet getGeneratedKeys() {
        return this.getGeneratedResultSet();
    }

    @Override
    public synchronized int getResultSetHoldability() {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return d.getJDBCHoldability(this.rsProperties);
    }

    @Override
    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void setRowId(int n2, RowId rowId) {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized void setNString(int n2, String string) {
        this.setString(n2, string);
    }

    @Override
    public synchronized void setNCharacterStream(int n2, Reader reader, long l2) {
        this.setCharacterStream(n2, reader, l2);
    }

    @Override
    public synchronized void setNClob(int n2, NClob nClob) {
        this.setClob(n2, nClob);
    }

    @Override
    public synchronized void setClob(int n2, Reader reader, long l2) {
        this.setCharacterStream(n2, reader, l2);
    }

    @Override
    public synchronized void setBlob(int n2, InputStream inputStream, long l2) {
        this.setBinaryStream(n2, inputStream, l2);
    }

    @Override
    public synchronized void setNClob(int n2, Reader reader, long l2) {
        this.setClob(n2, reader, l2);
    }

    @Override
    public void setSQLXML(int n2, SQLXML sQLXML) {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized void setAsciiStream(int n2, InputStream inputStream, long l2) {
        if (l2 < 0L) {
            throw JDBCUtil.sqlException(423, "length: " + l2);
        }
        this.setAscStream(n2, inputStream, l2);
    }

    void setAscStream(int n2, InputStream inputStream, long l2) {
        if (l2 > Integer.MAX_VALUE) {
            JDBCUtil.sqlException(3401);
        }
        if (inputStream == null) {
            throw JDBCUtil.nullArgument("x");
        }
        try {
            String string = bh.inputStreamToString(inputStream, "US-ASCII");
            if (l2 >= 0L && (long)string.length() > l2) {
                string = string.substring(0, (int)l2);
            }
            this.setParameter(n2, string);
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(422, null, iOException);
        }
    }

    @Override
    public synchronized void setBinaryStream(int n2, InputStream inputStream, long l2) {
        if (l2 < 0L) {
            throw JDBCUtil.sqlException(423, "length: " + l2);
        }
        this.setBinStream(n2, inputStream, l2);
    }

    private void setBinStream(int n2, InputStream inputStream, long l2) {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (this.parameterTypes[n2 - 1].typeCode == 30) {
            this.setBlobParameter(n2, inputStream, l2);
            return;
        }
        if (l2 > Integer.MAX_VALUE) {
            String string = "Maximum Blob input length exceeded: " + l2;
            throw JDBCUtil.sqlException(422, string);
        }
        try {
            x x2 = l2 < 0L ? new x(inputStream) : new x(inputStream, (int)l2);
            this.setParameter(n2, x2.toByteArray());
        }
        catch (Throwable throwable) {
            throw JDBCUtil.sqlException(422, throwable.toString(), throwable);
        }
    }

    @Override
    public synchronized void setCharacterStream(int n2, Reader reader, long l2) {
        if (l2 < 0L) {
            throw JDBCUtil.sqlException(423, "length: " + l2);
        }
        this.setCharStream(n2, reader, l2);
    }

    private void setCharStream(int n2, Reader reader, long l2) {
        this.checkSetParameterIndex(n2);
        if (this.parameterTypes[n2 - 1].typeCode == 40) {
            this.setClobParameter(n2, reader, l2);
            return;
        }
        if (l2 > Integer.MAX_VALUE) {
            String string = "Maximum Clob input length exceeded: " + l2;
            throw JDBCUtil.sqlException(422, string);
        }
        try {
            g g2 = l2 < 0L ? new g(reader) : new g(reader, (int)l2);
            this.setParameter(n2, g2.toString());
        }
        catch (Throwable throwable) {
            throw JDBCUtil.sqlException(422, throwable.toString(), throwable);
        }
    }

    @Override
    public void setAsciiStream(int n2, InputStream inputStream) {
        this.setAscStream(n2, inputStream, -1L);
    }

    @Override
    public synchronized void setBinaryStream(int n2, InputStream inputStream) {
        this.setBinStream(n2, inputStream, -1L);
    }

    @Override
    public void setCharacterStream(int n2, Reader reader) {
        this.setCharStream(n2, reader, -1L);
    }

    @Override
    public void setNCharacterStream(int n2, Reader reader) {
        this.setCharStream(n2, reader, -1L);
    }

    @Override
    public void setClob(int n2, Reader reader) {
        this.setCharStream(n2, reader, -1L);
    }

    @Override
    public void setBlob(int n2, InputStream inputStream) {
        this.setBinStream(n2, inputStream, -1L);
    }

    @Override
    public void setNClob(int n2, Reader reader) {
        this.setCharStream(n2, reader, -1L);
    }

    @Override
    public synchronized int getMaxFieldSize() {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return 0;
    }

    @Override
    public synchronized void setMaxFieldSize(int n2) {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n2 < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
    }

    @Override
    public synchronized int getMaxRows() {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.maxRows;
    }

    @Override
    public synchronized void setMaxRows(int n2) {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n2 < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        this.maxRows = n2;
    }

    @Override
    public synchronized int getQueryTimeout() {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.queryTimeout;
    }

    @Override
    public synchronized void setQueryTimeout(int n2) {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n2 < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (n2 > Short.MAX_VALUE) {
            n2 = Short.MAX_VALUE;
        }
        this.queryTimeout = n2;
    }

    @Override
    public void cancel() {
        this.checkClosed();
    }

    @Override
    public synchronized SQLWarning getWarnings() {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.rootWarning;
    }

    @Override
    public synchronized void clearWarnings() {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.rootWarning = null;
    }

    @Override
    public void setCursorName(String string) {
        this.checkClosed();
    }

    @Override
    public synchronized ResultSet getResultSet() {
        return super.getResultSet();
    }

    @Override
    public synchronized int getUpdateCount() {
        return super.getUpdateCount();
    }

    @Override
    public synchronized boolean getMoreResults() {
        return this.getMoreResults(1);
    }

    @Override
    public synchronized void setFetchDirection(int n2) {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n2 != 1000 && n2 != 1001 && n2 != 1002) {
            throw JDBCUtil.notSupported();
        }
        this.fetchDirection = n2;
    }

    @Override
    public synchronized int getFetchDirection() {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.fetchDirection;
    }

    @Override
    public synchronized void setFetchSize(int n2) {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n2 < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        this.fetchSize = n2;
    }

    @Override
    public synchronized int getFetchSize() {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.fetchSize;
    }

    @Override
    public synchronized int getResultSetConcurrency() {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return d.getJDBCConcurrency(this.rsProperties);
    }

    @Override
    public synchronized int getResultSetType() {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return d.getJDBCScrollability(this.rsProperties);
    }

    @Override
    public synchronized void clearBatch() {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (this.isBatch) {
            this.resultOut.getNavigator().clear();
        }
    }

    @Override
    public synchronized Connection getConnection() {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.connection;
    }

    @Override
    public synchronized void setPoolable(boolean bl2) {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.poolable = bl2;
    }

    @Override
    public synchronized boolean isPoolable() {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.poolable;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    JDBCPreparedStatement(JDBCConnection jDBCConnection, String string, int n2, int n3, int n4, int n5, int[] nArray, String[] stringArray) {
        int n6;
        this.isResult = false;
        this.connection = jDBCConnection;
        this.connectionIncarnation = this.connection.incarnation;
        this.session = jDBCConnection.sessionProxy;
        string = jDBCConnection.nativeSQL(string);
        int[] nArray2 = null;
        if (nArray != null) {
            nArray2 = new int[nArray.length];
            for (n6 = 0; n6 < nArray.length; ++n6) {
                nArray2[n6] = nArray[n6] - 1;
            }
        }
        this.resultOut = a.newPrepareStatementRequest();
        n6 = d.getValueForJDBC(n2, n3, n4);
        this.resultOut.setPrepareOrExecuteProperties(string, 0, 0, 0, this.queryTimeout, n6, n5, nArray, stringArray);
        a a2 = this.session.execute(this.resultOut);
        if (a2.mode == 2) {
            throw JDBCUtil.sqlException(a2);
        }
        this.rootWarning = null;
        a a3 = a2;
        while (a3.getChainedResult() != null) {
            if (!(a3 = a3.getUnlinkChainedResult()).isWarning()) continue;
            SQLWarning sQLWarning = JDBCUtil.sqlWarning(a3);
            if (this.rootWarning == null) {
                this.rootWarning = sQLWarning;
                continue;
            }
            this.rootWarning.setNextWarning(sQLWarning);
        }
        this.connection.setWarnings(this.rootWarning);
        this.statementID = a2.getStatementID();
        this.statementRetType = a2.getStatementType();
        this.resultMetaData = a2.metaData;
        this.parameterMetaData = a2.parameterMetaData;
        this.parameterTypes = this.parameterMetaData.getParameterTypes();
        this.parameterModes = this.parameterMetaData.paramModes;
        this.rsProperties = a2.rsProperties;
        int n7 = this.parameterMetaData.getColumnCount();
        this.parameterValues = new Object[n7];
        this.parameterSet = new Boolean[n7];
        this.streamLengths = new long[n7];
        for (int i2 = 0; i2 < n7; ++i2) {
            if (!this.parameterTypes[i2].isLobType()) continue;
            this.hasLOBs = true;
            break;
        }
        this.resultOut = a.newPreparedExecuteRequest(this.parameterTypes, this.statementID);
        this.resultOut.setStatement(a2.getStatement());
        this.sql = string;
    }

    JDBCPreparedStatement(JDBCConnection jDBCConnection, a a2) {
        this.isResult = true;
        this.connection = jDBCConnection;
        this.connectionIncarnation = this.connection.incarnation;
        this.session = jDBCConnection.sessionProxy;
        int n2 = a2.metaData.getExtendedColumnCount();
        this.parameterMetaData = a2.metaData;
        this.parameterTypes = a2.metaData.columnTypes;
        this.parameterModes = new byte[n2];
        this.parameterValues = new Object[n2];
        this.parameterSet = new Boolean[n2];
        this.streamLengths = new long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.parameterModes[i2] = 1;
            if (!this.parameterTypes[i2].isLobType()) continue;
            this.hasLOBs = true;
        }
        this.resultOut = a.newUpdateResultRequest(this.parameterTypes, a2.getResultId());
    }

    protected void checkStatementType(int n2) {
        if (n2 != this.statementRetType) {
            if (this.statementRetType == 1) {
                throw JDBCUtil.sqlException(1254);
            }
            throw JDBCUtil.sqlException(1253);
        }
    }

    protected void checkParameterIndex(int n2) {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n2 < 1 || n2 > this.parameterValues.length) {
            String string = "parameter index out of range: " + n2;
            throw JDBCUtil.outOfRangeArgument(string);
        }
    }

    protected void checkSetParameterIndex(int n2) {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n2 < 1 || n2 > this.parameterValues.length) {
            String string = "parameter index out of range: " + n2;
            throw JDBCUtil.outOfRangeArgument(string);
        }
        if (this.parameterModes[n2 - 1] == 4) {
            String string = "Not IN or INOUT mode for parameter: " + n2;
            throw JDBCUtil.invalidArgument(string);
        }
    }

    protected void checkGetParameterIndex(int n2) {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n2 < 1 || n2 > this.parameterValues.length) {
            String string = "parameter index out of range: " + n2;
            throw JDBCUtil.outOfRangeArgument(string);
        }
        byte by2 = this.parameterModes[n2 - 1];
        switch (by2) {
            case 0: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                String string = "Not OUT or INOUT mode: " + by2 + " for parameter: " + n2;
                throw JDBCUtil.invalidArgument(string);
            }
        }
    }

    private void checkParametersSet() {
        if (this.isResult) {
            return;
        }
        for (int i2 = 0; i2 < this.parameterSet.length; ++i2) {
            if (this.parameterModes[i2] == 4 || this.parameterSet[i2] != null) continue;
            throw JDBCUtil.sqlException(424);
        }
    }

    void setParameter(int n2, Object object) {
        this.checkSetParameterIndex(n2);
        --n2;
        if (object == null) {
            this.parameterValues[n2] = null;
            this.parameterSet[n2] = Boolean.TRUE;
            return;
        }
        ad ad2 = this.parameterTypes[n2];
        switch (ad2.typeCode) {
            case 1111: {
                try {
                    if (object instanceof Serializable) {
                        object = new v((Serializable)object);
                        break;
                    }
                }
                catch (aa aa2) {
                    JDBCUtil.throwError(aa2);
                }
                JDBCUtil.throwError(org.hsqldb.a.a.error(5563));
            }
            case 14: 
            case 15: {
                try {
                    if (object instanceof Boolean) {
                        object = ad2.convertToDefaultType(this.session, object);
                        break;
                    }
                    if (object instanceof Integer) {
                        object = ad2.convertToDefaultType(this.session, object);
                        break;
                    }
                    if (object instanceof byte[]) {
                        object = ad2.convertToDefaultType(this.session, object);
                        break;
                    }
                    if (object instanceof String) {
                        object = ad2.convertToDefaultType(this.session, object);
                        break;
                    }
                }
                catch (aa aa3) {
                    JDBCUtil.throwError(aa3);
                }
                JDBCUtil.throwError(org.hsqldb.a.a.error(5563));
            }
            case 60: 
            case 61: {
                if (object instanceof byte[]) {
                    object = new b((byte[])object, !this.connection.isNetConn);
                    break;
                }
                try {
                    if (object instanceof String) {
                        object = ad2.convertToDefaultType(this.session, object);
                        break;
                    }
                }
                catch (aa aa4) {
                    JDBCUtil.throwError(aa4);
                }
                JDBCUtil.throwError(org.hsqldb.a.a.error(5563));
                break;
            }
            case 50: {
                if (object instanceof Array) {
                    this.setArray(n2 + 1, (Array)object);
                    return;
                }
                if (object instanceof ArrayList) {
                    object = ((ArrayList)object).toArray();
                }
                if (object instanceof Object[]) {
                    ad ad3 = ad2.collectionBaseType();
                    Object object2 = object;
                    Object[] objectArray = new Object[((Object[])object2).length];
                    for (int i2 = 0; i2 < objectArray.length; ++i2) {
                        objectArray[i2] = ad3.convertJavaToSQL(this.session, object2[i2]);
                    }
                    object = objectArray;
                    break;
                }
                JDBCUtil.throwError(org.hsqldb.a.a.error(5563));
            }
            case 30: {
                this.setBlobParameter(n2 + 1, object);
                return;
            }
            case 40: {
                this.setClobParameter(n2 + 1, object);
                return;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                try {
                    if (object instanceof String) {
                        object = ad2.convertToType(this.session, object, ad.SQL_VARCHAR);
                        break;
                    }
                    object = ad2.convertJavaToSQL(this.session, object);
                    break;
                }
                catch (aa aa5) {
                    JDBCUtil.throwError(aa5);
                }
            }
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 25: {
                try {
                    if (object instanceof String) {
                        object = ad2.convertToType(this.session, object, ad.SQL_VARCHAR);
                        break;
                    }
                    if (object instanceof Boolean) {
                        boolean bl2 = (Boolean)object;
                        object = bl2 ? Integer.valueOf(1) : Integer.valueOf(0);
                    }
                    object = ad2.convertToDefaultType(this.session, object);
                    break;
                }
                catch (aa aa6) {
                    JDBCUtil.throwError(aa6);
                }
            }
            case 12: {
                if (object instanceof String) break;
                try {
                    object = ad2.convertToDefaultType(this.session, object);
                    break;
                }
                catch (aa aa7) {
                    JDBCUtil.throwError(aa7);
                }
            }
            case 1: {
                if (ad2.precision == 1L) {
                    if (object instanceof Character) {
                        object = new String(new char[]{((Character)object).charValue()});
                        break;
                    }
                    if (object instanceof Boolean) {
                        object = (Boolean)object != false ? "1" : "0";
                        break;
                    }
                }
            }
            default: {
                try {
                    object = ad2.convertToDefaultType(this.session, object);
                    break;
                }
                catch (aa aa8) {
                    JDBCUtil.throwError(aa8);
                }
            }
        }
        this.parameterValues[n2] = object;
        this.parameterSet[n2] = Boolean.TRUE;
    }

    void setClobParameter(int n2, Object object) {
        this.setClobParameter(n2, object, 0L);
    }

    void setClobParameter(int n2, Object object, long l2) {
        if (object instanceof JDBCClobClient) {
            JDBCClobClient jDBCClobClient = (JDBCClobClient)object;
            if (!jDBCClobClient.session.getDatabaseUniqueName().equals(this.session.getDatabaseUniqueName())) {
                l2 = jDBCClobClient.length();
                Reader reader = jDBCClobClient.getCharacterStream();
                this.parameterValues[n2 - 1] = reader;
                this.streamLengths[n2 - 1] = l2;
                this.parameterSet[n2 - 1] = Boolean.FALSE;
                return;
            }
            this.parameterValues[n2 - 1] = object;
            this.parameterSet[n2 - 1] = Boolean.TRUE;
            return;
        }
        if (object instanceof Clob) {
            this.parameterValues[n2 - 1] = object;
            this.parameterSet[n2 - 1] = Boolean.TRUE;
            return;
        }
        if (object instanceof n) {
            n n3 = (n)object;
            if (n3.session.getDatabaseUniqueName().equals(this.session.getDatabaseUniqueName())) {
                throw JDBCUtil.sqlException(423, "invalid Reader");
            }
            this.parameterValues[n2 - 1] = object;
            this.streamLengths[n2 - 1] = l2;
            this.parameterSet[n2 - 1] = Boolean.FALSE;
            return;
        }
        if (object instanceof Reader) {
            this.parameterValues[n2 - 1] = object;
            this.streamLengths[n2 - 1] = l2;
            this.parameterSet[n2 - 1] = Boolean.FALSE;
            return;
        }
        if (object instanceof String) {
            JDBCClob jDBCClob = new JDBCClob((String)object);
            this.parameterValues[n2 - 1] = jDBCClob;
            this.parameterSet[n2 - 1] = false;
            return;
        }
        throw JDBCUtil.invalidArgument();
    }

    void setBlobParameter(int n2, Object object) {
        this.setBlobParameter(n2, object, 0L);
    }

    void setBlobParameter(int n2, Object object, long l2) {
        if (object instanceof JDBCBlobClient) {
            JDBCBlobClient jDBCBlobClient = (JDBCBlobClient)object;
            if (!jDBCBlobClient.session.getDatabaseUniqueName().equals(this.session.getDatabaseUniqueName())) {
                l2 = jDBCBlobClient.length();
                InputStream inputStream = jDBCBlobClient.getBinaryStream();
                this.parameterValues[n2 - 1] = inputStream;
                this.streamLengths[n2 - 1] = l2;
                this.parameterSet[n2 - 1] = Boolean.FALSE;
                return;
            }
            this.parameterValues[n2 - 1] = object;
            this.parameterSet[n2 - 1] = Boolean.TRUE;
            return;
        }
        if (object instanceof Blob) {
            this.parameterValues[n2 - 1] = object;
            this.parameterSet[n2 - 1] = Boolean.FALSE;
            return;
        }
        if (object instanceof org.hsqldb.k.g) {
            org.hsqldb.k.g g2 = (org.hsqldb.k.g)object;
            if (g2.session.getDatabaseUniqueName().equals(this.session.getDatabaseUniqueName())) {
                throw JDBCUtil.sqlException(423, "invalid Reader");
            }
            this.parameterValues[n2 - 1] = object;
            this.streamLengths[n2 - 1] = l2;
            this.parameterSet[n2 - 1] = Boolean.FALSE;
            return;
        }
        if (object instanceof InputStream) {
            this.parameterValues[n2 - 1] = object;
            this.streamLengths[n2 - 1] = l2;
            this.parameterSet[n2 - 1] = Boolean.FALSE;
            return;
        }
        if (object instanceof byte[]) {
            JDBCBlob jDBCBlob = new JDBCBlob((byte[])object);
            this.parameterValues[n2 - 1] = jDBCBlob;
            this.parameterSet[n2 - 1] = Boolean.TRUE;
            return;
        }
        throw JDBCUtil.invalidArgument();
    }

    void setIntParameter(int n2, int n3) {
        this.checkSetParameterIndex(n2);
        int n4 = this.parameterTypes[n2 - 1].typeCode;
        switch (n4) {
            case -6: 
            case 4: 
            case 5: {
                Integer n5 = n3;
                this.parameterValues[n2 - 1] = n5;
                this.parameterSet[n2 - 1] = Boolean.TRUE;
                break;
            }
            case 25: {
                Long l2 = n3;
                this.parameterValues[n2 - 1] = l2;
                this.parameterSet[n2 - 1] = Boolean.TRUE;
                break;
            }
            case 60: 
            case 61: 
            case 1111: {
                throw JDBCUtil.sqlException(org.hsqldb.a.a.error(5563));
            }
            default: {
                this.setParameter(n2, n3);
            }
        }
    }

    void setLongParameter(int n2, long l2) {
        this.checkSetParameterIndex(n2);
        int n3 = this.parameterTypes[n2 - 1].typeCode;
        switch (n3) {
            case 25: {
                Long l3 = l2;
                this.parameterValues[n2 - 1] = l3;
                this.parameterSet[n2 - 1] = Boolean.TRUE;
                break;
            }
            case 60: 
            case 61: 
            case 1111: {
                throw JDBCUtil.sqlException(org.hsqldb.a.a.error(5563));
            }
            default: {
                this.setParameter(n2, l2);
            }
        }
    }

    private void performPreExecute() {
        if (!this.hasLOBs) {
            return;
        }
        for (int i2 = 0; i2 < this.parameterValues.length; ++i2) {
            org.hsqldb.g.b b2;
            Closeable closeable;
            org.hsqldb.g.b b3;
            Closeable closeable2;
            long l2;
            long l3;
            w w2;
            Object object = this.parameterValues[i2];
            if (object == null) continue;
            if (this.parameterTypes[i2].typeCode == 30) {
                w2 = null;
                if (object instanceof JDBCBlobClient) {
                    w2 = ((JDBCBlobClient)object).blob;
                    l3 = ((f)w2).getId();
                } else if (object instanceof Blob) {
                    l2 = ((Blob)object).length();
                    w2 = this.session.createBlob(l2);
                    l3 = ((f)w2).getId();
                    closeable2 = ((Blob)object).getBinaryStream();
                    b3 = org.hsqldb.g.b.newLobCreateBlobRequest(this.session.getId(), l3, (InputStream)closeable2, l2);
                    this.session.allocateResultLob(b3, null);
                    this.resultOut.addLobResult(b3);
                } else if (object instanceof InputStream) {
                    l2 = this.streamLengths[i2];
                    long l4 = l2 > 0L ? l2 : 0L;
                    w2 = this.session.createBlob(l4);
                    l3 = ((f)w2).getId();
                    closeable = (InputStream)object;
                    b2 = org.hsqldb.g.b.newLobCreateBlobRequest(this.session.getId(), l3, closeable, l2);
                    this.session.allocateResultLob(b2, null);
                    this.resultOut.addLobResult(b2);
                } else if (object instanceof f) {
                    w2 = (f)object;
                }
                this.parameterValues[i2] = w2;
                continue;
            }
            if (this.parameterTypes[i2].typeCode != 40) continue;
            w2 = null;
            if (object instanceof JDBCClobClient) {
                w2 = ((JDBCClobClient)object).clob;
                l3 = ((m)w2).getId();
            } else if (object instanceof Clob) {
                l2 = ((Clob)object).length();
                closeable2 = ((Clob)object).getCharacterStream();
                w2 = this.session.createClob(l2);
                l3 = ((m)w2).getId();
                b3 = org.hsqldb.g.b.newLobCreateClobRequest(this.session.getId(), l3, closeable2, l2);
                this.session.allocateResultLob(b3, null);
                this.resultOut.addLobResult(b3);
            } else if (object instanceof Reader) {
                l2 = this.streamLengths[i2];
                long l5 = l2 > 0L ? l2 : 0L;
                w2 = this.session.createClob(l5);
                l3 = ((m)w2).getId();
                closeable = (Reader)object;
                b2 = org.hsqldb.g.b.newLobCreateClobRequest(this.session.getId(), l3, (Reader)closeable, l2);
                this.session.allocateResultLob(b2, null);
                this.resultOut.addLobResult(b2);
            } else if (object instanceof m) {
                w2 = (m)object;
            }
            this.parameterValues[i2] = w2;
        }
    }

    void fetchResult() {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.closeResultData();
        this.checkParametersSet();
        if (this.isBatch) {
            throw JDBCUtil.sqlExceptionSQL(1255);
        }
        if (this.isResult) {
            this.resultOut.setPreparedResultUpdateProperties(this.parameterValues);
        } else {
            this.resultOut.setPreparedExecuteProperties(this.parameterValues, this.maxRows, this.fetchSize, this.rsProperties, this.queryTimeout);
        }
        try {
            this.performPreExecute();
            this.resultIn = this.session.execute(this.resultOut);
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
        finally {
            this.performPostExecute();
        }
        if (this.resultIn.mode == 2) {
            throw JDBCUtil.sqlException(this.resultIn);
        }
        if (this.resultIn.isData()) {
            this.currentResultSet = new JDBCResultSet(this.connection, this, this.resultIn, this.resultIn.metaData);
        } else if (this.statementRetType == 2) {
            this.getMoreResults();
        }
    }

    boolean isAnyParameterSet() {
        for (int i2 = 0; i2 < this.parameterValues.length; ++i2) {
            if (this.parameterSet[i2] == null) continue;
            return true;
        }
        return false;
    }

    @Override
    void performPostExecute() {
        super.performPostExecute();
    }
}

