/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Wrapper;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.logging.Logger;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import org.hsqldb.jdbc.JDBCCommonDataSource;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.jdbc.pool.JDBCPooledConnection;
import org.hsqldb.jdbc.pool.JDBCPooledDataSource;

public class JDBCPool
extends JDBCCommonDataSource
implements Serializable,
Wrapper,
Referenceable,
ConnectionEventListener,
DataSource,
StatementEventListener {
    AtomicIntegerArray states;
    JDBCPooledConnection[] connections;
    JDBCPooledDataSource source = new JDBCPooledDataSource();
    volatile boolean closed;

    @Override
    public Connection getConnection() {
        int n2 = 300;
        if (this.source.loginTimeout != 0) {
            n2 = this.source.loginTimeout * 10;
        }
        if (this.closed) {
            throw new SQLException("connection pool is closed");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < this.states.length(); ++i3) {
                if (this.states.compareAndSet(i3, 1, 2)) {
                    return this.connections[i3].getConnection();
                }
                if (!this.states.compareAndSet(i3, 0, 2)) continue;
                try {
                    JDBCPooledConnection jDBCPooledConnection = (JDBCPooledConnection)this.source.getPooledConnection();
                    jDBCPooledConnection.addConnectionEventListener(this);
                    jDBCPooledConnection.addStatementEventListener(this);
                    this.connections[i3] = jDBCPooledConnection;
                    return this.connections[i3].getConnection();
                }
                catch (SQLException sQLException) {
                    this.states.set(i3, 0);
                }
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw JDBCUtil.invalidArgument();
    }

    @Override
    public Connection getConnection(String string, String string2) {
        return this.source.getPooledConnection(string, string2).getConnection();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public Reference getReference() {
        String string = "org.hsqldb.jdbc.JDBCDataSourceFactory";
        Reference reference = new Reference(this.getClass().getName(), string, null);
        reference.add(new StringRefAddr("database", this.source.getDatabase()));
        reference.add(new StringRefAddr("user", this.source.getUser()));
        reference.add(new StringRefAddr("password", this.source.password));
        reference.add(new StringRefAddr("loginTimeout", Integer.toString(this.source.loginTimeout)));
        reference.add(new StringRefAddr("poolSize", Integer.toString(this.connections.length)));
        return reference;
    }

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        for (int i2 = 0; i2 < this.connections.length; ++i2) {
            if (this.connections[i2] != pooledConnection) continue;
            this.states.set(i2, 1);
            break;
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        for (int i2 = 0; i2 < this.connections.length; ++i2) {
            if (this.connections[i2] != pooledConnection) continue;
            this.states.set(i2, 2);
            this.connections[i2] = null;
            this.states.set(i2, 0);
            break;
        }
    }

    @Override
    public void statementClosed(StatementEvent statementEvent) {
    }

    @Override
    public void statementErrorOccurred(StatementEvent statementEvent) {
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.source.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        this.source.setLogWriter(printWriter);
    }

    @Override
    public void setLoginTimeout(int n2) {
        this.source.setLoginTimeout(n2);
    }

    @Override
    public int getLoginTimeout() {
        return this.source.getLoginTimeout();
    }

    @Override
    public String getDescription() {
        return "org.hsqldb.jdbc.JDBCPool max size " + this.connections.length;
    }

    @Override
    public String getDataSourceName() {
        return "org.hsqldb.jdbc.JDBCPool";
    }

    @Override
    public String getDatabaseName() {
        return this.source.getUrl();
    }

    @Override
    public String getDatabase() {
        return this.source.getDatabase();
    }

    @Override
    public String getUrl() {
        return this.source.getUrl();
    }

    @Override
    public String getUser() {
        return this.source.getUser();
    }

    @Override
    public void setDatabaseName(String string) {
        this.source.setDatabaseName(string);
    }

    @Override
    public void setDatabase(String string) {
        this.source.setDatabase(string);
    }

    @Override
    public void setUrl(String string) {
        this.source.setUrl(string);
    }

    @Override
    public void setPassword(String string) {
        this.source.setPassword(string);
    }

    @Override
    public void setUser(String string) {
        this.source.setUser(string);
    }

    @Override
    public void setProperties(Properties properties) {
        this.source.setProperties(properties);
    }

    @Override
    public Logger getParentLogger() {
        throw (SQLFeatureNotSupportedException)JDBCUtil.notSupported();
    }

    public JDBCPool() {
        this(10);
    }

    public JDBCPool(int n2) {
        this.connections = new JDBCPooledConnection[n2];
        this.states = new AtomicIntegerArray(n2);
    }

    public void close(int n2) {
        int n3;
        if (n2 < 0 || n2 > 60) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            Thread.sleep(1000 * n2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (n3 = 0; n3 < this.connections.length; ++n3) {
            if (this.connections[n3] == null) continue;
            this.connections[n3].release();
        }
        for (n3 = 0; n3 < this.connections.length; ++n3) {
            this.connections[n3] = null;
        }
    }

    static interface RefState {
        public static final int empty = 0;
        public static final int available = 1;
        public static final int allocated = 2;
    }
}

