/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.ParameterMetaData;
import java.sql.Wrapper;
import org.hsqldb.g.c;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.k.ad;
import org.hsqldb.k.r;
import org.hsqldb.k.u;

public class JDBCParameterMetaData
implements ParameterMetaData,
Wrapper {
    c rmd;
    String[] classNames;
    int parameterCount;
    private boolean translateTTIType;

    @Override
    public int getParameterCount() {
        return this.parameterCount;
    }

    @Override
    public int isNullable(int n2) {
        this.checkRange(n2);
        return 2;
    }

    @Override
    public boolean isSigned(int n2) {
        this.checkRange(n2);
        ad ad2 = this.translateType(this.rmd.columnTypes[--n2]);
        return ad2.isNumberType();
    }

    @Override
    public int getPrecision(int n2) {
        this.checkRange(n2);
        ad ad2 = this.translateType(this.rmd.columnTypes[--n2]);
        if (ad2.isDateTimeType()) {
            return ad2.displaySize();
        }
        long l2 = ad2.precision;
        if (l2 > Integer.MAX_VALUE) {
            l2 = 0L;
        }
        return (int)l2;
    }

    @Override
    public int getScale(int n2) {
        this.checkRange(n2);
        ad ad2 = this.translateType(this.rmd.columnTypes[--n2]);
        return ad2.scale;
    }

    @Override
    public int getParameterType(int n2) {
        this.checkRange(n2);
        ad ad2 = this.translateType(this.rmd.columnTypes[--n2]);
        return ad2.getJDBCTypeCode();
    }

    @Override
    public String getParameterTypeName(int n2) {
        this.checkRange(n2);
        ad ad2 = this.translateType(this.rmd.columnTypes[--n2]);
        return ad2.getNameString();
    }

    @Override
    public String getParameterClassName(int n2) {
        this.checkRange(n2);
        ad ad2 = this.translateType(this.rmd.columnTypes[--n2]);
        return ad2.getJDBCClassName();
    }

    @Override
    public int getParameterMode(int n2) {
        this.checkRange(n2);
        return this.rmd.paramModes[--n2];
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    JDBCParameterMetaData(JDBCConnection jDBCConnection, c c2) {
        this.rmd = c2;
        this.parameterCount = this.rmd.getColumnCount();
        if (jDBCConnection.clientProperties != null) {
            this.translateTTIType = jDBCConnection.clientProperties.isPropertyTrue("jdbc.translate_tti_types");
        }
    }

    private ad translateType(ad ad2) {
        if (this.translateTTIType) {
            if (ad2.isIntervalType()) {
                ad2 = ((u)ad2).getCharacterType();
            } else if (ad2.isDateTimeTypeWithZone()) {
                ad2 = ((r)ad2).getDateTimeTypeWithoutZone();
            }
        }
        return ad2;
    }

    void checkRange(int n2) {
        if (n2 < 1 || n2 > this.parameterCount) {
            String string = n2 + " is out of range";
            throw JDBCUtil.outOfRangeArgument(string);
        }
    }

    public String toString() {
        try {
            return this.toStringImpl();
        }
        catch (Throwable throwable) {
            return super.toString() + "[toStringImpl_exception=" + throwable + "]";
        }
    }

    private String toStringImpl() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        int n2 = this.getParameterCount();
        if (n2 == 0) {
            stringBuffer.append("[parameterCount=0]");
            return stringBuffer.toString();
        }
        Method[] methodArray = this.getClass().getDeclaredMethods();
        stringBuffer.append('[');
        int n3 = methodArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append('\n');
            stringBuffer.append("    parameter_");
            stringBuffer.append(i2 + 1);
            stringBuffer.append('=');
            stringBuffer.append('[');
            for (int i3 = 0; i3 < n3; ++i3) {
                Method method = methodArray[i3];
                if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 1) continue;
                stringBuffer.append(method.getName());
                stringBuffer.append('=');
                stringBuffer.append(method.invoke((Object)this, new Integer(i2 + 1)));
                if (i3 + 1 >= n3) continue;
                stringBuffer.append(',');
                stringBuffer.append(' ');
            }
            stringBuffer.append(']');
            if (i2 + 1 >= n2) continue;
            stringBuffer.append(',');
            stringBuffer.append(' ');
        }
        stringBuffer.append('\n');
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

