/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.hsqldb.e.p;
import org.hsqldb.i;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCUtil;

public class JDBCDriver
implements Driver {
    public static JDBCDriver driverInstance;
    public final ThreadLocal<JDBCConnection> threadConnection = new ThreadLocal();

    @Override
    public Connection connect(String string, Properties properties) {
        if (string.regionMatches(true, 0, "jdbc:default:connection", 0, "jdbc:default:connection".length())) {
            JDBCConnection jDBCConnection = this.threadConnection.get();
            if (jDBCConnection == null) {
                return null;
            }
            return jDBCConnection;
        }
        return JDBCDriver.getConnection(string, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(String string, Properties properties) {
        final p p2 = i.parseURL(string, true, false);
        if (p2 == null) {
            throw JDBCUtil.invalidArgument();
        }
        if (p2.isEmpty()) {
            return null;
        }
        long l2 = 0L;
        if (properties != null) {
            l2 = p.getIntegerProperty(properties, "loginTimeout", 0);
        }
        p2.addProperties(properties);
        if (l2 == 0L) {
            l2 = DriverManager.getLoginTimeout();
        }
        if (l2 == 0L) {
            return new JDBCConnection(p2);
        }
        String string2 = p2.getProperty("connection_type");
        if (i.isInProcessDatabaseType(string2)) {
            return new JDBCConnection(p2);
        }
        final JDBCConnection[] jDBCConnectionArray = new JDBCConnection[1];
        final SQLException[] sQLExceptionArray = new SQLException[1];
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    jDBCConnectionArray[0] = new JDBCConnection(p2);
                }
                catch (SQLException sQLException) {
                    sQLExceptionArray[0] = sQLException;
                }
            }
        };
        thread.start();
        long l3 = System.currentTimeMillis();
        try {
            thread.join(1000L * l2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            thread.stop();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                thread.setContextClassLoader(null);
            }
            catch (Throwable throwable) {}
        }
        if (sQLExceptionArray[0] != null) {
            throw sQLExceptionArray[0];
        }
        if (jDBCConnectionArray[0] != null) {
            return jDBCConnectionArray[0];
        }
        throw JDBCUtil.sqlException(1351);
    }

    @Override
    public boolean acceptsURL(String string) {
        if (string == null) {
            return false;
        }
        if (string.regionMatches(true, 0, "jdbc:hsqldb:", 0, "jdbc:hsqldb:".length())) {
            return true;
        }
        return string.regionMatches(true, 0, "jdbc:default:connection", 0, "jdbc:default:connection".length());
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        if (!this.acceptsURL(string)) {
            return new DriverPropertyInfo[0];
        }
        String[] stringArray = new String[]{"true", "false"};
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[6];
        if (properties == null) {
            properties = new Properties();
        }
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo("user", null);
        driverPropertyInfo.value = properties.getProperty("user");
        driverPropertyInfo.required = true;
        driverPropertyInfoArray[0] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("password", null);
        driverPropertyInfo.value = properties.getProperty("password");
        driverPropertyInfo.required = true;
        driverPropertyInfoArray[1] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("get_column_name", null);
        driverPropertyInfo.value = properties.getProperty("get_column_name", "true");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfoArray[2] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("ifexists", null);
        driverPropertyInfo.value = properties.getProperty("ifexists", "false");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfoArray[3] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("default_schema", null);
        driverPropertyInfo.value = properties.getProperty("default_schema", "false");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfoArray[4] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("shutdown", null);
        driverPropertyInfo.value = properties.getProperty("shutdown", "false");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfoArray[5] = driverPropertyInfo;
        return driverPropertyInfoArray;
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 3;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() {
        throw (SQLFeatureNotSupportedException)JDBCUtil.notSupported();
    }

    static {
        try {
            driverInstance = new JDBCDriver();
            DriverManager.registerDriver(driverInstance);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

