/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.Wrapper;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.JDBCStatement;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.k.ad;
import org.hsqldb.lib.bh;
import org.hsqldb.lib.bj;
import org.hsqldb.w;

public class JDBCDatabaseMetaData
implements DatabaseMetaData,
Wrapper {
    static final Integer INT_COLUMNS_NO_NULLS = 0;
    private JDBCConnection connection;
    private final boolean useSchemaDefault;
    private boolean concatNulls = true;
    private boolean nullsFirst = true;
    private boolean nullsOrder = true;
    private boolean uniqueNulls = true;
    private static final String BRI_SESSION_SCOPE_IN_LIST = "(2)";
    private static final String BRI_TEMPORARY_SCOPE_IN_LIST = "(0,1,2)";
    private static final String BRI_TRANSACTION_SCOPE_IN_LIST = "(1,2)";
    private static final String selstar = "SELECT * FROM INFORMATION_SCHEMA.";
    private static final String whereTrue = " WHERE TRUE";
    public static final int JDBC_MAJOR = 4;

    @Override
    public boolean allProceduresAreCallable() {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return true;
    }

    @Override
    public String getURL() {
        return this.connection.getURL();
    }

    @Override
    public String getUserName() {
        ResultSet resultSet = this.execute("CALL USER()");
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        return string;
    }

    @Override
    public boolean isReadOnly() {
        ResultSet resultSet = this.execute("CALL IS_READONLY_DATABASE()");
        resultSet.next();
        boolean bl2 = resultSet.getBoolean(1);
        resultSet.close();
        return bl2;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        this.setCurrentProperties();
        return !this.nullsFirst && !this.nullsOrder;
    }

    @Override
    public boolean nullsAreSortedLow() {
        this.setCurrentProperties();
        return this.nullsFirst && !this.nullsOrder;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        this.setCurrentProperties();
        return this.nullsFirst && this.nullsOrder;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        this.setCurrentProperties();
        return !this.nullsFirst && this.nullsOrder;
    }

    @Override
    public String getDatabaseProductName() {
        return "HSQL Database Engine";
    }

    @Override
    public String getDatabaseProductVersion() {
        ResultSet resultSet = this.execute("call database_version()");
        resultSet.next();
        return resultSet.getString(1);
    }

    @Override
    public String getDriverName() {
        return "HSQL Database Engine Driver";
    }

    @Override
    public String getDriverVersion() {
        return "2.3.3";
    }

    @Override
    public int getDriverMajorVersion() {
        return 2;
    }

    @Override
    public int getDriverMinorVersion() {
        return 3;
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() {
        return "\"";
    }

    @Override
    public String getSQLKeywords() {
        return "";
    }

    @Override
    public String getNumericFunctions() {
        return bj.getList(w.openGroupNumericFunctions, ",", "");
    }

    @Override
    public String getStringFunctions() {
        return bj.getList(w.openGroupStringFunctions, ",", "");
    }

    @Override
    public String getSystemFunctions() {
        return bj.getList(w.openGroupSystemFunctions, ",", "");
    }

    @Override
    public String getTimeDateFunctions() {
        return bj.getList(w.openGroupDateTimeFunctions, ",", "");
    }

    @Override
    public String getSearchStringEscape() {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return this.concatNulls;
    }

    @Override
    public boolean supportsConvert() {
        return true;
    }

    @Override
    public boolean supportsConvert(int n2, int n3) {
        ad ad2 = ad.getDefaultTypeWithSize(ad.getHSQLDBTypeCode(n2));
        ad ad3 = ad.getDefaultTypeWithSize(ad.getHSQLDBTypeCode(n3));
        if (ad2 == null || ad3 == null) {
            return false;
        }
        if (n2 == 0 && n3 == 2003) {
            return true;
        }
        return ad3.canConvertFrom(ad2);
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return true;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return true;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    @Override
    public String getSchemaTerm() {
        return "SCHEMA";
    }

    @Override
    public String getProcedureTerm() {
        return "PROCEDURE";
    }

    @Override
    public String getCatalogTerm() {
        return "CATALOG";
    }

    @Override
    public boolean isCatalogAtStart() {
        return true;
    }

    @Override
    public String getCatalogSeparator() {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return !this.useSchemaDefault;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return !this.useSchemaDefault;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return !this.useSchemaDefault;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return !this.useSchemaDefault;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return !this.useSchemaDefault;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return !this.useSchemaDefault;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return !this.useSchemaDefault;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return !this.useSchemaDefault;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return !this.useSchemaDefault;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return !this.useSchemaDefault;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return true;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 128;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 0;
    }

    @Override
    public int getMaxConnections() {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 128;
    }

    @Override
    public int getMaxIndexLength() {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 128;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 128;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 128;
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return true;
    }

    @Override
    public int getMaxStatementLength() {
        return 0;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 128;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() {
        return 128;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        ResultSet resultSet = this.execute("CALL DATABASE_ISOLATION_LEVEL()");
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        if (string.startsWith("READ COMMITTED")) {
            return 2;
        }
        if (string.startsWith("READ UNCOMMITTED")) {
            return 1;
        }
        if (string.startsWith("SERIALIZABLE")) {
            return 8;
        }
        return 2;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int n2) {
        return n2 == 1 || n2 == 2 || n2 == 4 || n2 == 8;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return true;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return true;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public ResultSet getProcedures(String string, String string2, String string3) {
        if (JDBCDatabaseMetaData.wantsIsNull(string3)) {
            return this.executeSelect("SYSTEM_PROCEDURES", "0=1");
        }
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_PROCEDURES").append(JDBCDatabaseMetaData.and("PROCEDURE_CAT", "=", string)).append(JDBCDatabaseMetaData.and("PROCEDURE_SCHEM", "LIKE", string2)).append(JDBCDatabaseMetaData.and("PROCEDURE_NAME", "LIKE", string3));
        return this.execute(stringBuffer.toString());
    }

    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) {
        if (JDBCDatabaseMetaData.wantsIsNull(string3) || JDBCDatabaseMetaData.wantsIsNull(string4)) {
            return this.executeSelect("SYSTEM_PROCEDURECOLUMNS", "0=1");
        }
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_PROCEDURECOLUMNS").append(JDBCDatabaseMetaData.and("PROCEDURE_CAT", "=", string)).append(JDBCDatabaseMetaData.and("PROCEDURE_SCHEM", "LIKE", string2)).append(JDBCDatabaseMetaData.and("PROCEDURE_NAME", "LIKE", string3)).append(JDBCDatabaseMetaData.and("COLUMN_NAME", "LIKE", string4));
        return this.execute(stringBuffer.toString());
    }

    @Override
    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) {
        if (JDBCDatabaseMetaData.wantsIsNull(string3) || stringArray != null && stringArray.length == 0) {
            return this.executeSelect("SYSTEM_TABLES", "0=1");
        }
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_TABLES").append(JDBCDatabaseMetaData.and("TABLE_CAT", "=", string)).append(JDBCDatabaseMetaData.and("TABLE_SCHEM", "LIKE", string2)).append(JDBCDatabaseMetaData.and("TABLE_NAME", "LIKE", string3));
        if (stringArray != null) {
            stringBuffer.append(" AND TABLE_TYPE IN (").append(bj.getList(stringArray, ",", "'")).append(')');
        }
        return this.execute(stringBuffer.toString());
    }

    @Override
    public ResultSet getSchemas() {
        return this.executeSelect("SYSTEM_SCHEMAS", null);
    }

    @Override
    public ResultSet getCatalogs() {
        String string = "SELECT CATALOG_NAME AS TABLE_CAT FROM INFORMATION_SCHEMA.INFORMATION_SCHEMA_CATALOG_NAME";
        return this.execute(string);
    }

    @Override
    public ResultSet getTableTypes() {
        return this.executeSelect("SYSTEM_TABLETYPES", null);
    }

    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) {
        if (JDBCDatabaseMetaData.wantsIsNull(string3) || JDBCDatabaseMetaData.wantsIsNull(string4)) {
            return this.executeSelect("SYSTEM_COLUMNS", "0=1");
        }
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_COLUMNS").append(JDBCDatabaseMetaData.and("TABLE_CAT", "=", string)).append(JDBCDatabaseMetaData.and("TABLE_SCHEM", "LIKE", string2)).append(JDBCDatabaseMetaData.and("TABLE_NAME", "LIKE", string3)).append(JDBCDatabaseMetaData.and("COLUMN_NAME", "LIKE", string4));
        return this.execute(stringBuffer.toString());
    }

    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) {
        if (string3 == null) {
            throw JDBCUtil.nullArgument("table");
        }
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        String string5 = "SELECT TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM,TABLE_NAME, COLUMN_NAME, GRANTOR, GRANTEE, PRIVILEGE_TYPE PRIVILEGE, IS_GRANTABLE FROM INFORMATION_SCHEMA.COLUMN_PRIVILEGES WHERE TRUE " + JDBCDatabaseMetaData.and("TABLE_CATALOG", "=", string) + JDBCDatabaseMetaData.and("TABLE_SCHEMA", "=", string2) + JDBCDatabaseMetaData.and("TABLE_NAME", "=", string3) + JDBCDatabaseMetaData.and("COLUMN_NAME", "LIKE", string4);
        return this.execute(string5);
    }

    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) {
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        String string4 = "SELECT TABLE_CATALOG TABLE_CAT, TABLE_SCHEMA TABLE_SCHEM,TABLE_NAME, GRANTOR, GRANTEE, PRIVILEGE_TYPE PRIVILEGE, IS_GRANTABLE FROM INFORMATION_SCHEMA.TABLE_PRIVILEGES WHERE TRUE " + JDBCDatabaseMetaData.and("TABLE_CATALOG", "=", string) + JDBCDatabaseMetaData.and("TABLE_SCHEMA", "LIKE", string2) + JDBCDatabaseMetaData.and("TABLE_NAME", "LIKE", string3);
        return this.execute(string4);
    }

    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n2, boolean bl2) {
        String string4;
        if (string3 == null) {
            throw JDBCUtil.nullArgument("table");
        }
        switch (n2) {
            case 0: {
                string4 = BRI_TEMPORARY_SCOPE_IN_LIST;
                break;
            }
            case 1: {
                string4 = BRI_TRANSACTION_SCOPE_IN_LIST;
                break;
            }
            case 2: {
                string4 = BRI_SESSION_SCOPE_IN_LIST;
                break;
            }
            default: {
                throw JDBCUtil.invalidArgument("scope");
            }
        }
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        Integer n3 = bl2 ? null : INT_COLUMNS_NO_NULLS;
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_BESTROWIDENTIFIER").append(JDBCDatabaseMetaData.and("TABLE_CAT", "=", string)).append(JDBCDatabaseMetaData.and("TABLE_SCHEM", "=", string2)).append(JDBCDatabaseMetaData.and("TABLE_NAME", "=", string3)).append(JDBCDatabaseMetaData.and("NULLABLE", "=", n3)).append(" AND SCOPE IN " + string4);
        return this.execute(stringBuffer.toString());
    }

    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) {
        if (string3 == null) {
            throw JDBCUtil.nullArgument("table");
        }
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_VERSIONCOLUMNS").append(JDBCDatabaseMetaData.and("TABLE_CAT", "=", string)).append(JDBCDatabaseMetaData.and("TABLE_SCHEM", "=", string2)).append(JDBCDatabaseMetaData.and("TABLE_NAME", "=", string3));
        return this.execute(stringBuffer.toString());
    }

    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) {
        if (string3 == null) {
            throw JDBCUtil.nullArgument("table");
        }
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_PRIMARYKEYS").append(JDBCDatabaseMetaData.and("TABLE_CAT", "=", string)).append(JDBCDatabaseMetaData.and("TABLE_SCHEM", "=", string2)).append(JDBCDatabaseMetaData.and("TABLE_NAME", "=", string3));
        return this.execute(stringBuffer.toString());
    }

    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) {
        if (string3 == null) {
            throw JDBCUtil.nullArgument("table");
        }
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_CROSSREFERENCE").append(JDBCDatabaseMetaData.and("FKTABLE_CAT", "=", string)).append(JDBCDatabaseMetaData.and("FKTABLE_SCHEM", "=", string2)).append(JDBCDatabaseMetaData.and("FKTABLE_NAME", "=", string3)).append(" ORDER BY PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, KEY_SEQ");
        return this.execute(stringBuffer.toString());
    }

    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) {
        if (string3 == null) {
            throw JDBCUtil.nullArgument("table");
        }
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_CROSSREFERENCE").append(JDBCDatabaseMetaData.and("PKTABLE_CAT", "=", string)).append(JDBCDatabaseMetaData.and("PKTABLE_SCHEM", "=", string2)).append(JDBCDatabaseMetaData.and("PKTABLE_NAME", "=", string3));
        return this.execute(stringBuffer.toString());
    }

    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) {
        if (string3 == null) {
            throw JDBCUtil.nullArgument("parentTable");
        }
        if (string6 == null) {
            throw JDBCUtil.nullArgument("foreignTable");
        }
        string = this.translateCatalog(string);
        string4 = this.translateCatalog(string4);
        string2 = this.translateSchema(string2);
        string5 = this.translateSchema(string5);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_CROSSREFERENCE").append(JDBCDatabaseMetaData.and("PKTABLE_CAT", "=", string)).append(JDBCDatabaseMetaData.and("PKTABLE_SCHEM", "=", string2)).append(JDBCDatabaseMetaData.and("PKTABLE_NAME", "=", string3)).append(JDBCDatabaseMetaData.and("FKTABLE_CAT", "=", string4)).append(JDBCDatabaseMetaData.and("FKTABLE_SCHEM", "=", string5)).append(JDBCDatabaseMetaData.and("FKTABLE_NAME", "=", string6));
        return this.execute(stringBuffer.toString());
    }

    @Override
    public ResultSet getTypeInfo() {
        return this.executeSelect("SYSTEM_TYPEINFO", null);
    }

    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl2, boolean bl3) {
        if (string3 == null) {
            throw JDBCUtil.nullArgument("table");
        }
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        Boolean bl4 = bl2 ? Boolean.FALSE : null;
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_INDEXINFO").append(JDBCDatabaseMetaData.and("TABLE_CAT", "=", string)).append(JDBCDatabaseMetaData.and("TABLE_SCHEM", "=", string2)).append(JDBCDatabaseMetaData.and("TABLE_NAME", "=", string3)).append(JDBCDatabaseMetaData.and("NON_UNIQUE", "=", bl4));
        return this.execute(stringBuffer.toString());
    }

    @Override
    public boolean supportsResultSetType(int n2) {
        return n2 == 1003 || n2 == 1004;
    }

    @Override
    public boolean supportsResultSetConcurrency(int n2, int n3) {
        return this.supportsResultSetType(n2) && (n3 == 1007 || n3 == 1008);
    }

    @Override
    public boolean ownUpdatesAreVisible(int n2) {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int n2) {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int n2) {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int n2) {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int n2) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int n2) {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int n2) {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int n2) {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int n2) {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) {
        if (JDBCDatabaseMetaData.wantsIsNull(string3) || nArray != null && nArray.length == 0) {
            this.executeSelect("SYSTEM_UDTS", "0=1");
        }
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_UDTS").append(JDBCDatabaseMetaData.and("TYPE_CAT", "=", string)).append(JDBCDatabaseMetaData.and("TYPE_SCHEM", "LIKE", string2)).append(JDBCDatabaseMetaData.and("TYPE_NAME", "LIKE", string3));
        if (nArray != null) {
            stringBuffer.append(" AND DATA_TYPE IN (").append(bj.getList(nArray, ",", "")).append(')');
        }
        return this.execute(stringBuffer.toString());
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) {
        if (JDBCDatabaseMetaData.wantsIsNull(string3)) {
            return this.executeSelect("SYSTEM_SUPERTYPES", "0=1");
        }
        string = this.translateCatalog(string);
        string2 = this.translateSchema(string2);
        StringBuffer stringBuffer = this.toQueryPrefixNoSelect("SELECT * FROM (SELECT USER_DEFINED_TYPE_CATALOG, USER_DEFINED_TYPE_SCHEMA, USER_DEFINED_TYPE_NAME,CAST (NULL AS INFORMATION_SCHEMA.SQL_IDENTIFIER), CAST (NULL AS INFORMATION_SCHEMA.SQL_IDENTIFIER), DATA_TYPE FROM INFORMATION_SCHEMA.USER_DEFINED_TYPES UNION SELECT DOMAIN_CATALOG, DOMAIN_SCHEMA, DOMAIN_NAME,NULL,NULL, DATA_TYPE FROM INFORMATION_SCHEMA.DOMAINS) AS SUPERTYPES(TYPE_CAT, TYPE_SCHEM, TYPE_NAME, SUPERTYPE_CAT, SUPERTYPE_SCHEM, SUPERTYPE_NAME) ").append(JDBCDatabaseMetaData.and("TYPE_CAT", "=", string)).append(JDBCDatabaseMetaData.and("TYPE_SCHEM", "LIKE", string2)).append(JDBCDatabaseMetaData.and("TYPE_NAME", "LIKE", string3));
        return this.execute(stringBuffer.toString());
    }

    @Override
    public ResultSet getSuperTables(String string, String string2, String string3) {
        StringBuffer stringBuffer = this.toQueryPrefixNoSelect("SELECT TABLE_NAME AS TABLE_CAT, TABLE_NAME AS TABLE_SCHEM, TABLE_NAME, TABLE_NAME AS SUPERTABLE_NAME FROM INFORMATION_SCHEMA.TABLES ").append(JDBCDatabaseMetaData.and("TABLE_NAME", "=", ""));
        return this.execute(stringBuffer.toString());
    }

    @Override
    public ResultSet getAttributes(String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = this.toQueryPrefixNoSelect("SELECT TABLE_NAME AS TYPE_CAT, TABLE_NAME AS TYPE_SCHME, TABLE_NAME AS TYPE_NAME, TABLE_NAME AS ATTR_NAME, CAST(0 AS INTEGER) AS DATA_TYPE, TABLE_NAME AS ATTR_TYPE_NAME, CAST(0 AS INTEGER) AS ATTR_SIZE, CAST(0 AS INTEGER) AS DECIMAL_DIGITS, CAST(0 AS INTEGER) AS NUM_PREC_RADIX, CAST(0 AS INTEGER) AS NULLABLE, '' AS REMARK, '' AS ATTR_DEF, CAST(0 AS INTEGER) AS SQL_DATA_TYPE, CAST(0 AS INTEGER) AS SQL_DATETIME_SUB, CAST(0 AS INTEGER) AS CHAR_OCTECT_LENGTH, CAST(0 AS INTEGER) AS ORDINAL_POSITION, '' AS NULLABLE, '' AS SCOPE_CATALOG, '' AS SCOPE_SCHEMA, '' AS SCOPE_TABLE, CAST(0 AS SMALLINT) AS SCOPE_DATA_TYPE FROM INFORMATION_SCHEMA.TABLES ").append(JDBCDatabaseMetaData.and("TABLE_NAME", "=", ""));
        return this.execute(stringBuffer.toString());
    }

    @Override
    public boolean supportsResultSetHoldability(int n2) {
        return n2 == 1 || n2 == 2;
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() {
        ResultSet resultSet = this.execute("call database_version()");
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        return Integer.parseInt(string.substring(0, string.indexOf(".")));
    }

    @Override
    public int getDatabaseMinorVersion() {
        ResultSet resultSet = this.execute("call database_version()");
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        int n2 = string.indexOf(".") + 1;
        return Integer.parseInt(string.substring(n2, string.indexOf(".", n2)));
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 0;
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() {
        return true;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getSchemas(String string, String string2) {
        StringBuffer stringBuffer = this.toQueryPrefix("SYSTEM_SCHEMAS").append(JDBCDatabaseMetaData.and("TABLE_CATALOG", "=", string)).append(JDBCDatabaseMetaData.and("TABLE_SCHEM", "LIKE", string2));
        return this.execute(stringBuffer.toString());
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() {
        String string = "SELECT * FROM INFORMATION_SCHEMA.SYSTEM_CONNECTION_PROPERTIES";
        return this.execute(string);
    }

    @Override
    public ResultSet getFunctions(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("select ").append("sp.procedure_cat as FUNCTION_CAT,").append("sp.procedure_schem as FUNCTION_SCHEM,").append("sp.procedure_name as FUNCTION_NAME,").append("sp.remarks as REMARKS,").append("1 as FUNCTION_TYPE,").append("sp.specific_name as SPECIFIC_NAME ").append("from information_schema.system_procedures sp ").append("where sp.procedure_type = 2 ");
        if (JDBCDatabaseMetaData.wantsIsNull(string3)) {
            return this.execute(stringBuffer.append("and 1=0").toString());
        }
        string2 = this.translateSchema(string2);
        stringBuffer.append(JDBCDatabaseMetaData.and("sp.procedure_cat", "=", string)).append(JDBCDatabaseMetaData.and("sp.procedure_schem", "LIKE", string2)).append(JDBCDatabaseMetaData.and("sp.procedure_name", "LIKE", string3));
        return this.execute(stringBuffer.toString());
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("select pc.procedure_cat as FUNCTION_CAT,").append("pc.procedure_schem as FUNCTION_SCHEM,").append("pc.procedure_name as FUNCTION_NAME,").append("pc.column_name as COLUMN_NAME,").append("case pc.column_type").append(" when 3 then 5").append(" when 4 then 3").append(" when 5 then 4").append(" else pc.column_type").append(" end as COLUMN_TYPE,").append("pc.DATA_TYPE,").append("pc.TYPE_NAME,").append("pc.PRECISION,").append("pc.LENGTH,").append("pc.SCALE,").append("pc.RADIX,").append("pc.NULLABLE,").append("pc.REMARKS,").append("pc.CHAR_OCTET_LENGTH,").append("pc.ORDINAL_POSITION,").append("pc.IS_NULLABLE,").append("pc.SPECIFIC_NAME,").append("case pc.column_type").append(" when 3 then 1").append(" else 0").append(" end AS COLUMN_GROUP ").append("from information_schema.system_procedurecolumns pc ").append("join (select procedure_schem,").append("procedure_name,").append("specific_name ").append("from information_schema.system_procedures ").append("where procedure_type = 2) p ").append("on pc.procedure_schem = p.procedure_schem ").append("and pc.procedure_name = p.procedure_name ").append("and pc.specific_name = p.specific_name ").append("and ((pc.column_type = 3 and pc.column_name = '@p0') ").append("or ").append("(pc.column_type <> 3)) ");
        if (JDBCDatabaseMetaData.wantsIsNull(string3) || JDBCDatabaseMetaData.wantsIsNull(string4)) {
            return this.execute(stringBuffer.append("where 1=0").toString());
        }
        string2 = this.translateSchema(string2);
        stringBuffer.append("where 1=1 ").append(JDBCDatabaseMetaData.and("pc.procedure_cat", "=", string)).append(JDBCDatabaseMetaData.and("pc.procedure_schem", "LIKE", string2)).append(JDBCDatabaseMetaData.and("pc.procedure_name", "LIKE", string3)).append(JDBCDatabaseMetaData.and("pc.column_name", "LIKE", string4)).append(" order by 1, 2, 3, 17, 18 , 15");
        return this.execute(stringBuffer.toString());
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public ResultSet getPseudoColumns(String string, String string2, String string3, String string4) {
        throw JDBCUtil.notSupported();
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return true;
    }

    JDBCDatabaseMetaData(JDBCConnection jDBCConnection) {
        this.connection = jDBCConnection;
        this.useSchemaDefault = jDBCConnection.isInternal ? false : jDBCConnection.connProperties.isPropertyTrue("default_schema");
    }

    private static String and(String string, String string2, Object object) {
        if (object == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = object instanceof String;
        if (bl2 && ((String)object).length() == 0) {
            return stringBuffer.append(" AND ").append(string).append(" IS NULL").toString();
        }
        String string3 = bl2 ? ad.SQL_VARCHAR.convertToSQLString(object) : String.valueOf(object);
        stringBuffer.append(" AND ").append(string).append(' ');
        if (bl2 && "LIKE".equalsIgnoreCase(string2)) {
            if (string3.indexOf(95) < 0 && string3.indexOf(37) < 0) {
                stringBuffer.append("=").append(' ').append(string3);
            } else {
                stringBuffer.append("LIKE").append(' ').append(string3);
                if (string3.indexOf("\\_") >= 0 || string3.indexOf("\\%") >= 0) {
                    stringBuffer.append(" ESCAPE '\\'");
                }
            }
        } else {
            stringBuffer.append(string2).append(' ').append(string3);
        }
        return stringBuffer.toString();
    }

    private ResultSet execute(String string) {
        JDBCStatement jDBCStatement = (JDBCStatement)this.connection.createStatement(1004, 1007);
        jDBCStatement.maxRows = -1;
        ResultSet resultSet = jDBCStatement.executeQuery(string);
        ((JDBCResultSet)resultSet).autoClose = true;
        return resultSet;
    }

    private ResultSet executeSelect(String string, String string2) {
        String string3 = selstar + string;
        if (string2 != null) {
            string3 = string3 + " WHERE " + string2;
        }
        return this.execute(string3);
    }

    private StringBuffer toQueryPrefix(String string) {
        StringBuffer stringBuffer = new StringBuffer(255);
        return stringBuffer.append(selstar).append(string).append(whereTrue);
    }

    private StringBuffer toQueryPrefixNoSelect(String string) {
        StringBuffer stringBuffer = new StringBuffer(255);
        return stringBuffer.append(string).append(whereTrue);
    }

    private static boolean wantsIsNull(String string) {
        return string != null && string.length() == 0;
    }

    private void setCurrentProperties() {
        ResultSet resultSet = this.executeSelect("SYSTEM_PROPERTIES", "PROPERTY_NAME IN ('sql.concat_nulls', 'sql.nulls_first' , 'sql.nulls_order', 'sql.unique_nulls')");
        while (resultSet.next()) {
            String string = resultSet.getString(2);
            boolean bl2 = Boolean.valueOf(resultSet.getString(3));
            if (string.equals("sql.concat_nulls")) {
                this.concatNulls = bl2;
                continue;
            }
            if (string.equals("sql.nulls_first")) {
                this.nullsFirst = bl2;
                continue;
            }
            if (string.equals("sql.nulls_order")) {
                this.nullsOrder = bl2;
                continue;
            }
            if (!string.equals("sql.unique_nulls")) continue;
            this.uniqueNulls = bl2;
        }
    }

    String getDatabaseDefaultSchema() {
        ResultSet resultSet = this.executeSelect("SYSTEM_SCHEMAS", "IS_DEFAULT=TRUE");
        return resultSet.next() ? resultSet.getString(1) : null;
    }

    String getConnectionDefaultSchema() {
        ResultSet resultSet = this.execute("CALL CURRENT_SCHEMA");
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        return string;
    }

    void setConnectionDefaultSchema(String string) {
        this.execute("SET SCHEMA " + bh.toQuotedString(string, '\"', true));
    }

    private String translateSchema(String string) {
        String string2;
        if (this.useSchemaDefault && string != null && string.length() == 0 && (string2 = this.getDatabaseDefaultSchema()) != null) {
            string = string2;
        }
        return string;
    }

    String getDatabaseDefaultCatalog() {
        ResultSet resultSet = this.executeSelect("SYSTEM_SCHEMAS", "IS_DEFAULT=TRUE");
        return resultSet.next() ? resultSet.getString(2) : null;
    }

    private String translateCatalog(String string) {
        String string2;
        if (this.useSchemaDefault && string != null && string.length() == 0 && (string2 = this.getDatabaseDefaultCatalog()) != null) {
            string = string2;
        }
        return string;
    }
}

