/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Wrapper;
import java.util.Properties;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import org.hsqldb.jdbc.JDBCCommonDataSource;
import org.hsqldb.jdbc.JDBCDriver;
import org.hsqldb.jdbc.JDBCUtil;

public class JDBCDataSource
extends JDBCCommonDataSource
implements Serializable,
Wrapper,
Referenceable,
DataSource {
    @Override
    public Connection getConnection() {
        if (this.url == null) {
            throw JDBCUtil.nullArgument("url");
        }
        if (this.connectionProps == null) {
            if (this.user == null) {
                throw JDBCUtil.invalidArgument("user");
            }
            if (this.password == null) {
                throw JDBCUtil.invalidArgument("password");
            }
            return this.getConnection(this.user, this.password);
        }
        return this.getConnection(this.url, this.connectionProps);
    }

    @Override
    public Connection getConnection(String string, String string2) {
        if (string == null) {
            throw JDBCUtil.invalidArgument("user");
        }
        if (string2 == null) {
            throw JDBCUtil.invalidArgument("password");
        }
        Properties properties = new Properties();
        properties.setProperty("user", string);
        properties.setProperty("password", string2);
        properties.setProperty("loginTimeout", Integer.toString(this.loginTimeout));
        return this.getConnection(this.url, properties);
    }

    private Connection getConnection(String string, Properties properties) {
        if (!string.startsWith("jdbc:hsqldb:")) {
            string = "jdbc:hsqldb:" + string;
        }
        return JDBCDriver.getConnection(string, properties);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public Reference getReference() {
        String string = "org.hsqldb.jdbc.JDBCDataSourceFactory";
        Reference reference = new Reference(this.getClass().getName(), string, null);
        reference.add(new StringRefAddr("database", this.getDatabase()));
        reference.add(new StringRefAddr("user", this.getUser()));
        reference.add(new StringRefAddr("password", this.password));
        reference.add(new StringRefAddr("loginTimeout", Integer.toString(this.loginTimeout)));
        return reference;
    }
}

