/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.hsqldb.a;
import org.hsqldb.aa;
import org.hsqldb.b;
import org.hsqldb.bj;
import org.hsqldb.e.p;
import org.hsqldb.g.d;
import org.hsqldb.h;
import org.hsqldb.i;
import org.hsqldb.jdbc.JDBCArray;
import org.hsqldb.jdbc.JDBCBlob;
import org.hsqldb.jdbc.JDBCCallableStatement;
import org.hsqldb.jdbc.JDBCClob;
import org.hsqldb.jdbc.JDBCConnectionEventListener;
import org.hsqldb.jdbc.JDBCDatabaseMetaData;
import org.hsqldb.jdbc.JDBCNClob;
import org.hsqldb.jdbc.JDBCPreparedStatement;
import org.hsqldb.jdbc.JDBCSQLXML;
import org.hsqldb.jdbc.JDBCSavepoint;
import org.hsqldb.jdbc.JDBCStatement;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.k.ad;
import org.hsqldb.z;

public class JDBCConnection
implements Connection {
    int rsHoldability = 1;
    p connProperties;
    p clientProperties;
    bj sessionProxy;
    boolean isInternal;
    protected boolean isNetConn;
    boolean isClosed;
    private SQLWarning rootWarning;
    private final Object rootWarning_mutex = new Object();
    private int savepointIDSequence;
    int incarnation;
    boolean isPooled;
    JDBCConnectionEventListener poolEventListener;
    boolean isCloseResultSet;
    boolean isUseColumnName = true;

    @Override
    public synchronized Statement createStatement() {
        this.checkClosed();
        int n2 = d.getValueForJDBC(1003, 1007, this.rsHoldability);
        JDBCStatement jDBCStatement = new JDBCStatement(this, n2);
        return jDBCStatement;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string) {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, string, 1003, 1007, this.rsHoldability, 2, null, null);
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String string) {
        this.checkClosed();
        try {
            JDBCCallableStatement jDBCCallableStatement = new JDBCCallableStatement(this, string, 1003, 1007, this.rsHoldability);
            return jDBCCallableStatement;
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized String nativeSQL(String string) {
        this.checkClosed();
        if (string == null || string.length() == 0 || string.indexOf(123) == -1) {
            return string;
        }
        boolean bl2 = false;
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        StringBuffer stringBuffer = null;
        int n5 = 0;
        block6: for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            switch (n2) {
                case 0: {
                    if (c2 == '\'') {
                        n2 = 1;
                        continue block6;
                    }
                    if (c2 == '\"') {
                        n2 = 2;
                        continue block6;
                    }
                    if (c2 != '{') continue block6;
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(string.length());
                    }
                    stringBuffer.append(string.substring(n5, i2));
                    n5 = i2 = this.onStartEscapeSequence(string, stringBuffer, i2);
                    bl2 = true;
                    ++n4;
                    n2 = 3;
                    continue block6;
                }
                case 1: 
                case 4: {
                    if (c2 != '\'') continue block6;
                    --n2;
                    continue block6;
                }
                case 2: 
                case 5: {
                    if (c2 != '\"') continue block6;
                    n2 -= 2;
                    continue block6;
                }
                case 3: {
                    if (c2 == '\'') {
                        n2 = 4;
                        continue block6;
                    }
                    if (c2 == '\"') {
                        n2 = 5;
                        continue block6;
                    }
                    if (c2 == '}') {
                        stringBuffer.append(string.substring(n5, i2));
                        stringBuffer.append(' ');
                        n5 = ++i2;
                        bl2 = true;
                        n2 = --n4 == 0 ? 0 : 3;
                        continue block6;
                    }
                    if (c2 != '{') continue block6;
                    stringBuffer.append(string.substring(n5, i2));
                    n5 = i2 = this.onStartEscapeSequence(string, stringBuffer, i2);
                    bl2 = true;
                    ++n4;
                    n2 = 3;
                }
            }
        }
        if (!bl2) {
            return string;
        }
        stringBuffer.append(string.substring(n5, string.length()));
        return stringBuffer.toString();
    }

    @Override
    public synchronized void setAutoCommit(boolean bl2) {
        this.checkClosed();
        try {
            this.sessionProxy.setAutoCommit(bl2);
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized boolean getAutoCommit() {
        this.checkClosed();
        try {
            return this.sessionProxy.isAutoCommit();
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized void commit() {
        this.checkClosed();
        try {
            this.sessionProxy.commit(false);
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized void rollback() {
        this.checkClosed();
        try {
            this.sessionProxy.rollback(false);
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized void close() {
        if (this.isInternal || this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.rootWarning = null;
        this.connProperties = null;
        if (this.isPooled) {
            if (this.poolEventListener != null) {
                this.poolEventListener.connectionClosed();
                this.poolEventListener = null;
            }
        } else if (this.sessionProxy != null) {
            this.sessionProxy.close();
            this.sessionProxy = null;
        }
    }

    @Override
    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public synchronized DatabaseMetaData getMetaData() {
        this.checkClosed();
        return new JDBCDatabaseMetaData(this);
    }

    @Override
    public synchronized void setReadOnly(boolean bl2) {
        this.checkClosed();
        try {
            this.sessionProxy.setReadOnlyDefault(bl2);
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized boolean isReadOnly() {
        this.checkClosed();
        try {
            return this.sessionProxy.isReadOnlyDefault();
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized void setCatalog(String string) {
        this.checkClosed();
        try {
            this.sessionProxy.setAttribute(3, string);
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized String getCatalog() {
        this.checkClosed();
        try {
            return (String)this.sessionProxy.getAttribute(3);
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized void setTransactionIsolation(int n2) {
        this.checkClosed();
        switch (n2) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw JDBCUtil.invalidArgument();
            }
        }
        try {
            this.sessionProxy.setIsolationDefault(n2);
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized int getTransactionIsolation() {
        this.checkClosed();
        try {
            return this.sessionProxy.getIsolation();
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized SQLWarning getWarnings() {
        this.checkClosed();
        return this.rootWarning;
    }

    @Override
    public synchronized void clearWarnings() {
        this.checkClosed();
        this.rootWarning = null;
    }

    @Override
    public synchronized Statement createStatement(int n2, int n3) {
        this.checkClosed();
        int n4 = d.getValueForJDBC(n2, n3, this.rsHoldability);
        return new JDBCStatement(this, n4);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n2, int n3) {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, string, n2, n3, this.rsHoldability, 2, null, null);
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String string, int n2, int n3) {
        this.checkClosed();
        try {
            return new JDBCCallableStatement(this, string, n2, n3, this.rsHoldability);
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized Map<String, Class<?>> getTypeMap() {
        this.checkClosed();
        return new HashMap();
    }

    @Override
    public synchronized void setTypeMap(Map<String, Class<?>> map) {
        this.checkClosed();
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized void setHoldability(int n2) {
        this.checkClosed();
        switch (n2) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw JDBCUtil.invalidArgument();
            }
        }
        this.rsHoldability = n2;
    }

    @Override
    public synchronized int getHoldability() {
        this.checkClosed();
        return this.rsHoldability;
    }

    @Override
    public synchronized Savepoint setSavepoint() {
        this.checkClosed();
        if (this.getAutoCommit()) {
            throw JDBCUtil.sqlException(4821);
        }
        JDBCSavepoint jDBCSavepoint = new JDBCSavepoint(this);
        try {
            this.sessionProxy.savepoint(jDBCSavepoint.name);
        }
        catch (aa aa2) {
            JDBCUtil.throwError(aa2);
        }
        return jDBCSavepoint;
    }

    @Override
    public synchronized Savepoint setSavepoint(String string) {
        this.checkClosed();
        if (this.getAutoCommit()) {
            throw JDBCUtil.sqlException(4821);
        }
        if (string == null) {
            throw JDBCUtil.nullArgument();
        }
        if (string.startsWith("SYSTEM_SAVEPOINT_")) {
            throw JDBCUtil.invalidArgument();
        }
        try {
            this.sessionProxy.savepoint(string);
        }
        catch (aa aa2) {
            JDBCUtil.throwError(aa2);
        }
        return new JDBCSavepoint(string, this);
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) {
        this.checkClosed();
        if (savepoint == null) {
            throw JDBCUtil.nullArgument();
        }
        if (!(savepoint instanceof JDBCSavepoint)) {
            String string = org.hsqldb.a.a.getMessage(4821);
            throw JDBCUtil.invalidArgument(string);
        }
        JDBCSavepoint jDBCSavepoint = (JDBCSavepoint)savepoint;
        if (jDBCSavepoint.name == null) {
            String string = org.hsqldb.a.a.getMessage(4821);
            throw JDBCUtil.invalidArgument(string);
        }
        if (this != jDBCSavepoint.connection) {
            String string = org.hsqldb.a.a.getMessage(4821);
            throw JDBCUtil.invalidArgument(string);
        }
        if (this.getAutoCommit()) {
            jDBCSavepoint.name = null;
            jDBCSavepoint.connection = null;
            throw JDBCUtil.sqlException(4821);
        }
        try {
            this.sessionProxy.rollbackToSavepoint(jDBCSavepoint.name);
            jDBCSavepoint.connection = null;
            jDBCSavepoint.name = null;
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) {
        this.checkClosed();
        if (savepoint == null) {
            throw JDBCUtil.nullArgument();
        }
        if (!(savepoint instanceof JDBCSavepoint)) {
            String string = org.hsqldb.a.a.getMessage(4821);
            throw JDBCUtil.invalidArgument(string);
        }
        JDBCSavepoint jDBCSavepoint = (JDBCSavepoint)savepoint;
        if (jDBCSavepoint.name == null) {
            String string = org.hsqldb.a.a.getMessage(4821);
            throw JDBCUtil.invalidArgument(string);
        }
        if (this != jDBCSavepoint.connection) {
            String string = org.hsqldb.a.a.getMessage(4821);
            throw JDBCUtil.invalidArgument(string);
        }
        if (this.getAutoCommit()) {
            jDBCSavepoint.name = null;
            jDBCSavepoint.connection = null;
            throw JDBCUtil.sqlException(4821);
        }
        try {
            this.sessionProxy.releaseSavepoint(jDBCSavepoint.name);
            jDBCSavepoint.connection = null;
            jDBCSavepoint.name = null;
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized Statement createStatement(int n2, int n3, int n4) {
        this.checkClosed();
        int n5 = d.getValueForJDBC(n2, n3, n4);
        return new JDBCStatement(this, n5);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n2, int n3, int n4) {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, string, n2, n3, n4, 2, null, null);
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String string, int n2, int n3, int n4) {
        this.checkClosed();
        try {
            return new JDBCCallableStatement(this, string, n2, n3, n4);
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n2) {
        this.checkClosed();
        try {
            if (n2 != 1 && n2 != 2) {
                throw JDBCUtil.invalidArgument("autoGeneratedKeys");
            }
            return new JDBCPreparedStatement(this, string, 1003, 1007, this.rsHoldability, n2, null, null);
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int[] nArray) {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, string, 1003, 1007, this.rsHoldability, 21, nArray, null);
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, String[] stringArray) {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, string, 1003, 1007, this.rsHoldability, 11, null, stringArray);
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public Clob createClob() {
        this.checkClosed();
        return new JDBCClob();
    }

    @Override
    public Blob createBlob() {
        this.checkClosed();
        return new JDBCBlob();
    }

    @Override
    public NClob createNClob() {
        this.checkClosed();
        return new JDBCNClob();
    }

    @Override
    public SQLXML createSQLXML() {
        this.checkClosed();
        return new JDBCSQLXML();
    }

    @Override
    public boolean isValid(int n2) {
        if (n2 < 0) {
            throw JDBCUtil.outOfRangeArgument("timeout: " + n2);
        }
        if (this.isInternal) {
            return true;
        }
        if (!this.isNetConn) {
            return !this.isClosed();
        }
        if (this.isClosed()) {
            return false;
        }
        final boolean[] blArray = new boolean[]{true};
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    JDBCConnection.this.getMetaData().getDatabaseMajorVersion();
                }
                catch (Throwable throwable) {
                    blArray[0] = false;
                }
            }
        };
        if (n2 > 60) {
            n2 = 60;
        }
        n2 *= 1000;
        try {
            thread.start();
            long l2 = System.currentTimeMillis();
            thread.join(n2);
            try {
                thread.setContextClassLoader(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (n2 == 0) {
                return blArray[0];
            }
            return blArray[0] && System.currentTimeMillis() - l2 < (long)n2;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public void setClientInfo(String string, String string2) {
        SQLClientInfoException sQLClientInfoException = new SQLClientInfoException();
        sQLClientInfoException.initCause(JDBCUtil.notSupported());
        throw sQLClientInfoException;
    }

    @Override
    public void setClientInfo(Properties properties) {
        if (!this.isClosed && (properties == null || properties.isEmpty())) {
            return;
        }
        SQLClientInfoException sQLClientInfoException = new SQLClientInfoException();
        if (this.isClosed) {
            sQLClientInfoException.initCause(JDBCUtil.connectionClosedException());
        } else {
            sQLClientInfoException.initCause(JDBCUtil.notSupported());
        }
        throw sQLClientInfoException;
    }

    @Override
    public String getClientInfo(String string) {
        this.checkClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() {
        this.checkClosed();
        return null;
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) {
        this.checkClosed();
        if (string == null) {
            throw JDBCUtil.nullArgument();
        }
        int n2 = ad.getTypeNr(string = string.toUpperCase());
        if (n2 < 0) {
            throw JDBCUtil.invalidArgument(string);
        }
        ad ad2 = ad.getDefaultType(n2);
        if (ad2.isArrayType() || ad2.isLobType() || ad2.isRowType()) {
            throw JDBCUtil.invalidArgument(string);
        }
        Object[] objectArray2 = new Object[objectArray.length];
        try {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Object object = ad2.convertJavaToSQL(this.sessionProxy, objectArray[i2]);
                objectArray2[i2] = ad2.convertToTypeLimits(this.sessionProxy, object);
            }
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
        return new JDBCArray(objectArray2, ad2, this);
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) {
        this.checkClosed();
        throw JDBCUtil.notSupported();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        this.checkClosed();
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        this.checkClosed();
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public void setSchema(String string) {
        this.checkClosed();
        if (string == null) {
            JDBCUtil.nullArgument("schema");
        } else if (string.length() == 0) {
            JDBCUtil.invalidArgument("Zero-length schema");
        } else {
            new JDBCDatabaseMetaData(this).setConnectionDefaultSchema(string);
        }
    }

    @Override
    public String getSchema() {
        this.checkClosed();
        return new JDBCDatabaseMetaData(this).getConnectionDefaultSchema();
    }

    @Override
    public void abort(Executor executor) {
        if (executor == null) {
            throw JDBCUtil.nullArgument("executor");
        }
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n2) {
        this.checkClosed();
        throw JDBCUtil.notSupported();
    }

    @Override
    public int getNetworkTimeout() {
        return 0;
    }

    public JDBCConnection(p p2) {
        String string = p2.getProperty("user");
        String string2 = p2.getProperty("password");
        String string3 = p2.getProperty("connection_type");
        String string4 = p2.getProperty("host");
        int n2 = p2.getIntegerProperty("port", 0);
        String string5 = p2.getProperty("path");
        String string6 = p2.getProperty("database");
        boolean bl2 = string3 == "hsqls://" || string3 == "https://";
        boolean bl3 = p2.isPropertyTrue("tls_wrapper", false);
        bl3 &= bl2;
        if (string == null) {
            string = "SA";
        }
        if (string2 == null) {
            string2 = "";
        }
        Calendar calendar = Calendar.getInstance();
        int n3 = z.getZoneSeconds(calendar);
        try {
            if (i.isInProcessDatabaseType(string3)) {
                this.sessionProxy = h.newSession(string3, string6, string, string2, p2, null, n3);
            } else if (string3 == "hsql://" || string3 == "hsqls://") {
                this.sessionProxy = new a(string4, n2, string5, string6, bl2, bl3, string, string2, n3);
                this.isNetConn = true;
            } else if (string3 == "http://" || string3 == "https://") {
                this.sessionProxy = new b(string4, n2, string5, string6, bl2, bl3, string, string2, n3);
                this.isNetConn = true;
            } else {
                throw JDBCUtil.invalidArgument(string3);
            }
            this.sessionProxy.setJDBCConnection(this);
            this.connProperties = p2;
            this.clientProperties = this.sessionProxy.getClientProperties();
            this.isCloseResultSet = this.connProperties.isPropertyTrue("close_result", false);
            this.isUseColumnName = this.connProperties.isPropertyTrue("get_column_name", true);
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    public JDBCConnection(bj bj2) {
        this.isInternal = true;
        this.sessionProxy = bj2;
    }

    public JDBCConnection(JDBCConnection jDBCConnection, JDBCConnectionEventListener jDBCConnectionEventListener) {
        this.sessionProxy = jDBCConnection.sessionProxy;
        this.connProperties = jDBCConnection.connProperties;
        this.clientProperties = jDBCConnection.clientProperties;
        this.isPooled = true;
        this.poolEventListener = jDBCConnectionEventListener;
        if (this.connProperties != null) {
            this.isCloseResultSet = this.connProperties.isPropertyTrue("close_result", false);
            this.isUseColumnName = this.connProperties.isPropertyTrue("get_column_name", true);
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    synchronized int getSavepointID() {
        return this.savepointIDSequence++;
    }

    synchronized String getURL() {
        this.checkClosed();
        return this.isInternal ? this.sessionProxy.getInternalConnectionURL() : this.connProperties.getProperty("url");
    }

    synchronized void checkClosed() {
        if (this.isClosed) {
            throw JDBCUtil.connectionClosedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWarning(SQLWarning sQLWarning) {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            if (this.rootWarning == null) {
                this.rootWarning = sQLWarning;
            } else {
                this.rootWarning.setNextWarning(sQLWarning);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWarnings(SQLWarning sQLWarning) {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            this.rootWarning = sQLWarning;
        }
    }

    public void reset() {
        try {
            ++this.incarnation;
            this.sessionProxy.resetSession();
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(1305, aa2.getMessage(), aa2);
        }
    }

    public void closeFully() {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.sessionProxy != null) {
                this.sessionProxy.close();
                this.sessionProxy = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public bj getSession() {
        return this.sessionProxy;
    }

    private int onStartEscapeSequence(String string, StringBuffer stringBuffer, int n2) {
        stringBuffer.append(' ');
        ++n2;
        n2 = org.hsqldb.lib.bj.skipSpaces(string, n2);
        if (string.regionMatches(true, n2, "fn ", 0, 3) || string.regionMatches(true, n2, "oj ", 0, 3)) {
            n2 += 2;
        } else if (string.regionMatches(true, n2, "ts ", 0, 3)) {
            stringBuffer.append("TIMESTAMP");
            n2 += 2;
        } else if (string.regionMatches(true, n2, "d ", 0, 2)) {
            stringBuffer.append("DATE");
            ++n2;
        } else if (string.regionMatches(true, n2, "t ", 0, 2)) {
            stringBuffer.append("TIME");
            ++n2;
        } else if (string.regionMatches(true, n2, "call ", 0, 5)) {
            stringBuffer.append("CALL");
            n2 += 4;
        } else if (string.regionMatches(true, n2, "?= call ", 0, 8)) {
            stringBuffer.append("CALL");
            n2 += 7;
        } else if (string.regionMatches(true, n2, "? = call ", 0, 8)) {
            stringBuffer.append("CALL");
            n2 += 8;
        } else if (string.regionMatches(true, n2, "escape ", 0, 7)) {
            n2 += 6;
        } else {
            throw JDBCUtil.sqlException(org.hsqldb.a.a.error(425, string.substring(--n2)));
        }
        return n2;
    }
}

