/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hsqldb.jdbc.JDBCBlobFile;
import org.hsqldb.jdbc.JDBCClob;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.lib.ab;
import org.hsqldb.lib.aj;
import org.hsqldb.lib.p;

public class JDBCClobFile
implements Clob {
    public static final String TEMP_FILE_PREFIX = "hsql_jdbc_clob_file_";
    public static final String TEMP_FILE_SUFFIX = ".tmp";
    private final File m_file;
    private boolean m_closed;
    private boolean m_deleteOnFree;
    private String m_encoding;
    private Charset m_charset;
    private CharsetEncoder m_encoder;
    private boolean m_fixedWidthCharset;
    private int m_maxCharWidth;
    private List m_streams = new ArrayList();

    @Override
    public long length() {
        this.checkClosed();
        if (this.m_fixedWidthCharset) {
            return this.m_file.length() / (long)this.m_maxCharWidth;
        }
        ReaderAdapter readerAdapter = null;
        try {
            long l2;
            readerAdapter = new ReaderAdapter(this.m_file, 0L, Long.MAX_VALUE);
            long l3 = l2 = readerAdapter.skip(Long.MAX_VALUE);
            return l3;
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        finally {
            if (readerAdapter != null) {
                try {
                    readerAdapter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public String getSubString(long l2, int n2) {
        Reader reader = null;
        CharArrayWriter charArrayWriter = null;
        try {
            int n3 = Math.min(8192, n2);
            reader = this.getCharacterStream(l2, n2);
            charArrayWriter = new CharArrayWriter(n3);
            ab.copy(reader, charArrayWriter, (long)n2);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return charArrayWriter.toString();
    }

    @Override
    public Reader getCharacterStream() {
        return this.getCharacterStream(1L, Long.MAX_VALUE);
    }

    @Override
    public InputStream getAsciiStream() {
        JDBCBlobFile.InputStreamAdapter inputStreamAdapter;
        try {
            inputStreamAdapter = new JDBCBlobFile.InputStreamAdapter(this.m_file, 0L, Long.MAX_VALUE){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCClobFile.this.m_streams.remove(this);
                    }
                }
            };
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        this.m_streams.add(inputStreamAdapter);
        return inputStreamAdapter;
    }

    public long position(char[] cArray, long l2) {
        if (l2 < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + l2);
        }
        if (cArray == null || cArray.length == 0 || l2 > this.length()) {
            return -1L;
        }
        Reader reader = null;
        try {
            reader = this.getCharacterStream(l2, Long.MAX_VALUE);
            long l3 = aj.search(reader, cArray, aj.computeTable(cArray));
            long l4 = l3 == -1L ? -1L : l2 + l3;
            return l4;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public long position(String string, long l2) {
        return this.position(string == null ? null : string.toCharArray(), l2);
    }

    @Override
    public long position(Clob clob, long l2) {
        char[] cArray;
        if (l2 < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + l2);
        }
        long l3 = clob == null ? 0L : clob.length();
        if (l3 == 0L) {
            return -1L;
        }
        if (l3 > Integer.MAX_VALUE) {
            throw JDBCUtil.outOfRangeArgument("pattern.length(): " + l3);
        }
        if (clob instanceof JDBCClob) {
            cArray = ((JDBCClob)clob).data().toCharArray();
        } else {
            Reader reader = null;
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            try {
                reader = clob.getCharacterStream();
                ab.copy(reader, charArrayWriter, l3);
            }
            catch (IOException iOException) {
                throw JDBCUtil.sqlException(iOException);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            cArray = charArrayWriter.toCharArray();
        }
        return this.position(cArray, l2);
    }

    @Override
    public int setString(long l2, String string) {
        return this.setString(l2, string, 0, string == null ? 0 : string.length());
    }

    @Override
    public int setString(long l2, String string, int n2, int n3) {
        if (string == null) {
            throw JDBCUtil.nullArgument("str");
        }
        Writer writer = null;
        try {
            writer = this.setCharacterStream(l2);
            writer.write(string, n2, n3);
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
        return n3;
    }

    @Override
    public OutputStream setAsciiStream(long l2) {
        JDBCBlobFile.OutputStreamAdapter outputStreamAdapter;
        if (l2 < 1L) {
            throw JDBCUtil.invalidArgument("pos: " + l2);
        }
        this.checkClosed();
        this.createFile();
        try {
            outputStreamAdapter = new JDBCBlobFile.OutputStreamAdapter(this.m_file, l2 - 1L){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCClobFile.this.m_streams.remove(this);
                    }
                }
            };
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        this.m_streams.add(outputStreamAdapter);
        return outputStreamAdapter;
    }

    @Override
    public Writer setCharacterStream(long l2) {
        BufferedWriter bufferedWriter;
        if (l2 < 1L) {
            throw JDBCUtil.invalidArgument("pos: " + l2);
        }
        this.checkClosed();
        this.createFile();
        try {
            WriterAdapter writerAdapter = new WriterAdapter(this.m_file, l2 - 1L){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCClobFile.this.m_streams.remove(this);
                    }
                }
            };
            bufferedWriter = new BufferedWriter(writerAdapter);
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        this.m_streams.add(bufferedWriter);
        return bufferedWriter;
    }

    @Override
    public void truncate(long l2) {
        if (l2 < 0L) {
            throw JDBCUtil.invalidArgument("len: " + l2);
        }
        this.checkClosed();
        ReaderAdapter readerAdapter = null;
        RandomAccessFile randomAccessFile = null;
        try {
            readerAdapter = new ReaderAdapter(this.m_file, l2, Long.MAX_VALUE);
            long l3 = readerAdapter.getFilePointer();
            readerAdapter.close();
            randomAccessFile = new RandomAccessFile(this.m_file, "rw");
            randomAccessFile.setLength(l3);
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        finally {
            if (readerAdapter != null) {
                try {
                    readerAdapter.close();
                }
                catch (Exception exception) {}
            }
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public synchronized void free() {
        if (this.m_closed) {
            return;
        }
        this.m_closed = true;
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.m_streams);
        this.m_streams = null;
        for (Object e2 : arrayList) {
            if (e2 instanceof InputStream) {
                try {
                    ((InputStream)e2).close();
                }
                catch (Exception exception) {}
                continue;
            }
            if (!(e2 instanceof OutputStream)) continue;
            try {
                ((OutputStream)e2).close();
            }
            catch (Exception exception) {}
        }
        if (this.m_deleteOnFree) {
            try {
                this.m_file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Reader getCharacterStream(long l2, long l3) {
        ReaderAdapter readerAdapter;
        if (l2 < 1L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l2);
        }
        --l2;
        if (l3 < 0L) {
            throw JDBCUtil.outOfRangeArgument("length: " + l3);
        }
        try {
            readerAdapter = new ReaderAdapter(this.m_file, l2, l3){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCClobFile.this.m_streams.remove(this);
                    }
                }
            };
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        this.m_streams.add(readerAdapter);
        return readerAdapter;
    }

    public File getFile() {
        return this.m_file;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public boolean isDeleteOnFree() {
        return this.m_deleteOnFree;
    }

    public void setDeleteOnFree(boolean bl2) {
        this.m_deleteOnFree = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        try {
            super.finalize();
        }
        finally {
            try {
                this.free();
            }
            catch (Throwable throwable) {}
        }
    }

    public JDBCClobFile() {
        this((String)null);
    }

    public JDBCClobFile(String string) {
        try {
            this.setEncoding(string);
            this.m_file = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
            this.m_deleteOnFree = true;
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
    }

    public JDBCClobFile(File file) {
        this(file, null);
    }

    public JDBCClobFile(File file, String string) {
        if (file == null) {
            throw JDBCUtil.nullArgument("file");
        }
        try {
            this.setEncoding(string);
            this.m_file = file.getCanonicalFile();
            this.checkIsFile(false);
            this.m_deleteOnFree = false;
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
    }

    protected final void setEncoding(String string) {
        boolean bl2;
        Charset charset = JDBCClobFile.charsetForName(string);
        CharsetEncoder charsetEncoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        float f2 = charsetEncoder.maxBytesPerChar();
        float f3 = charsetEncoder.averageBytesPerChar();
        this.m_fixedWidthCharset = bl2 = f2 == (float)Math.round(f2) && f2 == f3;
        this.m_maxCharWidth = Math.round(f2);
        this.m_charset = charset;
        this.m_encoder = charsetEncoder;
        this.m_encoding = this.m_charset.name();
    }

    protected static Charset charsetForName(String string) {
        String string2 = string;
        if (string2 == null) {
            string2 = Charset.defaultCharset().name();
        }
        try {
            if (Charset.isSupported(string2)) {
                return Charset.forName(string2);
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        throw new UnsupportedEncodingException(string2);
    }

    protected final void checkIsFile(boolean bl2) {
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            bl3 = this.m_file.exists();
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        if (bl3) {
            try {
                bl4 = this.m_file.isFile();
            }
            catch (Exception exception) {
                throw JDBCUtil.sqlException(exception);
            }
        }
        if (bl3) {
            if (!bl4) {
                throw JDBCUtil.invalidArgument("Is not a file: " + this.m_file);
            }
        } else if (bl2) {
            throw JDBCUtil.invalidArgument("Does not exist: " + this.m_file);
        }
    }

    protected void checkClosed() {
        if (this.m_closed) {
            throw JDBCUtil.sqlException(1251);
        }
    }

    protected void createFile() {
        try {
            if (!this.m_file.exists()) {
                p.getFileUtil().makeParentDirectories(this.m_file);
                this.m_file.createNewFile();
            }
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        this.checkIsFile(true);
    }

    protected class ReaderAdapter
    extends Reader {
        private static final int CHARBUFFER_CAPACTIY = 128;
        private final Reader m_reader;
        private long m_remaining = Long.MAX_VALUE;
        private long m_filePointer;
        private ByteBuffer m_byteBuffer;
        private CharBuffer m_charBuffer;

        public ReaderAdapter(File file, long l2, long l3) {
            int n2;
            if (file == null) {
                throw new NullPointerException("file");
            }
            if (l2 < 0L) {
                throw new IllegalArgumentException("pos: " + l2);
            }
            if (l3 < 0L) {
                throw new IllegalArgumentException("length: " + l3);
            }
            if (!JDBCClobFile.this.m_fixedWidthCharset) {
                int n3 = 128 * JDBCClobFile.this.m_maxCharWidth;
                this.m_charBuffer = CharBuffer.allocate(128);
                this.m_byteBuffer = ByteBuffer.allocate(n3);
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, JDBCClobFile.this.m_charset);
            this.m_reader = inputStreamReader;
            for (long i2 = 0L; i2 < l2 && (n2 = this.read()) != -1; ++i2) {
            }
            this.m_remaining = l3;
        }

        @Override
        public int read(char[] cArray, int n2, int n3) {
            int n4;
            int n5;
            long l2 = this.m_remaining;
            if (l2 <= 0L) {
                return -1;
            }
            if (l2 < (long)n3) {
                n3 = (int)l2;
            }
            if ((n5 = this.m_reader.read(cArray, n2, n3)) == -1) {
                return -1;
            }
            if ((long)n5 > l2) {
                n5 = (int)l2;
                this.m_remaining = 0L;
            } else {
                this.m_remaining -= (long)n5;
            }
            if (JDBCClobFile.this.m_fixedWidthCharset) {
                n4 = JDBCClobFile.this.m_maxCharWidth * n5;
            } else {
                boolean bl2 = n5 > this.m_charBuffer.capacity();
                CharBuffer charBuffer = bl2 ? CharBuffer.allocate(n5) : this.m_charBuffer;
                ByteBuffer byteBuffer = bl2 ? ByteBuffer.allocate(n5 * JDBCClobFile.this.m_maxCharWidth) : this.m_byteBuffer;
                charBuffer.clear();
                byteBuffer.clear();
                charBuffer.put(cArray, n2, n5);
                charBuffer.flip();
                JDBCClobFile.this.m_encoder.encode(charBuffer, byteBuffer, true);
                byteBuffer.flip();
                n4 = byteBuffer.limit();
                if (bl2) {
                    this.m_byteBuffer = byteBuffer;
                    this.m_charBuffer = charBuffer;
                }
            }
            this.m_filePointer += (long)n4;
            return n5;
        }

        @Override
        public void close() {
            this.m_reader.close();
        }

        public long getFilePointer() {
            return this.m_filePointer;
        }
    }

    protected class WriterAdapter
    extends Writer {
        private final RandomAccessFile m_randomAccessFile;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WriterAdapter(File file, long l2) {
            long l3;
            if (file == null) {
                throw new NullPointerException("file");
            }
            if (l2 < 0L) {
                throw new IllegalArgumentException("pos: " + l2);
            }
            ReaderAdapter readerAdapter = null;
            try {
                readerAdapter = new ReaderAdapter(file, l2, Long.MAX_VALUE);
                l3 = readerAdapter.getFilePointer();
            }
            finally {
                if (readerAdapter != null) {
                    try {
                        readerAdapter.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.m_randomAccessFile = new RandomAccessFile(file, "rw");
            this.m_randomAccessFile.seek(l3);
        }

        @Override
        public void flush() {
            this.m_randomAccessFile.getFD().sync();
        }

        @Override
        public void close() {
            this.m_randomAccessFile.close();
        }

        @Override
        public void write(char[] cArray, int n2, int n3) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = JDBCClobFile.this.m_encoding == null ? new OutputStreamWriter(byteArrayOutputStream) : new OutputStreamWriter((OutputStream)byteArrayOutputStream, JDBCClobFile.this.m_charset);
            outputStreamWriter.write(cArray, n2, n3);
            outputStreamWriter.close();
            this.m_randomAccessFile.write(byteArrayOutputStream.toByteArray());
        }
    }
}

