/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.sql.Clob;
import org.hsqldb.aa;
import org.hsqldb.bj;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.k.m;
import org.hsqldb.k.n;

public class JDBCClobClient
implements Clob {
    m originalClob;
    m clob;
    bj session;
    int colIndex;
    private boolean isClosed;
    private boolean isWritable;
    JDBCResultSet resultSet;

    @Override
    public synchronized InputStream getAsciiStream() {
        this.checkClosed();
        return new InputStream(){
            private final byte[] oneChar = new byte[1];
            private boolean m_closed;
            private CharBuffer m_charBuffer = (CharBuffer)CharBuffer.allocate(65536).flip();
            private ByteBuffer m_byteBuffer = ByteBuffer.allocate(1024);
            private Charset m_charset = JDBCClobClient.charsetForName("US-ASCII");
            private CharsetEncoder m_encoder = this.m_charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            private Reader m_reader;
            {
                this.m_reader = JDBCClobClient.this.clob.getCharacterStream(JDBCClobClient.this.session);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int read() {
                if (this.isEOF()) {
                    return -1;
                }
                byte[] byArray = this.oneChar;
                synchronized (this.oneChar) {
                    int n2 = this.read(this.oneChar, 0, 1);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return n2 == 1 ? this.oneChar[0] : -1;
                }
            }

            @Override
            public int read(byte[] byArray, int n2, int n3) {
                this.checkClosed();
                if (this.isEOF()) {
                    return -1;
                }
                CharBuffer charBuffer = this.m_charBuffer;
                if (charBuffer.remaining() == 0) {
                    charBuffer.clear();
                    int n4 = this.m_reader.read(charBuffer);
                    charBuffer.flip();
                    if (n4 < 0) {
                        this.setEOF();
                        return -1;
                    }
                    if (n4 == 0) {
                        return 0;
                    }
                }
                ByteBuffer byteBuffer = this.m_byteBuffer.capacity() < n3 ? ByteBuffer.allocate(n3) : this.m_byteBuffer;
                int n5 = charBuffer.limit();
                int n6 = charBuffer.position();
                charBuffer.limit(n6 + n3);
                byteBuffer.clear();
                int n7 = byteBuffer.position();
                CoderResult coderResult = this.m_encoder.encode(charBuffer, byteBuffer, false);
                if (n7 == byteBuffer.position() && coderResult.isUnderflow()) {
                    charBuffer.limit(charBuffer.limit() + 1);
                    this.m_encoder.encode(charBuffer, byteBuffer, false);
                }
                charBuffer.limit(n5);
                byteBuffer.flip();
                int n8 = byteBuffer.limit();
                if (n8 == 0) {
                    this.setEOF();
                    return -1;
                }
                this.m_byteBuffer = byteBuffer;
                byteBuffer.get(byArray, n2, n8);
                return n8;
            }

            @Override
            public void close() {
                boolean bl2 = this.m_closed;
                if (!bl2) {
                    this.m_closed = true;
                    this.m_charBuffer = null;
                    this.m_charset = null;
                    this.m_encoder = null;
                    try {
                        this.m_reader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            private boolean isEOF() {
                Reader reader = this.m_reader;
                return reader == null;
            }

            private void setEOF() {
                Reader reader = this.m_reader;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.m_reader = null;
            }

            private void checkClosed() {
                if (JDBCClobClient.this.isClosed()) {
                    try {
                        this.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.m_closed) {
                    throw new IOException("The stream is closed.");
                }
            }
        };
    }

    @Override
    public synchronized Reader getCharacterStream() {
        this.checkClosed();
        return new n(this.session, this.clob, 0L, this.length());
    }

    @Override
    public synchronized String getSubString(long l2, int n2) {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(Long.MAX_VALUE, l2 - 1L, n2)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        try {
            return this.clob.getSubString(this.session, l2 - 1L, n2);
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized long length() {
        this.checkClosed();
        try {
            return this.clob.length(this.session);
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized long position(String string, long l2) {
        if (!JDBCClobClient.isInLimits(Long.MAX_VALUE, l2 - 1L, 0L)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        this.checkClosed();
        try {
            return this.clob.position(this.session, string, l2 - 1L);
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized long position(Clob clob, long l2) {
        if (!JDBCClobClient.isInLimits(Long.MAX_VALUE, l2 - 1L, 0L)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (clob instanceof JDBCClobClient) {
            m m2 = ((JDBCClobClient)clob).clob;
            try {
                return this.clob.position(this.session, m2, l2 - 1L);
            }
            catch (aa aa2) {
                throw JDBCUtil.sqlException(aa2);
            }
        }
        return this.position(clob.getSubString(1L, (int)clob.length()), l2);
    }

    @Override
    public synchronized OutputStream setAsciiStream(final long l2) {
        this.checkClosed();
        if (l2 < 1L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l2);
        }
        if (!this.isWritable) {
            throw JDBCUtil.notUpdatableColumn();
        }
        this.startUpdate();
        return new OutputStream(){
            private long m_position;
            private Charset m_charset;
            private CharsetDecoder m_decoder;
            private CharBuffer m_charBuffer;
            private ByteBuffer m_byteBuffer;
            private final byte[] oneByte;
            private boolean m_closed;
            {
                this.m_position = l2 - 1L;
                this.m_charset = JDBCClobClient.charsetForName("US-ASCII");
                this.m_decoder = this.m_charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
                this.m_charBuffer = CharBuffer.allocate(65536);
                this.m_byteBuffer = ByteBuffer.allocate(1024);
                this.oneByte = new byte[1];
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(int n2) {
                byte[] byArray = this.oneByte;
                synchronized (this.oneByte) {
                    this.oneByte[0] = (byte)n2;
                    this.write(this.oneByte, 0, 1);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            @Override
            public void write(byte[] byArray, int n2, int n3) {
                ByteBuffer byteBuffer;
                this.checkClosed();
                ByteBuffer byteBuffer2 = byteBuffer = this.m_byteBuffer.capacity() < n3 ? ByteBuffer.allocate(n3) : this.m_byteBuffer;
                if (this.m_charBuffer.remaining() < n3) {
                    this.flush0();
                }
                CharBuffer charBuffer = this.m_charBuffer.capacity() < n3 ? CharBuffer.allocate(n3) : this.m_charBuffer;
                byteBuffer.clear();
                byteBuffer.put(byArray, n2, n3);
                byteBuffer.flip();
                this.m_decoder.decode(byteBuffer, charBuffer, false);
                if (charBuffer.remaining() == 0) {
                    this.flush();
                }
            }

            @Override
            public void flush() {
                this.checkClosed();
                this.flush0();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                if (!this.m_closed) {
                    try {
                        this.flush0();
                    }
                    finally {
                        this.m_closed = true;
                        this.m_byteBuffer = null;
                        this.m_charBuffer = null;
                        this.m_charset = null;
                        this.m_decoder = null;
                    }
                }
            }

            private void checkClosed() {
                if (JDBCClobClient.this.isClosed()) {
                    try {
                        this.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.m_closed) {
                    throw new IOException("The stream is closed.");
                }
            }

            private void flush0() {
                CharBuffer charBuffer = this.m_charBuffer;
                charBuffer.flip();
                char[] cArray = new char[charBuffer.length()];
                charBuffer.get(cArray);
                charBuffer.clear();
                try {
                    JDBCClobClient.this.clob.setChars(JDBCClobClient.this.session, this.m_position, cArray, 0, cArray.length);
                }
                catch (Exception exception) {
                    throw new IOException(exception.toString());
                }
                this.m_position += (long)cArray.length;
            }
        };
    }

    @Override
    public synchronized Writer setCharacterStream(final long l2) {
        this.checkClosed();
        if (l2 < 1L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l2);
        }
        if (!this.isWritable) {
            throw JDBCUtil.notUpdatableColumn();
        }
        this.startUpdate();
        return new Writer(){
            private long m_clobPosition;
            private boolean m_closed;
            {
                this.m_clobPosition = l2 - 1L;
            }

            @Override
            public void write(char[] cArray, int n2, int n3) {
                this.checkClosed();
                JDBCClobClient.this.clob.setChars(JDBCClobClient.this.session, this.m_clobPosition, cArray, n2, n3);
                this.m_clobPosition += (long)n3;
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
                this.m_closed = true;
            }

            private void checkClosed() {
                if (this.m_closed || JDBCClobClient.this.isClosed()) {
                    throw new IOException("The stream is closed");
                }
            }
        };
    }

    @Override
    public synchronized int setString(long l2, String string) {
        return this.setString(l2, string, 0, string.length());
    }

    @Override
    public synchronized int setString(long l2, String string, int n2, int n3) {
        if (!JDBCClobClient.isInLimits(string.length(), n2, n3)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        this.checkClosed();
        if (l2 < 1L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l2);
        }
        if (!this.isWritable) {
            throw JDBCUtil.notUpdatableColumn();
        }
        this.startUpdate();
        string = string.substring(n2, n2 + n3);
        try {
            this.clob.setString(this.session, l2 - 1L, string);
            return n3;
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized void truncate(long l2) {
        if (l2 < 0L) {
            throw JDBCUtil.outOfRangeArgument("len: " + l2);
        }
        this.checkClosed();
        try {
            this.clob.truncate(this.session, l2);
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized void free() {
        this.isClosed = true;
        this.clob = null;
        this.session = null;
    }

    @Override
    public synchronized Reader getCharacterStream(long l2, long l3) {
        if (!JDBCClobClient.isInLimits(Long.MAX_VALUE, l2 - 1L, l3)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        this.checkClosed();
        return new n(this.session, this.clob, l2 - 1L, l3);
    }

    char[] getChars(long l2, int n2) {
        try {
            return this.clob.getChars(this.session, l2 - 1L, n2);
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    public JDBCClobClient(bj bj2, m m2) {
        this.session = bj2;
        this.clob = m2;
    }

    public m getClob() {
        return this.clob;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public synchronized void setWritable(JDBCResultSet jDBCResultSet, int n2) {
        this.isWritable = true;
        this.resultSet = jDBCResultSet;
        this.colIndex = n2;
    }

    public synchronized void clearUpdates() {
        if (this.originalClob != null) {
            this.clob = this.originalClob;
            this.originalClob = null;
        }
    }

    private void startUpdate() {
        if (this.originalClob != null) {
            return;
        }
        this.originalClob = this.clob;
        this.clob = (m)this.clob.duplicate(this.session);
        this.resultSet.startUpdate(this.colIndex + 1);
        this.resultSet.preparedStatement.parameterValues[this.colIndex] = this.clob;
        this.resultSet.preparedStatement.parameterSet[this.colIndex] = Boolean.TRUE;
    }

    private void checkClosed() {
        if (this.isClosed) {
            throw JDBCUtil.sqlException(1251);
        }
    }

    static boolean isInLimits(long l2, long l3, long l4) {
        return l2 >= 0L && l3 >= 0L && l4 >= 0L && l3 <= l2 - l4;
    }

    protected static Charset charsetForName(String string) {
        String string2 = string;
        if (string2 == null) {
            string2 = Charset.defaultCharset().name();
        }
        try {
            if (Charset.isSupported(string2)) {
                return Charset.forName(string2);
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        throw JDBCUtil.sqlException(new UnsupportedEncodingException(string2));
    }
}

