/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.lib.a.a;
import org.hsqldb.lib.aj;

public class JDBCClob
implements Clob {
    private static final long MIN_POS = 1L;
    private static final long MAX_POS = 0x80000000L;
    private boolean m_closed;
    private String m_data;
    private final boolean m_createdByConnection;

    @Override
    public long length() {
        return this.getData().length();
    }

    @Override
    public String getSubString(long l2, int n2) {
        String string = this.getData();
        int n3 = string.length();
        if (l2 < 1L || l2 > (long)n3) {
            JDBCUtil.outOfRangeArgument("pos: " + l2);
        }
        if (n2 < 0 || (long)n2 > (long)n3 - --l2) {
            throw JDBCUtil.outOfRangeArgument("length: " + n2);
        }
        return l2 == 0L && n2 == n3 ? string : string.substring((int)l2, (int)l2 + n2);
    }

    @Override
    public Reader getCharacterStream() {
        return new StringReader(this.getData());
    }

    @Override
    public InputStream getAsciiStream() {
        try {
            return new ByteArrayInputStream(this.getData().getBytes("US-ASCII"));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public long position(String string, long l2) {
        String string2 = this.getData();
        if (l2 < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + l2);
        }
        if (string == null || l2 > 0x80000000L) {
            return -1L;
        }
        int n2 = aj.search(string2, string, null, (int)l2);
        return n2 == -1 ? -1L : (long)(n2 + 1);
    }

    @Override
    public long position(Clob clob, long l2) {
        long l3;
        String string = this.getData();
        if (l2 < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + l2);
        }
        if (clob == null) {
            return -1L;
        }
        long l4 = string.length();
        if (--l2 > l4 - (l3 = clob.length())) {
            return -1L;
        }
        String string2 = clob instanceof JDBCClob ? ((JDBCClob)clob).data() : clob.getSubString(1L, (int)l3);
        int n2 = aj.search(string, string2, null, (int)l2);
        return n2 == -1 ? -1L : (long)(n2 + 1);
    }

    @Override
    public int setString(long l2, String string) {
        if (string == null) {
            throw JDBCUtil.nullArgument("str");
        }
        return this.setString(l2, string, 0, string.length());
    }

    @Override
    public int setString(long l2, String string, int n2, int n3) {
        StringBuffer stringBuffer;
        if (!this.m_createdByConnection) {
            throw JDBCUtil.notSupported();
        }
        String string2 = this.getData();
        if (string == null) {
            throw JDBCUtil.nullArgument("str");
        }
        int n4 = string.length();
        if (n2 < 0 || n2 > n4) {
            throw JDBCUtil.outOfRangeArgument("offset: " + n2);
        }
        if (n3 > n4 - n2) {
            throw JDBCUtil.outOfRangeArgument("len: " + n3);
        }
        if (l2 < 1L || l2 > 1L + (long)(Integer.MAX_VALUE - n3)) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l2);
        }
        int n5 = (int)(l2 - 1L);
        int n6 = string2.length();
        if (n5 > n6 - n3) {
            stringBuffer = new StringBuffer(n5 + n3);
            stringBuffer.append(string2.substring(0, n5));
            string2 = null;
            stringBuffer.append(string.substring(n2, n2 + n3));
            string = null;
        } else {
            stringBuffer = new StringBuffer(string2);
            string2 = null;
            int n7 = n5;
            for (int i2 = 0; i2 < n3; ++i2) {
                stringBuffer.setCharAt(n7, string.charAt(n2 + i2));
                ++n7;
            }
            string = null;
        }
        this.setData(stringBuffer.toString());
        return n3;
    }

    @Override
    public OutputStream setAsciiStream(final long l2) {
        if (!this.m_createdByConnection) {
            throw JDBCUtil.notSupported();
        }
        this.checkClosed();
        if (l2 < 1L || l2 > 0x80000000L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l2);
        }
        return new ByteArrayOutputStream(){

            @Override
            public synchronized void close() {
                try {
                    JDBCClob.this.setString(l2, new String(this.toByteArray(), "US-ASCII"));
                }
                catch (SQLException sQLException) {
                    throw a.toIOException(sQLException);
                }
                finally {
                    super.close();
                }
            }
        };
    }

    @Override
    public Writer setCharacterStream(final long l2) {
        if (!this.m_createdByConnection) {
            throw JDBCUtil.notSupported();
        }
        this.checkClosed();
        if (l2 < 1L || l2 > 0x80000000L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l2);
        }
        return new StringWriter(){

            @Override
            public synchronized void close() {
                try {
                    JDBCClob.this.setString(l2, this.toString());
                }
                catch (SQLException sQLException) {
                    throw a.toIOException(sQLException);
                }
            }
        };
    }

    @Override
    public void truncate(long l2) {
        String string = this.getData();
        long l3 = string.length();
        if (!this.m_createdByConnection) {
            throw JDBCUtil.notSupported();
        }
        if (l2 != l3) {
            if (l2 < 0L || l2 > l3) {
                throw JDBCUtil.outOfRangeArgument("len: " + l2);
            }
            this.setData(string.substring(0, (int)l2));
        }
    }

    @Override
    public synchronized void free() {
        this.m_closed = true;
        this.m_data = null;
    }

    @Override
    public Reader getCharacterStream(long l2, long l3) {
        if (l3 > Integer.MAX_VALUE) {
            throw JDBCUtil.outOfRangeArgument("length: " + l3);
        }
        return new StringReader(this.getSubString(l2, (int)l3));
    }

    public JDBCClob(String string) {
        if (string == null) {
            throw JDBCUtil.nullArgument();
        }
        this.m_data = string;
        this.m_createdByConnection = false;
    }

    protected JDBCClob() {
        this.m_data = "";
        this.m_createdByConnection = true;
    }

    protected synchronized void checkClosed() {
        if (this.m_closed) {
            throw JDBCUtil.sqlException(1251);
        }
    }

    protected String data() {
        return this.getData();
    }

    private synchronized String getData() {
        this.checkClosed();
        return this.m_data;
    }

    private synchronized void setData(String string) {
        this.checkClosed();
        this.m_data = string;
    }
}

