/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.hsqldb.a.a;
import org.hsqldb.aa;
import org.hsqldb.jdbc.JDBCArray;
import org.hsqldb.jdbc.JDBCBlobClient;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCPreparedStatement;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.k.ab;
import org.hsqldb.k.ac;
import org.hsqldb.k.ad;
import org.hsqldb.k.b;
import org.hsqldb.k.f;
import org.hsqldb.k.m;
import org.hsqldb.k.r;
import org.hsqldb.k.v;
import org.hsqldb.lib.ah;
import org.hsqldb.z;

public class JDBCCallableStatement
extends JDBCPreparedStatement
implements CallableStatement {
    private ah parameterNameMap = new ah();
    private boolean wasNullValue;

    @Override
    public synchronized void registerOutParameter(int n2, int n3) {
        this.checkGetParameterIndex(n2);
        if (this.parameterModes[--n2] == 1) {
            throw JDBCUtil.invalidArgument();
        }
    }

    @Override
    public ResultSet getResultSet() {
        return super.getResultSet();
    }

    @Override
    public synchronized void registerOutParameter(int n2, int n3, int n4) {
        this.registerOutParameter(n2, n3);
    }

    @Override
    public synchronized boolean wasNull() {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.wasNullValue;
    }

    @Override
    public synchronized String getString(int n2) {
        return (String)this.getColumnInType(n2, ad.SQL_VARCHAR);
    }

    @Override
    public synchronized boolean getBoolean(int n2) {
        Object object = this.getColumnInType(n2, ad.SQL_BOOLEAN);
        return object == null ? false : (Boolean)object;
    }

    @Override
    public synchronized byte getByte(int n2) {
        Object object = this.getColumnInType(n2, ad.TINYINT);
        return object == null ? (byte)0 : ((Number)object).byteValue();
    }

    @Override
    public synchronized short getShort(int n2) {
        Object object = this.getColumnInType(n2, ad.SQL_SMALLINT);
        return object == null ? (short)0 : ((Number)object).shortValue();
    }

    @Override
    public synchronized int getInt(int n2) {
        Object object = this.getColumnInType(n2, ad.SQL_INTEGER);
        return object == null ? 0 : ((Number)object).intValue();
    }

    @Override
    public synchronized long getLong(int n2) {
        Object object = this.getColumnInType(n2, ad.SQL_BIGINT);
        return object == null ? 0L : ((Number)object).longValue();
    }

    @Override
    public synchronized float getFloat(int n2) {
        Object object = this.getColumnInType(n2, ad.SQL_DOUBLE);
        return object == null ? 0.0f : ((Number)object).floatValue();
    }

    @Override
    public synchronized double getDouble(int n2) {
        Object object = this.getColumnInType(n2, ad.SQL_DOUBLE);
        return object == null ? 0.0 : ((Number)object).doubleValue();
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int n2, int n3) {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n3 < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        BigDecimal bigDecimal = this.getBigDecimal(n2);
        if (bigDecimal != null) {
            bigDecimal = bigDecimal.setScale(n3, 1);
        }
        return bigDecimal;
    }

    @Override
    public synchronized byte[] getBytes(int n2) {
        Object object = this.getColumnInType(n2, ad.SQL_VARBINARY);
        if (object == null) {
            return null;
        }
        return ((b)object).getBytes();
    }

    @Override
    public synchronized Date getDate(int n2) {
        ac ac2 = (ac)this.getColumnInType(n2, ad.SQL_DATE);
        if (ac2 == null) {
            return null;
        }
        return (Date)ad.SQL_DATE.convertSQLToJava(this.session, ac2);
    }

    @Override
    public synchronized Time getTime(int n2) {
        ab ab2 = (ab)this.getColumnInType(n2, ad.SQL_TIME);
        if (ab2 == null) {
            return null;
        }
        return (Time)ad.SQL_TIME.convertSQLToJava(this.session, ab2);
    }

    @Override
    public synchronized Timestamp getTimestamp(int n2) {
        ac ac2 = (ac)this.getColumnInType(n2, ad.SQL_TIMESTAMP);
        if (ac2 == null) {
            return null;
        }
        return (Timestamp)ad.SQL_TIMESTAMP.convertSQLToJava(this.session, ac2);
    }

    @Override
    public synchronized Object getObject(int n2) {
        this.checkGetParameterIndex(n2);
        ad ad2 = this.parameterTypes[n2 - 1];
        switch (ad2.typeCode) {
            case 50: {
                return this.getArray(n2);
            }
            case 91: {
                return this.getDate(n2);
            }
            case 92: 
            case 94: {
                return this.getTime(n2);
            }
            case 93: 
            case 95: {
                return this.getTimestamp(n2);
            }
            case 60: 
            case 61: {
                return this.getBytes(n2);
            }
            case 14: {
                boolean bl2 = this.getBoolean(n2);
                return this.wasNull() ? null : (bl2 ? Boolean.TRUE : Boolean.FALSE);
            }
            case 40: {
                return this.getClob(n2);
            }
            case 30: {
                return this.getBlob(n2);
            }
            case 1111: 
            case 2000: {
                Object object = this.getColumnInType(n2, ad2);
                if (object == null) {
                    return null;
                }
                try {
                    return ((v)object).getObject();
                }
                catch (aa aa2) {
                    throw JDBCUtil.sqlException(aa2);
                }
            }
        }
        return this.getColumnInType(n2, ad2);
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int n2) {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        ad ad2 = this.parameterMetaData.columnTypes[n2 - 1];
        switch (ad2.typeCode) {
            case 2: 
            case 3: {
                break;
            }
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                ad2 = ad.SQL_DECIMAL;
                break;
            }
            default: {
                ad2 = ad.SQL_DECIMAL_DEFAULT;
            }
        }
        return (BigDecimal)this.getColumnInType(n2, ad2);
    }

    @Override
    public Object getObject(int n2, Map<String, Class<?>> map) {
        this.checkGetParameterIndex(n2);
        throw JDBCUtil.notSupported();
    }

    @Override
    public Ref getRef(int n2) {
        this.checkGetParameterIndex(n2);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized Blob getBlob(int n2) {
        this.checkGetParameterIndex(n2);
        ad ad2 = this.parameterMetaData.columnTypes[n2 - 1];
        Object object = this.getColumnInType(n2, ad2);
        if (object == null) {
            return null;
        }
        if (object instanceof f) {
            return new JDBCBlobClient(this.session, (f)object);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public synchronized Clob getClob(int n2) {
        this.checkGetParameterIndex(n2);
        ad ad2 = this.parameterMetaData.columnTypes[n2 - 1];
        Object object = this.getColumnInType(n2, ad2);
        if (object == null) {
            return null;
        }
        if (object instanceof m) {
            return new JDBCClobClient(this.session, (m)object);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public Array getArray(int n2) {
        this.checkGetParameterIndex(n2);
        ad ad2 = this.parameterMetaData.columnTypes[n2 - 1];
        if (!ad2.isArrayType()) {
            throw JDBCUtil.sqlException(5561);
        }
        Object[] objectArray = (Object[])this.parameterValues[n2 - 1];
        if (objectArray == null) {
            return null;
        }
        return new JDBCArray(objectArray, ad2.collectionBaseType(), ad2, this.connection);
    }

    @Override
    public synchronized Date getDate(int n2, Calendar calendar) {
        ac ac2 = (ac)this.getColumnInType(n2, ad.SQL_DATE);
        if (ac2 == null) {
            return null;
        }
        long l2 = ac2.getSeconds() * 1000L;
        if (calendar != null) {
            l2 = z.convertMillisToCalendar(calendar, l2);
        }
        return new Date(l2);
    }

    @Override
    public synchronized Time getTime(int n2, Calendar calendar) {
        ab ab2 = (ab)this.getColumnInType(n2, ad.SQL_TIME);
        if (ab2 == null) {
            return null;
        }
        long l2 = r.normaliseTime(ab2.getSeconds()) * 1000;
        if (!this.parameterMetaData.columnTypes[--n2].isDateTimeTypeWithZone()) {
            Calendar calendar2 = calendar == null ? this.session.getCalendar() : calendar;
            l2 = z.convertMillisToCalendar(calendar2, l2);
            l2 = z.getNormalisedTime(l2);
        }
        return new Time(l2);
    }

    @Override
    public synchronized Timestamp getTimestamp(int n2, Calendar calendar) {
        Comparable<Calendar> comparable;
        ac ac2 = (ac)this.getColumnInType(n2, ad.SQL_TIMESTAMP);
        if (ac2 == null) {
            return null;
        }
        long l2 = ac2.getSeconds() * 1000L;
        if (!this.parameterMetaData.columnTypes[--n2].isDateTimeTypeWithZone()) {
            Comparable<Calendar> comparable2 = comparable = calendar == null ? this.session.getCalendar() : calendar;
            if (calendar != null) {
                l2 = z.convertMillisToCalendar((Calendar)comparable, l2);
            }
        }
        comparable = new Timestamp(l2);
        ((Timestamp)comparable).setNanos(ac2.getNanos());
        return comparable;
    }

    @Override
    public synchronized void registerOutParameter(int n2, int n3, String string) {
        this.registerOutParameter(n2, n3);
    }

    @Override
    public synchronized void registerOutParameter(String string, int n2) {
        this.registerOutParameter(this.findParameterIndex(string), n2);
    }

    @Override
    public synchronized void registerOutParameter(String string, int n2, int n3) {
        this.registerOutParameter(this.findParameterIndex(string), n2);
    }

    @Override
    public synchronized void registerOutParameter(String string, int n2, String string2) {
        this.registerOutParameter(this.findParameterIndex(string), n2);
    }

    @Override
    public URL getURL(int n2) {
        this.checkGetParameterIndex(n2);
        throw JDBCUtil.notSupported();
    }

    @Override
    public void setURL(String string, URL uRL) {
        this.setURL(this.findParameterIndex(string), uRL);
    }

    @Override
    public synchronized void setNull(String string, int n2) {
        this.setNull(this.findParameterIndex(string), n2);
    }

    @Override
    public synchronized void setBoolean(String string, boolean bl2) {
        this.setBoolean(this.findParameterIndex(string), bl2);
    }

    @Override
    public synchronized void setByte(String string, byte by2) {
        this.setByte(this.findParameterIndex(string), by2);
    }

    @Override
    public synchronized void setShort(String string, short s2) {
        this.setShort(this.findParameterIndex(string), s2);
    }

    @Override
    public synchronized void setInt(String string, int n2) {
        this.setInt(this.findParameterIndex(string), n2);
    }

    @Override
    public synchronized void setLong(String string, long l2) {
        this.setLong(this.findParameterIndex(string), l2);
    }

    @Override
    public synchronized void setFloat(String string, float f2) {
        this.setFloat(this.findParameterIndex(string), f2);
    }

    @Override
    public synchronized void setDouble(String string, double d2) {
        this.setDouble(this.findParameterIndex(string), d2);
    }

    @Override
    public synchronized void setBigDecimal(String string, BigDecimal bigDecimal) {
        this.setBigDecimal(this.findParameterIndex(string), bigDecimal);
    }

    @Override
    public synchronized void setString(String string, String string2) {
        this.setString(this.findParameterIndex(string), string2);
    }

    @Override
    public synchronized void setBytes(String string, byte[] byArray) {
        this.setBytes(this.findParameterIndex(string), byArray);
    }

    @Override
    public synchronized void setDate(String string, Date date) {
        this.setDate(this.findParameterIndex(string), date);
    }

    @Override
    public synchronized void setTime(String string, Time time) {
        this.setTime(this.findParameterIndex(string), time);
    }

    @Override
    public synchronized void setTimestamp(String string, Timestamp timestamp) {
        this.setTimestamp(this.findParameterIndex(string), timestamp);
    }

    @Override
    public synchronized void setAsciiStream(String string, InputStream inputStream, int n2) {
        this.setAsciiStream(this.findParameterIndex(string), inputStream, n2);
    }

    @Override
    public synchronized void setBinaryStream(String string, InputStream inputStream, int n2) {
        this.setBinaryStream(this.findParameterIndex(string), inputStream, n2);
    }

    @Override
    public synchronized void setObject(String string, Object object, int n2, int n3) {
        this.setObject(this.findParameterIndex(string), object, n2, n3);
    }

    @Override
    public synchronized void setObject(String string, Object object, int n2) {
        this.setObject(this.findParameterIndex(string), object, n2);
    }

    @Override
    public synchronized void setObject(String string, Object object) {
        this.setObject(this.findParameterIndex(string), object);
    }

    @Override
    public synchronized void setCharacterStream(String string, Reader reader, int n2) {
        this.setCharacterStream(this.findParameterIndex(string), reader, n2);
    }

    @Override
    public synchronized void setDate(String string, Date date, Calendar calendar) {
        this.setDate(this.findParameterIndex(string), date, calendar);
    }

    @Override
    public synchronized void setTime(String string, Time time, Calendar calendar) {
        this.setTime(this.findParameterIndex(string), time, calendar);
    }

    @Override
    public synchronized void setTimestamp(String string, Timestamp timestamp, Calendar calendar) {
        this.setTimestamp(this.findParameterIndex(string), timestamp, calendar);
    }

    @Override
    public synchronized void setNull(String string, int n2, String string2) {
        this.setNull(this.findParameterIndex(string), n2, string2);
    }

    @Override
    public synchronized String getString(String string) {
        return this.getString(this.findParameterIndex(string));
    }

    @Override
    public synchronized boolean getBoolean(String string) {
        return this.getBoolean(this.findParameterIndex(string));
    }

    @Override
    public synchronized byte getByte(String string) {
        return this.getByte(this.findParameterIndex(string));
    }

    @Override
    public synchronized short getShort(String string) {
        return this.getShort(this.findParameterIndex(string));
    }

    @Override
    public synchronized int getInt(String string) {
        return this.getInt(this.findParameterIndex(string));
    }

    @Override
    public synchronized long getLong(String string) {
        return this.getLong(this.findParameterIndex(string));
    }

    @Override
    public synchronized float getFloat(String string) {
        return this.getFloat(this.findParameterIndex(string));
    }

    @Override
    public synchronized double getDouble(String string) {
        return this.getDouble(this.findParameterIndex(string));
    }

    @Override
    public synchronized byte[] getBytes(String string) {
        return this.getBytes(this.findParameterIndex(string));
    }

    @Override
    public synchronized Date getDate(String string) {
        return this.getDate(this.findParameterIndex(string));
    }

    @Override
    public synchronized Time getTime(String string) {
        return this.getTime(this.findParameterIndex(string));
    }

    @Override
    public synchronized Timestamp getTimestamp(String string) {
        return this.getTimestamp(this.findParameterIndex(string));
    }

    @Override
    public synchronized Object getObject(String string) {
        return this.getObject(this.findParameterIndex(string));
    }

    @Override
    public synchronized BigDecimal getBigDecimal(String string) {
        return this.getBigDecimal(this.findParameterIndex(string));
    }

    public synchronized Object getObject(String string, Map map) {
        return this.getObject(this.findParameterIndex(string), map);
    }

    @Override
    public synchronized Ref getRef(String string) {
        return this.getRef(this.findParameterIndex(string));
    }

    @Override
    public synchronized Blob getBlob(String string) {
        return this.getBlob(this.findParameterIndex(string));
    }

    @Override
    public synchronized Clob getClob(String string) {
        return this.getClob(this.findParameterIndex(string));
    }

    @Override
    public synchronized Array getArray(String string) {
        return this.getArray(this.findParameterIndex(string));
    }

    @Override
    public synchronized Date getDate(String string, Calendar calendar) {
        return this.getDate(this.findParameterIndex(string), calendar);
    }

    @Override
    public synchronized Time getTime(String string, Calendar calendar) {
        return this.getTime(this.findParameterIndex(string), calendar);
    }

    @Override
    public synchronized Timestamp getTimestamp(String string, Calendar calendar) {
        return this.getTimestamp(this.findParameterIndex(string), calendar);
    }

    @Override
    public URL getURL(String string) {
        return this.getURL(this.findParameterIndex(string));
    }

    @Override
    public RowId getRowId(int n2) {
        this.checkGetParameterIndex(n2);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized RowId getRowId(String string) {
        return this.getRowId(this.findParameterIndex(string));
    }

    @Override
    public synchronized void setRowId(String string, RowId rowId) {
        super.setRowId(this.findParameterIndex(string), rowId);
    }

    @Override
    public synchronized void setNString(String string, String string2) {
        super.setNString(this.findParameterIndex(string), string2);
    }

    @Override
    public synchronized void setNCharacterStream(String string, Reader reader, long l2) {
        super.setNCharacterStream(this.findParameterIndex(string), reader, l2);
    }

    @Override
    public synchronized void setNClob(String string, NClob nClob) {
        super.setNClob(this.findParameterIndex(string), nClob);
    }

    @Override
    public synchronized void setClob(String string, Reader reader, long l2) {
        super.setClob(this.findParameterIndex(string), reader, l2);
    }

    @Override
    public synchronized void setBlob(String string, InputStream inputStream, long l2) {
        super.setBlob(this.findParameterIndex(string), inputStream, l2);
    }

    @Override
    public synchronized void setNClob(String string, Reader reader, long l2) {
        super.setNClob(this.findParameterIndex(string), reader, l2);
    }

    @Override
    public NClob getNClob(int n2) {
        this.checkGetParameterIndex(n2);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized NClob getNClob(String string) {
        return this.getNClob(this.findParameterIndex(string));
    }

    @Override
    public synchronized void setSQLXML(String string, SQLXML sQLXML) {
        super.setSQLXML(this.findParameterIndex(string), sQLXML);
    }

    @Override
    public SQLXML getSQLXML(int n2) {
        this.checkGetParameterIndex(n2);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized SQLXML getSQLXML(String string) {
        return this.getSQLXML(this.findParameterIndex(string));
    }

    @Override
    public String getNString(int n2) {
        this.checkGetParameterIndex(n2);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized String getNString(String string) {
        return this.getNString(this.findParameterIndex(string));
    }

    @Override
    public Reader getNCharacterStream(int n2) {
        this.checkGetParameterIndex(n2);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized Reader getNCharacterStream(String string) {
        return this.getNCharacterStream(this.findParameterIndex(string));
    }

    @Override
    public Reader getCharacterStream(int n2) {
        this.checkGetParameterIndex(n2);
        ad ad2 = this.parameterMetaData.columnTypes[n2 - 1];
        Object object = this.getColumnInType(n2, ad2);
        if (object == null) {
            return null;
        }
        if (object instanceof m) {
            return ((m)object).getCharacterStream(this.session);
        }
        if (object instanceof Clob) {
            return ((Clob)object).getCharacterStream();
        }
        if (object instanceof String) {
            return new StringReader((String)object);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public synchronized Reader getCharacterStream(String string) {
        return this.getCharacterStream(this.findParameterIndex(string));
    }

    @Override
    public synchronized void setBlob(String string, Blob blob) {
        super.setBlob(this.findParameterIndex(string), blob);
    }

    @Override
    public synchronized void setClob(String string, Clob clob) {
        super.setClob(this.findParameterIndex(string), clob);
    }

    @Override
    public synchronized void setAsciiStream(String string, InputStream inputStream, long l2) {
        if (l2 > Integer.MAX_VALUE) {
            String string2 = "Maximum ASCII input octet length exceeded: " + l2;
            throw JDBCUtil.sqlException(422, string2);
        }
        this.setAsciiStream(string, inputStream, (int)l2);
    }

    @Override
    public synchronized void setBinaryStream(String string, InputStream inputStream, long l2) {
        if (l2 > Integer.MAX_VALUE) {
            String string2 = "Maximum Binary input octet length exceeded: " + l2;
            throw JDBCUtil.sqlException(422, string2);
        }
        this.setBinaryStream(string, inputStream, (int)l2);
    }

    @Override
    public synchronized void setCharacterStream(String string, Reader reader, long l2) {
        if (l2 > Integer.MAX_VALUE) {
            String string2 = "Maximum character input length exceeded: " + l2;
            throw JDBCUtil.sqlException(422, string2);
        }
        this.setCharacterStream(string, reader, (int)l2);
    }

    @Override
    public synchronized void setAsciiStream(String string, InputStream inputStream) {
        super.setAsciiStream(this.findParameterIndex(string), inputStream);
    }

    @Override
    public synchronized void setBinaryStream(String string, InputStream inputStream) {
        super.setBinaryStream(this.findParameterIndex(string), inputStream);
    }

    @Override
    public synchronized void setCharacterStream(String string, Reader reader) {
        super.setCharacterStream(this.findParameterIndex(string), reader);
    }

    @Override
    public synchronized void setNCharacterStream(String string, Reader reader) {
        super.setNCharacterStream(this.findParameterIndex(string), reader);
    }

    @Override
    public synchronized void setClob(String string, Reader reader) {
        super.setClob(this.findParameterIndex(string), reader);
    }

    @Override
    public synchronized void setBlob(String string, InputStream inputStream) {
        super.setBlob(this.findParameterIndex(string), inputStream);
    }

    @Override
    public synchronized void setNClob(String string, Reader reader) {
        super.setNClob(this.findParameterIndex(string), reader);
    }

    @Override
    public <T> T getObject(int n2, Class<T> clazz) {
        return (T)this.getObject(n2);
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) {
        return this.getObject(this.findParameterIndex(string), clazz);
    }

    public JDBCCallableStatement(JDBCConnection jDBCConnection, String string, int n2, int n3, int n4) {
        super(jDBCConnection, string, n2, n3, n4, 2, null, null);
        if (this.parameterMetaData != null) {
            String[] stringArray = this.parameterMetaData.columnLabels;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = stringArray[i2];
                if (string2 == null || string2.length() == 0) continue;
                this.parameterNameMap.put(string2, i2);
            }
        }
    }

    @Override
    void fetchResult() {
        super.fetchResult();
        if (this.resultIn.getType() == 43) {
            Object[] objectArray = this.resultIn.getParameterData();
            for (int i2 = 0; i2 < this.parameterValues.length; ++i2) {
                this.parameterValues[i2] = objectArray[i2];
            }
        }
    }

    int findParameterIndex(String string) {
        int n2;
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if ((n2 = this.parameterNameMap.get((Object)string, -1)) >= 0) {
            return n2 + 1;
        }
        throw JDBCUtil.sqlException(421, string);
    }

    @Override
    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        this.parameterNameMap = null;
        super.close();
    }

    private Object getColumnInType(int n2, ad ad2) {
        this.checkGetParameterIndex(n2);
        ad ad3 = this.parameterTypes[--n2];
        Object object = this.parameterValues[n2];
        if (this.trackNull(object)) {
            return null;
        }
        if (ad3.typeCode != ad2.typeCode) {
            try {
                object = ad2.convertToTypeJDBC(this.session, object, ad3);
            }
            catch (aa aa2) {
                String string = object instanceof Number || object instanceof String || object instanceof java.util.Date ? object.toString() : "instance of " + object.getClass().getName();
                String string2 = "from SQL type " + ad3.getNameString() + " to " + ad2.getJDBCClassName() + ", value: " + string;
                aa aa3 = a.error(5561, string2);
                throw JDBCUtil.sqlException(aa3, aa2);
            }
        }
        return object;
    }

    private boolean trackNull(Object object) {
        this.wasNullValue = object == null;
        return this.wasNullValue;
    }

    @Override
    public void closeOnCompletion() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isCloseOnCompletion() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized ResultSet executeQuery() {
        this.fetchResult();
        ResultSet resultSet = this.getResultSet();
        if (resultSet != null) {
            return resultSet;
        }
        if (this.getMoreResults()) {
            return this.getResultSet();
        }
        throw JDBCUtil.sqlException(1254);
    }
}

