/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hsqldb.jdbc.JDBCBlob;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.lib.ab;
import org.hsqldb.lib.aj;
import org.hsqldb.lib.k;
import org.hsqldb.lib.p;

public class JDBCBlobFile
implements Blob {
    public static final String TEMP_FILE_PREFIX = "hsql_jdbc_blob_file_";
    public static final String TEMP_FILE_SUFFIX = ".tmp";
    private final File m_file;
    private boolean m_closed;
    private boolean m_deleteOnFree;
    private List m_streams = new ArrayList();

    @Override
    public long length() {
        this.checkClosed();
        try {
            return this.m_file.length();
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
    }

    @Override
    public byte[] getBytes(long l2, int n2) {
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        int n3 = Math.min(8192, n2);
        try {
            inputStream = this.getBinaryStream(l2, n2);
            byteArrayOutputStream = new ByteArrayOutputStream(n3);
            ab.copy(inputStream, byteArrayOutputStream, (long)n2);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public InputStream getBinaryStream() {
        return this.getBinaryStream(1L, Long.MAX_VALUE);
    }

    @Override
    public long position(byte[] byArray, long l2) {
        if (l2 < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + l2);
        }
        if (byArray == null || byArray.length == 0 || l2 > this.length()) {
            return -1L;
        }
        InputStream inputStream = null;
        try {
            inputStream = this.getBinaryStream(l2, Long.MAX_VALUE);
            long l3 = aj.search(inputStream, byArray, aj.computeTable(byArray));
            long l4 = l3 == -1L ? -1L : l2 + l3;
            return l4;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public long position(Blob blob, long l2) {
        if (l2 < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + l2);
        }
        long l3 = blob == null ? 0L : blob.length();
        if (l3 == 0L || l2 > this.length()) {
            return -1L;
        }
        if (l3 > Integer.MAX_VALUE) {
            throw JDBCUtil.outOfRangeArgument("pattern.length(): " + l3);
        }
        byte[] byArray = blob instanceof JDBCBlob ? ((JDBCBlob)blob).data() : blob.getBytes(1L, (int)l3);
        return this.position(byArray, l2);
    }

    @Override
    public int setBytes(long l2, byte[] byArray) {
        return this.setBytes(l2, byArray, 0, byArray == null ? 0 : byArray.length);
    }

    @Override
    public int setBytes(long l2, byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw JDBCUtil.nullArgument("bytes");
        }
        OutputStream outputStream = this.setBinaryStream(l2);
        try {
            outputStream.write(byArray, n2, n3);
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
        return n3;
    }

    @Override
    public OutputStream setBinaryStream(long l2) {
        OutputStreamAdapter outputStreamAdapter;
        if (l2 < 1L) {
            throw JDBCUtil.invalidArgument("pos: " + l2);
        }
        this.checkClosed();
        this.createFile();
        try {
            outputStreamAdapter = new OutputStreamAdapter(this.m_file, l2 - 1L){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCBlobFile.this.m_streams.remove(this);
                    }
                }
            };
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        this.m_streams.add(outputStreamAdapter);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStreamAdapter);
        return bufferedOutputStream;
    }

    @Override
    public void truncate(long l2) {
        if (l2 < 0L) {
            throw JDBCUtil.invalidArgument("len: " + l2);
        }
        this.checkClosed();
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(this.m_file, "rw");
            randomAccessFile.setLength(l2);
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public synchronized void free() {
        if (this.m_closed) {
            return;
        }
        this.m_closed = true;
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.m_streams);
        this.m_streams = null;
        for (Object e2 : arrayList) {
            if (e2 instanceof InputStream) {
                try {
                    ((InputStream)e2).close();
                }
                catch (Exception exception) {}
                continue;
            }
            if (!(e2 instanceof OutputStream)) continue;
            try {
                ((OutputStream)e2).close();
            }
            catch (Exception exception) {}
        }
        if (this.m_deleteOnFree) {
            try {
                this.m_file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public InputStream getBinaryStream(long l2, long l3) {
        InputStreamAdapter inputStreamAdapter;
        if (l2 < 1L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l2);
        }
        this.checkClosed();
        try {
            inputStreamAdapter = new InputStreamAdapter(this.m_file, l2 - 1L, l3){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCBlobFile.this.m_streams.remove(this);
                    }
                }
            };
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        this.m_streams.add(inputStreamAdapter);
        return inputStreamAdapter;
    }

    public File getFile() {
        return this.m_file;
    }

    public boolean isDeleteOnFree() {
        return this.m_deleteOnFree;
    }

    public void setDeleteOnFree(boolean bl2) {
        this.m_deleteOnFree = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        try {
            super.finalize();
        }
        finally {
            this.free();
        }
    }

    public JDBCBlobFile() {
        this(true);
    }

    public JDBCBlobFile(boolean bl2) {
        this.m_deleteOnFree = bl2;
        try {
            this.m_file = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX).getCanonicalFile();
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
    }

    public JDBCBlobFile(File file) {
        this(file, false);
    }

    public JDBCBlobFile(File file, boolean bl2) {
        this.m_deleteOnFree = bl2;
        try {
            this.m_file = file.getCanonicalFile();
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        this.checkIsFile(false);
    }

    protected final void checkIsFile(boolean bl2) {
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            bl3 = this.m_file.exists();
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        if (bl3) {
            try {
                bl4 = this.m_file.isFile();
            }
            catch (Exception exception) {
                throw JDBCUtil.sqlException(exception);
            }
        }
        if (bl3) {
            if (!bl4) {
                throw JDBCUtil.invalidArgument("Is not a file: " + this.m_file);
            }
        } else if (bl2) {
            throw JDBCUtil.invalidArgument("Does not exist: " + this.m_file);
        }
    }

    private void checkClosed() {
        if (this.m_closed) {
            throw JDBCUtil.sqlException(1251);
        }
    }

    private void createFile() {
        try {
            if (!this.m_file.exists()) {
                p.getFileUtil().makeParentDirectories(this.m_file);
                this.m_file.createNewFile();
            }
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        this.checkIsFile(true);
    }

    static class InputStreamAdapter
    extends InputStream {
        private final k m_countdownInputStream;

        InputStreamAdapter(File file, long l2, long l3) {
            if (file == null) {
                throw new NullPointerException("file");
            }
            if (l2 < 0L) {
                throw new IllegalArgumentException("pos: " + l2);
            }
            if (l3 < 0L) {
                throw new IllegalArgumentException("length: " + l3);
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            if (l2 > 0L) {
                long l4 = fileInputStream.skip(l2);
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            k k2 = new k(bufferedInputStream);
            k2.setCount(l3);
            this.m_countdownInputStream = k2;
        }

        @Override
        public int available() {
            return this.m_countdownInputStream.available();
        }

        @Override
        public int read() {
            return this.m_countdownInputStream.read();
        }

        @Override
        public int read(byte[] byArray) {
            return this.m_countdownInputStream.read(byArray);
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) {
            return this.m_countdownInputStream.read(byArray, n2, n3);
        }

        @Override
        public long skip(long l2) {
            return this.m_countdownInputStream.skip(l2);
        }

        @Override
        public void close() {
            this.m_countdownInputStream.close();
        }
    }

    protected static class OutputStreamAdapter
    extends OutputStream {
        private final RandomAccessFile m_randomAccessFile;

        public OutputStreamAdapter(File file, long l2) {
            if (l2 < 0L) {
                throw new IllegalArgumentException("pos: " + l2);
            }
            this.m_randomAccessFile = new RandomAccessFile(file, "rw");
            this.m_randomAccessFile.seek(l2);
        }

        @Override
        public void write(int n2) {
            this.m_randomAccessFile.write(n2);
        }

        @Override
        public void write(byte[] byArray) {
            this.m_randomAccessFile.write(byArray);
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) {
            this.m_randomAccessFile.write(byArray, n2, n3);
        }

        @Override
        public void flush() {
            this.m_randomAccessFile.getFD().sync();
        }

        @Override
        public void close() {
            this.m_randomAccessFile.close();
        }
    }
}

