/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import org.hsqldb.aa;
import org.hsqldb.bj;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.k.f;
import org.hsqldb.k.g;

public class JDBCBlobClient
implements Blob {
    f originalBlob;
    f blob;
    bj session;
    int colIndex;
    private boolean isClosed;
    private boolean isWritable;
    JDBCResultSet resultSet;

    @Override
    public synchronized long length() {
        try {
            return this.blob.length(this.session);
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized byte[] getBytes(long l2, int n2) {
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, l2 - 1L, n2)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        try {
            return this.blob.getBytes(this.session, l2 - 1L, n2);
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized InputStream getBinaryStream() {
        return new g(this.session, this.blob, 0L, this.length());
    }

    @Override
    public synchronized long position(byte[] byArray, long l2) {
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, l2 - 1L, 0L)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        try {
            long l3 = this.blob.position(this.session, byArray, l2 - 1L);
            if (l3 >= 0L) {
                ++l3;
            }
            return l3;
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized long position(Blob blob, long l2) {
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, l2 - 1L, 0L)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (blob instanceof JDBCBlobClient) {
            f f2 = ((JDBCBlobClient)blob).blob;
            try {
                long l3 = this.blob.position(this.session, f2, l2 - 1L);
                if (l3 >= 0L) {
                    ++l3;
                }
                return l3;
            }
            catch (aa aa2) {
                throw JDBCUtil.sqlException(aa2);
            }
        }
        if (!JDBCBlobClient.isInLimits(Integer.MAX_VALUE, 0L, blob.length())) {
            throw JDBCUtil.outOfRangeArgument();
        }
        byte[] byArray = blob.getBytes(1L, (int)blob.length());
        return this.position(byArray, l2);
    }

    @Override
    public synchronized int setBytes(long l2, byte[] byArray) {
        return this.setBytes(l2, byArray, 0, byArray.length);
    }

    @Override
    public synchronized int setBytes(long l2, byte[] byArray, int n2, int n3) {
        if (!JDBCBlobClient.isInLimits(byArray.length, n2, n3)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, l2 - 1L, n3)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (!this.isWritable) {
            throw JDBCUtil.notUpdatableColumn();
        }
        this.startUpdate();
        try {
            this.blob.setBytes(this.session, l2 - 1L, byArray, n2, n3);
            return n3;
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized OutputStream setBinaryStream(long l2) {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized void truncate(long l2) {
        try {
            this.blob.truncate(this.session, l2);
        }
        catch (aa aa2) {
            throw JDBCUtil.sqlException(aa2);
        }
    }

    @Override
    public synchronized void free() {
        this.isClosed = true;
    }

    @Override
    public synchronized InputStream getBinaryStream(long l2, long l3) {
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, l2 - 1L, l3)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        return new g(this.session, this.blob, l2 - 1L, l3);
    }

    public JDBCBlobClient(bj bj2, f f2) {
        this.session = bj2;
        this.blob = f2;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public f getBlob() {
        return this.blob;
    }

    public synchronized void setWritable(JDBCResultSet jDBCResultSet, int n2) {
        this.isWritable = true;
        this.resultSet = jDBCResultSet;
        this.colIndex = n2;
    }

    public synchronized void clearUpdates() {
        if (this.originalBlob != null) {
            this.blob = this.originalBlob;
            this.originalBlob = null;
        }
    }

    private void startUpdate() {
        if (this.originalBlob != null) {
            return;
        }
        this.originalBlob = this.blob;
        this.blob = (f)this.blob.duplicate(this.session);
        this.resultSet.startUpdate(this.colIndex + 1);
        this.resultSet.preparedStatement.parameterValues[this.colIndex] = this.blob;
        this.resultSet.preparedStatement.parameterSet[this.colIndex] = Boolean.TRUE;
    }

    private void checkClosed() {
        if (this.isClosed) {
            throw JDBCUtil.sqlException(1251);
        }
    }

    static boolean isInLimits(long l2, long l3, long l4) {
        return l3 >= 0L && l4 >= 0L && l3 + l4 <= l2;
    }
}

