/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.Array;
import java.sql.ResultSet;
import java.util.Map;
import org.hsqldb.c;
import org.hsqldb.d.d;
import org.hsqldb.g.a;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.k.ad;

public class JDBCArrayBasic
implements Array {
    ad arrayType;
    ad elementType;
    Object[] data;

    @Override
    public String getBaseTypeName() {
        this.checkClosed();
        return this.elementType.getNameString();
    }

    @Override
    public int getBaseType() {
        this.checkClosed();
        return this.elementType.getJDBCTypeCode();
    }

    @Override
    public Object getArray() {
        return this.data;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) {
        return this.getArray();
    }

    @Override
    public Object getArray(long l2, int n2) {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(this.data.length, l2 - 1L, n2)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        Object[] objectArray = new Object[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = this.data[(int)l2 + i2 - 1];
        }
        return objectArray;
    }

    @Override
    public Object getArray(long l2, int n2, Map<String, Class<?>> map) {
        return this.getArray(l2, n2);
    }

    @Override
    public ResultSet getResultSet() {
        this.checkClosed();
        a a2 = this.newColumnResult(0L, this.data.length);
        return JDBCResultSet.newJDBCResultSet(a2, a2.metaData);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) {
        return this.getResultSet();
    }

    @Override
    public ResultSet getResultSet(long l2, int n2) {
        this.checkClosed();
        a a2 = this.newColumnResult(l2 - 1L, n2);
        return new JDBCResultSet(null, a2, a2.metaData);
    }

    @Override
    public ResultSet getResultSet(long l2, int n2, Map<String, Class<?>> map) {
        return this.getResultSet(l2, n2);
    }

    public String toString() {
        if (this.arrayType == null) {
            this.arrayType = ad.getDefaultArrayType(this.elementType.typeCode);
        }
        return this.arrayType.convertToString(this.data);
    }

    @Override
    public void free() {
    }

    public JDBCArrayBasic(Object[] objectArray, ad ad2) {
        this.data = objectArray;
        this.elementType = ad2;
    }

    Object[] getArrayInternal() {
        return this.data;
    }

    private a newColumnResult(long l2, int n2) {
        if (!JDBCClobClient.isInLimits(this.data.length, l2, n2)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        ad[] adArray = new ad[]{ad.SQL_INTEGER, this.elementType};
        org.hsqldb.g.c c2 = org.hsqldb.g.c.newSimpleResultMetaData(adArray);
        c2.columnLabels = new String[]{"C1", "C2"};
        c2.colIndexes = new int[]{-1, -1};
        c2.columns = new c[2];
        for (int i2 = 0; i2 < c2.columns.length; ++i2) {
            c c3 = new c("", "", "", "");
            c3.setType(adArray[i2]);
            c2.columns[i2] = c3;
        }
        d d2 = new d();
        int n3 = (int)l2;
        while ((long)n3 < l2 + (long)n2) {
            Object[] objectArray = new Object[]{n3 + 1, this.data[n3]};
            d2.add(objectArray);
            ++n3;
        }
        a a2 = a.newDataResult(c2);
        a2.setNavigator(d2);
        return a2;
    }

    private void checkClosed() {
    }
}

