/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.Array;
import java.sql.ResultSet;
import java.util.Map;
import org.hsqldb.bj;
import org.hsqldb.c;
import org.hsqldb.d.d;
import org.hsqldb.g.a;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.k.ad;

public class JDBCArray
implements Array {
    volatile boolean closed;
    ad arrayType;
    ad elementType;
    Object[] data;
    JDBCConnection connection;
    bj sessionProxy;

    @Override
    public String getBaseTypeName() {
        this.checkClosed();
        return this.elementType.getNameString();
    }

    @Override
    public int getBaseType() {
        this.checkClosed();
        return this.elementType.getJDBCTypeCode();
    }

    @Override
    public Object getArray() {
        this.checkClosed();
        Object[] objectArray = new Object[this.data.length];
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            objectArray[i2] = this.elementType.convertSQLToJava(this.sessionProxy, this.data[i2]);
        }
        return objectArray;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) {
        return this.getArray();
    }

    @Override
    public Object getArray(long l2, int n2) {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(this.data.length, l2 - 1L, n2)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        Object[] objectArray = new Object[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = this.elementType.convertSQLToJava(this.sessionProxy, this.data[(int)l2 + i2 - 1]);
        }
        return objectArray;
    }

    @Override
    public Object getArray(long l2, int n2, Map<String, Class<?>> map) {
        return this.getArray(l2, n2);
    }

    @Override
    public ResultSet getResultSet() {
        this.checkClosed();
        a a2 = this.newColumnResult(0L, this.data.length);
        return new JDBCResultSet(this.connection, a2, a2.metaData);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) {
        return this.getResultSet();
    }

    @Override
    public ResultSet getResultSet(long l2, int n2) {
        this.checkClosed();
        a a2 = this.newColumnResult(l2 - 1L, n2);
        return new JDBCResultSet(this.connection, a2, a2.metaData);
    }

    @Override
    public ResultSet getResultSet(long l2, int n2, Map<String, Class<?>> map) {
        return this.getResultSet(l2, n2);
    }

    public String toString() {
        if (this.arrayType == null) {
            this.arrayType = ad.getDefaultArrayType(this.elementType.typeCode);
        }
        return this.arrayType.convertToString(this.data);
    }

    @Override
    public void free() {
        if (!this.closed) {
            this.closed = true;
            this.connection = null;
            this.sessionProxy = null;
        }
    }

    public JDBCArray(Object[] objectArray, ad ad2, ad ad3, bj bj2) {
        this(objectArray, ad2, ad3, bj2.getJDBCConnection());
        this.sessionProxy = bj2;
    }

    JDBCArray(Object[] objectArray, ad ad2, JDBCConnection jDBCConnection) {
        this(objectArray, ad2, null, jDBCConnection);
    }

    JDBCArray(Object[] objectArray, ad ad2, ad ad3, JDBCConnection jDBCConnection) {
        this.data = objectArray;
        this.elementType = ad2;
        this.arrayType = ad3;
        this.connection = jDBCConnection;
        if (jDBCConnection != null) {
            this.sessionProxy = jDBCConnection.sessionProxy;
        }
    }

    public Object[] getArrayInternal() {
        return this.data;
    }

    private a newColumnResult(long l2, int n2) {
        if (!JDBCClobClient.isInLimits(this.data.length, l2, n2)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        ad[] adArray = new ad[]{ad.SQL_INTEGER, this.elementType};
        org.hsqldb.g.c c2 = org.hsqldb.g.c.newSimpleResultMetaData(adArray);
        c2.columnLabels = new String[]{"C1", "C2"};
        c2.colIndexes = new int[]{-1, -1};
        c2.columns = new c[2];
        c c3 = new c("", "", "", "");
        c3.setType(adArray[0]);
        c2.columns[0] = c3;
        c3 = new c("", "", "", "");
        c3.setType(adArray[1]);
        c2.columns[1] = c3;
        d d2 = new d();
        int n3 = (int)l2;
        while ((long)n3 < l2 + (long)n2) {
            Object[] objectArray = new Object[]{n3 + 1, this.data[n3]};
            d2.add(objectArray);
            ++n3;
        }
        a a2 = a.newDataResult(c2);
        a2.setNavigator(d2);
        return a2;
    }

    private void checkClosed() {
        if (this.closed) {
            throw JDBCUtil.sqlException(1251);
        }
    }
}

