/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.e;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.hsqldb.lib.aa;
import org.hsqldb.lib.bh;
import org.hsqldb.lib.p;
import org.hsqldb.z;

public class w {
    public static final long HEARTBEAT_INTERVAL = 10000L;
    public static final long HEARTBEAT_INTERVAL_PADDED = 10100L;
    protected static final byte[] MAGIC = new byte[]{72, 83, 81, 76, 76, 79, 67, 75};
    public static final int USED_REGION = 16;
    public static final int POLL_RETRIES_DEFAULT = 10;
    public static final String POLL_RETRIES_PROPERTY = "hsqldb.lockfile.poll.retries";
    public static final String POLL_INTERVAL_PROPERTY = "hsqldb.lockfile.poll.interval";
    public static final boolean USE_NIO_FILELOCK_DEFAULT = false;
    public static final String USE_NIO_FILELOCK_PROPERTY = "hsqldb.lockfile.nio.filelock";
    public static final boolean NIO_FILELOCK_AVAILABLE;
    public static final Class NIO_LOCKFILE_CLASS;
    protected static final aa timer;
    protected File file;
    private String aSb;
    protected volatile RandomAccessFile raf;
    protected volatile boolean locked;
    private volatile Object aAb;

    private static final w mC() {
        if (NIO_FILELOCK_AVAILABLE && NIO_LOCKFILE_CLASS != null) {
            try {
                return (w)NIO_LOCKFILE_CLASS.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected w() {
    }

    public static final w newLockFile(String string) {
        w w2 = w.mC();
        if (w2 == null) {
            w2 = new w();
        }
        w2.setPath(string);
        return w2;
    }

    public static final w newLockFileLock(String string) {
        w w2 = null;
        try {
            w2 = w.newLockFile(string + ".lck");
        }
        catch (a a2) {
            throw org.hsqldb.a.a.error(451, a2.getMessage());
        }
        boolean bl2 = false;
        try {
            bl2 = w2.tryLock();
        }
        catch (a a3) {
            throw org.hsqldb.a.a.error(451, a3.getMessage());
        }
        if (!bl2) {
            throw org.hsqldb.a.a.error(451, w2.toString());
        }
        return w2;
    }

    private final void aa(boolean bl2) {
        long l2;
        long l3 = 0L;
        try {
            if (bl2) {
                try {
                    if (this.file.createNewFile()) {
                        return;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!this.file.exists()) {
                return;
            }
            l3 = this.file.length();
        }
        catch (SecurityException securityException) {
            throw new c(this, "checkHeartbeat", securityException);
        }
        if (l3 != 16L) {
            if (l3 == 0L) {
                this.file.delete();
                return;
            }
            throw new i(this, "checkHeartbeat", l3);
        }
        long l4 = System.currentTimeMillis();
        if (Math.abs(l4 - (l2 = this.mF())) <= 10100L) {
            throw new e(this, "checkHeartbeat", l4, l2);
        }
    }

    private final void mD() {
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {
                throw new g(this, "closeRAF", iOException);
            }
            finally {
                this.raf = null;
            }
        }
    }

    protected boolean doOptionalLockActions() {
        return false;
    }

    protected boolean doOptionalReleaseActions() {
        return false;
    }

    private final void setPath(String string) {
        string = p.getFileUtil().canonicalOrAbsolutePath(string);
        this.file = new File(string);
        try {
            p.getFileUtil().makeParentDirectories(this.file);
        }
        catch (SecurityException securityException) {
            throw new c(this, "setPath", securityException);
        }
        try {
            this.file = p.getFileUtil().canonicalFile(string);
        }
        catch (SecurityException securityException) {
            throw new c(this, "setPath", securityException);
        }
        catch (IOException iOException) {
            throw new b(this, "setPath", iOException);
        }
        this.aSb = this.file.getPath();
    }

    private final void mE() {
        try {
            this.raf = new RandomAccessFile(this.file, "rw");
        }
        catch (SecurityException securityException) {
            throw new c(this, "openRAF", securityException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new h(this, "openRAF", fileNotFoundException);
        }
    }

    private final void a(DataInputStream dataInputStream) {
        boolean bl2 = true;
        byte[] byArray = new byte[MAGIC.length];
        try {
            for (int i2 = 0; i2 < MAGIC.length; ++i2) {
                byArray[i2] = dataInputStream.readByte();
                if (MAGIC[i2] == byArray[i2]) continue;
                bl2 = false;
            }
        }
        catch (SecurityException securityException) {
            throw new c(this, "checkMagic", securityException);
        }
        catch (EOFException eOFException) {
            throw new f(this, "checkMagic", eOFException);
        }
        catch (IOException iOException) {
            throw new g(this, "checkMagic", iOException);
        }
        if (!bl2) {
            throw new j(this, "checkMagic", byArray);
        }
    }

    private final long mF() {
        long l2;
        FileInputStream fileInputStream = null;
        DataInputStream dataInputStream = null;
        try {
            if (!this.file.exists()) {
                long l3 = Long.MIN_VALUE;
                return l3;
            }
            fileInputStream = new FileInputStream(this.file);
            dataInputStream = new DataInputStream(fileInputStream);
            this.a(dataInputStream);
            l2 = dataInputStream.readLong();
        }
        catch (SecurityException securityException) {
            throw new c(this, "readHeartbeat", securityException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new h(this, "readHeartbeat", fileNotFoundException);
        }
        catch (EOFException eOFException) {
            throw new f(this, "readHeartbeat", eOFException);
        }
        catch (IOException iOException) {
            throw new g(this, "readHeartbeat", iOException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return l2;
    }

    private final void mG() {
        if (this.aAb == null || aa.isCancelled(this.aAb)) {
            d d2 = new d();
            this.aAb = timer.schedulePeriodicallyAfter(0L, 10000L, d2, true);
        }
    }

    private final void mH() {
        if (this.aAb != null && !aa.isCancelled(this.aAb)) {
            aa.cancel(this.aAb);
            this.aAb = null;
        }
    }

    private final void mI() {
        try {
            this.raf.seek(0L);
            this.raf.write(MAGIC);
        }
        catch (SecurityException securityException) {
            throw new c(this, "writeMagic", securityException);
        }
        catch (EOFException eOFException) {
            throw new f(this, "writeMagic", eOFException);
        }
        catch (IOException iOException) {
            throw new g(this, "writeMagic", iOException);
        }
    }

    private final void mJ() {
        try {
            this.raf.seek(MAGIC.length);
            this.raf.writeLong(System.currentTimeMillis());
        }
        catch (SecurityException securityException) {
            throw new c(this, "writeHeartbeat", securityException);
        }
        catch (EOFException eOFException) {
            throw new f(this, "writeHeartbeat", eOFException);
        }
        catch (IOException iOException) {
            throw new g(this, "writeHeartbeat", iOException);
        }
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof w) {
            w w2 = (w)object;
            return this.file == null ? w2.file == null : this.file.equals(w2.file);
        }
        return false;
    }

    public final String getCanonicalPath() {
        return this.aSb;
    }

    public final int hashCode() {
        return this.file == null ? 0 : this.file.hashCode();
    }

    public final boolean isLocked() {
        return this.locked;
    }

    public static final boolean isLocked(String string) {
        boolean bl2 = true;
        try {
            w w2 = w.newLockFile(string);
            w2.aa(false);
            bl2 = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl2;
    }

    public boolean isValid() {
        return this.isLocked() && this.file != null && this.file.exists() && this.raf != null;
    }

    public String toString() {
        return new StringBuffer(super.toString()).append("[file =").append(this.aSb).append(", exists=").append(this.file.exists()).append(", locked=").append(this.isLocked()).append(", valid=").append(this.isValid()).append(", ").append(this.toStringImpl()).append("]").toString();
    }

    protected String toStringImpl() {
        return "";
    }

    public int getPollHeartbeatRetries() {
        int n2 = 10;
        try {
            n2 = Integer.getInteger("hsqldb.lockfile_poll_retries", n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n2 < 1) {
            n2 = 1;
        }
        return n2;
    }

    public long getPollHeartbeatInterval() {
        int n2 = this.getPollHeartbeatRetries();
        long l2 = 10L + 10100L / (long)n2;
        try {
            l2 = Long.getLong(POLL_INTERVAL_PROPERTY, l2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (l2 <= 0L) {
            l2 = 10L + 10100L / (long)n2;
        }
        return l2;
    }

    private final void mK() {
        boolean bl2 = false;
        int n2 = this.getPollHeartbeatRetries();
        long l2 = this.getPollHeartbeatInterval();
        a a2 = null;
        for (int i2 = n2; i2 > 0; --i2) {
            try {
                this.aa(true);
                bl2 = true;
                break;
            }
            catch (a a3) {
                a2 = a3;
                try {
                    Thread.sleep(l2);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
        if (!bl2) {
            if (a2 instanceof c) {
                throw (c)a2;
            }
            if (a2 instanceof e) {
                throw (e)a2;
            }
            if (a2 instanceof h) {
                throw (h)a2;
            }
            if (a2 instanceof f) {
                throw (f)a2;
            }
            if (a2 instanceof g) {
                throw (g)a2;
            }
            if (a2 instanceof i) {
                throw (i)a2;
            }
            if (a2 instanceof j) {
                throw (j)a2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean tryLock() {
        if (this.locked) {
            return true;
        }
        try {
            this.mK();
            this.mE();
            this.doOptionalLockActions();
            this.mI();
            this.mJ();
            p.getFileUtil().deleteOnExit(this.file);
            this.locked = true;
            this.mG();
        }
        finally {
            if (!this.locked) {
                this.doOptionalReleaseActions();
                try {
                    this.mD();
                }
                catch (Exception exception) {}
            }
        }
        return this.locked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean tryRelease() {
        boolean bl2;
        boolean bl3 = bl2 = !this.locked;
        if (bl2) {
            return true;
        }
        this.mH();
        this.doOptionalReleaseActions();
        g g2 = null;
        c c2 = null;
        try {
            try {
                this.mD();
            }
            catch (g g3) {
                g2 = g3;
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                bl2 = this.file.delete();
            }
            catch (SecurityException securityException) {
                c2 = new c(this, "tryRelease", securityException);
            }
        }
        finally {
            this.locked = false;
        }
        if (g2 != null) {
            throw g2;
        }
        if (c2 != null) {
            throw c2;
        }
        return bl2;
    }

    protected final void finalize() {
        this.tryRelease();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        timer = org.hsqldb.h.getTimer();
        Class<w> clazz = w.class;
        synchronized (w.class) {
            boolean bl2 = false;
            try {
                bl2 = "true".equalsIgnoreCase(System.getProperty(USE_NIO_FILELOCK_PROPERTY, bl2 ? "true" : "false"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl3 = false;
            Class<?> clazz2 = null;
            if (bl2) {
                try {
                    Class.forName("java.nio.channels.FileLock");
                    clazz2 = Class.forName("org.hsqldb.persist.NIOLockFile");
                    bl3 = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            NIO_FILELOCK_AVAILABLE = bl3;
            NIO_LOCKFILE_CLASS = clazz2;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static final class j
    extends a {
        private final byte[] aSl;

        public j(w w2, String string, byte[] byArray) {
            super(w2, string);
            this.aSl = byArray;
        }

        @Override
        public String getMessage() {
            String string = super.getMessage() + " magic: ";
            string = string + (this.aSl == null ? "null" : "'" + bh.byteArrayToHexString(this.aSl) + "'");
            return string;
        }

        public byte[] getMagic() {
            return this.aSl == null ? null : (byte[])this.aSl.clone();
        }
    }

    public static final class i
    extends a {
        private final long length;

        public i(w w2, String string, long l2) {
            super(w2, string);
            this.length = l2;
        }

        public long getLength() {
            return this.length;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + " length: " + this.length;
        }
    }

    public static final class h
    extends a {
        private final FileNotFoundException aSk;

        public h(w w2, String string, FileNotFoundException fileNotFoundException) {
            super(w2, string);
            this.aSk = fileNotFoundException;
        }

        public FileNotFoundException getReason() {
            return this.aSk;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + " reason: " + this.aSk;
        }
    }

    public static final class g
    extends a {
        private final IOException aSe;

        public g(w w2, String string, IOException iOException) {
            super(w2, string);
            this.aSe = iOException;
        }

        public IOException getReason() {
            return this.aSe;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + " reason: " + this.aSe;
        }
    }

    public static final class f
    extends a {
        private final EOFException aSj;

        public f(w w2, String string, EOFException eOFException) {
            super(w2, string);
            this.aSj = eOFException;
        }

        public EOFException getReason() {
            return this.aSj;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + " reason: " + this.aSj;
        }
    }

    public static final class e
    extends a {
        private final long aSh;
        private final long aSi;

        public e(w w2, String string, long l2, long l3) {
            super(w2, string);
            this.aSh = l2;
            this.aSi = l3;
        }

        public long getHeartbeat() {
            return this.aSi;
        }

        public long getRead() {
            return this.aSh;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + " read: " + z.getTimestampString(this.aSh) + " heartbeat - read: " + (this.aSi - this.aSh) + " ms.";
        }
    }

    public static final class c
    extends a {
        private final SecurityException aSf;

        public c(w w2, String string, SecurityException securityException) {
            super(w2, string);
            this.aSf = securityException;
        }

        public SecurityException getReason() {
            return this.aSf;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + " reason: " + this.aSf;
        }
    }

    public static final class b
    extends a {
        private final IOException aSe;

        public b(w w2, String string, IOException iOException) {
            super(w2, string);
            this.aSe = iOException;
        }

        public IOException getReason() {
            return this.aSe;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + " reason: " + this.aSe;
        }
    }

    public static abstract class a
    extends Exception {
        private final w aSc;
        private final String aSd;

        public a(w w2, String string) {
            if (w2 == null) {
                throw new NullPointerException("lockFile");
            }
            if (string == null) {
                throw new NullPointerException("inMethod");
            }
            this.aSc = w2;
            this.aSd = string;
        }

        @Override
        public String getMessage() {
            return "lockFile: " + this.aSc + " method: " + this.aSd;
        }

        public String getInMethod() {
            return this.aSd;
        }

        public w getLockFile() {
            return this.aSc;
        }
    }

    private final class d
    implements Runnable {
        private d() {
        }

        @Override
        public void run() {
            try {
                w.this.mJ();
            }
            catch (Throwable throwable) {
                org.hsqldb.a.a.printSystemOut(throwable.toString());
            }
        }
    }
}

