/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.e;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.hsqldb.a.a;
import org.hsqldb.c.d;
import org.hsqldb.lib.n;
import org.hsqldb.lib.r;

public class p {
    public static final int ANY_ERROR = 0;
    public static final int NO_VALUE_FOR_KEY = 1;
    protected String fileName;
    protected String fileExtension = "";
    protected Properties stringProps;
    protected int[] errorCodes = d.emptyIntArray;
    protected String[] errorKeys = d.emptyStringArray;
    protected boolean resource = false;
    protected n fa;
    protected r metaData;
    public static final int indexName = 0;
    public static final int indexType = 1;
    public static final int indexClass = 2;
    public static final int indexIsRange = 3;
    public static final int indexDefaultValue = 4;
    public static final int indexRangeLow = 5;
    public static final int indexRangeHigh = 6;
    public static final int indexValues = 7;
    public static final int indexLimit = 9;

    public p() {
        this.stringProps = new Properties();
        this.fileName = null;
    }

    public p(String string) {
        this(string, ".properties");
    }

    public p(String string, String string2) {
        this.stringProps = new Properties();
        this.fileName = string;
        this.fileExtension = string2;
        this.fa = org.hsqldb.lib.p.getFileUtil();
    }

    public p(r r2, String string, n n2, boolean bl2) {
        this.stringProps = new Properties();
        this.fileName = string;
        this.fileExtension = ".properties";
        this.fa = n2;
        this.metaData = r2;
    }

    public p(Properties properties) {
        this.stringProps = properties;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String setProperty(String string, int n2) {
        return this.setProperty(string, Integer.toString(n2));
    }

    public String setProperty(String string, boolean bl2) {
        return this.setProperty(string, String.valueOf(bl2));
    }

    public String setProperty(String string, String string2) {
        return (String)this.stringProps.put(string, string2);
    }

    public String setPropertyIfNotExists(String string, String string2) {
        string2 = this.getProperty(string, string2);
        return this.setProperty(string, string2);
    }

    public Properties getProperties() {
        return this.stringProps;
    }

    public String getProperty(String string) {
        return this.stringProps.getProperty(string);
    }

    public String getProperty(String string, String string2) {
        return this.stringProps.getProperty(string, string2);
    }

    public int getIntegerProperty(String string, int n2) {
        return p.getIntegerProperty(this.stringProps, string, n2);
    }

    public static int getIntegerProperty(Properties properties, String string, int n2) {
        String string2 = properties.getProperty(string);
        try {
            if (string2 != null) {
                string2 = string2.trim();
                n2 = Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    public boolean isPropertyTrue(String string) {
        return this.isPropertyTrue(string, false);
    }

    public boolean isPropertyTrue(String string, boolean bl2) {
        String string2 = this.stringProps.getProperty(string);
        if (string2 == null) {
            return bl2;
        }
        string2 = string2.trim();
        return string2.toLowerCase().equals("true");
    }

    public void removeProperty(String string) {
        this.stringProps.remove(string);
    }

    public void addProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            this.stringProps.put(string, string2);
        }
    }

    public void addProperties(p p2) {
        if (p2 == null) {
            return;
        }
        this.addProperties(p2.stringProps);
    }

    public boolean propertiesFileExists() {
        if (this.fileName == null) {
            return false;
        }
        String string = this.fileName + this.fileExtension;
        return this.fa.isStreamElement(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load() {
        if (this.fileName == null || this.fileName.length() == 0) {
            throw new FileNotFoundException(a.getMessage(28));
        }
        if (!this.propertiesFileExists()) {
            return false;
        }
        InputStream inputStream = null;
        String string = this.fileName + this.fileExtension;
        try {
            inputStream = this.fa.openInputStreamElement(string);
            this.stringProps.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return true;
    }

    public void save() {
        if (this.fileName == null || this.fileName.length() == 0) {
            throw new FileNotFoundException(a.getMessage(28));
        }
        String string = this.fileName + this.fileExtension;
        this.save(string);
    }

    public void save(String string) {
        this.fa.createParentDirs(string);
        this.fa.removeElement(string);
        OutputStream outputStream = this.fa.openOutputStreamElement(string);
        n.a a2 = this.fa.getFileSync(outputStream);
        String string2 = "HSQL Database Engine 2.3.3";
        this.stringProps.store(outputStream, string2);
        outputStream.flush();
        a2.sync();
        outputStream.close();
        a2 = null;
        outputStream = null;
    }

    protected void addError(int n2, String string) {
        this.errorCodes = (int[])org.hsqldb.lib.d.resizeArray(this.errorCodes, this.errorCodes.length + 1);
        this.errorKeys = (String[])org.hsqldb.lib.d.resizeArray(this.errorKeys, this.errorKeys.length + 1);
        this.errorCodes[this.errorCodes.length - 1] = n2;
        this.errorKeys[this.errorKeys.length - 1] = string;
    }

    public static p argArrayToProps(String[] stringArray, String string) {
        p p2 = new p();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2;
            String string3 = stringArray[i2];
            if (string3.equals("--help") || string3.equals("-help")) {
                p2.addError(1, string3.substring(1));
                continue;
            }
            if (string3.startsWith("--")) {
                string2 = i2 + 1 < stringArray.length ? stringArray[i2 + 1] : "";
                p2.setProperty(string + "." + string3.substring(2), string2);
                ++i2;
                continue;
            }
            if (string3.charAt(0) != '-') continue;
            string2 = i2 + 1 < stringArray.length ? stringArray[i2 + 1] : "";
            p2.setProperty(string + "." + string3.substring(1), string2);
            ++i2;
        }
        return p2;
    }

    public static p delimitedArgPairsToProps(String string, String string2, String string3, String string4) {
        p p2 = new p();
        int n2 = 0;
        while (true) {
            int n3;
            int n4;
            if ((n4 = string.indexOf(string3, n2)) == -1) {
                n4 = string.length();
            }
            if ((n3 = string.substring(0, n4).indexOf(string2, n2)) == -1) {
                p2.addError(1, string.substring(n2, n4).trim());
            } else {
                String string5 = string.substring(n2, n3).trim();
                String string6 = string.substring(n3 + string2.length(), n4).trim();
                if (string4 != null) {
                    string5 = string4 + "." + string5;
                }
                p2.setProperty(string5, string6);
            }
            if (n4 == string.length()) break;
            n2 = n4 + string3.length();
        }
        return p2;
    }

    public Enumeration propertyNames() {
        return this.stringProps.propertyNames();
    }

    public boolean isEmpty() {
        return this.stringProps.isEmpty();
    }

    public String[] getErrorKeys() {
        return this.errorKeys;
    }

    public void validate() {
    }

    public static Object[] getMeta(String string, int n2) {
        Object[] objectArray = new Object[9];
        objectArray[0] = string;
        objectArray[1] = d.getInt(n2);
        objectArray[2] = "Long";
        objectArray[4] = 0L;
        return objectArray;
    }

    public static Object[] getMeta(String string, int n2, String string2) {
        Object[] objectArray = new Object[9];
        objectArray[0] = string;
        objectArray[1] = d.getInt(n2);
        objectArray[2] = "String";
        objectArray[4] = string2;
        return objectArray;
    }

    public static Object[] getMeta(String string, int n2, boolean bl2) {
        Object[] objectArray = new Object[9];
        objectArray[0] = string;
        objectArray[1] = d.getInt(n2);
        objectArray[2] = "Boolean";
        objectArray[4] = bl2 ? Boolean.TRUE : Boolean.FALSE;
        return objectArray;
    }

    public static Object[] getMeta(String string, int n2, int n3, int[] nArray) {
        Object[] objectArray = new Object[9];
        objectArray[0] = string;
        objectArray[1] = d.getInt(n2);
        objectArray[2] = "Integer";
        objectArray[4] = d.getInt(n3);
        objectArray[7] = nArray;
        return objectArray;
    }

    public static Object[] getMeta(String string, int n2, int n3, int n4, int n5) {
        Object[] objectArray = new Object[9];
        objectArray[0] = string;
        objectArray[1] = d.getInt(n2);
        objectArray[2] = "Integer";
        objectArray[4] = d.getInt(n3);
        objectArray[3] = Boolean.TRUE;
        objectArray[5] = d.getInt(n4);
        objectArray[6] = d.getInt(n5);
        return objectArray;
    }

    public static String validateProperty(String string, String string2, Object[] objectArray) {
        if (objectArray[2].equals("Boolean")) {
            if ((string2 = string2.toLowerCase()).equals("true") || string2.equals("false")) {
                return null;
            }
            return "invalid boolean value for property: " + string;
        }
        if (objectArray[2].equals("String")) {
            return null;
        }
        if (objectArray[2].equals("Long")) {
            return null;
        }
        if (objectArray[2].equals("Integer")) {
            int[] nArray;
            int n2 = Integer.parseInt(string2);
            if (Boolean.TRUE.equals(objectArray[3])) {
                int n3 = (Integer)objectArray[5];
                int n4 = (Integer)objectArray[6];
                if (n2 < n3 || n4 < n2) {
                    return "value outside range for property: " + string;
                }
            }
            if (objectArray[7] != null && org.hsqldb.lib.d.find(nArray = (int[])objectArray[7], n2) == -1) {
                return "value not supported for property: " + string;
            }
            return null;
        }
        return null;
    }

    public boolean validateProperty(String string, int n2) {
        Object[] objectArray = (Object[])this.metaData.get(string);
        if (objectArray == null) {
            return false;
        }
        if (objectArray[2].equals("Integer")) {
            int[] nArray;
            if (Boolean.TRUE.equals(objectArray[3])) {
                int n3 = (Integer)objectArray[5];
                int n4 = (Integer)objectArray[6];
                if (n2 < n3 || n4 < n2) {
                    return false;
                }
            }
            return objectArray[7] == null || org.hsqldb.lib.d.find(nArray = (int[])objectArray[7], n2) != -1;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        int n2 = this.stringProps.size();
        Enumeration<?> enumeration = this.stringProps.propertyNames();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append(string);
            stringBuffer.append('=');
            stringBuffer.append(this.stringProps.get(string));
            if (i2 + 1 < n2) {
                stringBuffer.append(',');
                stringBuffer.append(' ');
            }
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }
}

