/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.e;

import java.util.Enumeration;
import org.hsqldb.a.a;
import org.hsqldb.e.p;
import org.hsqldb.g;
import org.hsqldb.i;
import org.hsqldb.lib.ai;
import org.hsqldb.lib.bd;
import org.hsqldb.lib.bj;
import org.hsqldb.lib.r;
import org.hsqldb.lib.t;

public class o
extends p {
    public static final String textdb_allow_full_path = "textdb.allow_full_path";
    private static t aRq;
    private static boolean aRr;
    public static final int SYSTEM_PROPERTY = 0;
    public static final int FILE_PROPERTY = 1;
    public static final int SQL_PROPERTY = 2;
    public static final int FILES_NOT_MODIFIED = 0;
    public static final int FILES_MODIFIED = 1;
    public static final int FILES_MODIFIED_NEW = 2;
    public static final int FILES_NEW = 3;
    private static final r aRs;
    private static final r aRt;
    public static final String VERSION_STRING_1_8_0 = "1.8.0";
    public static final String THIS_VERSION = "2.3.3";
    public static final String THIS_FULL_VERSION = "2.3.3";
    public static final String THIS_CACHE_VERSION = "2.0.0";
    public static final String PRODUCT_NAME = "HSQL Database Engine";
    public static final int MAJOR = 2;
    public static final int MINOR = 3;
    public static final int REVISION = 3;
    public static final String system_lockfile_poll_retries_property = "hsqldb.lockfile_poll_retries";
    public static final String system_max_char_or_varchar_display_size = "hsqldb.max_char_or_varchar_display_size";
    public static final String hsqldb_inc_backup = "hsqldb.inc_backup";
    public static final String hsqldb_version = "version";
    public static final String hsqldb_readonly = "readonly";
    public static final String tx_timestamp = "tx_timestamp";
    public static final String hsqldb_cache_version = "hsqldb.cache_version";
    public static final String runtime_gc_interval = "runtime.gc_interval";
    public static final String url_ifexists = "ifexists";
    public static final String url_create = "create";
    public static final String url_default_schema = "default_schema";
    public static final String url_check_props = "check_props";
    public static final String url_get_column_name = "get_column_name";
    public static final String url_close_result = "close_result";
    public static final String url_storage_class_name = "storage_class_name";
    public static final String url_fileaccess_class_name = "fileaccess_class_name";
    public static final String url_storage_key = "storage_key";
    public static final String url_shutdown = "shutdown";
    public static final String url_recover = "recover";
    public static final String url_tls_wrapper = "tls_wrapper";
    public static final String url_crypt_key = "crypt_key";
    public static final String url_crypt_type = "crypt_type";
    public static final String url_crypt_provider = "crypt_provider";
    public static final String url_crypt_lobs = "crypt_lobs";
    public static final String hsqldb_tx = "hsqldb.tx";
    public static final String hsqldb_tx_level = "hsqldb.tx_level";
    public static final String hsqldb_tx_conflict_rollback = "hsqldb.tx_conflict_rollback";
    public static final String hsqldb_applog = "hsqldb.applog";
    public static final String hsqldb_sqllog = "hsqldb.sqllog";
    public static final String hsqldb_lob_file_scale = "hsqldb.lob_file_scale";
    public static final String hsqldb_lob_file_compressed = "hsqldb.lob_compressed";
    public static final String hsqldb_cache_file_scale = "hsqldb.cache_file_scale";
    public static final String hsqldb_cache_free_count = "hsqldb.cache_free_count";
    public static final String hsqldb_cache_rows = "hsqldb.cache_rows";
    public static final String hsqldb_cache_size = "hsqldb.cache_size";
    public static final String hsqldb_default_table_type = "hsqldb.default_table_type";
    public static final String hsqldb_defrag_limit = "hsqldb.defrag_limit";
    public static final String hsqldb_files_readonly = "files_readonly";
    public static final String hsqldb_lock_file = "hsqldb.lock_file";
    public static final String hsqldb_log_data = "hsqldb.log_data";
    public static final String hsqldb_log_size = "hsqldb.log_size";
    public static final String hsqldb_nio_data_file = "hsqldb.nio_data_file";
    public static final String hsqldb_nio_max_size = "hsqldb.nio_max_size";
    public static final String hsqldb_script_format = "hsqldb.script_format";
    public static final String hsqldb_temp_directory = "hsqldb.temp_directory";
    public static final String hsqldb_result_max_memory_rows = "hsqldb.result_max_memory_rows";
    public static final String hsqldb_write_delay = "hsqldb.write_delay";
    public static final String hsqldb_write_delay_millis = "hsqldb.write_delay_millis";
    public static final String hsqldb_full_log_replay = "hsqldb.full_log_replay";
    public static final String hsqldb_large_data = "hsqldb.large_data";
    public static final String hsqldb_files_space = "hsqldb.files_space";
    public static final String hsqldb_digest = "hsqldb.digest";
    public static final String jdbc_translate_tti_types = "jdbc.translate_tti_types";
    public static final String sql_ref_integrity = "sql.ref_integrity";
    public static final String sql_compare_in_locale = "sql.compare_in_locale";
    public static final String sql_enforce_size = "sql.enforce_size";
    public static final String sql_enforce_strict_size = "sql.enforce_strict_size";
    public static final String sql_enforce_refs = "sql.enforce_refs";
    public static final String sql_enforce_names = "sql.enforce_names";
    public static final String sql_regular_names = "sql.regular_names";
    public static final String sql_enforce_types = "sql.enforce_types";
    public static final String sql_enforce_tdcd = "sql.enforce_tdc_delete";
    public static final String sql_enforce_tdcu = "sql.enforce_tdc_update";
    public static final String sql_concat_nulls = "sql.concat_nulls";
    public static final String sql_nulls_first = "sql.nulls_first";
    public static final String sql_nulls_order = "sql.nulls_order";
    public static final String sql_unique_nulls = "sql.unique_nulls";
    public static final String sql_convert_trunc = "sql.convert_trunc";
    public static final String sql_avg_scale = "sql.avg_scale";
    public static final String sql_double_nan = "sql.double_nan";
    public static final String sql_syntax_db2 = "sql.syntax_db2";
    public static final String sql_syntax_mss = "sql.syntax_mss";
    public static final String sql_syntax_mys = "sql.syntax_mys";
    public static final String sql_syntax_ora = "sql.syntax_ora";
    public static final String sql_syntax_pgs = "sql.syntax_pgs";
    public static final String sql_longvar_is_lob = "sql.longvar_is_lob";
    public static final String sql_pad_space = "sql.pad_space";
    public static final String sql_ignore_case = "sql.ignore_case";
    public static final String textdb_cache_scale = "textdb.cache_scale";
    public static final String textdb_cache_size_scale = "textdb.cache_size_scale";
    public static final String textdb_cache_rows = "textdb.cache_rows";
    public static final String textdb_cache_size = "textdb.cache_size";
    public static final String textdb_all_quoted = "textdb.all_quoted";
    public static final String textdb_encoding = "textdb.encoding";
    public static final String textdb_ignore_first = "textdb.ignore_first";
    public static final String textdb_quoted = "textdb.quoted";
    public static final String textdb_fs = "textdb.fs";
    public static final String textdb_vs = "textdb.vs";
    public static final String textdb_lvs = "textdb.lvs";
    public static final String hsqldb_min_reuse = "hsqldb.min_reuse";
    private g database;
    public static final int NO_MESSAGE = 1;

    public static boolean supportsJavaMethod(String string) {
        if (aRq == null) {
            return true;
        }
        if (string.startsWith("java.lang.Math.")) {
            return true;
        }
        if (aRq.contains(string)) {
            return true;
        }
        ai ai2 = aRq.iterator();
        while (ai2.hasNext()) {
            String string2 = (String)ai2.next();
            int n2 = string2.lastIndexOf(".*");
            if (n2 < 1 || !string.startsWith(string2.substring(0, n2 + 1))) continue;
            return true;
        }
        return false;
    }

    public o(g g2) {
        super(aRs, g2.getPath(), g2.logger.getFileAccess(), g2.isFilesInJar());
        this.database = g2;
        this.my();
    }

    void my() {
        this.setProperty(hsqldb_version, "2.3.3");
        this.setProperty("modified", "no-new-files");
        if (this.database.logger.isStoredFileAccess()) {
            this.setProperty(hsqldb_cache_rows, 25000);
            this.setProperty(hsqldb_cache_size, 6000);
            this.setProperty(hsqldb_log_size, 10);
            this.setProperty(sql_enforce_size, true);
            this.setProperty(hsqldb_nio_data_file, false);
            this.setProperty(hsqldb_lock_file, true);
            this.setProperty(hsqldb_default_table_type, "cached");
            this.setProperty(jdbc_translate_tti_types, true);
        }
    }

    @Override
    public boolean load() {
        boolean bl2;
        if (!i.isFileBasedDatabaseType(this.database.getType())) {
            return true;
        }
        try {
            bl2 = super.load();
        }
        catch (Throwable throwable) {
            throw a.error(throwable, 452, 27, new Object[]{throwable.toString(), this.fileName});
        }
        if (!bl2) {
            return false;
        }
        this.mz();
        String string = this.getStringProperty(hsqldb_version);
        int n2 = string.substring(0, 5).compareTo(VERSION_STRING_1_8_0);
        if (n2 < 0) {
            throw a.error(453);
        }
        if (n2 == 0 && this.getIntegerProperty(hsqldb_script_format) != 0) {
            throw a.error(453);
        }
        n2 = string.substring(0, 2).compareTo("2.3.3");
        if (n2 > 0) {
            throw a.error(453);
        }
        return true;
    }

    @Override
    public void save() {
        if (!i.isFileBasedDatabaseType(this.database.getType()) || this.database.isFilesReadOnly() || this.database.isFilesInJar()) {
            return;
        }
        try {
            p p2 = new p(aRs, this.database.getPath(), this.database.logger.getFileAccess(), false);
            if (this.getIntegerProperty(hsqldb_script_format) == 3) {
                p2.setProperty(hsqldb_script_format, 3);
            }
            p2.setProperty(hsqldb_version, "2.3.3");
            p2.setProperty(tx_timestamp, Long.toString(this.database.logger.getFilesTimestamp()));
            if (!this.database.logger.isStoredFileAccess() || !this.database.logger.isNewStoredFileAccess()) {
                // empty if block
            }
            p2.setProperty("modified", this.getProperty("modified"));
            p2.save(this.fileName + ".properties" + ".new");
            this.fa.renameElement(this.fileName + ".properties" + ".new", this.fileName + ".properties");
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("save failed", throwable);
            throw a.error(throwable, 452, 27, new Object[]{throwable.toString(), this.fileName});
        }
    }

    void mz() {
        String string = this.stringProps.getProperty(sql_enforce_strict_size);
        if (string != null) {
            this.stringProps.setProperty(sql_enforce_size, string);
        }
        Enumeration<?> enumeration = this.stringProps.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            boolean bl2 = aRs.containsKey(string2);
            if (bl2) continue;
            this.stringProps.remove(string2);
        }
    }

    public void setURLProperties(p p2) {
        Object[] objectArray;
        String string;
        boolean bl2 = false;
        if (p2 == null) {
            return;
        }
        String string2 = p2.getProperty(sql_enforce_strict_size);
        if (string2 != null) {
            p2.setProperty(sql_enforce_size, string2);
            p2.removeProperty(sql_enforce_strict_size);
        }
        bl2 = p2.isPropertyTrue(url_check_props, false);
        Enumeration enumeration = p2.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            objectArray = p2.getProperty(string);
            boolean bl3 = false;
            boolean bl4 = false;
            String string3 = null;
            Object[] objectArray2 = (Object[])aRs.get(string);
            if (objectArray2 != null && (Integer)objectArray2[1] == 2) {
                bl3 = true;
                string3 = p.validateProperty(string, (String)objectArray, objectArray2);
                boolean bl5 = bl4 = string3 == null;
            }
            if (!string.startsWith("sql.") && !string.startsWith("hsqldb.") && !string.startsWith("textdb.")) continue;
            if (bl2 && !bl3) {
                throw a.error(5555, string);
            }
            if (!bl2 || bl4) continue;
            throw a.error(5556, string);
        }
        enumeration = p2.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            objectArray = (Object[])aRs.get(string);
            if (objectArray == null || (Integer)objectArray[1] != 2) continue;
            this.setDatabaseProperty(string, p2.getProperty(string));
        }
    }

    public bd getUserDefinedPropertyData() {
        t t2 = new t();
        ai ai2 = aRs.values().iterator();
        while (ai2.hasNext()) {
            Object[] objectArray = (Object[])ai2.next();
            if ((Integer)objectArray[1] != 2) continue;
            t2.add(objectArray);
        }
        return t2;
    }

    public boolean isUserDefinedProperty(String string) {
        Object[] objectArray = (Object[])aRs.get(string);
        return objectArray != null && (Integer)objectArray[1] == 2;
    }

    public boolean isBoolean(String string) {
        Object[] objectArray = (Object[])aRs.get(string);
        return objectArray != null && objectArray[2].equals("Boolean") && (Integer)objectArray[1] == 2;
    }

    public boolean isIntegral(String string) {
        Object[] objectArray = (Object[])aRs.get(string);
        return objectArray != null && objectArray[2].equals("Integer") && (Integer)objectArray[1] == 2;
    }

    public boolean isString(String string) {
        Object[] objectArray = (Object[])aRs.get(string);
        return objectArray != null && objectArray[2].equals("String") && (Integer)objectArray[1] == 2;
    }

    public boolean setDatabaseProperty(String string, String string2) {
        Object[] objectArray = (Object[])aRs.get(string);
        String string3 = p.validateProperty(string, string2, objectArray);
        if (string3 != null) {
            return false;
        }
        this.stringProps.put(string, string2);
        return true;
    }

    public int getDefaultWriteDelay() {
        if (this.database.logger.isStoredFileAccess()) {
            return 2000;
        }
        return 500;
    }

    public int getErrorLevel() {
        return 1;
    }

    public boolean divisionByZero() {
        return false;
    }

    public void setDBModified(int n2) {
        String string;
        switch (n2) {
            case 0: {
                string = "no";
                break;
            }
            case 1: {
                string = "yes";
                break;
            }
            case 2: {
                string = "yes-new-files";
                break;
            }
            default: {
                throw a.runtimeError(201, "HsqlDatabaseProperties");
            }
        }
        this.stringProps.put("modified", string);
        this.save();
    }

    public int getDBModified() {
        String string = this.getStringProperty("modified");
        if ("yes".equals(string)) {
            return 1;
        }
        if ("yes-new-files".equals(string)) {
            return 2;
        }
        if ("no-new-files".equals(string)) {
            return 3;
        }
        return 0;
    }

    @Override
    public String getProperty(String string) {
        Object[] objectArray = (Object[])aRs.get(string);
        if (objectArray == null) {
            throw a.error(5555, string);
        }
        return this.stringProps.getProperty(string);
    }

    public String getPropertyString(String string) {
        boolean bl2;
        Object[] objectArray = (Object[])aRs.get(string);
        if (objectArray == null) {
            throw a.error(5555, string);
        }
        String string2 = this.stringProps.getProperty(string);
        boolean bl3 = bl2 = (Integer)objectArray[1] == 0;
        if (string2 == null && bl2) {
            try {
                string2 = System.getProperty(string);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (string2 == null) {
            Object object = objectArray[4];
            if (object == null) {
                return null;
            }
            return String.valueOf(object);
        }
        return string2;
    }

    @Override
    public boolean isPropertyTrue(String string) {
        boolean bl2;
        Object[] objectArray = (Object[])aRs.get(string);
        if (objectArray == null) {
            throw a.error(5555, string);
        }
        Boolean bl3 = (Boolean)objectArray[4];
        String string2 = null;
        boolean bl4 = bl2 = (Integer)objectArray[1] == 0;
        if (bl2) {
            try {
                string2 = System.getProperty(string);
            }
            catch (SecurityException securityException) {}
        } else {
            string2 = this.stringProps.getProperty(string);
        }
        if (string2 != null) {
            bl3 = Boolean.valueOf(string2);
        }
        return bl3;
    }

    public String getStringPropertyDefault(String string) {
        Object[] objectArray = (Object[])aRs.get(string);
        if (objectArray == null) {
            throw a.error(5555, string);
        }
        return (String)objectArray[4];
    }

    public String getStringProperty(String string) {
        Object[] objectArray = (Object[])aRs.get(string);
        if (objectArray == null) {
            throw a.error(5555, string);
        }
        String string2 = (String)objectArray[4];
        String string3 = this.stringProps.getProperty(string);
        if (string3 != null) {
            string2 = string3;
        }
        return string2;
    }

    public int getIntegerProperty(String string) {
        Object[] objectArray = (Object[])aRs.get(string);
        if (objectArray == null) {
            throw a.error(5555, string);
        }
        int n2 = (Integer)objectArray[4];
        String string2 = this.stringProps.getProperty(string);
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    public static ai getPropertiesMetaIterator() {
        return aRs.values().iterator();
    }

    public String getClientPropertiesAsString() {
        if (this.isPropertyTrue(jdbc_translate_tti_types)) {
            StringBuffer stringBuffer = new StringBuffer(jdbc_translate_tti_types);
            stringBuffer.append('=').append(true);
            return stringBuffer.toString();
        }
        return "";
    }

    public boolean isVersion18() {
        String string = this.getProperty(hsqldb_cache_version, "2.3.3");
        return string.substring(0, 4).equals("1.7.");
    }

    static {
        try {
            String string = System.getProperty("hsqldb.method_class_names");
            if (string != null) {
                aRq = new t();
                String[] stringArray = bj.split(string, ";");
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    aRq.add(stringArray[i2]);
                }
            }
            if ((string = System.getProperty(textdb_allow_full_path)) != null && Boolean.valueOf(string).booleanValue()) {
                aRr = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        aRs = new r(67);
        aRt = new r(17);
        aRt.put(textdb_allow_full_path, p.getMeta(textdb_allow_full_path, 0, aRr));
        aRt.put(textdb_quoted, p.getMeta(textdb_quoted, 2, true));
        aRt.put(textdb_all_quoted, p.getMeta(textdb_all_quoted, 2, false));
        aRt.put(textdb_ignore_first, p.getMeta(textdb_ignore_first, 2, false));
        aRt.put(textdb_fs, p.getMeta(textdb_fs, 2, ","));
        aRt.put(textdb_vs, p.getMeta(textdb_vs, 2, null));
        aRt.put(textdb_lvs, p.getMeta(textdb_lvs, 2, null));
        aRt.put(textdb_encoding, p.getMeta(textdb_encoding, 2, "ISO-8859-1"));
        aRt.put(textdb_cache_scale, p.getMeta(textdb_cache_scale, 2, 10, 8, 16));
        aRt.put(textdb_cache_size_scale, p.getMeta(textdb_cache_size_scale, 2, 10, 6, 20));
        aRt.put(textdb_cache_rows, p.getMeta(textdb_cache_rows, 2, 1000, 100, 1000000));
        aRt.put(textdb_cache_size, p.getMeta(textdb_cache_size, 2, 100, 10, 1000000));
        aRs.putAll(aRt);
        aRs.put(hsqldb_version, p.getMeta(hsqldb_version, 1, null));
        aRs.put("modified", p.getMeta("modified", 1, null));
        aRs.put(hsqldb_cache_version, p.getMeta(hsqldb_cache_version, 1, null));
        aRs.put(hsqldb_readonly, p.getMeta(hsqldb_readonly, 1, false));
        aRs.put(hsqldb_files_readonly, p.getMeta(hsqldb_files_readonly, 1, false));
        aRs.put(hsqldb_tx, p.getMeta(hsqldb_tx, 2, "LOCKS"));
        aRs.put(hsqldb_tx_level, p.getMeta(hsqldb_tx_level, 2, "READ_COMMITTED"));
        aRs.put(hsqldb_temp_directory, p.getMeta(hsqldb_temp_directory, 2, null));
        aRs.put(hsqldb_default_table_type, p.getMeta(hsqldb_default_table_type, 2, "MEMORY"));
        aRs.put(hsqldb_digest, p.getMeta(hsqldb_digest, 2, "MD5"));
        aRs.put(tx_timestamp, p.getMeta(tx_timestamp, 0));
        aRs.put(hsqldb_tx_conflict_rollback, p.getMeta(hsqldb_tx_conflict_rollback, 2, true));
        aRs.put(jdbc_translate_tti_types, p.getMeta(jdbc_translate_tti_types, 2, true));
        aRs.put(hsqldb_inc_backup, p.getMeta(hsqldb_inc_backup, 2, true));
        aRs.put(hsqldb_lock_file, p.getMeta(hsqldb_lock_file, 2, true));
        aRs.put(hsqldb_log_data, p.getMeta(hsqldb_log_data, 2, true));
        aRs.put(hsqldb_nio_data_file, p.getMeta(hsqldb_nio_data_file, 2, true));
        aRs.put(hsqldb_full_log_replay, p.getMeta(hsqldb_full_log_replay, 2, false));
        aRs.put(sql_ref_integrity, p.getMeta(sql_ref_integrity, 2, true));
        aRs.put(sql_enforce_names, p.getMeta(sql_enforce_names, 2, false));
        aRs.put(sql_regular_names, p.getMeta(sql_regular_names, 2, true));
        aRs.put(sql_enforce_refs, p.getMeta(sql_enforce_refs, 2, false));
        aRs.put(sql_enforce_size, p.getMeta(sql_enforce_size, 2, true));
        aRs.put(sql_enforce_types, p.getMeta(sql_enforce_types, 2, false));
        aRs.put(sql_enforce_tdcd, p.getMeta(sql_enforce_tdcd, 2, true));
        aRs.put(sql_enforce_tdcu, p.getMeta(sql_enforce_tdcu, 2, true));
        aRs.put(sql_concat_nulls, p.getMeta(sql_concat_nulls, 2, true));
        aRs.put(sql_nulls_first, p.getMeta(sql_nulls_first, 2, true));
        aRs.put(sql_nulls_order, p.getMeta(sql_nulls_order, 2, true));
        aRs.put(sql_unique_nulls, p.getMeta(sql_unique_nulls, 2, true));
        aRs.put(sql_convert_trunc, p.getMeta(sql_convert_trunc, 2, true));
        aRs.put(sql_avg_scale, p.getMeta(sql_avg_scale, 2, 0, 0, 10));
        aRs.put(sql_double_nan, p.getMeta(sql_double_nan, 2, true));
        aRs.put(sql_syntax_db2, p.getMeta(sql_syntax_db2, 2, false));
        aRs.put(sql_syntax_mss, p.getMeta(sql_syntax_mss, 2, false));
        aRs.put(sql_syntax_mys, p.getMeta(sql_syntax_mys, 2, false));
        aRs.put(sql_syntax_ora, p.getMeta(sql_syntax_ora, 2, false));
        aRs.put(sql_syntax_pgs, p.getMeta(sql_syntax_pgs, 2, false));
        aRs.put(sql_compare_in_locale, p.getMeta(sql_compare_in_locale, 2, false));
        aRs.put(sql_longvar_is_lob, p.getMeta(sql_longvar_is_lob, 2, false));
        aRs.put(sql_pad_space, p.getMeta(sql_pad_space, 2, true));
        aRs.put(sql_ignore_case, p.getMeta(sql_ignore_case, 2, false));
        aRs.put(hsqldb_write_delay, p.getMeta(hsqldb_write_delay, 2, true));
        aRs.put(hsqldb_large_data, p.getMeta(hsqldb_large_data, 2, false));
        aRs.put(hsqldb_files_space, p.getMeta(hsqldb_files_space, 2, 0, new int[]{0, 1, 2, 4, 8, 16, 32, 64}));
        aRs.put(hsqldb_write_delay_millis, p.getMeta(hsqldb_write_delay_millis, 2, 500, 0, 10000));
        aRs.put(hsqldb_applog, p.getMeta(hsqldb_applog, 2, 0, 0, 3));
        aRs.put(hsqldb_sqllog, p.getMeta(hsqldb_sqllog, 2, 0, 0, 4));
        aRs.put(hsqldb_script_format, p.getMeta(hsqldb_script_format, 2, 0, new int[]{0, 1, 3}));
        aRs.put(hsqldb_lob_file_scale, p.getMeta(hsqldb_lob_file_scale, 2, 32, new int[]{1, 2, 4, 8, 16, 32}));
        aRs.put(hsqldb_lob_file_compressed, p.getMeta(hsqldb_lob_file_compressed, 2, false));
        aRs.put(hsqldb_cache_file_scale, p.getMeta(hsqldb_cache_file_scale, 2, 32, new int[]{1, 8, 16, 32, 64, 128, 256, 512, 1024}));
        aRs.put(hsqldb_log_size, p.getMeta(hsqldb_log_size, 2, 50, 0, 4096));
        aRs.put(hsqldb_defrag_limit, p.getMeta(hsqldb_defrag_limit, 2, 0, 0, 100));
        aRs.put(runtime_gc_interval, p.getMeta(runtime_gc_interval, 2, 0, 0, 1000000));
        aRs.put(hsqldb_cache_size, p.getMeta(hsqldb_cache_size, 2, 10000, 100, 0x400000));
        aRs.put(hsqldb_cache_rows, p.getMeta(hsqldb_cache_rows, 2, 50000, 100, 0x400000));
        aRs.put(hsqldb_cache_free_count, p.getMeta(hsqldb_cache_free_count, 2, 512, 0, 4096));
        aRs.put(hsqldb_result_max_memory_rows, p.getMeta(hsqldb_result_max_memory_rows, 2, 0, 0, 0x400000));
        aRs.put(hsqldb_nio_max_size, p.getMeta(hsqldb_nio_max_size, 2, 256, 64, 262144));
        aRs.put(hsqldb_min_reuse, p.getMeta(hsqldb_min_reuse, 2, 0, 0, 0x100000));
    }
}

