/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.e;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.a.a;
import org.hsqldb.aa;
import org.hsqldb.c.b;
import org.hsqldb.e.ad;
import org.hsqldb.e.ah;
import org.hsqldb.e.ai;
import org.hsqldb.e.ak;
import org.hsqldb.e.c;
import org.hsqldb.e.d;
import org.hsqldb.e.i;
import org.hsqldb.e.j;
import org.hsqldb.e.k;
import org.hsqldb.e.l;
import org.hsqldb.e.z;
import org.hsqldb.i.e;
import org.hsqldb.i.m;
import org.hsqldb.lib.ae;
import org.hsqldb.lib.n;
import org.hsqldb.lib.o;
import org.hsqldb.lib.p;

public class g {
    protected n fa;
    public static final int FLAG_ISSHADOWED = 1;
    public static final int FLAG_ISSAVED = 2;
    public static final int FLAG_ROWINFO = 3;
    public static final int FLAG_190 = 4;
    public static final int FLAG_HX = 5;
    public j spaceManager;
    protected String dataFileName;
    protected String backupFileName;
    protected org.hsqldb.g database;
    protected boolean logEvents = true;
    protected boolean fileModified;
    protected boolean cacheModified;
    protected int dataFileScale;
    protected boolean cacheReadonly;
    protected int cachedRowPadding;
    protected long initialFreePos;
    protected long lostSpaceSize;
    protected long spaceManagerPosition;
    protected long fileStartFreePosition;
    protected boolean hasRowInfo = false;
    protected int storeCount;
    protected e rowIn;
    public m rowOut;
    public long maxDataFileSize;
    boolean aQF;
    protected ak dataFile;
    protected volatile long fileFreePosition;
    protected int maxCacheRows;
    protected long maxCacheBytes;
    protected c cache;
    private ai aQG;
    ReadWriteLock aGW = new ReentrantReadWriteLock();
    Lock aGX = this.aGW.readLock();
    Lock aGY = this.aGW.writeLock();

    public g(org.hsqldb.g g2, String string) {
        this.initParams(g2, string, false);
        this.cache = new c(this);
    }

    public g(org.hsqldb.g g2, String string, boolean bl2) {
        this.initParams(g2, string, true);
        this.cache = new c(this);
        try {
            this.dataFile = this.database.logger.isStoredFileAccess() ? ad.a(this.database, this.dataFileName, false, 3) : new ah(this.database.logger, this.dataFileName, "rw");
        }
        catch (Throwable throwable) {
            throw a.error(452, throwable);
        }
        this.mh();
        this.initBuffers();
        this.spaceManager = this.database.logger.getDataFileSpaces() > 0 ? new k(this) : new l(this);
    }

    protected void initParams(org.hsqldb.g g2, String string, boolean bl2) {
        this.dataFileName = string + ".data";
        this.backupFileName = string + ".backup";
        this.database = g2;
        this.fa = g2.logger.getFileAccess();
        this.dataFileScale = g2.logger.getDataFileScale();
        this.cachedRowPadding = 8;
        if (this.dataFileScale > 8) {
            this.cachedRowPadding = this.dataFileScale;
        }
        this.initialFreePos = 32L;
        if (this.initialFreePos < (long)this.dataFileScale) {
            this.initialFreePos = this.dataFileScale;
        }
        this.cacheReadonly = g2.isFilesReadOnly();
        this.maxCacheRows = g2.logger.getCacheMaxRows();
        this.maxCacheBytes = g2.logger.getCacheSize();
        this.maxDataFileSize = Integer.MAX_VALUE * (long)this.dataFileScale * (long)g2.logger.getDataFileFactor();
        if (bl2) {
            this.dataFileName = this.dataFileName + ".new";
            this.backupFileName = this.backupFileName + ".new";
            this.maxCacheRows = 1024;
            this.maxCacheBytes = 0x400000L;
        }
    }

    public void open(boolean bl2) {
        if (this.database.logger.isStoredFileAccess()) {
            this.W(bl2);
            return;
        }
        this.fileFreePosition = this.initialFreePos;
        this.logInfoEvent("dataFileCache open start");
        try {
            boolean bl3 = this.database.logger.aSz;
            int n2 = this.database.isFilesInJar() ? 2 : (bl3 ? 1 : 0);
            if (bl2 || this.database.isFilesInJar()) {
                this.dataFile = ad.a(this.database, this.dataFileName, bl2, n2);
                int n3 = this.getFlags();
                boolean bl4 = this.aQF = !b.isSet(n3, 4);
                if (b.isSet(n3, 5)) {
                    throw a.error(453);
                }
                this.dataFile.seek(12L);
                this.fileFreePosition = this.dataFile.readLong();
                this.dataFile.seek(24L);
                this.spaceManagerPosition = (long)this.dataFile.readInt() * 4096L;
                this.initBuffers();
                this.spaceManager = new l(this);
                return;
            }
            boolean bl5 = this.fa.isStreamElement(this.dataFileName);
            boolean bl6 = this.database.logger.aSy;
            boolean bl7 = false;
            if (bl5) {
                int n4;
                this.dataFile = new ah(this.database.logger, this.dataFileName, "r");
                long l2 = this.dataFile.length();
                boolean bl8 = false;
                if (l2 >= this.initialFreePos) {
                    n4 = this.getFlags();
                    bl7 = b.isSet(n4, 2);
                    bl6 = b.isSet(n4, 1);
                    boolean bl9 = this.aQF = !b.isSet(n4, 4);
                    if (b.isSet(n4, 5)) {
                        bl8 = true;
                    }
                }
                this.dataFile.close();
                if (bl8) {
                    throw a.error(453);
                }
                if (!this.database.logger.aSU && l2 > this.maxDataFileSize / 8L * 7L) {
                    this.database.logger.aSU = true;
                    this.maxDataFileSize = Integer.MAX_VALUE * (long)this.dataFileScale * (long)this.database.logger.getDataFileFactor();
                }
                if (l2 > this.maxDataFileSize) {
                    throw a.error(468, String.valueOf(this.maxDataFileSize));
                }
                if (bl7 && bl6 && (n4 = (int)(this.fa.isStreamElement(this.backupFileName) ? 1 : 0)) != 0) {
                    this.logInfoEvent("data file was not modified but inc backup exists");
                }
            }
            if (bl7) {
                if (bl6) {
                    this.mp();
                } else {
                    boolean bl10 = this.fa.isStreamElement(this.backupFileName);
                    if (!bl10) {
                        this.X(false);
                    }
                }
            } else if (bl6) {
                if (bl5 && !(bl5 = this.mk())) {
                    this.database.logger.logSevereEvent("DataFileCache data file modified but no backup exists", null);
                    throw a.error(454);
                }
            } else {
                bl5 = this.mj();
            }
            this.dataFile = ad.a(this.database, this.dataFileName, bl2, n2);
            if (bl5) {
                int n5 = this.getFlags();
                this.aQF = !b.isSet(n5, 4);
                this.dataFile.seek(4L);
                this.lostSpaceSize = this.dataFile.readLong();
                this.dataFile.seek(12L);
                this.fileStartFreePosition = this.fileFreePosition = this.dataFile.readLong();
                this.dataFile.seek(24L);
                this.spaceManagerPosition = (long)this.dataFile.readInt() * 4096L;
                this.mi();
            } else {
                this.mh();
            }
            this.initBuffers();
            this.fileModified = false;
            this.cacheModified = false;
            this.spaceManager = this.database.logger.getDataFileSpaces() > 0 ? new k(this) : new l(this);
            this.logInfoEvent("dataFileCache open end");
        }
        catch (aa aa2) {
            throw aa2;
        }
        catch (Throwable throwable) {
            this.logSevereEvent("DataFileCache.open", throwable);
            this.release();
            throw a.error(throwable, 452, 52, new Object[]{throwable.toString(), this.dataFileName});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean mg() {
        this.aGY.lock();
        int n2 = this.database.logger.aSV;
        try {
            if (n2 > 0 && this.spaceManagerPosition == 0L) {
                this.spaceManager.reset();
                this.spaceManager = new k(this);
                boolean bl2 = true;
                return bl2;
            }
            if (n2 == 0 && this.spaceManagerPosition != 0L) {
                this.spaceManager.reset();
                this.spaceManager = new l(this);
                boolean bl3 = true;
                return bl3;
            }
            boolean bl4 = false;
            return bl4;
        }
        finally {
            this.aGY.unlock();
        }
    }

    void W(boolean bl2) {
        this.fileFreePosition = this.initialFreePos;
        this.logInfoEvent("dataFileCache open start");
        try {
            boolean bl3;
            int n2 = 3;
            if (bl2) {
                this.dataFile = ad.a(this.database, this.dataFileName, bl2, n2);
                this.dataFile.seek(28L);
                int n3 = this.dataFile.readInt();
                this.aQF = !b.isSet(n3, 4);
                this.dataFile.seek(12L);
                this.fileFreePosition = this.dataFile.readLong();
                this.initBuffers();
                return;
            }
            long l2 = 0L;
            boolean bl4 = this.fa.isStreamElement(this.dataFileName);
            boolean bl5 = this.database.logger.aSy;
            boolean bl6 = bl3 = this.database.getProperties().getDBModified() == 1;
            if (bl4 && bl3) {
                bl4 = bl5 ? this.mk() : this.mj();
            }
            this.dataFile = ad.a(this.database, this.dataFileName, bl2, n2);
            if (bl4) {
                this.dataFile.seek(4L);
                l2 = this.dataFile.readLong();
                this.dataFile.seek(12L);
                this.fileStartFreePosition = this.fileFreePosition = this.dataFile.readLong();
                this.dataFile.seek(28L);
                int n4 = this.dataFile.readInt();
                this.aQF = !b.isSet(n4, 4);
                this.mi();
            } else {
                this.mh();
            }
            this.initBuffers();
            this.fileModified = false;
            this.cacheModified = false;
            this.spaceManager = new l(this);
            this.logInfoEvent("dataFileCache open end");
        }
        catch (Throwable throwable) {
            this.logSevereEvent("dataFileCache open failed", throwable);
            this.release();
            throw a.error(throwable, 452, 52, new Object[]{throwable.toString(), this.dataFileName});
        }
    }

    void mh() {
        try {
            this.fileFreePosition = this.initialFreePos;
            this.fileStartFreePosition = this.initialFreePos;
            this.dataFile.seek(12L);
            this.dataFile.writeLong(this.fileFreePosition);
            int n2 = this.dataFileScale;
            this.dataFile.seek(20L);
            this.dataFile.writeInt(n2 |= this.database.logger.getDataFileSpaces() << 16);
            int n3 = 0;
            if (this.database.logger.aSy) {
                n3 = b.set(n3, 1);
            }
            n3 = b.set(n3, 2);
            n3 = b.set(n3, 4);
            this.setFlags(n3);
            this.aQF = false;
        }
        catch (Throwable throwable) {
            throw a.error(452, throwable);
        }
    }

    private void mi() {
        if (this.database.logger.aSy && this.fileFreePosition != this.initialFreePos) {
            this.aQG = new ai(this.database, this.dataFile, this.backupFileName, this.fileFreePosition, 16384);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIncrementBackup(boolean bl2) {
        this.aGY.lock();
        try {
            int n2 = this.getFlags();
            n2 = bl2 ? b.set(n2, 1) : b.unset(n2, 1);
            this.setFlags(n2);
            this.fileModified = true;
        }
        catch (Throwable throwable) {
            this.logSevereEvent("DataFileCache.setIncrementalBackup", throwable);
        }
        finally {
            this.aGY.unlock();
        }
    }

    private boolean mj() {
        try {
            n n2 = this.database.logger.getFileAccess();
            g.c(this.database, this.dataFileName);
            if (n2.isStreamElement(this.backupFileName)) {
                o.unarchive(this.backupFileName, this.dataFileName, n2, 1);
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("DataFileCache.restoreBackup", throwable);
            throw a.error(throwable, 452, 26, new Object[]{throwable.toString(), this.backupFileName});
        }
    }

    private boolean mk() {
        try {
            n n2 = this.database.logger.getFileAccess();
            if (n2.isStreamElement(this.backupFileName)) {
                ai.restoreFile(this.database, this.backupFileName, this.dataFileName);
                g.c(this.database, this.backupFileName);
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("DataFileCache.restoreBackupIncremental", throwable);
            throw a.error(452, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.aGY.lock();
        try {
            if (this.dataFile == null) {
                return;
            }
            if (this.aQG != null) {
                this.aQG.close();
                this.aQG = null;
            }
            this.dataFile.close();
            this.logDetailEvent("dataFileCache file closed");
            this.dataFile = null;
        }
        catch (Throwable throwable) {
            this.logSevereEvent("DataFileCache.release", throwable);
        }
        finally {
            this.aGY.unlock();
        }
    }

    public void close() {
        this.aGY.lock();
        try {
            boolean bl2;
            if (this.dataFile == null) {
                return;
            }
            this.reset();
            this.dataFile.close();
            this.logDetailEvent("dataFileCache file close end");
            this.dataFile = null;
            boolean bl3 = bl2 = this.fileFreePosition == this.initialFreePos;
            if (bl2) {
                this.mo();
                this.mp();
            }
        }
        catch (aa aa2) {
            throw aa2;
        }
        catch (Throwable throwable) {
            this.logSevereEvent("DataFileCache.close", throwable);
            throw a.error(throwable, 452, 53, new Object[]{throwable.toString(), this.dataFileName});
        }
        finally {
            this.aGY.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        this.aGY.lock();
        try {
            this.cache.clear();
        }
        finally {
            this.aGY.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustStoreCount(int n2) {
        this.aGY.lock();
        try {
            this.storeCount += n2;
        }
        finally {
            this.aGY.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reopen() {
        this.aGY.lock();
        try {
            this.mi();
            this.spaceManager.initialiseSpaces();
        }
        finally {
            this.aGY.unlock();
        }
    }

    public void reset() {
        this.aGY.lock();
        try {
            if (this.cacheReadonly) {
                return;
            }
            this.logInfoEvent("dataFileCache commit start");
            this.spaceManager.reset();
            this.cache.mf();
            long l2 = this.spaceManager.getLostBlocksSize();
            this.dataFile.seek(4L);
            this.dataFile.writeLong(l2);
            this.dataFile.seek(12L);
            this.dataFile.writeLong(this.fileFreePosition);
            int n2 = this.dataFileScale;
            this.dataFile.seek(20L);
            this.dataFile.writeInt(n2 |= this.database.logger.getDataFileSpaces() << 16);
            int n3 = (int)(this.spaceManagerPosition / 4096L);
            this.dataFile.seek(24L);
            this.dataFile.writeInt(n3);
            int n4 = this.getFlags();
            n4 = b.set(n4, 2);
            this.setFlags(n4);
            this.logDetailEvent("file sync end");
            this.fileModified = false;
            this.cacheModified = false;
            this.fileStartFreePosition = this.fileFreePosition;
            if (this.aQG != null) {
                this.aQG.close();
                this.aQG = null;
            }
            this.logInfoEvent("dataFileCache commit end");
        }
        catch (Throwable throwable) {
            this.logSevereEvent("DataFileCache.reset commit", throwable);
            throw a.error(throwable, 452, 53, new Object[]{throwable.toString(), this.dataFileName});
        }
        finally {
            this.aGY.unlock();
        }
    }

    protected void initBuffers() {
        if (this.rowOut == null) {
            this.rowOut = this.aQF ? new org.hsqldb.i.k(4096, this.cachedRowPadding) : new org.hsqldb.i.l(this.database.logger.getCrypto(), 4096, this.cachedRowPadding);
        }
        if (this.rowIn == null) {
            this.rowIn = this.aQF ? new org.hsqldb.i.c(new byte[4096]) : new org.hsqldb.i.d(this.database.logger.getCrypto(), new byte[4096]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    i ml() {
        this.aGY.lock();
        try {
            this.cache.mf();
            i i2 = new i(this.database, this);
            i2.process();
            this.close();
            this.cache.clear();
            if (!this.database.logger.aSy) {
                this.Y(true);
            }
            this.database.schemaManager.setTempIndexRoots(i2.getIndexRoots());
            try {
                this.database.logger.aSX.ab(false);
            }
            finally {
                this.database.schemaManager.setTempIndexRoots(null);
            }
            this.database.getProperties().setProperty("hsqldb.script_format", this.database.logger.aST);
            this.database.getProperties().setDBModified(2);
            this.database.logger.aSX.na();
            this.database.logger.aSX.mS();
            this.database.logger.aSX.mP();
            this.mm();
            this.mn();
            this.database.getProperties().setDBModified(0);
            this.open(false);
            if (this.database.logger.aSX.aSo != null) {
                this.database.logger.aSX.mZ();
            }
            i i3 = i2;
            return i3;
        }
        finally {
            this.aGY.unlock();
        }
    }

    public void remove(d d2) {
        this.release(d2.getPos());
    }

    public void removePersistence(d d2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(d d2, boolean bl2) {
        this.aGY.lock();
        try {
            this.cacheModified = true;
            this.cache.a(d2);
            if (bl2) {
                d2.keepInMemory(true);
            }
            if (d2.getStorageSize() > 4096) {
                this.rowOut.reset(d2.getStorageSize());
            }
        }
        finally {
            this.aGY.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public d get(d d2, z z2, boolean bl2) {
        long l2;
        this.aGX.lock();
        try {
            if (d2.isInMemory()) {
                if (bl2) {
                    d2.keepInMemory(true);
                }
                d d3 = d2;
                return d3;
            }
            l2 = d2.getPos();
            if (l2 < 0L) {
                d d4 = null;
                return d4;
            }
            d2 = this.cache.get(l2);
            if (d2 != null) {
                if (bl2) {
                    d2.keepInMemory(true);
                }
                d d5 = d2;
                return d5;
            }
        }
        finally {
            this.aGX.unlock();
        }
        return this.a(l2, z2, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public d get(long l2, int n2, z z2, boolean bl2) {
        if (l2 < 0L) {
            return null;
        }
        this.aGX.lock();
        try {
            d d2 = this.cache.get(l2);
            if (d2 != null) {
                if (bl2) {
                    d2.keepInMemory(true);
                }
                d d3 = d2;
                return d3;
            }
        }
        finally {
            this.aGX.unlock();
        }
        return this.a(l2, n2, z2, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public d get(long l2, z z2, boolean bl2) {
        if (l2 < 0L) {
            return null;
        }
        this.aGX.lock();
        try {
            d d2 = this.cache.get(l2);
            if (d2 != null) {
                if (bl2) {
                    d2.keepInMemory(true);
                }
                d d3 = d2;
                return d3;
            }
        }
        finally {
            this.aGX.unlock();
        }
        return this.a(l2, z2, bl2);
    }

    private d a(long l2, z z2, boolean bl2) {
        d d2 = null;
        this.aGY.lock();
        try {
            d2 = this.cache.get(l2);
            if (d2 != null) {
                if (bl2) {
                    d2.keepInMemory(true);
                }
                d d3 = d2;
                return d3;
            }
            for (int i2 = 0; i2 < 2; ++i2) {
                try {
                    this.J(l2);
                    d2 = z2.get(this.rowIn);
                    if (d2 == null) {
                        throw a.error(467, "position " + l2);
                    }
                    break;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof OutOfMemoryError) {
                        this.cache.me();
                        System.gc();
                        if (i2 <= 0) continue;
                        this.logInfoEvent(this.dataFileName + " getFromFile out of mem " + l2);
                        aa aa2 = a.error(460, throwable);
                        aa2.info = this.rowIn;
                        throw aa2;
                    }
                    if (throwable instanceof aa) {
                        ((aa)throwable).info = this.rowIn;
                        throw (aa)throwable;
                    }
                    aa aa3 = a.error(467, throwable);
                    aa3.info = this.rowIn;
                    throw aa3;
                }
            }
            this.cache.a(d2);
            if (bl2) {
                d2.keepInMemory(true);
            }
            z2.set(d2);
            d d4 = d2;
            return d4;
        }
        catch (aa aa4) {
            this.logSevereEvent(this.dataFileName + " getFromFile failed " + l2, aa4);
            throw aa4;
        }
        finally {
            this.aGY.unlock();
        }
    }

    private d a(long l2, int n2, z z2, boolean bl2) {
        d d2 = null;
        this.aGY.lock();
        try {
            d2 = this.cache.get(l2);
            if (d2 != null) {
                if (bl2) {
                    d2.keepInMemory(true);
                }
                d d3 = d2;
                return d3;
            }
            for (int i2 = 0; i2 < 2; ++i2) {
                try {
                    this.readObject(l2, n2);
                    d2 = z2.get(this.rowIn);
                    break;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    this.cache.me();
                    System.gc();
                    if (i2 <= 0) continue;
                    this.logSevereEvent(this.dataFileName + " getFromFile out of mem " + l2, outOfMemoryError);
                    throw outOfMemoryError;
                }
            }
            this.cache.b(d2);
            if (bl2) {
                d2.keepInMemory(true);
            }
            z2.set(d2);
            d d4 = d2;
            return d4;
        }
        catch (aa aa2) {
            this.logSevereEvent(this.dataFileName + " getFromFile failed " + l2, aa2);
            throw aa2;
        }
        finally {
            this.aGY.unlock();
        }
    }

    private void J(long l2) {
        try {
            this.dataFile.seek(l2 * (long)this.dataFileScale);
            int n2 = this.dataFile.readInt();
            this.rowIn.resetRow(l2, n2);
            this.dataFile.read(this.rowIn.getBuffer(), 4, n2 - 4);
        }
        catch (Throwable throwable) {
            this.a("DataFileCache.readObject", throwable, l2);
            aa aa2 = a.error(466, throwable);
            if (this.rowIn.getPos() != l2) {
                this.rowIn.resetRow(l2, 0);
            }
            aa2.info = this.rowIn;
            throw aa2;
        }
    }

    protected void readObject(long l2, int n2) {
        try {
            this.rowIn.resetBlock(l2, n2);
            this.dataFile.seek(l2 * (long)this.dataFileScale);
            this.dataFile.read(this.rowIn.getBuffer(), 0, n2);
        }
        catch (Throwable throwable) {
            this.a("DataFileCache.readObject", throwable, l2);
            aa aa2 = a.error(466, throwable);
            aa2.info = this.rowIn;
            throw aa2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseRange(long l2, long l3) {
        this.aGY.lock();
        try {
            org.hsqldb.lib.ai ai2 = this.cache.getIterator();
            while (ai2.hasNext()) {
                d d2 = (d)ai2.next();
                long l4 = d2.getPos();
                if (l4 < l2 || l4 >= l3) continue;
                d2.setInMemory(false);
                ai2.remove();
            }
        }
        finally {
            this.aGY.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseRange(ae ae2, int n2) {
        this.aGY.lock();
        try {
            this.cache.releaseRange(ae2, n2);
        }
        finally {
            this.aGY.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public d release(long l2) {
        this.aGY.lock();
        try {
            d d2 = this.cache.release(l2);
            return d2;
        }
        finally {
            this.aGY.unlock();
        }
    }

    protected void saveRows(d[] dArray, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        int n4 = this.copyShadow(dArray, n2, n3);
        long l2 = this.cache.aQw.elapsedTime();
        this.cache.aQw.start();
        if (n4 > 0) {
            this.setFileModified();
        }
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            d d2 = dArray[i2];
            this.saveRowNoLock(d2);
            dArray[i2] = null;
        }
        this.cache.aQw.stop();
        this.cache.a(n3, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRow(d d2) {
        this.aGY.lock();
        try {
            this.copyShadow(d2);
            this.setFileModified();
            this.saveRowNoLock(d2);
        }
        finally {
            this.aGY.unlock();
        }
    }

    public void saveRowOutput(long l2) {
        try {
            this.dataFile.seek(l2 * (long)this.dataFileScale);
            this.dataFile.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
        }
        catch (Throwable throwable) {
            this.a("DataFileCache.saveRowOutput", throwable, l2);
            throw a.error(466, throwable);
        }
    }

    protected void saveRowNoLock(d d2) {
        try {
            this.rowOut.reset();
            d2.write(this.rowOut);
            this.dataFile.seek(d2.getPos() * (long)this.dataFileScale);
            this.dataFile.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
            d2.setChanged(false);
        }
        catch (Throwable throwable) {
            this.a("DataFileCache.saveRowNoLock", throwable, d2.getPos());
            throw a.error(466, throwable);
        }
    }

    protected int copyShadow(d[] dArray, int n2, int n3) {
        int n4 = 0;
        if (this.aQG != null) {
            long l2 = this.cache.aQx.elapsedTime();
            long l3 = 0L;
            this.cache.aQx.start();
            try {
                for (int i2 = n2; i2 < n2 + n3; ++i2) {
                    d d2 = dArray[i2];
                    l3 = d2.getPos() * (long)this.dataFileScale;
                    n4 += this.aQG.e(l3, d2.getStorageSize());
                }
                if (n4 > 0) {
                    this.aQG.synch();
                }
            }
            catch (Throwable throwable) {
                this.a("DataFileCache.copyShadow", throwable, l3);
                throw a.error(466, throwable);
            }
            this.cache.aQx.stop();
            if (n4 > 0) {
                l2 = this.cache.aQx.elapsedTime() - l2;
                this.logDetailEvent("copyShadow [size, time] " + this.aQG.getSavedLength() + " " + l2);
            }
        }
        return n4;
    }

    protected int copyShadow(d d2) {
        if (this.aQG != null) {
            long l2 = d2.getPos() * (long)this.dataFileScale;
            try {
                int n2 = this.aQG.e(l2, d2.getStorageSize());
                this.aQG.synch();
                return n2;
            }
            catch (Throwable throwable) {
                this.a("DataFileCache.copyShadow", throwable, d2.getPos());
                throw a.error(466, throwable);
            }
        }
        return 0;
    }

    void X(boolean bl2) {
        g.a(this.database, this.dataFileName, this.backupFileName, bl2);
    }

    void Y(boolean bl2) {
        g.a(this.database, this.dataFileName + ".new", this.backupFileName, bl2);
    }

    static void a(org.hsqldb.g g2, String string, String string2, boolean bl2) {
        try {
            n n2 = g2.logger.getFileAccess();
            if (g2.logger.aSy) {
                if (n2.isStreamElement(string2)) {
                    g.c(g2, string2);
                    if (n2.isStreamElement(string2)) {
                        throw a.error(466, "cannot delete old backup file");
                    }
                }
                return;
            }
            if (n2.isStreamElement(string)) {
                if (bl2) {
                    string2 = string2 + ".new";
                } else {
                    g.c(g2, string2);
                    if (n2.isStreamElement(string2)) {
                        throw a.error(466, "cannot delete old backup file");
                    }
                }
                o.archive(string, string2, n2, 1);
            }
        }
        catch (Throwable throwable) {
            g2.logger.logSevereEvent("DataFileCache.backupFile", throwable);
            throw a.error(466, throwable);
        }
    }

    void mm() {
        g.a(this.database, this.backupFileName);
    }

    static void a(org.hsqldb.g g2, String string) {
        n n2 = g2.logger.getFileAccess();
        if (g2.logger.aSy) {
            g.c(g2, string);
            return;
        }
        if (n2.isStreamElement(string + ".new")) {
            g.c(g2, string);
            n2.renameElement(string + ".new", string);
        }
    }

    void mn() {
        g.b(this.database, this.dataFileName);
    }

    static void b(org.hsqldb.g g2, String string) {
        n n2 = g2.logger.getFileAccess();
        if (n2.isStreamElement(string + ".new")) {
            g.c(g2, string);
            n2.renameElement(string + ".new", string);
        }
    }

    void mo() {
        g.c(this.database, this.dataFileName);
    }

    static void c(org.hsqldb.g g2, String string) {
        n n2 = g2.logger.getFileAccess();
        n2.removeElement(string);
        if (g2.logger.isStoredFileAccess()) {
            return;
        }
        if (n2.isStreamElement(string)) {
            g2.logger.aSX.nd();
            n2.removeElement(string);
            if (n2.isStreamElement(string)) {
                String string2 = p.newDiscardFileName(string);
                n2.renameElement(string, string2);
            }
        }
    }

    void mp() {
        g.c(this.database, this.backupFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long enlargeFileSpace(long l2) {
        this.aGY.lock();
        try {
            long l3 = this.fileFreePosition;
            if (l3 + l2 > this.maxDataFileSize) {
                this.logSevereEvent("data file reached maximum allowed size: " + this.dataFileName + " " + this.maxDataFileSize, null);
                throw a.error(468);
            }
            boolean bl2 = this.dataFile.ensureLength(l3 + l2);
            if (!bl2) {
                this.logSevereEvent("data file cannot be enlarged - disk space: " + this.dataFileName + " " + (l3 + l2), null);
                throw a.error(468);
            }
            this.fileFreePosition += l2;
            long l4 = l3;
            return l4;
        }
        finally {
            this.aGY.unlock();
        }
    }

    public int capacity() {
        return this.maxCacheRows;
    }

    public long bytesCapacity() {
        return this.maxCacheBytes;
    }

    public long getTotalCachedBlockSize() {
        return this.cache.getTotalCachedBlockSize();
    }

    public long getLostBlockSize() {
        return this.spaceManager.getLostBlocksSize();
    }

    public long getFileFreePos() {
        return this.fileFreePosition;
    }

    public int getCachedObjectCount() {
        return this.cache.size();
    }

    public int getAccessCount() {
        return this.cache.incrementAccessCount();
    }

    public String getFileName() {
        return this.dataFileName;
    }

    public int getDataFileScale() {
        return this.dataFileScale;
    }

    public boolean hasRowInfo() {
        return this.hasRowInfo;
    }

    public boolean isFileModified() {
        return this.fileModified;
    }

    public boolean isModified() {
        return this.cacheModified;
    }

    public boolean isFileOpen() {
        return this.dataFile != null;
    }

    protected void setFileModified() {
        try {
            if (!this.fileModified) {
                int n2 = this.getFlags();
                n2 = b.unset(n2, 2);
                this.setFlags(n2);
                this.logDetailEvent("setFileModified flag set ");
                this.fileModified = true;
            }
        }
        catch (Throwable throwable) {
            this.logSevereEvent("DataFileCache.setFileModified", throwable);
            throw a.error(466, throwable);
        }
    }

    public int getFlags() {
        this.dataFile.seek(28L);
        int n2 = this.dataFile.readInt();
        return n2;
    }

    private void setFlags(int n2) {
        this.dataFile.seek(28L);
        this.dataFile.writeInt(n2);
        this.dataFile.synch();
    }

    public boolean isDataReadOnly() {
        return this.cacheReadonly;
    }

    public ai getShadowFile() {
        return this.aQG;
    }

    private void a(String string, Throwable throwable, long l2) {
        if (this.logEvents) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(' ').append(l2);
            string = stringBuffer.toString();
            this.database.logger.logSevereEvent(string, throwable);
        }
    }

    void logSevereEvent(String string, Throwable throwable) {
        if (this.logEvents) {
            this.database.logger.logSevereEvent(string, throwable);
        }
    }

    void logInfoEvent(String string) {
        if (this.logEvents) {
            this.database.logger.logInfoEvent(string);
        }
    }

    void logDetailEvent(String string) {
        if (this.logEvents) {
            this.database.logger.logDetailEvent(string);
        }
    }
}

