/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.auth;

import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hsqldb.auth.b;
import org.hsqldb.jdbc.JDBCArrayBasic;
import org.hsqldb.k.ad;
import org.hsqldb.lib.q;

public class a {
    private static q aMB = q.getLog(a.class);
    private static a aMC = new a();
    private static Map<String, List<b>> aMD = new HashMap<String, List<b>>();

    private a() {
    }

    public static a getSingleton() {
        return aMC;
    }

    public void clear() {
        aMD.clear();
    }

    public void setAuthFunctionBeans(Map<String, List<b>> map) {
        if (aMD.size() > 0) {
            throw new IllegalStateException("Use setAuthFunctionBeans(Map) only when the set is empty");
        }
        aMD.putAll(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getUniqueNameFor(Connection connection) {
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("CALL database_name()");
            if (!resultSet.next()) {
                throw new SQLException("Engine did not reveal unique database name");
            }
            String string = resultSet.getString(1);
            return string;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    aMB.error("Failed to close ResultSet for retrieving db name");
                }
            }
            resultSet = null;
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                aMB.error("Failed to close Statement for retrieving db name");
            }
            statement = null;
        }
    }

    public void setAuthFunctionBeans(Connection connection, List<b> list) {
        this.setAuthFunctionBeans(a.getUniqueNameFor(connection), list);
    }

    public void setAuthFunctionBeans(String string, List<b> list) {
        if (string == null || string.length() != 16) {
            throw new IllegalArgumentException("Database name not exactly 16 characters long: " + string);
        }
        List<b> list2 = aMD.get(string);
        if (list2 == null) {
            list2 = new ArrayList<b>();
            aMD.put(string, list2);
        } else if (list2.size() > 0) {
            throw new IllegalStateException("Use setAuthFunctionBeans(String, List) only when the db's AuthFunctionBean list is empty");
        }
        list2.addAll(list);
    }

    public void setAuthFunctionBean(Connection connection, b b2) {
        this.setAuthFunctionBeans(a.getUniqueNameFor(connection), Collections.singletonList(b2));
    }

    public void setAuthFunctionBean(String string, b b2) {
        this.setAuthFunctionBeans(string, Collections.singletonList(b2));
    }

    public static Array authenticate(String string, String string2, String string3) {
        if (string == null || string.length() != 16) {
            throw new IllegalStateException("Internal problem.  Database name not exactly 16 characters long: " + string);
        }
        List<b> list = aMD.get(string);
        if (list == null) {
            aMB.error("Database '" + string + "' has not been set up with " + a.class.getName());
            throw new IllegalArgumentException("Database '" + string + "' has not been set up with " + a.class.getName());
        }
        RuntimeException runtimeException = null;
        for (b b2 : list) {
            try {
                Object[] objectArray = b2.authenticate(string2, string3);
                return objectArray == null ? null : new JDBCArrayBasic(objectArray, ad.SQL_VARCHAR);
            }
            catch (RuntimeException runtimeException2) {
                if (runtimeException == null) {
                    runtimeException = runtimeException2;
                }
                aMB.error("System failure of an AuthFunctionBean: " + (runtimeException2.getMessage() == null ? runtimeException2.toString() : runtimeException2.getMessage()));
            }
            catch (Exception exception) {
                throw exception;
            }
        }
        throw runtimeException;
    }
}

