/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.multibindings;

import com.google.inject.Key;
import com.google.inject.internal.Annotations;
import com.google.inject.multibindings.Element;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicInteger;

class RealElement
implements Element {
    private static final AtomicInteger nextUniqueId = new AtomicInteger(1);
    private final int uniqueId;
    private final String setName;
    private final Element.Type type;
    private final String keyType;

    RealElement(String string, Element.Type type, String string2) {
        this(string, type, string2, nextUniqueId.incrementAndGet());
    }

    RealElement(String string, Element.Type type, String string2, int n) {
        this.uniqueId = n;
        this.setName = string;
        this.type = type;
        this.keyType = string2;
    }

    @Override
    public String setName() {
        return this.setName;
    }

    @Override
    public int uniqueId() {
        return this.uniqueId;
    }

    @Override
    public Element.Type type() {
        return this.type;
    }

    @Override
    public String keyType() {
        return this.keyType;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Element.class;
    }

    @Override
    public String toString() {
        String string = String.valueOf(String.valueOf(Element.class.getName()));
        String string2 = String.valueOf(String.valueOf(this.setName));
        int n = this.uniqueId;
        String string3 = String.valueOf(String.valueOf((Object)this.type));
        String string4 = String.valueOf(String.valueOf(this.keyType));
        return new StringBuilder(49 + string.length() + string2.length() + string3.length() + string4.length()).append("@").append(string).append("(setName=").append(string2).append(",uniqueId=").append(n).append(", type=").append(string3).append(", keyType=").append(string4).append(")").toString();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Element && ((Element)object).setName().equals(this.setName()) && ((Element)object).uniqueId() == this.uniqueId() && ((Element)object).type() == this.type() && ((Element)object).keyType().equals(this.keyType());
    }

    @Override
    public int hashCode() {
        return (127 * "setName".hashCode() ^ this.setName.hashCode()) + (127 * "uniqueId".hashCode() ^ this.uniqueId) + (127 * "type".hashCode() ^ this.type.hashCode()) + (127 * "keyType".hashCode() ^ this.keyType.hashCode());
    }

    static String nameOf(Key<?> key) {
        Annotation annotation = key.getAnnotation();
        Class clazz = key.getAnnotationType();
        if (annotation != null && !Annotations.isMarker((Class)clazz)) {
            return key.getAnnotation().toString();
        }
        if (key.getAnnotationType() != null) {
            String string = String.valueOf(key.getAnnotationType().getName());
            return string.length() != 0 ? "@".concat(string) : new String("@");
        }
        return "";
    }
}

