/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.multibindings;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.MultibindingsTargetVisitor;
import com.google.inject.multibindings.OptionalBinderBinding;
import com.google.inject.multibindings.RealElement;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.Element;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderLookup;
import com.google.inject.spi.ProviderWithDependencies;
import com.google.inject.spi.ProviderWithExtensionVisitor;
import com.google.inject.spi.Toolable;
import com.google.inject.util.Types;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import javax.inject.Qualifier;

public abstract class OptionalBinder<T> {
    private static final Class<?> JAVA_OPTIONAL_CLASS;
    private static final Method JAVA_EMPTY_METHOD;
    private static final Method JAVA_OF_NULLABLE_METHOD;

    private OptionalBinder() {
    }

    public static <T> OptionalBinder<T> newOptionalBinder(Binder binder, Class<T> clazz) {
        return OptionalBinder.newRealOptionalBinder(binder, Key.get(clazz));
    }

    public static <T> OptionalBinder<T> newOptionalBinder(Binder binder, TypeLiteral<T> typeLiteral) {
        return OptionalBinder.newRealOptionalBinder(binder, Key.get(typeLiteral));
    }

    public static <T> OptionalBinder<T> newOptionalBinder(Binder binder, Key<T> key) {
        return OptionalBinder.newRealOptionalBinder(binder, key);
    }

    static <T> RealOptionalBinder<T> newRealOptionalBinder(Binder binder, Key<T> key) {
        binder = binder.skipSources(new Class[]{OptionalBinder.class, RealOptionalBinder.class});
        RealOptionalBinder realOptionalBinder = new RealOptionalBinder(binder, key);
        binder.install(realOptionalBinder);
        return realOptionalBinder;
    }

    static <T> TypeLiteral<Optional<T>> optionalOf(TypeLiteral<T> typeLiteral) {
        return TypeLiteral.get((Type)Types.newParameterizedType(Optional.class, (Type[])new Type[]{typeLiteral.getType()}));
    }

    static <T> TypeLiteral<?> javaOptionalOf(TypeLiteral<T> typeLiteral) {
        Preconditions.checkState((JAVA_OPTIONAL_CLASS != null ? 1 : 0) != 0, (Object)"java.util.Optional not found");
        return TypeLiteral.get((Type)Types.newParameterizedType(JAVA_OPTIONAL_CLASS, (Type[])new Type[]{typeLiteral.getType()}));
    }

    static <T> TypeLiteral<Optional<javax.inject.Provider<T>>> optionalOfJavaxProvider(TypeLiteral<T> typeLiteral) {
        return TypeLiteral.get((Type)Types.newParameterizedType(Optional.class, (Type[])new Type[]{Types.newParameterizedType(javax.inject.Provider.class, (Type[])new Type[]{typeLiteral.getType()})}));
    }

    static <T> TypeLiteral<?> javaOptionalOfJavaxProvider(TypeLiteral<T> typeLiteral) {
        Preconditions.checkState((JAVA_OPTIONAL_CLASS != null ? 1 : 0) != 0, (Object)"java.util.Optional not found");
        return TypeLiteral.get((Type)Types.newParameterizedType(JAVA_OPTIONAL_CLASS, (Type[])new Type[]{Types.newParameterizedType(javax.inject.Provider.class, (Type[])new Type[]{typeLiteral.getType()})}));
    }

    static <T> TypeLiteral<Optional<Provider<T>>> optionalOfProvider(TypeLiteral<T> typeLiteral) {
        return TypeLiteral.get((Type)Types.newParameterizedType(Optional.class, (Type[])new Type[]{Types.newParameterizedType(Provider.class, (Type[])new Type[]{typeLiteral.getType()})}));
    }

    static <T> TypeLiteral<?> javaOptionalOfProvider(TypeLiteral<T> typeLiteral) {
        Preconditions.checkState((JAVA_OPTIONAL_CLASS != null ? 1 : 0) != 0, (Object)"java.util.Optional not found");
        return TypeLiteral.get((Type)Types.newParameterizedType(JAVA_OPTIONAL_CLASS, (Type[])new Type[]{Types.newParameterizedType(Provider.class, (Type[])new Type[]{typeLiteral.getType()})}));
    }

    static <T> Key<Provider<T>> providerOf(Key<T> key) {
        ParameterizedType parameterizedType = Types.providerOf((Type)key.getTypeLiteral().getType());
        return key.ofType((Type)parameterizedType);
    }

    public abstract LinkedBindingBuilder<T> setDefault();

    public abstract LinkedBindingBuilder<T> setBinding();

    static {
        Class<?> clazz = null;
        Method method = null;
        Method method2 = null;
        boolean bl = false;
        try {
            clazz = Class.forName("java.util.Optional");
            method = clazz.getDeclaredMethod("empty", new Class[0]);
            method2 = clazz.getDeclaredMethod("ofNullable", Object.class);
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        JAVA_OPTIONAL_CLASS = bl ? clazz : null;
        JAVA_EMPTY_METHOD = bl ? method : null;
        JAVA_OF_NULLABLE_METHOD = bl ? method2 : null;
    }

    static abstract class BaseAnnotation
    implements Serializable,
    Annotation {
        private final String value;
        private final Class<? extends Annotation> clazz;
        private static final long serialVersionUID = 0L;

        BaseAnnotation(Class<? extends Annotation> clazz, String string) {
            this.clazz = (Class)Preconditions.checkNotNull(clazz, (Object)"clazz");
            this.value = (String)Preconditions.checkNotNull((Object)string, (Object)"value");
        }

        public String value() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return 127 * "value".hashCode() ^ this.value.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof Actual && this.clazz == Actual.class) {
                Actual actual = (Actual)object;
                return this.value.equals(actual.value());
            }
            if (object instanceof Default && this.clazz == Default.class) {
                Default default_ = (Default)object;
                return this.value.equals(default_.value());
            }
            return false;
        }

        @Override
        public String toString() {
            String string;
            String string2 = String.valueOf(String.valueOf(this.clazz.getName()));
            if (this.value.isEmpty()) {
                string = "";
            } else {
                String string3 = String.valueOf(String.valueOf(this.value));
                string = new StringBuilder(8 + string3.length()).append("(value=").append(string3).append(")").toString();
            }
            String string4 = String.valueOf(String.valueOf(string));
            return new StringBuilder(1 + string2.length() + string4.length()).append("@").append(string2).append(string4).toString();
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return this.clazz;
        }
    }

    static class ActualImpl
    extends BaseAnnotation
    implements Actual {
        public ActualImpl(String string) {
            super(Actual.class, string);
        }
    }

    static class DefaultImpl
    extends BaseAnnotation
    implements Default {
        public DefaultImpl(String string) {
            super(Default.class, string);
        }
    }

    static final class RealOptionalBinder<T>
    extends OptionalBinder<T>
    implements Module {
        private final Key<T> typeKey;
        private final Key<Optional<T>> optionalKey;
        private final Key<Optional<javax.inject.Provider<T>>> optionalJavaxProviderKey;
        private final Key<Optional<Provider<T>>> optionalProviderKey;
        private final Provider<Optional<Provider<T>>> optionalProviderT;
        private final Key<T> defaultKey;
        private final Key<T> actualKey;
        private final Key javaOptionalKey;
        private final Key javaOptionalJavaxProviderKey;
        private final Key javaOptionalProviderKey;
        private Binder binder;
        private Binding<T> defaultBinding;
        private Binding<T> actualBinding;
        private Set<Dependency<?>> dependencies;
        private Set<Dependency<?>> providerDependencies;

        private RealOptionalBinder(Binder binder, Key<T> key) {
            this.binder = binder;
            this.typeKey = (Key)Preconditions.checkNotNull(key);
            TypeLiteral typeLiteral = key.getTypeLiteral();
            this.optionalKey = key.ofType(RealOptionalBinder.optionalOf(typeLiteral));
            this.optionalJavaxProviderKey = key.ofType(RealOptionalBinder.optionalOfJavaxProvider(typeLiteral));
            this.optionalProviderKey = key.ofType(RealOptionalBinder.optionalOfProvider(typeLiteral));
            this.optionalProviderT = binder.getProvider(this.optionalProviderKey);
            String string = RealElement.nameOf(key);
            this.defaultKey = Key.get((TypeLiteral)key.getTypeLiteral(), (Annotation)new DefaultImpl(string));
            this.actualKey = Key.get((TypeLiteral)key.getTypeLiteral(), (Annotation)new ActualImpl(string));
            this.dependencies = ImmutableSet.of((Object)Dependency.get((Key)Key.get(Injector.class)));
            this.providerDependencies = ImmutableSet.of((Object)Dependency.get((Key)Key.get(Injector.class)));
            if (JAVA_OPTIONAL_CLASS != null) {
                this.javaOptionalKey = key.ofType(RealOptionalBinder.javaOptionalOf(typeLiteral));
                this.javaOptionalJavaxProviderKey = key.ofType(RealOptionalBinder.javaOptionalOfJavaxProvider(typeLiteral));
                this.javaOptionalProviderKey = key.ofType(RealOptionalBinder.javaOptionalOfProvider(typeLiteral));
            } else {
                this.javaOptionalKey = null;
                this.javaOptionalJavaxProviderKey = null;
                this.javaOptionalProviderKey = null;
            }
        }

        private void addDirectTypeBinding(Binder binder) {
            binder.bind(this.typeKey).toProvider((Provider)new RealDirectTypeProvider());
        }

        Key<T> getKeyForDefaultBinding() {
            Multibinder.checkConfiguration(!this.isInitialized(), "already initialized", new Object[0]);
            this.addDirectTypeBinding(this.binder);
            return this.defaultKey;
        }

        @Override
        public LinkedBindingBuilder<T> setDefault() {
            return this.binder.bind(this.getKeyForDefaultBinding());
        }

        Key<T> getKeyForActualBinding() {
            Multibinder.checkConfiguration(!this.isInitialized(), "already initialized", new Object[0]);
            this.addDirectTypeBinding(this.binder);
            return this.actualKey;
        }

        @Override
        public LinkedBindingBuilder<T> setBinding() {
            return this.binder.bind(this.getKeyForActualBinding());
        }

        public void configure(Binder binder) {
            Multibinder.checkConfiguration(!this.isInitialized(), "OptionalBinder was already initialized", new Object[0]);
            binder.bind(this.optionalProviderKey).toProvider((Provider)new RealOptionalProviderProvider());
            Key<Optional<Provider<T>>> key = this.optionalProviderKey;
            binder.bind(this.optionalJavaxProviderKey).to(key);
            binder.bind(this.optionalKey).toProvider((Provider)new RealOptionalKeyProvider());
            this.bindJava8Optional(binder);
        }

        private void bindJava8Optional(Binder binder) {
            if (JAVA_OPTIONAL_CLASS != null) {
                binder.bind(this.javaOptionalKey).toProvider((Provider)new JavaOptionalProvider());
                binder.bind(this.javaOptionalProviderKey).toProvider((Provider)new JavaOptionalProviderProvider());
                binder.bind(this.javaOptionalJavaxProviderKey).to(this.javaOptionalProviderKey);
            }
        }

        private Binding<?> getActualBinding() {
            if (this.isInitialized()) {
                return this.actualBinding;
            }
            throw new UnsupportedOperationException("getActualBinding() not supported from Elements.getElements, requires an Injector.");
        }

        private Binding<?> getDefaultBinding() {
            if (this.isInitialized()) {
                return this.defaultBinding;
            }
            throw new UnsupportedOperationException("getDefaultBinding() not supported from Elements.getElements, requires an Injector.");
        }

        private boolean containsElement(Element element) {
            Key key;
            if (element instanceof Binding) {
                key = ((Binding)element).getKey();
            } else if (element instanceof ProviderLookup) {
                key = ((ProviderLookup)element).getKey();
            } else {
                return false;
            }
            return key.equals(this.optionalKey) || key.equals(this.optionalProviderKey) || key.equals(this.optionalJavaxProviderKey) || key.equals(this.defaultKey) || key.equals(this.actualKey) || this.matchesJ8Keys(key) || this.matchesTypeKey(element, key);
        }

        private boolean matchesJ8Keys(Key<?> key) {
            if (JAVA_OPTIONAL_CLASS != null) {
                return key.equals((Object)this.javaOptionalKey) || key.equals((Object)this.javaOptionalProviderKey) || key.equals((Object)this.javaOptionalJavaxProviderKey);
            }
            return false;
        }

        private boolean matchesTypeKey(Element element, Key<?> key) {
            return key.equals(this.typeKey) && element instanceof ProviderInstanceBinding && ((ProviderInstanceBinding)element).getUserSuppliedProvider() instanceof RealOptionalBinderProviderWithDependencies;
        }

        private boolean isInitialized() {
            return this.binder == null;
        }

        public boolean equals(Object object) {
            return object instanceof RealOptionalBinder && ((RealOptionalBinder)object).typeKey.equals(this.typeKey);
        }

        public int hashCode() {
            return this.typeKey.hashCode();
        }

        private static abstract class RealOptionalBinderProviderWithDependencies<T>
        implements ProviderWithDependencies<T> {
            private final Object equality;

            public RealOptionalBinderProviderWithDependencies(Object object) {
                this.equality = object;
            }

            public boolean equals(Object object) {
                return this.getClass() == object.getClass() && this.equality.equals(((RealOptionalBinderProviderWithDependencies)object).equality);
            }

            public int hashCode() {
                return this.equality.hashCode();
            }
        }

        final class RealOptionalKeyProvider
        extends RealOptionalBinderProviderWithDependencies<Optional<T>>
        implements Provider<Optional<T>>,
        OptionalBinderBinding<Optional<T>>,
        ProviderWithExtensionVisitor<Optional<T>> {
            private RealOptionalKeyProvider() {
                super(RealOptionalBinder.this.typeKey);
            }

            public Optional<T> get() {
                Optional optional = (Optional)RealOptionalBinder.this.optionalProviderT.get();
                if (optional.isPresent()) {
                    return Optional.fromNullable((Object)((Provider)optional.get()).get());
                }
                return Optional.absent();
            }

            public Set<Dependency<?>> getDependencies() {
                return RealOptionalBinder.this.dependencies;
            }

            public <B, R> R acceptExtensionVisitor(BindingTargetVisitor<B, R> bindingTargetVisitor, ProviderInstanceBinding<? extends B> providerInstanceBinding) {
                if (bindingTargetVisitor instanceof MultibindingsTargetVisitor) {
                    return (R)((MultibindingsTargetVisitor)bindingTargetVisitor).visit(this);
                }
                return (R)bindingTargetVisitor.visit(providerInstanceBinding);
            }

            @Override
            public Key<Optional<T>> getKey() {
                return RealOptionalBinder.this.optionalKey;
            }

            @Override
            public Binding<?> getActualBinding() {
                return RealOptionalBinder.this.getActualBinding();
            }

            @Override
            public Binding<?> getDefaultBinding() {
                return RealOptionalBinder.this.getDefaultBinding();
            }

            @Override
            public boolean containsElement(Element element) {
                return RealOptionalBinder.this.containsElement(element);
            }
        }

        final class RealOptionalProviderProvider
        extends RealOptionalBinderProviderWithDependencies<Optional<Provider<T>>> {
            private Optional<Provider<T>> optional;

            private RealOptionalProviderProvider() {
                super(RealOptionalBinder.this.typeKey);
            }

            @Toolable
            @Inject
            void initialize(Injector injector) {
                RealOptionalBinder.this.binder = null;
                RealOptionalBinder.this.actualBinding = injector.getExistingBinding(RealOptionalBinder.this.actualKey);
                RealOptionalBinder.this.defaultBinding = injector.getExistingBinding(RealOptionalBinder.this.defaultKey);
                Binding binding = injector.getExistingBinding(RealOptionalBinder.this.typeKey);
                Binding binding2 = null;
                if (RealOptionalBinder.this.actualBinding != null) {
                    binding2 = RealOptionalBinder.this.actualBinding;
                } else if (RealOptionalBinder.this.defaultBinding != null) {
                    binding2 = RealOptionalBinder.this.defaultBinding;
                } else if (binding != null) {
                    binding2 = binding;
                    RealOptionalBinder.this.actualBinding = binding;
                }
                if (binding2 != null) {
                    this.optional = Optional.of((Object)binding2.getProvider());
                    RealOptionalBinder.this.dependencies = (Set)ImmutableSet.of((Object)Dependency.get((Key)binding2.getKey()));
                    RealOptionalBinder.this.providerDependencies = (Set)ImmutableSet.of((Object)Dependency.get(OptionalBinder.providerOf(binding2.getKey())));
                } else {
                    this.optional = Optional.absent();
                    RealOptionalBinder.this.dependencies = (Set)ImmutableSet.of();
                    RealOptionalBinder.this.providerDependencies = (Set)ImmutableSet.of();
                }
            }

            public Optional<Provider<T>> get() {
                return this.optional;
            }

            public Set<Dependency<?>> getDependencies() {
                return RealOptionalBinder.this.providerDependencies;
            }
        }

        final class RealDirectTypeProvider
        extends RealOptionalBinderProviderWithDependencies<T> {
            private RealDirectTypeProvider() {
                super(RealOptionalBinder.this.typeKey);
            }

            public T get() {
                Optional optional = (Optional)RealOptionalBinder.this.optionalProviderT.get();
                if (optional.isPresent()) {
                    return ((Provider)optional.get()).get();
                }
                return null;
            }

            public Set<Dependency<?>> getDependencies() {
                return RealOptionalBinder.this.dependencies;
            }
        }

        final class JavaOptionalProviderProvider
        extends RealOptionalBinderProviderWithDependencies {
            private JavaOptionalProviderProvider() {
                super(RealOptionalBinder.this.typeKey);
            }

            public Object get() {
                Optional optional = (Optional)RealOptionalBinder.this.optionalProviderT.get();
                try {
                    if (optional.isPresent()) {
                        return JAVA_OF_NULLABLE_METHOD.invoke((Object)JAVA_OPTIONAL_CLASS, optional.get());
                    }
                    return JAVA_EMPTY_METHOD.invoke((Object)JAVA_OPTIONAL_CLASS, new Object[0]);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new SecurityException(illegalAccessException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalStateException(illegalArgumentException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw Throwables.propagate((Throwable)invocationTargetException.getCause());
                }
            }

            public Set<Dependency<?>> getDependencies() {
                return RealOptionalBinder.this.providerDependencies;
            }
        }

        final class JavaOptionalProvider
        extends RealOptionalBinderProviderWithDependencies
        implements OptionalBinderBinding,
        ProviderWithExtensionVisitor {
            private JavaOptionalProvider() {
                super(RealOptionalBinder.this.typeKey);
            }

            public Object get() {
                Optional optional = (Optional)RealOptionalBinder.this.optionalProviderT.get();
                try {
                    if (optional.isPresent()) {
                        return JAVA_OF_NULLABLE_METHOD.invoke((Object)JAVA_OPTIONAL_CLASS, ((Provider)optional.get()).get());
                    }
                    return JAVA_EMPTY_METHOD.invoke((Object)JAVA_OPTIONAL_CLASS, new Object[0]);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new SecurityException(illegalAccessException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalStateException(illegalArgumentException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw Throwables.propagate((Throwable)invocationTargetException.getCause());
                }
            }

            public Set<Dependency<?>> getDependencies() {
                return RealOptionalBinder.this.dependencies;
            }

            public Object acceptExtensionVisitor(BindingTargetVisitor bindingTargetVisitor, ProviderInstanceBinding providerInstanceBinding) {
                if (bindingTargetVisitor instanceof MultibindingsTargetVisitor) {
                    return ((MultibindingsTargetVisitor)bindingTargetVisitor).visit(this);
                }
                return bindingTargetVisitor.visit(providerInstanceBinding);
            }

            @Override
            public boolean containsElement(Element element) {
                return RealOptionalBinder.this.containsElement(element);
            }

            public Binding getActualBinding() {
                return RealOptionalBinder.this.getActualBinding();
            }

            public Binding getDefaultBinding() {
                return RealOptionalBinder.this.getDefaultBinding();
            }

            public Key getKey() {
                return RealOptionalBinder.this.javaOptionalKey;
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    static @interface Actual {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    static @interface Default {
        public String value();
    }

    static enum Source {
        DEFAULT,
        ACTUAL;

    }
}

