/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.multibindings;

import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.MapKey;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.multibindings.ProvidesIntoMap;
import com.google.inject.multibindings.ProvidesIntoOptional;
import com.google.inject.multibindings.ProvidesIntoSet;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.ModuleAnnotatedMethodScanner;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;

public class MultibindingsScanner {
    private MultibindingsScanner() {
    }

    public static Module asModule() {
        return new AbstractModule(){

            protected void configure() {
                this.binder().scanModulesForAnnotatedMethods((ModuleAnnotatedMethodScanner)Scanner.INSTANCE);
            }
        };
    }

    public static ModuleAnnotatedMethodScanner scanner() {
        return Scanner.INSTANCE;
    }

    private static AnnotationOrError findMapKeyAnnotation(Binder binder, Method method) {
        Annotation annotation = null;
        for (Annotation annotation2 : method.getAnnotations()) {
            MapKey mapKey = annotation2.annotationType().getAnnotation(MapKey.class);
            if (mapKey == null) continue;
            if (annotation != null) {
                binder.addError("Found more than one MapKey annotations on %s.", new Object[]{method});
                return AnnotationOrError.forError();
            }
            if (mapKey.unwrapValue()) {
                try {
                    Method method2 = annotation2.annotationType().getDeclaredMethod("value", new Class[0]);
                    if (method2.getReturnType().isArray()) {
                        binder.addError("Array types are not allowed in a MapKey with unwrapValue=true: %s", new Object[]{annotation2.annotationType()});
                        return AnnotationOrError.forError();
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    binder.addError("No 'value' method in MapKey with unwrapValue=true: %s", new Object[]{annotation2.annotationType()});
                    return AnnotationOrError.forError();
                }
            }
            annotation = annotation2;
        }
        return AnnotationOrError.forPossiblyNullAnnotation(annotation);
    }

    static TypeAndValue<?> typeAndValueOfMapKey(Annotation annotation) {
        if (!annotation.annotationType().getAnnotation(MapKey.class).unwrapValue()) {
            return new TypeAndValue<Annotation>(TypeLiteral.get(annotation.annotationType()), annotation);
        }
        try {
            Method method = annotation.annotationType().getDeclaredMethod("value", new Class[0]);
            method.setAccessible(true);
            TypeLiteral typeLiteral = TypeLiteral.get(annotation.annotationType()).getReturnType(method);
            return new TypeAndValue<Object>(typeLiteral, method.invoke((Object)annotation, new Object[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new IllegalStateException(securityException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalStateException(invocationTargetException);
        }
    }

    private static class TypeAndValue<T> {
        final TypeLiteral<T> type;
        final T value;

        TypeAndValue(TypeLiteral<T> typeLiteral, T t) {
            this.type = typeLiteral;
            this.value = t;
        }
    }

    private static class AnnotationOrError {
        final Annotation annotation;
        final boolean error;

        AnnotationOrError(Annotation annotation, boolean bl) {
            this.annotation = annotation;
            this.error = bl;
        }

        static AnnotationOrError forPossiblyNullAnnotation(Annotation annotation) {
            return new AnnotationOrError(annotation, false);
        }

        static AnnotationOrError forError() {
            return new AnnotationOrError(null, true);
        }
    }

    private static class Scanner
    extends ModuleAnnotatedMethodScanner {
        private static final Scanner INSTANCE = new Scanner();

        private Scanner() {
        }

        public Set<? extends Class<? extends Annotation>> annotationClasses() {
            return ImmutableSet.of(ProvidesIntoSet.class, ProvidesIntoMap.class, ProvidesIntoOptional.class);
        }

        public <T> Key<T> prepareMethod(Binder binder, Annotation annotation, Key<T> key, InjectionPoint injectionPoint) {
            Method method = (Method)injectionPoint.getMember();
            AnnotationOrError annotationOrError = MultibindingsScanner.findMapKeyAnnotation(binder, method);
            if (annotation instanceof ProvidesIntoSet) {
                if (annotationOrError.annotation != null) {
                    binder.addError("Found a MapKey annotation on non map binding at %s.", new Object[]{method});
                }
                return Multibinder.newRealSetBinder(binder, key).getKeyForNewItem();
            }
            if (annotation instanceof ProvidesIntoMap) {
                if (annotationOrError.error) {
                    return key;
                }
                if (annotationOrError.annotation == null) {
                    binder.addError("No MapKey found for map binding at %s.", new Object[]{method});
                    return key;
                }
                TypeAndValue<?> typeAndValue = MultibindingsScanner.typeAndValueOfMapKey(annotationOrError.annotation);
                return MapBinder.newRealMapBinder(binder, typeAndValue.type, key).getKeyForNewValue(typeAndValue.value);
            }
            if (annotation instanceof ProvidesIntoOptional) {
                if (annotationOrError.annotation != null) {
                    binder.addError("Found a MapKey annotation on non map binding at %s.", new Object[]{method});
                }
                switch (((ProvidesIntoOptional)annotation).value()) {
                    case DEFAULT: {
                        return OptionalBinder.newRealOptionalBinder(binder, key).getKeyForDefaultBinding();
                    }
                    case ACTUAL: {
                        return OptionalBinder.newRealOptionalBinder(binder, key).getKeyForActualBinding();
                    }
                }
            }
            String string = String.valueOf(String.valueOf(annotation));
            throw new IllegalStateException(new StringBuilder(20 + string.length()).append("Invalid annotation: ").append(string).toString());
        }
    }
}

