/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.multibindings;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.internal.Errors;
import com.google.inject.multibindings.Element;
import com.google.inject.multibindings.Indexer;
import com.google.inject.multibindings.MultibinderBinding;
import com.google.inject.multibindings.MultibindingsTargetVisitor;
import com.google.inject.multibindings.RealElement;
import com.google.inject.name.Names;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.Message;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderWithDependencies;
import com.google.inject.spi.ProviderWithExtensionVisitor;
import com.google.inject.spi.Toolable;
import com.google.inject.util.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Multibinder<T> {
    private Multibinder() {
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, TypeLiteral<T> typeLiteral) {
        return Multibinder.newRealSetBinder(binder, Key.get(typeLiteral));
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, Class<T> clazz) {
        return Multibinder.newRealSetBinder(binder, Key.get(clazz));
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, TypeLiteral<T> typeLiteral, Annotation annotation) {
        return Multibinder.newRealSetBinder(binder, Key.get(typeLiteral, (Annotation)annotation));
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, Class<T> clazz, Annotation annotation) {
        return Multibinder.newRealSetBinder(binder, Key.get(clazz, (Annotation)annotation));
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, TypeLiteral<T> typeLiteral, Class<? extends Annotation> clazz) {
        return Multibinder.newRealSetBinder(binder, Key.get(typeLiteral, clazz));
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, Key<T> key) {
        return Multibinder.newRealSetBinder(binder, key);
    }

    static <T> RealMultibinder<T> newRealSetBinder(Binder binder, Key<T> key) {
        binder = binder.skipSources(new Class[]{RealMultibinder.class, Multibinder.class});
        RealMultibinder realMultibinder = new RealMultibinder(binder, key.getTypeLiteral(), key.ofType(Multibinder.setOf(key.getTypeLiteral())));
        binder.install(realMultibinder);
        return realMultibinder;
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, Class<T> clazz, Class<? extends Annotation> clazz2) {
        return Multibinder.newSetBinder(binder, Key.get(clazz, clazz2));
    }

    static <T> TypeLiteral<Set<T>> setOf(TypeLiteral<T> typeLiteral) {
        ParameterizedType parameterizedType = Types.setOf((Type)typeLiteral.getType());
        return TypeLiteral.get((Type)parameterizedType);
    }

    static <T> TypeLiteral<Collection<Provider<T>>> collectionOfProvidersOf(TypeLiteral<T> typeLiteral) {
        ParameterizedType parameterizedType = Types.providerOf((Type)typeLiteral.getType());
        ParameterizedType parameterizedType2 = Types.newParameterizedType(Collection.class, (Type[])new Type[]{parameterizedType});
        return TypeLiteral.get((Type)parameterizedType2);
    }

    static <T> TypeLiteral<Collection<javax.inject.Provider<T>>> collectionOfJavaxProvidersOf(TypeLiteral<T> typeLiteral) {
        ParameterizedType parameterizedType = Types.newParameterizedType(javax.inject.Provider.class, (Type[])new Type[]{typeLiteral.getType()});
        ParameterizedType parameterizedType2 = Types.newParameterizedType(Collection.class, (Type[])new Type[]{parameterizedType});
        return TypeLiteral.get((Type)parameterizedType2);
    }

    public abstract Multibinder<T> permitDuplicates();

    public abstract LinkedBindingBuilder<T> addBinding();

    static void checkConfiguration(boolean bl, String string, Object ... objectArray) {
        if (bl) {
            return;
        }
        throw new ConfigurationException((Iterable)ImmutableSet.of((Object)new Message(Errors.format((String)string, (Object[])objectArray))));
    }

    private static <T> ConfigurationException newDuplicateValuesException(Map<T, Binding<T>> map, Binding<T> binding, T t, Binding<T> binding2) {
        String string;
        Object object = Iterables.getOnlyElement((Iterable)Iterables.filter(map.keySet(), (Predicate)Predicates.equalTo(t)));
        String string2 = object.toString();
        if (Objects.equal((Object)string2, (Object)(string = t.toString()))) {
            return new ConfigurationException((Iterable)ImmutableSet.of((Object)new Message(Errors.format((String)"Set injection failed due to duplicated element \"%s\"\n    Bound at %s\n    Bound at %s", (Object[])new Object[]{t, binding2.getSource(), binding.getSource()}))));
        }
        return new ConfigurationException((Iterable)ImmutableSet.of((Object)new Message(Errors.format((String)"Set injection failed due to multiple elements comparing equal:\n    \"%s\"\n        bound at %s\n    \"%s\"\n        bound at %s", (Object[])new Object[]{object, binding2.getSource(), t, binding.getSource()}))));
    }

    static <T> T checkNotNull(T t, String string) {
        if (t != null) {
            return t;
        }
        NullPointerException nullPointerException = new NullPointerException(string);
        throw new ConfigurationException((Iterable)ImmutableSet.of((Object)new Message(nullPointerException.toString(), (Throwable)nullPointerException)));
    }

    private static class PermitDuplicatesModule
    extends AbstractModule {
        private final Key<Boolean> key;

        PermitDuplicatesModule(Key<Boolean> key) {
            this.key = key;
        }

        protected void configure() {
            this.bind(this.key).toInstance((Object)true);
        }

        public boolean equals(Object object) {
            return object instanceof PermitDuplicatesModule && ((PermitDuplicatesModule)((Object)object)).key.equals(this.key);
        }

        public int hashCode() {
            return ((Object)((Object)this)).getClass().hashCode() ^ this.key.hashCode();
        }
    }

    static final class RealMultibinder<T>
    extends Multibinder<T>
    implements Module,
    MultibinderBinding<Set<T>>,
    HasDependencies,
    ProviderWithExtensionVisitor<Set<T>> {
        private final TypeLiteral<T> elementType;
        private final String setName;
        private final Key<Set<T>> setKey;
        private final Key<Collection<Provider<T>>> collectionOfProvidersKey;
        private final Key<Collection<javax.inject.Provider<T>>> collectionOfJavaxProvidersKey;
        private final Key<Boolean> permitDuplicatesKey;
        private Binder binder;
        private ImmutableList<Binding<T>> bindings;
        private Set<Dependency<?>> dependencies;
        private boolean permitDuplicates;

        private RealMultibinder(Binder binder, TypeLiteral<T> typeLiteral, Key<Set<T>> key) {
            this.binder = RealMultibinder.checkNotNull(binder, "binder");
            this.elementType = RealMultibinder.checkNotNull(typeLiteral, "elementType");
            this.setKey = RealMultibinder.checkNotNull(key, "setKey");
            this.collectionOfProvidersKey = key.ofType(RealMultibinder.collectionOfProvidersOf(typeLiteral));
            this.collectionOfJavaxProvidersKey = key.ofType(RealMultibinder.collectionOfJavaxProvidersOf(typeLiteral));
            this.setName = RealElement.nameOf(key);
            this.permitDuplicatesKey = Key.get(Boolean.class, (Annotation)Names.named((String)String.valueOf(this.toString()).concat(" permits duplicates")));
        }

        public void configure(Binder binder) {
            RealMultibinder.checkConfiguration(!this.isInitialized(), "Multibinder was already initialized", new Object[0]);
            binder.bind(this.setKey).toProvider((Provider)this);
            binder.bind(this.collectionOfProvidersKey).toProvider((Provider)new RealMultibinderCollectionOfProvidersProvider());
            Key<Collection<Provider<T>>> key = this.collectionOfProvidersKey;
            binder.bind(this.collectionOfJavaxProvidersKey).to(key);
        }

        @Override
        public Multibinder<T> permitDuplicates() {
            this.binder.install((Module)new PermitDuplicatesModule(this.permitDuplicatesKey));
            return this;
        }

        Key<T> getKeyForNewItem() {
            RealMultibinder.checkConfiguration(!this.isInitialized(), "Multibinder was already initialized", new Object[0]);
            return Key.get(this.elementType, (Annotation)new RealElement(this.setName, Element.Type.MULTIBINDER, ""));
        }

        @Override
        public LinkedBindingBuilder<T> addBinding() {
            return this.binder.bind(this.getKeyForNewItem());
        }

        @Toolable
        @Inject
        void initialize(Injector injector) {
            ArrayList arrayList = Lists.newArrayList();
            HashSet hashSet = Sets.newHashSet();
            Indexer indexer = new Indexer(injector);
            ArrayList arrayList2 = Lists.newArrayList();
            for (Binding binding : injector.findBindingsByType(this.elementType)) {
                Binding binding2;
                if (!this.keyMatches(binding.getKey()) || !hashSet.add((binding2 = binding).acceptTargetVisitor((BindingTargetVisitor)indexer))) continue;
                arrayList.add(binding2);
                arrayList2.add(Dependency.get((Key)binding2.getKey()));
            }
            this.bindings = ImmutableList.copyOf((Collection)arrayList);
            this.dependencies = ImmutableSet.copyOf((Collection)arrayList2);
            this.permitDuplicates = this.permitsDuplicates(injector);
            this.binder = null;
        }

        private static int mapCapacity(int n) {
            if (n < 3) {
                return n + 1;
            }
            if (n < 0x40000000) {
                return (int)((float)n / 0.75f + 1.0f);
            }
            return Integer.MAX_VALUE;
        }

        boolean permitsDuplicates(Injector injector) {
            return injector.getBindings().containsKey(this.permitDuplicatesKey);
        }

        private boolean keyMatches(Key<?> key) {
            return key.getTypeLiteral().equals(this.elementType) && key.getAnnotation() instanceof Element && ((Element)key.getAnnotation()).setName().equals(this.setName) && ((Element)key.getAnnotation()).type() == Element.Type.MULTIBINDER;
        }

        private boolean isInitialized() {
            return this.binder == null;
        }

        public Set<T> get() {
            RealMultibinder.checkConfiguration(this.isInitialized(), "Multibinder is not initialized", new Object[0]);
            LinkedHashMap<Object, Binding> linkedHashMap = new LinkedHashMap<Object, Binding>(RealMultibinder.mapCapacity(this.bindings.size()));
            for (Binding binding : this.bindings) {
                Object object = binding.getProvider().get();
                RealMultibinder.checkConfiguration(object != null, "Set injection failed due to null element bound at: %s", binding.getSource());
                Binding binding2 = linkedHashMap.put(object, binding);
                if (this.permitDuplicates || binding2 == null) continue;
                throw Multibinder.newDuplicateValuesException(linkedHashMap, binding, object, binding2);
            }
            return ImmutableSet.copyOf(linkedHashMap.keySet());
        }

        public <B, V> V acceptExtensionVisitor(BindingTargetVisitor<B, V> bindingTargetVisitor, ProviderInstanceBinding<? extends B> providerInstanceBinding) {
            if (bindingTargetVisitor instanceof MultibindingsTargetVisitor) {
                return ((MultibindingsTargetVisitor)bindingTargetVisitor).visit(this);
            }
            return (V)bindingTargetVisitor.visit(providerInstanceBinding);
        }

        String getSetName() {
            return this.setName;
        }

        @Override
        public TypeLiteral<?> getElementTypeLiteral() {
            return this.elementType;
        }

        @Override
        public Key<Set<T>> getSetKey() {
            return this.setKey;
        }

        @Override
        public List<Binding<?>> getElements() {
            if (this.isInitialized()) {
                return this.bindings;
            }
            throw new UnsupportedOperationException("getElements() not supported for module bindings");
        }

        @Override
        public boolean permitsDuplicates() {
            if (this.isInitialized()) {
                return this.permitDuplicates;
            }
            throw new UnsupportedOperationException("permitsDuplicates() not supported for module bindings");
        }

        @Override
        public boolean containsElement(com.google.inject.spi.Element element) {
            if (element instanceof Binding) {
                Binding binding = (Binding)element;
                return this.keyMatches(binding.getKey()) || binding.getKey().equals(this.permitDuplicatesKey) || binding.getKey().equals(this.setKey) || binding.getKey().equals(this.collectionOfProvidersKey) || binding.getKey().equals(this.collectionOfJavaxProvidersKey);
            }
            return false;
        }

        public Set<Dependency<?>> getDependencies() {
            if (!this.isInitialized()) {
                return ImmutableSet.of((Object)Dependency.get((Key)Key.get(Injector.class)));
            }
            return this.dependencies;
        }

        public boolean equals(Object object) {
            return object instanceof RealMultibinder && ((RealMultibinder)object).setKey.equals(this.setKey);
        }

        public int hashCode() {
            return this.setKey.hashCode();
        }

        public String toString() {
            String string = String.valueOf(String.valueOf(this.setName.isEmpty() ? "" : String.valueOf(this.setName).concat(" ")));
            String string2 = String.valueOf(String.valueOf(this.elementType));
            return new StringBuilder(13 + string.length() + string2.length()).append(string).append("Multibinder<").append(string2).append(">").toString();
        }

        final class RealMultibinderCollectionOfProvidersProvider
        implements ProviderWithDependencies<Collection<Provider<T>>> {
            RealMultibinderCollectionOfProvidersProvider() {
            }

            public Collection<Provider<T>> get() {
                Multibinder.checkConfiguration(RealMultibinder.this.isInitialized(), "Multibinder is not initialized", new Object[0]);
                int n = RealMultibinder.this.bindings.size();
                Object[] objectArray = new Provider[n];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = ((Binding)RealMultibinder.this.bindings.get(i)).getProvider();
                }
                return ImmutableList.copyOf((Object[])objectArray);
            }

            public Set<Dependency<?>> getDependencies() {
                if (!RealMultibinder.this.isInitialized()) {
                    return ImmutableSet.of((Object)Dependency.get((Key)Key.get(Injector.class)));
                }
                ImmutableSet.Builder builder = ImmutableSet.builder();
                for (Dependency dependency : RealMultibinder.this.dependencies) {
                    Key key = dependency.getKey();
                    builder.add((Object)Dependency.get((Key)key.ofType((Type)Types.providerOf((Type)key.getTypeLiteral().getType()))));
                }
                return builder.build();
            }

            Key getCollectionKey() {
                return RealMultibinder.this.collectionOfProvidersKey;
            }

            public boolean equals(Object object) {
                return object instanceof RealMultibinderCollectionOfProvidersProvider && ((RealMultibinderCollectionOfProvidersProvider)object).getCollectionKey().equals((Object)this.getCollectionKey());
            }

            public int hashCode() {
                return this.getCollectionKey().hashCode();
            }
        }
    }
}

