/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.multibindings;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Supplier;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.internal.Errors;
import com.google.inject.multibindings.Element;
import com.google.inject.multibindings.Indexer;
import com.google.inject.multibindings.MapBinderBinding;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.MultibindingsTargetVisitor;
import com.google.inject.multibindings.RealElement;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.Element;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderLookup;
import com.google.inject.spi.ProviderWithDependencies;
import com.google.inject.spi.ProviderWithExtensionVisitor;
import com.google.inject.spi.Toolable;
import com.google.inject.util.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class MapBinder<K, V> {
    private MapBinder() {
    }

    public static <K, V> MapBinder<K, V> newMapBinder(Binder binder, TypeLiteral<K> typeLiteral, TypeLiteral<V> typeLiteral2) {
        binder = binder.skipSources(new Class[]{MapBinder.class, RealMapBinder.class});
        return MapBinder.newRealMapBinder(binder, typeLiteral, typeLiteral2, Key.get(MapBinder.mapOf(typeLiteral, typeLiteral2)), Multibinder.newSetBinder(binder, MapBinder.entryOfProviderOf(typeLiteral, typeLiteral2)));
    }

    public static <K, V> MapBinder<K, V> newMapBinder(Binder binder, Class<K> clazz, Class<V> clazz2) {
        return MapBinder.newMapBinder(binder, TypeLiteral.get(clazz), TypeLiteral.get(clazz2));
    }

    public static <K, V> MapBinder<K, V> newMapBinder(Binder binder, TypeLiteral<K> typeLiteral, TypeLiteral<V> typeLiteral2, Annotation annotation) {
        binder = binder.skipSources(new Class[]{MapBinder.class, RealMapBinder.class});
        return MapBinder.newRealMapBinder(binder, typeLiteral, typeLiteral2, Key.get(MapBinder.mapOf(typeLiteral, typeLiteral2), (Annotation)annotation), Multibinder.newSetBinder(binder, MapBinder.entryOfProviderOf(typeLiteral, typeLiteral2), annotation));
    }

    public static <K, V> MapBinder<K, V> newMapBinder(Binder binder, Class<K> clazz, Class<V> clazz2, Annotation annotation) {
        return MapBinder.newMapBinder(binder, TypeLiteral.get(clazz), TypeLiteral.get(clazz2), annotation);
    }

    public static <K, V> MapBinder<K, V> newMapBinder(Binder binder, TypeLiteral<K> typeLiteral, TypeLiteral<V> typeLiteral2, Class<? extends Annotation> clazz) {
        binder = binder.skipSources(new Class[]{MapBinder.class, RealMapBinder.class});
        return MapBinder.newRealMapBinder(binder, typeLiteral, typeLiteral2, Key.get(MapBinder.mapOf(typeLiteral, typeLiteral2), clazz), Multibinder.newSetBinder(binder, MapBinder.entryOfProviderOf(typeLiteral, typeLiteral2), clazz));
    }

    public static <K, V> MapBinder<K, V> newMapBinder(Binder binder, Class<K> clazz, Class<V> clazz2, Class<? extends Annotation> clazz3) {
        return MapBinder.newMapBinder(binder, TypeLiteral.get(clazz), TypeLiteral.get(clazz2), clazz3);
    }

    static <K, V> TypeLiteral<Map<K, V>> mapOf(TypeLiteral<K> typeLiteral, TypeLiteral<V> typeLiteral2) {
        return TypeLiteral.get((Type)Types.mapOf((Type)typeLiteral.getType(), (Type)typeLiteral2.getType()));
    }

    static <K, V> TypeLiteral<Map<K, Provider<V>>> mapOfProviderOf(TypeLiteral<K> typeLiteral, TypeLiteral<V> typeLiteral2) {
        return TypeLiteral.get((Type)Types.mapOf((Type)typeLiteral.getType(), (Type)Types.providerOf((Type)typeLiteral2.getType())));
    }

    static <K, V> TypeLiteral<Map<K, javax.inject.Provider<V>>> mapOfJavaxProviderOf(TypeLiteral<K> typeLiteral, TypeLiteral<V> typeLiteral2) {
        return TypeLiteral.get((Type)Types.mapOf((Type)typeLiteral.getType(), (Type)Types.newParameterizedType(javax.inject.Provider.class, (Type[])new Type[]{typeLiteral2.getType()})));
    }

    static <K, V> TypeLiteral<Map<K, Set<Provider<V>>>> mapOfSetOfProviderOf(TypeLiteral<K> typeLiteral, TypeLiteral<V> typeLiteral2) {
        return TypeLiteral.get((Type)Types.mapOf((Type)typeLiteral.getType(), (Type)Types.setOf((Type)Types.providerOf((Type)typeLiteral2.getType()))));
    }

    static <K, V> TypeLiteral<Map.Entry<K, Provider<V>>> entryOfProviderOf(TypeLiteral<K> typeLiteral, TypeLiteral<V> typeLiteral2) {
        return TypeLiteral.get((Type)Types.newParameterizedTypeWithOwner(Map.class, Map.Entry.class, (Type[])new Type[]{typeLiteral.getType(), Types.providerOf((Type)typeLiteral2.getType())}));
    }

    static <K, V> RealMapBinder<K, V> newRealMapBinder(Binder binder, TypeLiteral<K> typeLiteral, Key<V> key) {
        binder = binder.skipSources(new Class[]{MapBinder.class, RealMapBinder.class});
        TypeLiteral typeLiteral2 = key.getTypeLiteral();
        return MapBinder.newRealMapBinder(binder, typeLiteral, typeLiteral2, key.ofType(MapBinder.mapOf(typeLiteral, typeLiteral2)), Multibinder.newSetBinder(binder, key.ofType(MapBinder.entryOfProviderOf(typeLiteral, typeLiteral2))));
    }

    private static <K, V> RealMapBinder<K, V> newRealMapBinder(Binder binder, TypeLiteral<K> typeLiteral, TypeLiteral<V> typeLiteral2, Key<Map<K, V>> key, Multibinder<Map.Entry<K, Provider<V>>> multibinder) {
        RealMapBinder realMapBinder = new RealMapBinder(binder, typeLiteral, typeLiteral2, key, multibinder);
        binder.install(realMapBinder);
        return realMapBinder;
    }

    public abstract MapBinder<K, V> permitDuplicates();

    public abstract LinkedBindingBuilder<V> addBinding(K var1);

    static final class RealMapBinder<K, V>
    extends MapBinder<K, V>
    implements Module {
        private final TypeLiteral<K> keyType;
        private final TypeLiteral<V> valueType;
        private final Key<Map<K, V>> mapKey;
        private final Key<Map<K, javax.inject.Provider<V>>> javaxProviderMapKey;
        private final Key<Map<K, Provider<V>>> providerMapKey;
        private final Key<Map<K, Set<V>>> multimapKey;
        private final Key<Map<K, Set<Provider<V>>>> providerMultimapKey;
        private final Multibinder.RealMultibinder<Map.Entry<K, Provider<V>>> entrySetBinder;
        private final Map<K, String> duplicateKeyErrorMessages;
        private Binder binder;
        private boolean permitDuplicates;
        private ImmutableList<Map.Entry<K, Binding<V>>> mapBindings;

        private RealMapBinder(Binder binder, TypeLiteral<K> typeLiteral, TypeLiteral<V> typeLiteral2, Key<Map<K, V>> key, Multibinder<Map.Entry<K, Provider<V>>> multibinder) {
            this.keyType = typeLiteral;
            this.valueType = typeLiteral2;
            this.mapKey = key;
            this.providerMapKey = key.ofType(RealMapBinder.mapOfProviderOf(typeLiteral, typeLiteral2));
            this.javaxProviderMapKey = key.ofType(RealMapBinder.mapOfJavaxProviderOf(typeLiteral, typeLiteral2));
            this.multimapKey = key.ofType(RealMapBinder.mapOf(typeLiteral, Multibinder.setOf(typeLiteral2)));
            this.providerMultimapKey = key.ofType(RealMapBinder.mapOfSetOfProviderOf(typeLiteral, typeLiteral2));
            this.entrySetBinder = (Multibinder.RealMultibinder)multibinder;
            this.binder = binder;
            this.duplicateKeyErrorMessages = Maps.newHashMap();
        }

        void updateDuplicateKeyMessage(K k, String string) {
            this.duplicateKeyErrorMessages.put(k, string);
        }

        @Override
        public MapBinder<K, V> permitDuplicates() {
            this.entrySetBinder.permitDuplicates();
            this.binder.install(new MultimapBinder<K, V>(this.multimapKey, this.providerMultimapKey, this.entrySetBinder.getSetKey()));
            return this;
        }

        Key<V> getKeyForNewValue(K k) {
            Multibinder.checkNotNull(k, "key");
            Multibinder.checkConfiguration(!this.isInitialized(), "MapBinder was already initialized", new Object[0]);
            Key key = Key.get(this.valueType, (Annotation)new RealElement(this.entrySetBinder.getSetName(), Element.Type.MAPBINDER, this.keyType.toString()));
            this.entrySetBinder.addBinding().toProvider(new ProviderMapEntry(k, this.binder.getProvider(key), key));
            return key;
        }

        @Override
        public LinkedBindingBuilder<V> addBinding(K k) {
            return this.binder.bind(this.getKeyForNewValue(k));
        }

        public void configure(Binder binder) {
            Multibinder.checkConfiguration(!this.isInitialized(), "MapBinder was already initialized", new Object[0]);
            ImmutableSet immutableSet = ImmutableSet.of((Object)Dependency.get(this.entrySetBinder.getSetKey()));
            Provider provider = binder.getProvider(this.entrySetBinder.getSetKey());
            binder.bind(this.providerMapKey).toProvider((Provider)new RealProviderMapProvider(immutableSet, provider));
            Key<Map<K, Provider<V>>> key = this.providerMapKey;
            binder.bind(this.javaxProviderMapKey).to(key);
            Provider provider2 = binder.getProvider(this.providerMapKey);
            binder.bind(this.mapKey).toProvider((Provider)new RealMapProvider(immutableSet, provider2));
        }

        boolean containsElement(Element element) {
            Key key;
            if (this.entrySetBinder.containsElement(element)) {
                return true;
            }
            if (element instanceof Binding) {
                key = ((Binding)element).getKey();
            } else if (element instanceof ProviderLookup) {
                key = ((ProviderLookup)element).getKey();
            } else {
                return false;
            }
            return key.equals(this.mapKey) || key.equals(this.providerMapKey) || key.equals(this.javaxProviderMapKey) || key.equals(this.multimapKey) || key.equals(this.providerMultimapKey) || key.equals(this.entrySetBinder.getSetKey()) || this.matchesValueKey(key);
        }

        private boolean matchesValueKey(Key<?> key) {
            return key.getAnnotation() instanceof RealElement && ((RealElement)key.getAnnotation()).setName().equals(this.entrySetBinder.getSetName()) && ((RealElement)key.getAnnotation()).type() == Element.Type.MAPBINDER && ((RealElement)key.getAnnotation()).keyType().equals(this.keyType.toString()) && key.getTypeLiteral().equals(this.valueType);
        }

        private boolean isInitialized() {
            return this.binder == null;
        }

        public boolean equals(Object object) {
            return object instanceof RealMapBinder && ((RealMapBinder)object).mapKey.equals(this.mapKey);
        }

        public int hashCode() {
            return this.mapKey.hashCode();
        }

        private Multimap<K, String> newLinkedKeyArrayValueMultimap() {
            return Multimaps.newListMultimap(new LinkedHashMap(), (Supplier)new Supplier<List<String>>(){

                public List<String> get() {
                    return Lists.newArrayList();
                }
            });
        }

        private static abstract class RealMapBinderProviderWithDependencies<T>
        implements ProviderWithDependencies<T> {
            private final Object equality;

            public RealMapBinderProviderWithDependencies(Object object) {
                this.equality = object;
            }

            public boolean equals(Object object) {
                return this.getClass() == object.getClass() && this.equality.equals(((RealMapBinderProviderWithDependencies)object).equality);
            }

            public int hashCode() {
                return this.equality.hashCode();
            }
        }

        private static abstract class RealMapWithExtensionProvider<T>
        extends RealMapBinderProviderWithDependencies<T>
        implements MapBinderBinding<T>,
        ProviderWithExtensionVisitor<T> {
            public RealMapWithExtensionProvider(Object object) {
                super(object);
            }
        }

        static final class ProviderMapEntry<K, V>
        implements ProviderWithDependencies<Map.Entry<K, Provider<V>>>,
        Map.Entry<K, Provider<V>> {
            private final K key;
            private final Provider<V> provider;
            private final Key<V> valueKey;

            private ProviderMapEntry(K k, Provider<V> provider, Key<V> key) {
                this.key = k;
                this.provider = provider;
                this.valueKey = key;
            }

            public Map.Entry<K, Provider<V>> get() {
                return this;
            }

            public Set<Dependency<?>> getDependencies() {
                return ((HasDependencies)this.provider).getDependencies();
            }

            public Key<V> getValueKey() {
                return this.valueKey;
            }

            @Override
            public K getKey() {
                return this.key;
            }

            @Override
            public Provider<V> getValue() {
                return this.provider;
            }

            @Override
            public Provider<V> setValue(Provider<V> provider) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean equals(Object object) {
                if (object instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    return Objects.equal(this.key, entry.getKey()) && Objects.equal(this.provider, entry.getValue());
                }
                return false;
            }

            @Override
            public int hashCode() {
                return this.key.hashCode() ^ this.provider.hashCode();
            }

            public String toString() {
                String string = String.valueOf(String.valueOf(this.key));
                String string2 = String.valueOf(String.valueOf(this.provider));
                return new StringBuilder(20 + string.length() + string2.length()).append("ProviderMapEntry(").append(string).append(", ").append(string2).append(")").toString();
            }
        }

        static final class ValueProvider<V>
        implements Provider<V> {
            private final Provider<V> delegate;
            private final Binding<V> binding;

            ValueProvider(Provider<V> provider, Binding<V> binding) {
                this.delegate = provider;
                this.binding = binding;
            }

            public V get() {
                return (V)this.delegate.get();
            }

            public Binding<V> getValueBinding() {
                return this.binding;
            }
        }

        static final class MultimapBinder<K, V>
        implements Module {
            private final Key<Map<K, Set<V>>> multimapKey;
            private final Key<Map<K, Set<Provider<V>>>> providerMultimapKey;
            private final Key<Set<Map.Entry<K, Provider<V>>>> entrySetKey;

            public MultimapBinder(Key<Map<K, Set<V>>> key, Key<Map<K, Set<Provider<V>>>> key2, Key<Set<Map.Entry<K, Provider<V>>>> key3) {
                this.multimapKey = key;
                this.providerMultimapKey = key2;
                this.entrySetKey = key3;
            }

            public void configure(Binder binder) {
                ImmutableSet immutableSet = ImmutableSet.of((Object)Dependency.get(this.entrySetKey));
                Provider provider = binder.getProvider(this.entrySetKey);
                binder.bind(this.providerMultimapKey).toProvider((Provider)new RealProviderMultimapProvider(immutableSet, provider));
                Provider provider2 = binder.getProvider(this.providerMultimapKey);
                binder.bind(this.multimapKey).toProvider((Provider)new RealMultimapProvider(immutableSet, provider2));
            }

            public int hashCode() {
                return this.multimapKey.hashCode();
            }

            public boolean equals(Object object) {
                return object instanceof MultimapBinder && ((MultimapBinder)object).multimapKey.equals(this.multimapKey);
            }

            final class RealMultimapProvider
            extends RealMapBinderProviderWithDependencies<Map<K, Set<V>>> {
                private final ImmutableSet<Dependency<?>> dependencies;
                private final Provider<Map<K, Set<Provider<V>>>> multimapProvider;

                RealMultimapProvider(ImmutableSet<Dependency<?>> immutableSet, Provider<Map<K, Set<Provider<V>>>> provider) {
                    super(MultimapBinder.this.multimapKey);
                    this.dependencies = immutableSet;
                    this.multimapProvider = provider;
                }

                public Map<K, Set<V>> get() {
                    ImmutableMap.Builder builder = ImmutableMap.builder();
                    for (Map.Entry entry : ((Map)this.multimapProvider.get()).entrySet()) {
                        Object k = entry.getKey();
                        ImmutableSet.Builder builder2 = ImmutableSet.builder();
                        for (Provider provider : (Set)entry.getValue()) {
                            Object object = provider.get();
                            Multibinder.checkConfiguration(object != null, "Multimap injection failed due to null value for key \"%s\"", k);
                            builder2.add(object);
                        }
                        builder.put(k, (Object)builder2.build());
                    }
                    return builder.build();
                }

                public Set<Dependency<?>> getDependencies() {
                    return this.dependencies;
                }
            }

            final class RealProviderMultimapProvider
            extends RealMapBinderProviderWithDependencies<Map<K, Set<Provider<V>>>> {
                private final ImmutableSet<Dependency<?>> dependencies;
                private final Provider<Set<Map.Entry<K, Provider<V>>>> entrySetProvider;
                private Map<K, Set<Provider<V>>> providerMultimap;

                private RealProviderMultimapProvider(ImmutableSet<Dependency<?>> immutableSet, Provider<Set<Map.Entry<K, Provider<V>>>> provider) {
                    super(MultimapBinder.this.multimapKey);
                    this.dependencies = immutableSet;
                    this.entrySetProvider = provider;
                }

                @Inject
                void initialize(Injector injector) {
                    LinkedHashMap linkedHashMap = new LinkedHashMap();
                    for (Object object : (Set)this.entrySetProvider.get()) {
                        if (!linkedHashMap.containsKey(object.getKey())) {
                            linkedHashMap.put(object.getKey(), ImmutableSet.builder());
                        }
                        ((ImmutableSet.Builder)linkedHashMap.get(object.getKey())).add(object.getValue());
                    }
                    ImmutableMap.Builder builder = ImmutableMap.builder();
                    for (Map.Entry entry : linkedHashMap.entrySet()) {
                        builder.put(entry.getKey(), (Object)((ImmutableSet.Builder)entry.getValue()).build());
                    }
                    this.providerMultimap = builder.build();
                }

                public Map<K, Set<Provider<V>>> get() {
                    return this.providerMultimap;
                }

                public Set<Dependency<?>> getDependencies() {
                    return this.dependencies;
                }
            }
        }

        final class RealMapProvider
        extends RealMapWithExtensionProvider<Map<K, V>> {
            private final ImmutableSet<Dependency<?>> dependencies;
            private final Provider<Map<K, Provider<V>>> mapProvider;

            private RealMapProvider(ImmutableSet<Dependency<?>> immutableSet, Provider<Map<K, Provider<V>>> provider) {
                super(RealMapBinder.this.mapKey);
                this.dependencies = immutableSet;
                this.mapProvider = provider;
            }

            public Map<K, V> get() {
                LinkedHashMap linkedHashMap = new LinkedHashMap((Map)this.mapProvider.get());
                for (Map.Entry entry : linkedHashMap.entrySet()) {
                    ValueProvider valueProvider = (ValueProvider)entry.getValue();
                    Object v = valueProvider.get();
                    Multibinder.checkConfiguration(v != null, "Map injection failed due to null value for key \"%s\", bound at: %s", entry.getKey(), valueProvider.getValueBinding().getSource());
                    entry.setValue(v);
                }
                LinkedHashMap linkedHashMap2 = linkedHashMap;
                return Collections.unmodifiableMap(linkedHashMap2);
            }

            public Set<Dependency<?>> getDependencies() {
                return this.dependencies;
            }

            public <B, R> R acceptExtensionVisitor(BindingTargetVisitor<B, R> bindingTargetVisitor, ProviderInstanceBinding<? extends B> providerInstanceBinding) {
                if (bindingTargetVisitor instanceof MultibindingsTargetVisitor) {
                    return (R)((MultibindingsTargetVisitor)bindingTargetVisitor).visit(this);
                }
                return (R)bindingTargetVisitor.visit(providerInstanceBinding);
            }

            @Override
            public Key<Map<K, V>> getMapKey() {
                return RealMapBinder.this.mapKey;
            }

            @Override
            public TypeLiteral<?> getKeyTypeLiteral() {
                return RealMapBinder.this.keyType;
            }

            @Override
            public TypeLiteral<?> getValueTypeLiteral() {
                return RealMapBinder.this.valueType;
            }

            @Override
            public List<Map.Entry<?, Binding<?>>> getEntries() {
                if (RealMapBinder.this.isInitialized()) {
                    return RealMapBinder.this.mapBindings;
                }
                throw new UnsupportedOperationException("getElements() not supported for module bindings");
            }

            @Override
            public boolean permitsDuplicates() {
                if (RealMapBinder.this.isInitialized()) {
                    return RealMapBinder.this.permitDuplicates;
                }
                throw new UnsupportedOperationException("permitsDuplicates() not supported for module bindings");
            }

            @Override
            public boolean containsElement(Element element) {
                return RealMapBinder.this.containsElement(element);
            }
        }

        final class RealProviderMapProvider
        extends RealMapBinderProviderWithDependencies<Map<K, Provider<V>>> {
            private final ImmutableSet<Dependency<?>> dependencies;
            private final Provider<Set<Map.Entry<K, Provider<V>>>> entrySetProvider;
            private Map<K, Provider<V>> providerMap;

            private RealProviderMapProvider(ImmutableSet<Dependency<?>> immutableSet, Provider<Set<Map.Entry<K, Provider<V>>>> provider) {
                super(RealMapBinder.this.mapKey);
                this.dependencies = immutableSet;
                this.entrySetProvider = provider;
            }

            @Toolable
            @Inject
            void initialize(Injector injector) {
                Object object;
                Object object2;
                RealMapBinder.this.binder = null;
                RealMapBinder.this.permitDuplicates = RealMapBinder.this.entrySetBinder.permitsDuplicates(injector);
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                ArrayList arrayList = Lists.newArrayList();
                Indexer indexer = new Indexer(injector);
                HashMultimap hashMultimap = HashMultimap.create();
                Set set = null;
                for (Object object3 : (Set)this.entrySetProvider.get()) {
                    Map.Entry entry = (ProviderMapEntry)object3;
                    object2 = ((ProviderMapEntry)entry).getValueKey();
                    Object object4 = injector.getBinding(object2);
                    if (!hashMultimap.put(((ProviderMapEntry)entry).getKey(), object4.acceptTargetVisitor((BindingTargetVisitor)indexer))) continue;
                    object = linkedHashMap.put(((ProviderMapEntry)entry).getKey(), new ValueProvider(((ProviderMapEntry)entry).getValue(), object4));
                    if (object != null && !RealMapBinder.this.permitDuplicates) {
                        if (set == null) {
                            set = Sets.newHashSet();
                        }
                        set.add(((ProviderMapEntry)entry).getKey());
                    }
                    arrayList.add(Maps.immutableEntry(((ProviderMapEntry)entry).getKey(), (Object)object4));
                }
                if (set != null) {
                    Object object3;
                    Multimap multimap = RealMapBinder.this.newLinkedKeyArrayValueMultimap();
                    for (Map.Entry entry : arrayList) {
                        if (!set.contains(entry.getKey())) continue;
                        object2 = String.valueOf(String.valueOf(Errors.convert((Object)((Binding)entry.getValue()).getSource())));
                        multimap.put(entry.getKey(), (Object)new StringBuilder(5 + ((String)object2).length()).append("\t at ").append((String)object2).toString());
                    }
                    object3 = new StringBuilder("Map injection failed due to duplicated key ");
                    boolean bl = true;
                    for (Object object4 : multimap.keySet()) {
                        if (bl) {
                            bl = false;
                            if (RealMapBinder.this.duplicateKeyErrorMessages.containsKey(object4)) {
                                ((StringBuilder)object3).setLength(0);
                                ((StringBuilder)object3).append((String)RealMapBinder.this.duplicateKeyErrorMessages.get(object4));
                            } else {
                                object = String.valueOf(String.valueOf(object4));
                                ((StringBuilder)object3).append(new StringBuilder(19 + ((String)object).length()).append("\"").append((String)object).append("\", from bindings:\n").toString());
                            }
                        } else if (RealMapBinder.this.duplicateKeyErrorMessages.containsKey(object4)) {
                            String string = String.valueOf((String)RealMapBinder.this.duplicateKeyErrorMessages.get(object4));
                            ((StringBuilder)object3).append(string.length() != 0 ? "\n and ".concat(string) : new String("\n and "));
                        } else {
                            object = String.valueOf(String.valueOf(object4));
                            ((StringBuilder)object3).append(new StringBuilder(30 + ((String)object).length()).append("\n and key: \"").append((String)object).append("\", from bindings:\n").toString());
                        }
                        Joiner.on((char)'\n').appendTo((StringBuilder)object3, (Iterable)multimap.get(object4)).append("\n");
                    }
                    Multibinder.checkConfiguration(false, ((StringBuilder)object3).toString(), new Object[0]);
                }
                this.providerMap = ImmutableMap.copyOf(linkedHashMap);
                RealMapBinder.this.mapBindings = ImmutableList.copyOf((Collection)arrayList);
            }

            public Map<K, Provider<V>> get() {
                return this.providerMap;
            }

            public Set<Dependency<?>> getDependencies() {
                return this.dependencies;
            }
        }
    }
}

