/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.multibindings;

import com.google.common.base.Objects;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Element;
import com.google.inject.spi.BindingScopingVisitor;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.ConvertedConstantBinding;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.ExposedBinding;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.ProviderBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderKeyBinding;
import com.google.inject.spi.UntargettedBinding;
import java.lang.annotation.Annotation;

class Indexer
extends DefaultBindingTargetVisitor<Object, IndexedBinding>
implements BindingScopingVisitor<Object> {
    final Injector injector;
    private static final Object EAGER_SINGLETON = new Object();

    Indexer(Injector injector) {
        this.injector = injector;
    }

    boolean isIndexable(Binding<?> binding) {
        return binding.getKey().getAnnotation() instanceof Element;
    }

    private Object scope(Binding<?> binding) {
        return binding.acceptScopingVisitor((BindingScopingVisitor)this);
    }

    public IndexedBinding visit(ConstructorBinding<? extends Object> constructorBinding) {
        return new IndexedBinding((Binding<?>)constructorBinding, BindingType.CONSTRUCTOR, this.scope((Binding<?>)constructorBinding), constructorBinding.getConstructor());
    }

    public IndexedBinding visit(ConvertedConstantBinding<? extends Object> convertedConstantBinding) {
        return new IndexedBinding((Binding<?>)convertedConstantBinding, BindingType.CONSTANT, this.scope((Binding<?>)convertedConstantBinding), convertedConstantBinding.getValue());
    }

    public IndexedBinding visit(ExposedBinding<? extends Object> exposedBinding) {
        return new IndexedBinding((Binding<?>)exposedBinding, BindingType.EXPOSED, this.scope((Binding<?>)exposedBinding), exposedBinding);
    }

    public IndexedBinding visit(InstanceBinding<? extends Object> instanceBinding) {
        return new IndexedBinding((Binding<?>)instanceBinding, BindingType.INSTANCE, this.scope((Binding<?>)instanceBinding), instanceBinding.getInstance());
    }

    public IndexedBinding visit(LinkedKeyBinding<? extends Object> linkedKeyBinding) {
        return new IndexedBinding((Binding<?>)linkedKeyBinding, BindingType.LINKED_KEY, this.scope((Binding<?>)linkedKeyBinding), linkedKeyBinding.getLinkedKey());
    }

    public IndexedBinding visit(ProviderBinding<? extends Object> providerBinding) {
        return new IndexedBinding((Binding<?>)providerBinding, BindingType.PROVIDED_BY, this.scope((Binding<?>)providerBinding), this.injector.getBinding(providerBinding.getProvidedKey()));
    }

    public IndexedBinding visit(ProviderInstanceBinding<? extends Object> providerInstanceBinding) {
        return new IndexedBinding((Binding<?>)providerInstanceBinding, BindingType.PROVIDER_INSTANCE, this.scope((Binding<?>)providerInstanceBinding), providerInstanceBinding.getUserSuppliedProvider());
    }

    public IndexedBinding visit(ProviderKeyBinding<? extends Object> providerKeyBinding) {
        return new IndexedBinding((Binding<?>)providerKeyBinding, BindingType.PROVIDER_KEY, this.scope((Binding<?>)providerKeyBinding), providerKeyBinding.getProviderKey());
    }

    public IndexedBinding visit(UntargettedBinding<? extends Object> untargettedBinding) {
        return new IndexedBinding((Binding<?>)untargettedBinding, BindingType.UNTARGETTED, this.scope((Binding<?>)untargettedBinding), null);
    }

    public Object visitEagerSingleton() {
        return EAGER_SINGLETON;
    }

    public Object visitNoScoping() {
        return Scopes.NO_SCOPE;
    }

    public Object visitScope(Scope scope) {
        return scope;
    }

    public Object visitScopeAnnotation(Class<? extends Annotation> clazz) {
        return clazz;
    }

    static class IndexedBinding {
        final String annotationName;
        final Element.Type annotationType;
        final TypeLiteral<?> typeLiteral;
        final Object scope;
        final BindingType type;
        final Object extraEquality;

        IndexedBinding(Binding<?> binding, BindingType bindingType, Object object, Object object2) {
            this.scope = object;
            this.type = bindingType;
            this.extraEquality = object2;
            this.typeLiteral = binding.getKey().getTypeLiteral();
            Element element = (Element)binding.getKey().getAnnotation();
            this.annotationName = element.setName();
            this.annotationType = element.type();
        }

        public boolean equals(Object object) {
            if (!(object instanceof IndexedBinding)) {
                return false;
            }
            IndexedBinding indexedBinding = (IndexedBinding)object;
            return this.type == indexedBinding.type && Objects.equal((Object)this.scope, (Object)indexedBinding.scope) && this.typeLiteral.equals(indexedBinding.typeLiteral) && this.annotationType == indexedBinding.annotationType && this.annotationName.equals(indexedBinding.annotationName) && Objects.equal((Object)this.extraEquality, (Object)indexedBinding.extraEquality);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.type, this.scope, this.typeLiteral, this.annotationType, this.annotationName, this.extraEquality});
        }
    }

    static enum BindingType {
        INSTANCE,
        PROVIDER_INSTANCE,
        PROVIDER_KEY,
        LINKED_KEY,
        UNTARGETTED,
        CONSTRUCTOR,
        CONSTANT,
        EXPOSED,
        PROVIDED_BY;

    }
}

