/*
 * Decompiled with CFR 0.152.
 */
package pl.unizeto.socrates.cryptoagent.crypto.agent.gui;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.awt.AWTException;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.MenuItem;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.unizeto.socrates.cryptoagent.crypto.agent.base.option.Options;
import pl.unizeto.socrates.cryptoagent.crypto.agent.gui.base.d;
import pl.unizeto.socrates.cryptoagent.crypto.agent.gui.base.f;

@Singleton
public class a
extends JFrame
implements d {
    private static final long serialVersionUID = 1L;
    private static final int coU = 5;
    private final Logger log = LoggerFactory.getLogger(a.class);
    private final ResourceBundle bundle;
    private final b coV = new b();
    private final Options options;
    private TrayIcon coW;
    private JProgressBar coX;
    private JLabel coY;
    private JLabel coZ;
    private JLabel cpa;
    private JPanel cpb;
    private JPanel cpc;
    private JPanel cpe;

    @Inject
    public a(Locale locale, @Named(value="server.port") int n, EventBus eventBus, @Named(value="app version") String string, Options options, pl.unizeto.socrates.cryptoagent.crypto.agent.base.c.b b2) {
        this.log.debug("Tworzenie g\u0142\u00f3wnego okna aplikacji");
        this.bundle = pl.unizeto.socrates.cryptoagent.b.a.getBundle((Locale)locale);
        this.options = options;
        this.pB();
        this.sw();
        this.coV.setServerPort(n);
        this.coV.setLicense(this.a(b2.getLicenseInfo()));
        this.coV.setVersion(string);
        eventBus.register((Object)new a());
        this.setLocationRelativeTo(null);
        this.sy();
        if (!options.isSystemTrayEnabled()) {
            this.setDefaultCloseOperation(3);
        }
    }

    private void sw() {
        try {
            this.setIconImage(ImageIO.read(this.getClass().getResourceAsStream("/pl/unizeto/socrates/cryptoagent/crypto/agent/gui/images/icon.png")));
        }
        catch (IOException | IllegalArgumentException exception) {
            this.log.error("B\u0142\u0105d podczas \u0142adowania ikony certum");
            this.log.debug("", (Throwable)exception);
        }
    }

    private String a(pl.unizeto.socrates.cryptoagent.crypto.agent.base.c.a a2) {
        String string = a2.getMessage(this.bundle.getLocale());
        return "<font color='" + (a2.isValid() ? "green" : "red") + "'>" + string + "</font>";
    }

    private void pB() {
        this.cpe = new JPanel();
        this.cpc = new pl.unizeto.socrates.cryptoagent.crypto.agent.gui.base.b();
        this.coZ = new JLabel();
        this.coY = new JLabel();
        this.cpb = new JPanel();
        this.cpa = new JLabel();
        this.coX = new JProgressBar();
        this.setTitle(this.bundle.getString("gui.main.appTitle"));
        this.setPreferredSize(new Dimension(480, 360));
        this.cpe.setLayout(new CardLayout());
        this.coZ.setIcon(new ImageIcon(this.getClass().getResource("/pl/unizeto/socrates/cryptoagent/crypto/agent/gui/images/logo.png")));
        this.coY.setHorizontalAlignment(4);
        this.coY.setText(this.bundle.getString("gui.main.simpleHelpInformation"));
        this.coY.setVerticalAlignment(3);
        GroupLayout groupLayout = new GroupLayout(this.cpc);
        this.cpc.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.coY, -2, 230, -2)).addComponent(this.coZ, -1, 450, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.coZ).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.coY, -1, 184, Short.MAX_VALUE).addContainerGap()));
        this.cpe.add((Component)this.cpc, "DEFAULT");
        this.getContentPane().add((Component)this.cpe, "Center");
        this.cpb.setBorder(BorderFactory.createEtchedBorder());
        this.coX.setPreferredSize(new Dimension(100, 14));
        GroupLayout groupLayout2 = new GroupLayout(this.cpb);
        this.cpb.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.cpa, -1, 348, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.coX, -2, -1, -2).addGap(4, 4, 4)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addGap(2, 2, 2).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.cpa, -1, -1, Short.MAX_VALUE).addComponent(this.coX, -1, -1, Short.MAX_VALUE)).addGap(2, 2, 2)));
        this.getContentPane().add((Component)this.cpb, "South");
        this.pack();
    }

    public void addCard(Component component, String string) {
        Objects.requireNonNull(component);
        EventQueue.invokeLater(() -> {
            this.cpe.add(string, component);
            this.log.debug("Dodaj\u0119 panel {} o nazwie {}", (Object)component, (Object)string);
        });
    }

    public void removeCard(JPanel jPanel) {
        Objects.requireNonNull(jPanel);
        this.cpe.remove(jPanel);
    }

    public void showCard(String string) {
        Objects.requireNonNull(string);
        EventQueue.invokeLater(() -> {
            CardLayout cardLayout = (CardLayout)this.cpe.getLayout();
            cardLayout.show(this.cpe, string);
            if (this.isSilentMode()) {
                this.toFront();
                this.setVisible(true);
                this.setState(0);
                EventQueue.invokeLater(() -> this.sx());
            }
        });
    }

    void sx() {
        try {
            Robot robot = new Robot();
            Point point = MouseInfo.getPointerInfo().getLocation();
            int n = 1024;
            Rectangle rectangle = this.getBounds();
            robot.mouseMove((int)(rectangle.getMaxX() - 5.0), (int)(rectangle.getMaxY() - 5.0));
            robot.mousePress(n);
            robot.mouseRelease(n);
            robot.mouseMove(point.x, point.y);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showDefaultCard() {
        this.showCard("DEFAULT");
        this.revalidate();
    }

    public void showOnceCardAndWait(JPanel jPanel) {
        String string = UUID.randomUUID().toString();
        this.addCard(jPanel, string);
        try {
            this.showCardAndWait(string, () -> null, (f)jPanel);
        }
        finally {
            this.removeCard(jPanel);
        }
    }

    public <T> T showCardAndWait(String string, Supplier<T> supplier, f f2) {
        this.log.debug("Wy\u015bwietlam okno: {}", (Object)string);
        EventQueue.invokeLater(() -> this.showCard(string));
        f2.waitForIt();
        this.showDefaultCard();
        return supplier.get();
    }

    public void setMessage(String string) {
        this.cpa.setText(string);
        if (this.isSilentMode() && string != null) {
            this.coW.displayMessage(this.bundle.getString("gui.main.appTitle"), string, TrayIcon.MessageType.INFO);
        }
    }

    private boolean isSilentMode() {
        return !this.isVisible() && this.coW != null;
    }

    public void setIndeterminate(boolean bl) {
        this.coX.setIndeterminate(bl);
    }

    private void sy() {
        if (this.options.isSystemTrayEnabled() && !SystemTray.isSupported()) {
            this.log.warn("Zasobnik systemowy nie jest wspierany na danej platformie");
            return;
        }
        if (!this.options.isSystemTrayEnabled()) {
            this.log.debug("Tryb zasobnika systemowego jest wy\u0142\u0105czony");
            return;
        }
        SystemTray systemTray = SystemTray.getSystemTray();
        try {
            MenuItem menuItem = new MenuItem(this.bundle.getString("gui.main.systemTray.action.close"));
            menuItem.addActionListener(actionEvent -> System.exit(0));
            MenuItem menuItem2 = new MenuItem(this.bundle.getString("gui.main.systemTray.action.open"));
            menuItem2.addActionListener(actionEvent -> {
                this.setVisible(true);
                this.setState(0);
            });
            PopupMenu popupMenu = new PopupMenu();
            popupMenu.add(menuItem2);
            popupMenu.addSeparator();
            popupMenu.add(menuItem);
            this.coW = new TrayIcon(ImageIO.read(this.getClass().getResourceAsStream("/pl/unizeto/socrates/cryptoagent/crypto/agent/gui/images/system-tray.png")), this.bundle.getString("gui.main.appTitle"), popupMenu);
            this.coW.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1) {
                        a.this.setVisible(true);
                        a.this.setState(0);
                    }
                }
            });
            systemTray.add(this.coW);
        }
        catch (AWTException | IOException exception) {
            this.log.debug("", (Throwable)exception);
        }
    }

    private class b {
        private String version;
        private String cpg;
        private int serverPort;

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String string) {
            this.version = string;
            this.update(this);
        }

        public String getLicense() {
            return this.cpg;
        }

        public void setLicense(String string) {
            this.cpg = string;
            this.update(this);
        }

        public int getServerPort() {
            return this.serverPort;
        }

        public void setServerPort(int n) {
            this.serverPort = n;
            this.update(this);
        }

        public void update(b b2) {
            a.this.coY.setText(MessageFormat.format(a.this.bundle.getString("gui.main.simpleHelpInformation"), b2.getVersion(), b2.getLicense(), b2.getServerPort()));
        }
    }

    private class a {
        private a() {
        }

        @Subscribe
        public void consume(pl.unizeto.socrates.cryptoagent.crypto.agent.base.a.a.a a2) {
            a.this.coV.setServerPort(a2.getPort());
        }
    }
}

