/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.reflect.MemberUtils;

public class ConstructorUtils {
    public static Object invokeConstructor(Class clazz, Object object) {
        return ConstructorUtils.invokeConstructor(clazz, new Object[]{object});
    }

    public static Object invokeConstructor(Class clazz, Object[] objectArray) {
        if (null == objectArray) {
            objectArray = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        return ConstructorUtils.invokeConstructor(clazz, objectArray, classArray);
    }

    public static Object invokeConstructor(Class clazz, Object[] objectArray, Class[] classArray) {
        Constructor constructor;
        if (classArray == null) {
            classArray = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if (objectArray == null) {
            objectArray = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if (null == (constructor = ConstructorUtils.getMatchingAccessibleConstructor(clazz, classArray))) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + clazz.getName());
        }
        return constructor.newInstance(objectArray);
    }

    public static Object invokeExactConstructor(Class clazz, Object object) {
        return ConstructorUtils.invokeExactConstructor(clazz, new Object[]{object});
    }

    public static Object invokeExactConstructor(Class clazz, Object[] objectArray) {
        if (null == objectArray) {
            objectArray = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        int n = objectArray.length;
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        return ConstructorUtils.invokeExactConstructor(clazz, objectArray, classArray);
    }

    public static Object invokeExactConstructor(Class clazz, Object[] objectArray, Class[] classArray) {
        Constructor constructor;
        if (objectArray == null) {
            objectArray = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if (classArray == null) {
            classArray = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if (null == (constructor = ConstructorUtils.getAccessibleConstructor(clazz, classArray))) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + clazz.getName());
        }
        return constructor.newInstance(objectArray);
    }

    public static Constructor getAccessibleConstructor(Class clazz, Class clazz2) {
        return ConstructorUtils.getAccessibleConstructor(clazz, new Class[]{clazz2});
    }

    public static Constructor getAccessibleConstructor(Class clazz, Class[] classArray) {
        try {
            return ConstructorUtils.getAccessibleConstructor(clazz.getConstructor(classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Constructor getAccessibleConstructor(Constructor constructor) {
        return MemberUtils.isAccessible(constructor) && Modifier.isPublic(constructor.getDeclaringClass().getModifiers()) ? constructor : null;
    }

    public static Constructor getMatchingAccessibleConstructor(Class clazz, Class[] classArray) {
        try {
            Constructor constructor = clazz.getConstructor(classArray);
            MemberUtils.setAccessibleWorkaround(constructor);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Constructor constructor = null;
            Constructor<?>[] constructorArray = clazz.getConstructors();
            for (int i = 0; i < constructorArray.length; ++i) {
                Constructor constructor2;
                if (!ClassUtils.isAssignable(classArray, constructorArray[i].getParameterTypes(), true) || (constructor2 = ConstructorUtils.getAccessibleConstructor(constructorArray[i])) == null) continue;
                MemberUtils.setAccessibleWorkaround(constructor2);
                if (constructor != null && MemberUtils.compareParameterTypes(constructor2.getParameterTypes(), constructor.getParameterTypes(), classArray) >= 0) continue;
                constructor = constructor2;
            }
            return constructor;
        }
    }
}

