/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.mutable;

import org.apache.commons.lang.mutable.Mutable;

public class MutableLong
extends Number
implements Comparable,
Mutable {
    private static final long serialVersionUID = 62986528375L;
    private long value;

    public MutableLong() {
    }

    public MutableLong(long l) {
        this.value = l;
    }

    public MutableLong(Number number) {
        this.value = number.longValue();
    }

    public MutableLong(String string) {
        this.value = Long.parseLong(string);
    }

    public Object getValue() {
        return new Long(this.value);
    }

    public void setValue(long l) {
        this.value = l;
    }

    public void setValue(Object object) {
        this.setValue(((Number)object).longValue());
    }

    public void increment() {
        ++this.value;
    }

    public void decrement() {
        --this.value;
    }

    public void add(long l) {
        this.value += l;
    }

    public void add(Number number) {
        this.value += number.longValue();
    }

    public void subtract(long l) {
        this.value -= l;
    }

    public void subtract(Number number) {
        this.value -= number.longValue();
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public Long toLong() {
        return new Long(this.longValue());
    }

    public boolean equals(Object object) {
        if (object instanceof MutableLong) {
            return this.value == ((MutableLong)object).longValue();
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public int compareTo(Object object) {
        MutableLong mutableLong = (MutableLong)object;
        long l = mutableLong.value;
        return this.value < l ? -1 : (this.value == l ? 0 : 1);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

