/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.mutable;

import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.mutable.Mutable;

public class MutableFloat
extends Number
implements Comparable,
Mutable {
    private static final long serialVersionUID = 5787169186L;
    private float value;

    public MutableFloat() {
    }

    public MutableFloat(float f) {
        this.value = f;
    }

    public MutableFloat(Number number) {
        this.value = number.floatValue();
    }

    public MutableFloat(String string) {
        this.value = Float.parseFloat(string);
    }

    public Object getValue() {
        return new Float(this.value);
    }

    public void setValue(float f) {
        this.value = f;
    }

    public void setValue(Object object) {
        this.setValue(((Number)object).floatValue());
    }

    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public void increment() {
        this.value += 1.0f;
    }

    public void decrement() {
        this.value -= 1.0f;
    }

    public void add(float f) {
        this.value += f;
    }

    public void add(Number number) {
        this.value += number.floatValue();
    }

    public void subtract(float f) {
        this.value -= f;
    }

    public void subtract(Number number) {
        this.value -= number.floatValue();
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public Float toFloat() {
        return new Float(this.floatValue());
    }

    public boolean equals(Object object) {
        return object instanceof MutableFloat && Float.floatToIntBits(((MutableFloat)object).value) == Float.floatToIntBits(this.value);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public int compareTo(Object object) {
        MutableFloat mutableFloat = (MutableFloat)object;
        float f = mutableFloat.value;
        return NumberUtils.compare(this.value, f);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

