/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.mutable;

import java.io.Serializable;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.mutable.Mutable;

public class MutableBoolean
implements Serializable,
Comparable,
Mutable {
    private static final long serialVersionUID = -4830728138360036487L;
    private boolean value;

    public MutableBoolean() {
    }

    public MutableBoolean(boolean bl) {
        this.value = bl;
    }

    public MutableBoolean(Boolean bl) {
        this.value = bl;
    }

    public Object getValue() {
        return BooleanUtils.toBooleanObject(this.value);
    }

    public void setValue(boolean bl) {
        this.value = bl;
    }

    public void setValue(Object object) {
        this.setValue((Boolean)object);
    }

    public boolean isTrue() {
        return this.value;
    }

    public boolean isFalse() {
        return !this.value;
    }

    public boolean booleanValue() {
        return this.value;
    }

    public Boolean toBoolean() {
        return BooleanUtils.toBooleanObject(this.value);
    }

    public boolean equals(Object object) {
        if (object instanceof MutableBoolean) {
            return this.value == ((MutableBoolean)object).booleanValue();
        }
        return false;
    }

    public int hashCode() {
        return this.value ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode();
    }

    public int compareTo(Object object) {
        MutableBoolean mutableBoolean = (MutableBoolean)object;
        boolean bl = mutableBoolean.value;
        return this.value == bl ? 0 : (this.value ? 1 : -1);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

