/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.math;

import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.text.StrBuilder;

public abstract class Range {
    public abstract Number getMinimumNumber();

    public long getMinimumLong() {
        return this.getMinimumNumber().longValue();
    }

    public int getMinimumInteger() {
        return this.getMinimumNumber().intValue();
    }

    public double getMinimumDouble() {
        return this.getMinimumNumber().doubleValue();
    }

    public float getMinimumFloat() {
        return this.getMinimumNumber().floatValue();
    }

    public abstract Number getMaximumNumber();

    public long getMaximumLong() {
        return this.getMaximumNumber().longValue();
    }

    public int getMaximumInteger() {
        return this.getMaximumNumber().intValue();
    }

    public double getMaximumDouble() {
        return this.getMaximumNumber().doubleValue();
    }

    public float getMaximumFloat() {
        return this.getMaximumNumber().floatValue();
    }

    public abstract boolean containsNumber(Number var1);

    public boolean containsLong(Number number) {
        if (number == null) {
            return false;
        }
        return this.containsLong(number.longValue());
    }

    public boolean containsLong(long l) {
        return l >= this.getMinimumLong() && l <= this.getMaximumLong();
    }

    public boolean containsInteger(Number number) {
        if (number == null) {
            return false;
        }
        return this.containsInteger(number.intValue());
    }

    public boolean containsInteger(int n) {
        return n >= this.getMinimumInteger() && n <= this.getMaximumInteger();
    }

    public boolean containsDouble(Number number) {
        if (number == null) {
            return false;
        }
        return this.containsDouble(number.doubleValue());
    }

    public boolean containsDouble(double d) {
        int n = NumberUtils.compare(this.getMinimumDouble(), d);
        int n2 = NumberUtils.compare(this.getMaximumDouble(), d);
        return n <= 0 && n2 >= 0;
    }

    public boolean containsFloat(Number number) {
        if (number == null) {
            return false;
        }
        return this.containsFloat(number.floatValue());
    }

    public boolean containsFloat(float f) {
        int n = NumberUtils.compare(this.getMinimumFloat(), f);
        int n2 = NumberUtils.compare(this.getMaximumFloat(), f);
        return n <= 0 && n2 >= 0;
    }

    public boolean containsRange(Range range) {
        if (range == null) {
            return false;
        }
        return this.containsNumber(range.getMinimumNumber()) && this.containsNumber(range.getMaximumNumber());
    }

    public boolean overlapsRange(Range range) {
        if (range == null) {
            return false;
        }
        return range.containsNumber(this.getMinimumNumber()) || range.containsNumber(this.getMaximumNumber()) || this.containsNumber(range.getMinimumNumber());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        Range range = (Range)object;
        return this.getMinimumNumber().equals(range.getMinimumNumber()) && this.getMaximumNumber().equals(range.getMaximumNumber());
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.getClass().hashCode();
        n = 37 * n + this.getMinimumNumber().hashCode();
        n = 37 * n + this.getMaximumNumber().hashCode();
        return n;
    }

    public String toString() {
        StrBuilder strBuilder = new StrBuilder(32);
        strBuilder.append("Range[");
        strBuilder.append(this.getMinimumNumber());
        strBuilder.append(',');
        strBuilder.append(this.getMaximumNumber());
        strBuilder.append(']');
        return strBuilder.toString();
    }
}

