/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.math;

import java.util.Random;

public final class JVMRandom
extends Random {
    private static final long serialVersionUID = 1L;
    private static final Random SHARED_RANDOM = new Random();
    private boolean constructed = true;

    public synchronized void setSeed(long l) {
        if (this.constructed) {
            throw new UnsupportedOperationException();
        }
    }

    public synchronized double nextGaussian() {
        throw new UnsupportedOperationException();
    }

    public void nextBytes(byte[] byArray) {
        throw new UnsupportedOperationException();
    }

    public int nextInt() {
        return this.nextInt(Integer.MAX_VALUE);
    }

    public int nextInt(int n) {
        return SHARED_RANDOM.nextInt(n);
    }

    public long nextLong() {
        return JVMRandom.nextLong(Long.MAX_VALUE);
    }

    public static long nextLong(long l) {
        long l2;
        long l3;
        if (l <= 0L) {
            throw new IllegalArgumentException("Upper bound for nextInt must be positive");
        }
        if ((l & -l) == l) {
            return JVMRandom.next63bits() >> 63 - JVMRandom.bitsRequired(l - 1L);
        }
        while ((l3 = JVMRandom.next63bits()) - (l2 = l3 % l) + (l - 1L) < 0L) {
        }
        return l2;
    }

    public boolean nextBoolean() {
        return SHARED_RANDOM.nextBoolean();
    }

    public float nextFloat() {
        return SHARED_RANDOM.nextFloat();
    }

    public double nextDouble() {
        return SHARED_RANDOM.nextDouble();
    }

    private static long next63bits() {
        return SHARED_RANDOM.nextLong() & Long.MAX_VALUE;
    }

    private static int bitsRequired(long l) {
        long l2 = l;
        int n = 0;
        while (l >= 0L) {
            if (l2 == 0L) {
                return n;
            }
            ++n;
            l <<= 1;
            l2 >>= 1;
        }
        return 64 - n;
    }
}

