/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.CharSetUtils;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang.text.StrBuilder;

public class StringUtils {
    public static final String EMPTY = "";
    public static final int INDEX_NOT_FOUND = -1;
    private static final int PAD_LIMIT = 8192;

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isNotEmpty(String string) {
        return !StringUtils.isEmpty(string);
    }

    public static boolean isBlank(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String string) {
        return !StringUtils.isBlank(string);
    }

    public static String clean(String string) {
        return string == null ? EMPTY : string.trim();
    }

    public static String trim(String string) {
        return string == null ? null : string.trim();
    }

    public static String trimToNull(String string) {
        String string2 = StringUtils.trim(string);
        return StringUtils.isEmpty(string2) ? null : string2;
    }

    public static String trimToEmpty(String string) {
        return string == null ? EMPTY : string.trim();
    }

    public static String strip(String string) {
        return StringUtils.strip(string, null);
    }

    public static String stripToNull(String string) {
        if (string == null) {
            return null;
        }
        return (string = StringUtils.strip(string, null)).length() == 0 ? null : string;
    }

    public static String stripToEmpty(String string) {
        return string == null ? EMPTY : StringUtils.strip(string, null);
    }

    public static String strip(String string, String string2) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        string = StringUtils.stripStart(string, string2);
        return StringUtils.stripEnd(string, string2);
    }

    public static String stripStart(String string, String string2) {
        int n;
        int n2;
        if (string == null || (n2 = string.length()) == 0) {
            return string;
        }
        if (string2 == null) {
            for (n = 0; n != n2 && Character.isWhitespace(string.charAt(n)); ++n) {
            }
        } else {
            if (string2.length() == 0) {
                return string;
            }
            while (n != n2 && string2.indexOf(string.charAt(n)) != -1) {
                ++n;
            }
        }
        return string.substring(n);
    }

    public static String stripEnd(String string, String string2) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return string;
        }
        if (string2 == null) {
            while (n != 0 && Character.isWhitespace(string.charAt(n - 1))) {
                --n;
            }
        } else {
            if (string2.length() == 0) {
                return string;
            }
            while (n != 0 && string2.indexOf(string.charAt(n - 1)) != -1) {
                --n;
            }
        }
        return string.substring(0, n);
    }

    public static String[] stripAll(String[] stringArray) {
        return StringUtils.stripAll(stringArray, null);
    }

    public static String[] stripAll(String[] stringArray, String string) {
        int n;
        if (stringArray == null || (n = stringArray.length) == 0) {
            return stringArray;
        }
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = StringUtils.strip(stringArray[i], string);
        }
        return stringArray2;
    }

    public static boolean equals(String string, String string2) {
        return string == null ? string2 == null : string.equals(string2);
    }

    public static boolean equalsIgnoreCase(String string, String string2) {
        return string == null ? string2 == null : string.equalsIgnoreCase(string2);
    }

    public static int indexOf(String string, char c) {
        if (StringUtils.isEmpty(string)) {
            return -1;
        }
        return string.indexOf(c);
    }

    public static int indexOf(String string, char c, int n) {
        if (StringUtils.isEmpty(string)) {
            return -1;
        }
        return string.indexOf(c, n);
    }

    public static int indexOf(String string, String string2) {
        if (string == null || string2 == null) {
            return -1;
        }
        return string.indexOf(string2);
    }

    public static int ordinalIndexOf(String string, String string2, int n) {
        return StringUtils.ordinalIndexOf(string, string2, n, false);
    }

    private static int ordinalIndexOf(String string, String string2, int n, boolean bl) {
        if (string == null || string2 == null || n <= 0) {
            return -1;
        }
        if (string2.length() == 0) {
            return bl ? string.length() : 0;
        }
        int n2 = 0;
        int n3 = bl ? string.length() : -1;
        do {
            if ((n3 = bl ? string.lastIndexOf(string2, n3 - 1) : string.indexOf(string2, n3 + 1)) >= 0) continue;
            return n3;
        } while (++n2 < n);
        return n3;
    }

    public static int indexOf(String string, String string2, int n) {
        if (string == null || string2 == null) {
            return -1;
        }
        if (string2.length() == 0 && n >= string.length()) {
            return string.length();
        }
        return string.indexOf(string2, n);
    }

    public static int indexOfIgnoreCase(String string, String string2) {
        return StringUtils.indexOfIgnoreCase(string, string2, 0);
    }

    public static int indexOfIgnoreCase(String string, String string2, int n) {
        int n2;
        if (string == null || string2 == null) {
            return -1;
        }
        if (n < 0) {
            n = 0;
        }
        if (n > (n2 = string.length() - string2.length() + 1)) {
            return -1;
        }
        if (string2.length() == 0) {
            return n;
        }
        for (int i = n; i < n2; ++i) {
            if (!string.regionMatches(true, i, string2, 0, string2.length())) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(String string, char c) {
        if (StringUtils.isEmpty(string)) {
            return -1;
        }
        return string.lastIndexOf(c);
    }

    public static int lastIndexOf(String string, char c, int n) {
        if (StringUtils.isEmpty(string)) {
            return -1;
        }
        return string.lastIndexOf(c, n);
    }

    public static int lastIndexOf(String string, String string2) {
        if (string == null || string2 == null) {
            return -1;
        }
        return string.lastIndexOf(string2);
    }

    public static int lastOrdinalIndexOf(String string, String string2, int n) {
        return StringUtils.ordinalIndexOf(string, string2, n, true);
    }

    public static int lastIndexOf(String string, String string2, int n) {
        if (string == null || string2 == null) {
            return -1;
        }
        return string.lastIndexOf(string2, n);
    }

    public static int lastIndexOfIgnoreCase(String string, String string2) {
        if (string == null || string2 == null) {
            return -1;
        }
        return StringUtils.lastIndexOfIgnoreCase(string, string2, string.length());
    }

    public static int lastIndexOfIgnoreCase(String string, String string2, int n) {
        if (string == null || string2 == null) {
            return -1;
        }
        if (n > string.length() - string2.length()) {
            n = string.length() - string2.length();
        }
        if (n < 0) {
            return -1;
        }
        if (string2.length() == 0) {
            return n;
        }
        for (int i = n; i >= 0; --i) {
            if (!string.regionMatches(true, i, string2, 0, string2.length())) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(String string, char c) {
        if (StringUtils.isEmpty(string)) {
            return false;
        }
        return string.indexOf(c) >= 0;
    }

    public static boolean contains(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        return string.indexOf(string2) >= 0;
    }

    public static boolean containsIgnoreCase(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        int n = string2.length();
        int n2 = string.length() - n;
        for (int i = 0; i <= n2; ++i) {
            if (!string.regionMatches(true, i, string2, 0, n)) continue;
            return true;
        }
        return false;
    }

    public static int indexOfAny(String string, char[] cArray) {
        if (StringUtils.isEmpty(string) || ArrayUtils.isEmpty(cArray)) {
            return -1;
        }
        int n = string.length();
        int n2 = n - 1;
        int n3 = cArray.length;
        int n4 = n3 - 1;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            for (int j = 0; j < n3; ++j) {
                if (cArray[j] != c) continue;
                if (i < n2 && j < n4 && CharUtils.isHighSurrogate(c)) {
                    if (cArray[j + 1] != string.charAt(i + 1)) continue;
                    return i;
                }
                return i;
            }
        }
        return -1;
    }

    public static int indexOfAny(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return -1;
        }
        return StringUtils.indexOfAny(string, string2.toCharArray());
    }

    public static boolean containsAny(String string, char[] cArray) {
        if (StringUtils.isEmpty(string) || ArrayUtils.isEmpty(cArray)) {
            return false;
        }
        int n = string.length();
        int n2 = cArray.length;
        int n3 = n - 1;
        int n4 = n2 - 1;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            for (int j = 0; j < n2; ++j) {
                if (cArray[j] != c) continue;
                if (CharUtils.isHighSurrogate(c)) {
                    if (j == n4) {
                        return true;
                    }
                    if (i >= n3 || cArray[j + 1] != string.charAt(i + 1)) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        return StringUtils.containsAny(string, string2.toCharArray());
    }

    public static int indexOfAnyBut(String string, char[] cArray) {
        if (StringUtils.isEmpty(string) || ArrayUtils.isEmpty(cArray)) {
            return -1;
        }
        int n = string.length();
        int n2 = n - 1;
        int n3 = cArray.length;
        int n4 = n3 - 1;
        block0: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            for (int j = 0; j < n3; ++j) {
                if (cArray[j] == c && (i >= n2 || j >= n4 || !CharUtils.isHighSurrogate(c) || cArray[j + 1] == string.charAt(i + 1))) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int indexOfAnyBut(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return -1;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            char c = string.charAt(i);
            boolean bl2 = bl = string2.indexOf(c) >= 0;
            if (i + 1 < n && CharUtils.isHighSurrogate(c)) {
                char c2 = string.charAt(i + 1);
                if (!bl || string2.indexOf(c2) >= 0) continue;
                return i;
            }
            if (bl) continue;
            return i;
        }
        return -1;
    }

    public static boolean containsOnly(String string, char[] cArray) {
        if (cArray == null || string == null) {
            return false;
        }
        if (string.length() == 0) {
            return true;
        }
        if (cArray.length == 0) {
            return false;
        }
        return StringUtils.indexOfAnyBut(string, cArray) == -1;
    }

    public static boolean containsOnly(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        return StringUtils.containsOnly(string, string2.toCharArray());
    }

    public static boolean containsNone(String string, char[] cArray) {
        if (string == null || cArray == null) {
            return true;
        }
        int n = string.length();
        int n2 = n - 1;
        int n3 = cArray.length;
        int n4 = n3 - 1;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            for (int j = 0; j < n3; ++j) {
                if (cArray[j] != c) continue;
                if (CharUtils.isHighSurrogate(c)) {
                    if (j == n4) {
                        return false;
                    }
                    if (i >= n2 || cArray[j + 1] != string.charAt(i + 1)) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public static boolean containsNone(String string, String string2) {
        if (string == null || string2 == null) {
            return true;
        }
        return StringUtils.containsNone(string, string2.toCharArray());
    }

    public static int indexOfAny(String string, String[] stringArray) {
        if (string == null || stringArray == null) {
            return -1;
        }
        int n = stringArray.length;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            if (string2 == null || (n3 = string.indexOf(string2)) == -1 || n3 >= n2) continue;
            n2 = n3;
        }
        return n2 == Integer.MAX_VALUE ? -1 : n2;
    }

    public static int lastIndexOfAny(String string, String[] stringArray) {
        if (string == null || stringArray == null) {
            return -1;
        }
        int n = stringArray.length;
        int n2 = -1;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            if (string2 == null || (n3 = string.lastIndexOf(string2)) <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public static String substring(String string, int n) {
        if (string == null) {
            return null;
        }
        if (n < 0) {
            n = string.length() + n;
        }
        if (n < 0) {
            n = 0;
        }
        if (n > string.length()) {
            return EMPTY;
        }
        return string.substring(n);
    }

    public static String substring(String string, int n, int n2) {
        if (string == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = string.length() + n2;
        }
        if (n < 0) {
            n = string.length() + n;
        }
        if (n2 > string.length()) {
            n2 = string.length();
        }
        if (n > n2) {
            return EMPTY;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        return string.substring(n, n2);
    }

    public static String left(String string, int n) {
        if (string == null) {
            return null;
        }
        if (n < 0) {
            return EMPTY;
        }
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String right(String string, int n) {
        if (string == null) {
            return null;
        }
        if (n < 0) {
            return EMPTY;
        }
        if (string.length() <= n) {
            return string;
        }
        return string.substring(string.length() - n);
    }

    public static String mid(String string, int n, int n2) {
        if (string == null) {
            return null;
        }
        if (n2 < 0 || n > string.length()) {
            return EMPTY;
        }
        if (n < 0) {
            n = 0;
        }
        if (string.length() <= n + n2) {
            return string.substring(n);
        }
        return string.substring(n, n + n2);
    }

    public static String substringBefore(String string, String string2) {
        if (StringUtils.isEmpty(string) || string2 == null) {
            return string;
        }
        if (string2.length() == 0) {
            return EMPTY;
        }
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String substringAfter(String string, String string2) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        if (string2 == null) {
            return EMPTY;
        }
        int n = string.indexOf(string2);
        if (n == -1) {
            return EMPTY;
        }
        return string.substring(n + string2.length());
    }

    public static String substringBeforeLast(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        int n = string.lastIndexOf(string2);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String substringAfterLast(String string, String string2) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        if (StringUtils.isEmpty(string2)) {
            return EMPTY;
        }
        int n = string.lastIndexOf(string2);
        if (n == -1 || n == string.length() - string2.length()) {
            return EMPTY;
        }
        return string.substring(n + string2.length());
    }

    public static String substringBetween(String string, String string2) {
        return StringUtils.substringBetween(string, string2, string2);
    }

    public static String substringBetween(String string, String string2, String string3) {
        int n;
        if (string == null || string2 == null || string3 == null) {
            return null;
        }
        int n2 = string.indexOf(string2);
        if (n2 != -1 && (n = string.indexOf(string3, n2 + string2.length())) != -1) {
            return string.substring(n2 + string2.length(), n);
        }
        return null;
    }

    public static String[] substringsBetween(String string, String string2, String string3) {
        int n;
        int n2;
        if (string == null || StringUtils.isEmpty(string2) || StringUtils.isEmpty(string3)) {
            return null;
        }
        int n3 = string.length();
        if (n3 == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        int n4 = string3.length();
        int n5 = string2.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n6 = 0;
        while (n6 < n3 - n4 && (n2 = string.indexOf(string2, n6)) >= 0 && (n = string.indexOf(string3, n2 += n5)) >= 0) {
            arrayList.add(string.substring(n2, n));
            n6 = n + n4;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String getNestedString(String string, String string2) {
        return StringUtils.substringBetween(string, string2, string2);
    }

    public static String getNestedString(String string, String string2, String string3) {
        return StringUtils.substringBetween(string, string2, string3);
    }

    public static String[] split(String string) {
        return StringUtils.split(string, null, -1);
    }

    public static String[] split(String string, char c) {
        return StringUtils.splitWorker(string, c, false);
    }

    public static String[] split(String string, String string2) {
        return StringUtils.splitWorker(string, string2, -1, false);
    }

    public static String[] split(String string, String string2, int n) {
        return StringUtils.splitWorker(string, string2, n, false);
    }

    public static String[] splitByWholeSeparator(String string, String string2) {
        return StringUtils.splitByWholeSeparatorWorker(string, string2, -1, false);
    }

    public static String[] splitByWholeSeparator(String string, String string2, int n) {
        return StringUtils.splitByWholeSeparatorWorker(string, string2, n, false);
    }

    public static String[] splitByWholeSeparatorPreserveAllTokens(String string, String string2) {
        return StringUtils.splitByWholeSeparatorWorker(string, string2, -1, true);
    }

    public static String[] splitByWholeSeparatorPreserveAllTokens(String string, String string2, int n) {
        return StringUtils.splitByWholeSeparatorWorker(string, string2, n, true);
    }

    private static String[] splitByWholeSeparatorWorker(String string, String string2, int n, boolean bl) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        if (string2 == null || EMPTY.equals(string2)) {
            return StringUtils.splitWorker(string, null, n, bl);
        }
        int n3 = string2.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            n6 = string.indexOf(string2, n5);
            if (n6 > -1) {
                if (n6 > n5) {
                    if (++n4 == n) {
                        n6 = n2;
                        arrayList.add(string.substring(n5));
                        continue;
                    }
                    arrayList.add(string.substring(n5, n6));
                    n5 = n6 + n3;
                    continue;
                }
                if (bl) {
                    if (++n4 == n) {
                        n6 = n2;
                        arrayList.add(string.substring(n5));
                    } else {
                        arrayList.add(EMPTY);
                    }
                }
                n5 = n6 + n3;
                continue;
            }
            arrayList.add(string.substring(n5));
            n6 = n2;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] splitPreserveAllTokens(String string) {
        return StringUtils.splitWorker(string, null, -1, true);
    }

    public static String[] splitPreserveAllTokens(String string, char c) {
        return StringUtils.splitWorker(string, c, true);
    }

    private static String[] splitWorker(String string, char c, boolean bl) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        while (n2 < n) {
            if (string.charAt(n2) == c) {
                if (bl2 || bl) {
                    arrayList.add(string.substring(n3, n2));
                    bl2 = false;
                    bl3 = true;
                }
                n3 = ++n2;
                continue;
            }
            bl3 = false;
            bl2 = true;
            ++n2;
        }
        if (bl2 || bl && bl3) {
            arrayList.add(string.substring(n3, n2));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] splitPreserveAllTokens(String string, String string2) {
        return StringUtils.splitWorker(string, string2, -1, true);
    }

    public static String[] splitPreserveAllTokens(String string, String string2, int n) {
        return StringUtils.splitWorker(string, string2, n, true);
    }

    private static String[] splitWorker(String string, String string2, int n, boolean bl) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string2 == null) {
            while (n4 < n2) {
                if (Character.isWhitespace(string.charAt(n4))) {
                    if (bl2 || bl) {
                        bl3 = true;
                        if (n3++ == n) {
                            n4 = n2;
                            bl3 = false;
                        }
                        arrayList.add(string.substring(n5, n4));
                        bl2 = false;
                    }
                    n5 = ++n4;
                    continue;
                }
                bl3 = false;
                bl2 = true;
                ++n4;
            }
        } else if (string2.length() == 1) {
            char c = string2.charAt(0);
            while (n4 < n2) {
                if (string.charAt(n4) == c) {
                    if (bl2 || bl) {
                        bl3 = true;
                        if (n3++ == n) {
                            n4 = n2;
                            bl3 = false;
                        }
                        arrayList.add(string.substring(n5, n4));
                        bl2 = false;
                    }
                    n5 = ++n4;
                    continue;
                }
                bl3 = false;
                bl2 = true;
                ++n4;
            }
        } else {
            while (n4 < n2) {
                if (string2.indexOf(string.charAt(n4)) >= 0) {
                    if (bl2 || bl) {
                        bl3 = true;
                        if (n3++ == n) {
                            n4 = n2;
                            bl3 = false;
                        }
                        arrayList.add(string.substring(n5, n4));
                        bl2 = false;
                    }
                    n5 = ++n4;
                    continue;
                }
                bl3 = false;
                bl2 = true;
                ++n4;
            }
        }
        if (bl2 || bl && bl3) {
            arrayList.add(string.substring(n5, n4));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] splitByCharacterType(String string) {
        return StringUtils.splitByCharacterType(string, false);
    }

    public static String[] splitByCharacterTypeCamelCase(String string) {
        return StringUtils.splitByCharacterType(string, true);
    }

    private static String[] splitByCharacterType(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        char[] cArray = string.toCharArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = Character.getType(cArray[n]);
        for (int i = n + 1; i < cArray.length; ++i) {
            int n3 = Character.getType(cArray[i]);
            if (n3 == n2) continue;
            if (bl && n3 == 2 && n2 == 1) {
                int n4 = i - 1;
                if (n4 != n) {
                    arrayList.add(new String(cArray, n, n4 - n));
                    n = n4;
                }
            } else {
                arrayList.add(new String(cArray, n, i - n));
                n = i;
            }
            n2 = n3;
        }
        arrayList.add(new String(cArray, n, cArray.length - n));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String concatenate(Object[] objectArray) {
        return StringUtils.join(objectArray, null);
    }

    public static String join(Object[] objectArray) {
        return StringUtils.join(objectArray, null);
    }

    public static String join(Object[] objectArray, char c) {
        if (objectArray == null) {
            return null;
        }
        return StringUtils.join(objectArray, c, 0, objectArray.length);
    }

    public static String join(Object[] objectArray, char c, int n, int n2) {
        if (objectArray == null) {
            return null;
        }
        int n3 = n2 - n;
        if (n3 <= 0) {
            return EMPTY;
        }
        StrBuilder strBuilder = new StrBuilder(n3 *= (objectArray[n] == null ? 16 : objectArray[n].toString().length()) + 1);
        for (int i = n; i < n2; ++i) {
            if (i > n) {
                strBuilder.append(c);
            }
            if (objectArray[i] == null) continue;
            strBuilder.append(objectArray[i]);
        }
        return strBuilder.toString();
    }

    public static String join(Object[] objectArray, String string) {
        if (objectArray == null) {
            return null;
        }
        return StringUtils.join(objectArray, string, 0, objectArray.length);
    }

    public static String join(Object[] objectArray, String string, int n, int n2) {
        int n3;
        if (objectArray == null) {
            return null;
        }
        if (string == null) {
            string = EMPTY;
        }
        if ((n3 = n2 - n) <= 0) {
            return EMPTY;
        }
        StrBuilder strBuilder = new StrBuilder(n3 *= (objectArray[n] == null ? 16 : objectArray[n].toString().length()) + string.length());
        for (int i = n; i < n2; ++i) {
            if (i > n) {
                strBuilder.append(string);
            }
            if (objectArray[i] == null) continue;
            strBuilder.append(objectArray[i]);
        }
        return strBuilder.toString();
    }

    public static String join(Iterator iterator, char c) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object e = iterator.next();
        if (!iterator.hasNext()) {
            return ObjectUtils.toString(e);
        }
        StrBuilder strBuilder = new StrBuilder(256);
        if (e != null) {
            strBuilder.append(e);
        }
        while (iterator.hasNext()) {
            strBuilder.append(c);
            Object e2 = iterator.next();
            if (e2 == null) continue;
            strBuilder.append(e2);
        }
        return strBuilder.toString();
    }

    public static String join(Iterator iterator, String string) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object e = iterator.next();
        if (!iterator.hasNext()) {
            return ObjectUtils.toString(e);
        }
        StrBuilder strBuilder = new StrBuilder(256);
        if (e != null) {
            strBuilder.append(e);
        }
        while (iterator.hasNext()) {
            Object e2;
            if (string != null) {
                strBuilder.append(string);
            }
            if ((e2 = iterator.next()) == null) continue;
            strBuilder.append(e2);
        }
        return strBuilder.toString();
    }

    public static String join(Collection collection, char c) {
        if (collection == null) {
            return null;
        }
        return StringUtils.join(collection.iterator(), c);
    }

    public static String join(Collection collection, String string) {
        if (collection == null) {
            return null;
        }
        return StringUtils.join(collection.iterator(), string);
    }

    public static String deleteSpaces(String string) {
        if (string == null) {
            return null;
        }
        return CharSetUtils.delete(string, " \t\r\n\b");
    }

    public static String deleteWhitespace(String string) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            cArray[n2++] = string.charAt(i);
        }
        if (n2 == n) {
            return string;
        }
        return new String(cArray, 0, n2);
    }

    public static String removeStart(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        if (string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return string;
    }

    public static String removeStartIgnoreCase(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        if (StringUtils.startsWithIgnoreCase(string, string2)) {
            return string.substring(string2.length());
        }
        return string;
    }

    public static String removeEnd(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        if (string.endsWith(string2)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    public static String removeEndIgnoreCase(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        if (StringUtils.endsWithIgnoreCase(string, string2)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    public static String remove(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        return StringUtils.replace(string, string2, EMPTY, -1);
    }

    public static String remove(String string, char c) {
        if (StringUtils.isEmpty(string) || string.indexOf(c) == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == c) continue;
            cArray[n++] = cArray[i];
        }
        return new String(cArray, 0, n);
    }

    public static String replaceOnce(String string, String string2, String string3) {
        return StringUtils.replace(string, string2, string3, 1);
    }

    public static String replace(String string, String string2, String string3) {
        return StringUtils.replace(string, string2, string3, -1);
    }

    public static String replace(String string, String string2, String string3, int n) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2) || string3 == null || n == 0) {
            return string;
        }
        int n2 = 0;
        int n3 = string.indexOf(string2, n2);
        if (n3 == -1) {
            return string;
        }
        int n4 = string2.length();
        int n5 = string3.length() - n4;
        int n6 = n5 = n5 < 0 ? 0 : n5;
        StrBuilder strBuilder = new StrBuilder(string.length() + (n5 *= n < 0 ? 16 : (n > 64 ? 64 : n)));
        while (n3 != -1) {
            strBuilder.append(string.substring(n2, n3)).append(string3);
            n2 = n3 + n4;
            if (--n == 0) break;
            n3 = string.indexOf(string2, n2);
        }
        strBuilder.append(string.substring(n2));
        return strBuilder.toString();
    }

    public static String replaceEach(String string, String[] stringArray, String[] stringArray2) {
        return StringUtils.replaceEach(string, stringArray, stringArray2, false, 0);
    }

    public static String replaceEachRepeatedly(String string, String[] stringArray, String[] stringArray2) {
        int n = stringArray == null ? 0 : stringArray.length;
        return StringUtils.replaceEach(string, stringArray, stringArray2, true, n);
    }

    private static String replaceEach(String string, String[] stringArray, String[] stringArray2, boolean bl, int n) {
        int n2;
        int n3;
        if (string == null || string.length() == 0 || stringArray == null || stringArray.length == 0 || stringArray2 == null || stringArray2.length == 0) {
            return string;
        }
        if (n < 0) {
            throw new IllegalStateException("TimeToLive of " + n + " is less than 0: " + string);
        }
        int n4 = stringArray.length;
        int n5 = stringArray2.length;
        if (n4 != n5) {
            throw new IllegalArgumentException("Search and Replace array lengths don't match: " + n4 + " vs " + n5);
        }
        boolean[] blArray = new boolean[n4];
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        for (n3 = 0; n3 < n4; ++n3) {
            if (blArray[n3] || stringArray[n3] == null || stringArray[n3].length() == 0 || stringArray2[n3] == null) continue;
            n8 = string.indexOf(stringArray[n3]);
            if (n8 == -1) {
                blArray[n3] = true;
                continue;
            }
            if (n6 != -1 && n8 >= n6) continue;
            n6 = n8;
            n7 = n3;
        }
        if (n6 == -1) {
            return string;
        }
        n3 = 0;
        int n9 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray2[i] == null || (n2 = stringArray2[i].length() - stringArray[i].length()) <= 0) continue;
            n9 += 3 * n2;
        }
        n9 = Math.min(n9, string.length() / 5);
        StrBuilder strBuilder = new StrBuilder(string.length() + n9);
        while (n6 != -1) {
            for (n2 = n3; n2 < n6; ++n2) {
                strBuilder.append(string.charAt(n2));
            }
            strBuilder.append(stringArray2[n7]);
            n3 = n6 + stringArray[n7].length();
            n6 = -1;
            n7 = -1;
            n8 = -1;
            for (n2 = 0; n2 < n4; ++n2) {
                if (blArray[n2] || stringArray[n2] == null || stringArray[n2].length() == 0 || stringArray2[n2] == null) continue;
                n8 = string.indexOf(stringArray[n2], n3);
                if (n8 == -1) {
                    blArray[n2] = true;
                    continue;
                }
                if (n6 != -1 && n8 >= n6) continue;
                n6 = n8;
                n7 = n2;
            }
        }
        n2 = string.length();
        for (int i = n3; i < n2; ++i) {
            strBuilder.append(string.charAt(i));
        }
        String string2 = strBuilder.toString();
        if (!bl) {
            return string2;
        }
        return StringUtils.replaceEach(string2, stringArray, stringArray2, bl, n - 1);
    }

    public static String replaceChars(String string, char c, char c2) {
        if (string == null) {
            return null;
        }
        return string.replace(c, c2);
    }

    public static String replaceChars(String string, String string2, String string3) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        if (string3 == null) {
            string3 = EMPTY;
        }
        boolean bl = false;
        int n = string3.length();
        int n2 = string.length();
        StrBuilder strBuilder = new StrBuilder(n2);
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            int n3 = string2.indexOf(c);
            if (n3 >= 0) {
                bl = true;
                if (n3 >= n) continue;
                strBuilder.append(string3.charAt(n3));
                continue;
            }
            strBuilder.append(c);
        }
        if (bl) {
            return strBuilder.toString();
        }
        return string;
    }

    public static String overlayString(String string, String string2, int n, int n2) {
        return new StrBuilder(n + string2.length() + string.length() - n2 + 1).append(string.substring(0, n)).append(string2).append(string.substring(n2)).toString();
    }

    public static String overlay(String string, String string2, int n, int n2) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = EMPTY;
        }
        int n3 = string.length();
        if (n < 0) {
            n = 0;
        }
        if (n > n3) {
            n = n3;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        if (n > n2) {
            int n4 = n;
            n = n2;
            n2 = n4;
        }
        return new StrBuilder(n3 + n - n2 + string2.length() + 1).append(string.substring(0, n)).append(string2).append(string.substring(n2)).toString();
    }

    public static String chomp(String string) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        if (string.length() == 1) {
            char c = string.charAt(0);
            if (c == '\r' || c == '\n') {
                return EMPTY;
            }
            return string;
        }
        int n = string.length() - 1;
        char c = string.charAt(n);
        if (c == '\n') {
            if (string.charAt(n - 1) == '\r') {
                --n;
            }
        } else if (c != '\r') {
            ++n;
        }
        return string.substring(0, n);
    }

    public static String chomp(String string, String string2) {
        if (StringUtils.isEmpty(string) || string2 == null) {
            return string;
        }
        if (string.endsWith(string2)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    public static String chompLast(String string) {
        return StringUtils.chompLast(string, "\n");
    }

    public static String chompLast(String string, String string2) {
        if (string.length() == 0) {
            return string;
        }
        String string3 = string.substring(string.length() - string2.length());
        if (string2.equals(string3)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    public static String getChomp(String string, String string2) {
        int n = string.lastIndexOf(string2);
        if (n == string.length() - string2.length()) {
            return string2;
        }
        if (n != -1) {
            return string.substring(n);
        }
        return EMPTY;
    }

    public static String prechomp(String string, String string2) {
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        return string.substring(n + string2.length());
    }

    public static String getPrechomp(String string, String string2) {
        int n = string.indexOf(string2);
        if (n == -1) {
            return EMPTY;
        }
        return string.substring(0, n + string2.length());
    }

    public static String chop(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n < 2) {
            return EMPTY;
        }
        int n2 = n - 1;
        String string2 = string.substring(0, n2);
        char c = string.charAt(n2);
        if (c == '\n' && string2.charAt(n2 - 1) == '\r') {
            return string2.substring(0, n2 - 1);
        }
        return string2;
    }

    public static String chopNewline(String string) {
        int n = string.length() - 1;
        if (n <= 0) {
            return EMPTY;
        }
        char c = string.charAt(n);
        if (c == '\n') {
            if (string.charAt(n - 1) == '\r') {
                --n;
            }
        } else {
            ++n;
        }
        return string.substring(0, n);
    }

    public static String escape(String string) {
        return StringEscapeUtils.escapeJava(string);
    }

    public static String repeat(String string, int n) {
        if (string == null) {
            return null;
        }
        if (n <= 0) {
            return EMPTY;
        }
        int n2 = string.length();
        if (n == 1 || n2 == 0) {
            return string;
        }
        if (n2 == 1 && n <= 8192) {
            return StringUtils.padding(n, string.charAt(0));
        }
        int n3 = n2 * n;
        switch (n2) {
            case 1: {
                char c = string.charAt(0);
                char[] cArray = new char[n3];
                for (int i = n - 1; i >= 0; --i) {
                    cArray[i] = c;
                }
                return new String(cArray);
            }
            case 2: {
                char c = string.charAt(0);
                char c2 = string.charAt(1);
                char[] cArray = new char[n3];
                for (int i = n * 2 - 2; i >= 0; --i) {
                    cArray[i] = c;
                    cArray[i + 1] = c2;
                    --i;
                }
                return new String(cArray);
            }
        }
        StrBuilder strBuilder = new StrBuilder(n3);
        for (int i = 0; i < n; ++i) {
            strBuilder.append(string);
        }
        return strBuilder.toString();
    }

    public static String repeat(String string, String string2, int n) {
        if (string == null || string2 == null) {
            return StringUtils.repeat(string, n);
        }
        String string3 = StringUtils.repeat(string + string2, n);
        return StringUtils.removeEnd(string3, string2);
    }

    private static String padding(int n, char c) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Cannot pad a negative amount: " + n);
        }
        char[] cArray = new char[n];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = c;
        }
        return new String(cArray);
    }

    public static String rightPad(String string, int n) {
        return StringUtils.rightPad(string, n, ' ');
    }

    public static String rightPad(String string, int n, char c) {
        if (string == null) {
            return null;
        }
        int n2 = n - string.length();
        if (n2 <= 0) {
            return string;
        }
        if (n2 > 8192) {
            return StringUtils.rightPad(string, n, String.valueOf(c));
        }
        return string.concat(StringUtils.padding(n2, c));
    }

    public static String rightPad(String string, int n, String string2) {
        if (string == null) {
            return null;
        }
        if (StringUtils.isEmpty(string2)) {
            string2 = " ";
        }
        int n2 = string2.length();
        int n3 = string.length();
        int n4 = n - n3;
        if (n4 <= 0) {
            return string;
        }
        if (n2 == 1 && n4 <= 8192) {
            return StringUtils.rightPad(string, n, string2.charAt(0));
        }
        if (n4 == n2) {
            return string.concat(string2);
        }
        if (n4 < n2) {
            return string.concat(string2.substring(0, n4));
        }
        char[] cArray = new char[n4];
        char[] cArray2 = string2.toCharArray();
        for (int i = 0; i < n4; ++i) {
            cArray[i] = cArray2[i % n2];
        }
        return string.concat(new String(cArray));
    }

    public static String leftPad(String string, int n) {
        return StringUtils.leftPad(string, n, ' ');
    }

    public static String leftPad(String string, int n, char c) {
        if (string == null) {
            return null;
        }
        int n2 = n - string.length();
        if (n2 <= 0) {
            return string;
        }
        if (n2 > 8192) {
            return StringUtils.leftPad(string, n, String.valueOf(c));
        }
        return StringUtils.padding(n2, c).concat(string);
    }

    public static String leftPad(String string, int n, String string2) {
        if (string == null) {
            return null;
        }
        if (StringUtils.isEmpty(string2)) {
            string2 = " ";
        }
        int n2 = string2.length();
        int n3 = string.length();
        int n4 = n - n3;
        if (n4 <= 0) {
            return string;
        }
        if (n2 == 1 && n4 <= 8192) {
            return StringUtils.leftPad(string, n, string2.charAt(0));
        }
        if (n4 == n2) {
            return string2.concat(string);
        }
        if (n4 < n2) {
            return string2.substring(0, n4).concat(string);
        }
        char[] cArray = new char[n4];
        char[] cArray2 = string2.toCharArray();
        for (int i = 0; i < n4; ++i) {
            cArray[i] = cArray2[i % n2];
        }
        return new String(cArray).concat(string);
    }

    public static int length(String string) {
        return string == null ? 0 : string.length();
    }

    public static String center(String string, int n) {
        return StringUtils.center(string, n, ' ');
    }

    public static String center(String string, int n, char c) {
        if (string == null || n <= 0) {
            return string;
        }
        int n2 = string.length();
        int n3 = n - n2;
        if (n3 <= 0) {
            return string;
        }
        string = StringUtils.leftPad(string, n2 + n3 / 2, c);
        string = StringUtils.rightPad(string, n, c);
        return string;
    }

    public static String center(String string, int n, String string2) {
        int n2;
        int n3;
        if (string == null || n <= 0) {
            return string;
        }
        if (StringUtils.isEmpty(string2)) {
            string2 = " ";
        }
        if ((n3 = n - (n2 = string.length())) <= 0) {
            return string;
        }
        string = StringUtils.leftPad(string, n2 + n3 / 2, string2);
        string = StringUtils.rightPad(string, n, string2);
        return string;
    }

    public static String upperCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toUpperCase();
    }

    public static String upperCase(String string, Locale locale) {
        if (string == null) {
            return null;
        }
        return string.toUpperCase(locale);
    }

    public static String lowerCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase();
    }

    public static String lowerCase(String string, Locale locale) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase(locale);
    }

    public static String capitalize(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return string;
        }
        return new StrBuilder(n).append(Character.toTitleCase(string.charAt(0))).append(string.substring(1)).toString();
    }

    public static String capitalise(String string) {
        return StringUtils.capitalize(string);
    }

    public static String uncapitalize(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return string;
        }
        return new StrBuilder(n).append(Character.toLowerCase(string.charAt(0))).append(string.substring(1)).toString();
    }

    public static String uncapitalise(String string) {
        return StringUtils.uncapitalize(string);
    }

    public static String swapCase(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return string;
        }
        StrBuilder strBuilder = new StrBuilder(n);
        char c = '\u0000';
        for (int i = 0; i < n; ++i) {
            c = string.charAt(i);
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            } else if (Character.isTitleCase(c)) {
                c = Character.toLowerCase(c);
            } else if (Character.isLowerCase(c)) {
                c = Character.toUpperCase(c);
            }
            strBuilder.append(c);
        }
        return strBuilder.toString();
    }

    public static String capitaliseAllWords(String string) {
        return WordUtils.capitalize(string);
    }

    public static int countMatches(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(string2, n2)) != -1) {
            ++n;
            n2 += string2.length();
        }
        return n;
    }

    public static boolean isAlpha(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isLetter(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaSpace(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isLetter(string.charAt(i)) || string.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumeric(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isLetterOrDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumericSpace(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isLetterOrDigit(string.charAt(i)) || string.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isAsciiPrintable(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (CharUtils.isAsciiPrintable(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumericSpace(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(string.charAt(i)) || string.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllLowerCase(String string) {
        if (string == null || StringUtils.isEmpty(string)) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isLowerCase(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllUpperCase(String string) {
        if (string == null || StringUtils.isEmpty(string)) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isUpperCase(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String defaultString(String string) {
        return string == null ? EMPTY : string;
    }

    public static String defaultString(String string, String string2) {
        return string == null ? string2 : string;
    }

    public static String defaultIfBlank(String string, String string2) {
        return StringUtils.isBlank(string) ? string2 : string;
    }

    public static String defaultIfEmpty(String string, String string2) {
        return StringUtils.isEmpty(string) ? string2 : string;
    }

    public static String reverse(String string) {
        if (string == null) {
            return null;
        }
        return new StrBuilder(string).reverse().toString();
    }

    public static String reverseDelimited(String string, char c) {
        if (string == null) {
            return null;
        }
        Object[] objectArray = StringUtils.split(string, c);
        ArrayUtils.reverse(objectArray);
        return StringUtils.join(objectArray, c);
    }

    public static String reverseDelimitedString(String string, String string2) {
        if (string == null) {
            return null;
        }
        Object[] objectArray = StringUtils.split(string, string2);
        ArrayUtils.reverse(objectArray);
        if (string2 == null) {
            return StringUtils.join(objectArray, ' ');
        }
        return StringUtils.join(objectArray, string2);
    }

    public static String abbreviate(String string, int n) {
        return StringUtils.abbreviate(string, 0, n);
    }

    public static String abbreviate(String string, int n, int n2) {
        if (string == null) {
            return null;
        }
        if (n2 < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (string.length() <= n2) {
            return string;
        }
        if (n > string.length()) {
            n = string.length();
        }
        if (string.length() - n < n2 - 3) {
            n = string.length() - (n2 - 3);
        }
        if (n <= 4) {
            return string.substring(0, n2 - 3) + "...";
        }
        if (n2 < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (n + (n2 - 3) < string.length()) {
            return "..." + StringUtils.abbreviate(string.substring(n), n2 - 3);
        }
        return "..." + string.substring(string.length() - (n2 - 3));
    }

    public static String abbreviateMiddle(String string, String string2, int n) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        if (n >= string.length() || n < string2.length() + 2) {
            return string;
        }
        int n2 = n - string2.length();
        int n3 = n2 / 2 + n2 % 2;
        int n4 = string.length() - n2 / 2;
        StrBuilder strBuilder = new StrBuilder(n);
        strBuilder.append(string.substring(0, n3));
        strBuilder.append(string2);
        strBuilder.append(string.substring(n4));
        return strBuilder.toString();
    }

    public static String difference(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        int n = StringUtils.indexOfDifference(string, string2);
        if (n == -1) {
            return EMPTY;
        }
        return string2.substring(n);
    }

    public static int indexOfDifference(String string, String string2) {
        int n;
        if (string == string2) {
            return -1;
        }
        if (string == null || string2 == null) {
            return 0;
        }
        for (n = 0; n < string.length() && n < string2.length() && string.charAt(n) == string2.charAt(n); ++n) {
        }
        if (n < string2.length() || n < string.length()) {
            return n;
        }
        return -1;
    }

    public static int indexOfDifference(String[] stringArray) {
        int n;
        if (stringArray == null || stringArray.length <= 1) {
            return -1;
        }
        boolean bl = false;
        boolean bl2 = true;
        int n2 = stringArray.length;
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            if (stringArray[n] == null) {
                bl = true;
                n3 = 0;
                continue;
            }
            bl2 = false;
            n3 = Math.min(stringArray[n].length(), n3);
            n4 = Math.max(stringArray[n].length(), n4);
        }
        if (bl2 || n4 == 0 && !bl) {
            return -1;
        }
        if (n3 == 0) {
            return 0;
        }
        n = -1;
        for (int i = 0; i < n3; ++i) {
            char c = stringArray[0].charAt(i);
            for (int j = 1; j < n2; ++j) {
                if (stringArray[j].charAt(i) == c) continue;
                n = i;
                break;
            }
            if (n != -1) break;
        }
        if (n == -1 && n3 != n4) {
            return n3;
        }
        return n;
    }

    public static String getCommonPrefix(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return EMPTY;
        }
        int n = StringUtils.indexOfDifference(stringArray);
        if (n == -1) {
            if (stringArray[0] == null) {
                return EMPTY;
            }
            return stringArray[0];
        }
        if (n == 0) {
            return EMPTY;
        }
        return stringArray[0].substring(0, n);
    }

    public static int getLevenshteinDistance(String string, String string2) {
        int n;
        Object object;
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n2 = string.length();
        int n3 = string2.length();
        if (n2 == 0) {
            return n3;
        }
        if (n3 == 0) {
            return n2;
        }
        if (n2 > n3) {
            object = string;
            string = string2;
            string2 = object;
            n2 = n3;
            n3 = string2.length();
        }
        object = new int[n2 + 1];
        Object object2 = new int[n2 + 1];
        for (n = 0; n <= n2; ++n) {
            object[n] = n;
        }
        for (int i = 1; i <= n3; ++i) {
            char c = string2.charAt(i - 1);
            object2[0] = i;
            for (n = 1; n <= n2; ++n) {
                boolean bl = string.charAt(n - 1) != c;
                object2[n] = Math.min(Math.min(object2[n - 1] + 1, (int)(object[n] + true)), (int)(object[n - 1] + bl));
            }
            Object object3 = object;
            object = object2;
            object2 = object3;
        }
        return (int)object[n2];
    }

    public static boolean startsWith(String string, String string2) {
        return StringUtils.startsWith(string, string2, false);
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        return StringUtils.startsWith(string, string2, true);
    }

    private static boolean startsWith(String string, String string2, boolean bl) {
        if (string == null || string2 == null) {
            return string == null && string2 == null;
        }
        if (string2.length() > string.length()) {
            return false;
        }
        return string.regionMatches(bl, 0, string2, 0, string2.length());
    }

    public static boolean startsWithAny(String string, String[] stringArray) {
        if (StringUtils.isEmpty(string) || ArrayUtils.isEmpty(stringArray)) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!StringUtils.startsWith(string, string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWith(String string, String string2) {
        return StringUtils.endsWith(string, string2, false);
    }

    public static boolean endsWithIgnoreCase(String string, String string2) {
        return StringUtils.endsWith(string, string2, true);
    }

    private static boolean endsWith(String string, String string2, boolean bl) {
        if (string == null || string2 == null) {
            return string == null && string2 == null;
        }
        if (string2.length() > string.length()) {
            return false;
        }
        int n = string.length() - string2.length();
        return string.regionMatches(bl, n, string2, 0, string2.length());
    }

    public static String normalizeSpace(String string) {
        if ((string = StringUtils.strip(string)) == null || string.length() <= 2) {
            return string;
        }
        StrBuilder strBuilder = new StrBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                if (i <= 0 || Character.isWhitespace(string.charAt(i - 1))) continue;
                strBuilder.append(' ');
                continue;
            }
            strBuilder.append(c);
        }
        return strBuilder.toString();
    }

    public static boolean endsWithAny(String string, String[] stringArray) {
        if (StringUtils.isEmpty(string) || ArrayUtils.isEmpty(stringArray)) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!StringUtils.endsWith(string, string2)) continue;
            return true;
        }
        return false;
    }
}

