/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.lang.StringUtils;

public final class NumberUtils {
    public static int stringToInt(String string) {
        return NumberUtils.stringToInt(string, 0);
    }

    public static int stringToInt(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static Number createNumber(String string) {
        Number number;
        String string2;
        String string3;
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            throw new NumberFormatException("\"\" is not a valid number.");
        }
        if (string.length() == 1 && !Character.isDigit(string.charAt(0))) {
            throw new NumberFormatException(string + " is not a valid number.");
        }
        if (string.startsWith("--")) {
            return null;
        }
        if (string.startsWith("0x") || string.startsWith("-0x")) {
            return NumberUtils.createInteger(string);
        }
        char c = string.charAt(string.length() - 1);
        int n = string.indexOf(46);
        int n2 = string.indexOf(101) + string.indexOf(69) + 1;
        if (n > -1) {
            if (n2 > -1) {
                if (n2 < n) {
                    throw new NumberFormatException(string + " is not a valid number.");
                }
                string3 = string.substring(n + 1, n2);
            } else {
                string3 = string.substring(n + 1);
            }
            string2 = string.substring(0, n);
        } else {
            string2 = n2 > -1 ? string.substring(0, n2) : string;
            string3 = null;
        }
        if (!Character.isDigit(c)) {
            String string4 = n2 > -1 && n2 < string.length() - 1 ? string.substring(n2 + 1, string.length() - 1) : null;
            String string5 = string.substring(0, string.length() - 1);
            boolean bl = NumberUtils.isAllZeros(string2) && NumberUtils.isAllZeros(string4);
            switch (c) {
                case 'L': 
                case 'l': {
                    if (string3 == null && string4 == null && (string5.charAt(0) == '-' && NumberUtils.isDigits(string5.substring(1)) || NumberUtils.isDigits(string5))) {
                        try {
                            return NumberUtils.createLong(string5);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return NumberUtils.createBigInteger(string5);
                        }
                    }
                    throw new NumberFormatException(string + " is not a valid number.");
                }
                case 'F': 
                case 'f': {
                    Number number2;
                    try {
                        number2 = NumberUtils.createFloat(string5);
                        if (!((Float)number2).isInfinite() && (((Float)number2).floatValue() != 0.0f || bl)) {
                            return number2;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                case 'D': 
                case 'd': {
                    Number number2;
                    try {
                        number2 = NumberUtils.createDouble(string5);
                        if (!((Double)number2).isInfinite() && ((double)((Double)number2).floatValue() != 0.0 || bl)) {
                            return number2;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        return NumberUtils.createBigDecimal(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            throw new NumberFormatException(string + " is not a valid number.");
        }
        String string6 = n2 > -1 && n2 < string.length() - 1 ? string.substring(n2 + 1, string.length()) : null;
        if (string3 == null && string6 == null) {
            try {
                return NumberUtils.createInteger(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return NumberUtils.createLong(string);
                }
                catch (NumberFormatException numberFormatException2) {
                    return NumberUtils.createBigInteger(string);
                }
            }
        }
        boolean bl = NumberUtils.isAllZeros(string2) && NumberUtils.isAllZeros(string6);
        try {
            number = NumberUtils.createFloat(string);
            if (!((Float)number).isInfinite() && (((Float)number).floatValue() != 0.0f || bl)) {
                return number;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            number = NumberUtils.createDouble(string);
            if (!((Double)number).isInfinite() && ((Double)number != 0.0 || bl)) {
                return number;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return NumberUtils.createBigDecimal(string);
    }

    private static boolean isAllZeros(String string) {
        if (string == null) {
            return true;
        }
        for (int i = string.length() - 1; i >= 0; --i) {
            if (string.charAt(i) == '0') continue;
            return false;
        }
        return string.length() > 0;
    }

    public static Float createFloat(String string) {
        return Float.valueOf(string);
    }

    public static Double createDouble(String string) {
        return Double.valueOf(string);
    }

    public static Integer createInteger(String string) {
        return Integer.decode(string);
    }

    public static Long createLong(String string) {
        return Long.valueOf(string);
    }

    public static BigInteger createBigInteger(String string) {
        BigInteger bigInteger = new BigInteger(string);
        return bigInteger;
    }

    public static BigDecimal createBigDecimal(String string) {
        BigDecimal bigDecimal = new BigDecimal(string);
        return bigDecimal;
    }

    public static long minimum(long l, long l2, long l3) {
        if (l2 < l) {
            l = l2;
        }
        if (l3 < l) {
            l = l3;
        }
        return l;
    }

    public static int minimum(int n, int n2, int n3) {
        if (n2 < n) {
            n = n2;
        }
        if (n3 < n) {
            n = n3;
        }
        return n;
    }

    public static long maximum(long l, long l2, long l3) {
        if (l2 > l) {
            l = l2;
        }
        if (l3 > l) {
            l = l3;
        }
        return l;
    }

    public static int maximum(int n, int n2, int n3) {
        if (n2 > n) {
            n = n2;
        }
        if (n3 > n) {
            n = n3;
        }
        return n;
    }

    public static int compare(double d, double d2) {
        long l;
        if (d < d2) {
            return -1;
        }
        if (d > d2) {
            return 1;
        }
        long l2 = Double.doubleToLongBits(d);
        if (l2 == (l = Double.doubleToLongBits(d2))) {
            return 0;
        }
        if (l2 < l) {
            return -1;
        }
        return 1;
    }

    public static int compare(float f, float f2) {
        int n;
        if (f < f2) {
            return -1;
        }
        if (f > f2) {
            return 1;
        }
        int n2 = Float.floatToIntBits(f);
        if (n2 == (n = Float.floatToIntBits(f2))) {
            return 0;
        }
        if (n2 < n) {
            return -1;
        }
        return 1;
    }

    public static boolean isDigits(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(String string) {
        int n;
        int n2;
        if (StringUtils.isEmpty(string)) {
            return false;
        }
        char[] cArray = string.toCharArray();
        int n3 = cArray.length;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n4 = n2 = cArray[0] == '-' ? 1 : 0;
        if (n3 > n2 + 1 && cArray[n2] == '0' && cArray[n2 + 1] == 'x') {
            int n5 = n2 + 2;
            if (n5 == n3) {
                return false;
            }
            while (n5 < cArray.length) {
                if (!(cArray[n5] >= '0' && cArray[n5] <= '9' || cArray[n5] >= 'a' && cArray[n5] <= 'f' || cArray[n5] >= 'A' && cArray[n5] <= 'F')) {
                    return false;
                }
                ++n5;
            }
            return true;
        }
        --n3;
        for (n = n2; n < n3 || n < n3 + 1 && bl3 && !bl4; ++n) {
            if (cArray[n] >= '0' && cArray[n] <= '9') {
                bl4 = true;
                bl3 = false;
                continue;
            }
            if (cArray[n] == '.') {
                if (bl2 || bl) {
                    return false;
                }
                bl2 = true;
                continue;
            }
            if (cArray[n] == 'e' || cArray[n] == 'E') {
                if (bl) {
                    return false;
                }
                if (!bl4) {
                    return false;
                }
                bl = true;
                bl3 = true;
                continue;
            }
            if (cArray[n] == '+' || cArray[n] == '-') {
                if (!bl3) {
                    return false;
                }
                bl3 = false;
                bl4 = false;
                continue;
            }
            return false;
        }
        if (n < cArray.length) {
            if (cArray[n] >= '0' && cArray[n] <= '9') {
                return true;
            }
            if (cArray[n] == 'e' || cArray[n] == 'E') {
                return false;
            }
            if (!(bl3 || cArray[n] != 'd' && cArray[n] != 'D' && cArray[n] != 'f' && cArray[n] != 'F')) {
                return bl4;
            }
            if (cArray[n] == 'l' || cArray[n] == 'L') {
                return bl4 && !bl;
            }
            return false;
        }
        return !bl3 && bl4;
    }
}

