/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import org.apache.commons.lang.text.StrBuilder;

public final class NumberRange {
    private final Number min;
    private final Number max;

    public NumberRange(Number number) {
        if (number == null) {
            throw new NullPointerException("The number must not be null");
        }
        this.min = number;
        this.max = number;
    }

    public NumberRange(Number number, Number number2) {
        if (number == null) {
            throw new NullPointerException("The minimum value must not be null");
        }
        if (number2 == null) {
            throw new NullPointerException("The maximum value must not be null");
        }
        if (number2.doubleValue() < number.doubleValue()) {
            this.min = this.max = number;
        } else {
            this.min = number;
            this.max = number2;
        }
    }

    public Number getMinimum() {
        return this.min;
    }

    public Number getMaximum() {
        return this.max;
    }

    public boolean includesNumber(Number number) {
        if (number == null) {
            return false;
        }
        return !(this.min.doubleValue() > number.doubleValue()) && !(this.max.doubleValue() < number.doubleValue());
    }

    public boolean includesRange(NumberRange numberRange) {
        if (numberRange == null) {
            return false;
        }
        return this.includesNumber(numberRange.min) && this.includesNumber(numberRange.max);
    }

    public boolean overlaps(NumberRange numberRange) {
        if (numberRange == null) {
            return false;
        }
        return numberRange.includesNumber(this.min) || numberRange.includesNumber(this.max) || this.includesRange(numberRange);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NumberRange)) {
            return false;
        }
        NumberRange numberRange = (NumberRange)object;
        return this.min.equals(numberRange.min) && this.max.equals(numberRange.max);
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.min.hashCode();
        n = 37 * n + this.max.hashCode();
        return n;
    }

    public String toString() {
        StrBuilder strBuilder = new StrBuilder();
        if (this.min.doubleValue() < 0.0) {
            strBuilder.append('(').append(this.min).append(')');
        } else {
            strBuilder.append(this.min);
        }
        strBuilder.append('-');
        if (this.max.doubleValue() < 0.0) {
            strBuilder.append('(').append(this.max).append(')');
        } else {
            strBuilder.append(this.max);
        }
        return strBuilder.toString();
    }
}

