/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.set;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import org.apache.commons.collections.Unmodifiable;
import org.apache.commons.collections.iterators.UnmodifiableIterator;
import org.apache.commons.collections.set.AbstractSortedSetDecorator;

public final class UnmodifiableSortedSet
extends AbstractSortedSetDecorator
implements Serializable,
Unmodifiable {
    private static final long serialVersionUID = -725356885467962424L;

    public static SortedSet decorate(SortedSet sortedSet) {
        if (sortedSet instanceof Unmodifiable) {
            return sortedSet;
        }
        return new UnmodifiableSortedSet(sortedSet);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.collection);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.collection = (Collection)objectInputStream.readObject();
    }

    private UnmodifiableSortedSet(SortedSet sortedSet) {
        super(sortedSet);
    }

    public Iterator iterator() {
        return UnmodifiableIterator.decorate(this.getCollection().iterator());
    }

    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public SortedSet subSet(Object object, Object object2) {
        SortedSet<Object> sortedSet = this.getSortedSet().subSet(object, object2);
        return new UnmodifiableSortedSet(sortedSet);
    }

    public SortedSet headSet(Object object) {
        SortedSet<Object> sortedSet = this.getSortedSet().headSet(object);
        return new UnmodifiableSortedSet(sortedSet);
    }

    public SortedSet tailSet(Object object) {
        SortedSet<Object> sortedSet = this.getSortedSet().tailSet(object);
        return new UnmodifiableSortedSet(sortedSet);
    }
}

