/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.set;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class MapBackedSet
implements Serializable,
Set {
    private static final long serialVersionUID = 6723912213766056587L;
    protected final Map map;
    protected final Object dummyValue;

    public static Set decorate(Map map) {
        return MapBackedSet.decorate(map, null);
    }

    public static Set decorate(Map map, Object object) {
        if (map == null) {
            throw new IllegalArgumentException("The map must not be null");
        }
        return new MapBackedSet(map, object);
    }

    private MapBackedSet(Map map, Object object) {
        this.map = map;
        this.dummyValue = object;
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Iterator iterator() {
        return this.map.keySet().iterator();
    }

    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    public boolean containsAll(Collection collection) {
        return this.map.keySet().containsAll(collection);
    }

    public boolean add(Object object) {
        int n = this.map.size();
        this.map.put(object, this.dummyValue);
        return this.map.size() != n;
    }

    public boolean addAll(Collection collection) {
        int n = this.map.size();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.map.put(e, this.dummyValue);
        }
        return this.map.size() != n;
    }

    public boolean remove(Object object) {
        int n = this.map.size();
        this.map.remove(object);
        return this.map.size() != n;
    }

    public boolean removeAll(Collection collection) {
        return this.map.keySet().removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.map.keySet().retainAll(collection);
    }

    public void clear() {
        this.map.clear();
    }

    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.map.keySet().toArray(objectArray);
    }

    public boolean equals(Object object) {
        return ((Object)this.map.keySet()).equals(object);
    }

    public int hashCode() {
        return ((Object)this.map.keySet()).hashCode();
    }
}

