/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.set;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.collection.CompositeCollection;

public class CompositeSet
extends CompositeCollection
implements Set {
    public CompositeSet() {
    }

    public CompositeSet(Set set) {
        super(set);
    }

    public CompositeSet(Set[] setArray) {
        super(setArray);
    }

    public synchronized void addComposited(Collection collection) {
        if (!(collection instanceof Set)) {
            throw new IllegalArgumentException("Collections added must implement java.util.Set");
        }
        Iterator iterator = this.getCollections().iterator();
        while (iterator.hasNext()) {
            Set set = (Set)iterator.next();
            Collection collection2 = CollectionUtils.intersection(set, collection);
            if (collection2.size() <= 0) continue;
            if (this.mutator == null) {
                throw new UnsupportedOperationException("Collision adding composited collection with no SetMutator set");
            }
            if (!(this.mutator instanceof SetMutator)) {
                throw new UnsupportedOperationException("Collision adding composited collection to a CompositeSet with a CollectionMutator instead of a SetMutator");
            }
            ((SetMutator)this.mutator).resolveCollision(this, set, (Set)collection, collection2);
            if (CollectionUtils.intersection(set, collection).size() <= 0) continue;
            throw new IllegalArgumentException("Attempt to add illegal entry unresolved by SetMutator.resolveCollision()");
        }
        super.addComposited(new Collection[]{collection});
    }

    public synchronized void addComposited(Collection collection, Collection collection2) {
        if (!(collection instanceof Set)) {
            throw new IllegalArgumentException("Argument must implement java.util.Set");
        }
        if (!(collection2 instanceof Set)) {
            throw new IllegalArgumentException("Argument must implement java.util.Set");
        }
        this.addComposited(new Set[]{(Set)collection, (Set)collection2});
    }

    public synchronized void addComposited(Collection[] collectionArray) {
        for (int i = collectionArray.length - 1; i >= 0; --i) {
            this.addComposited(collectionArray[i]);
        }
    }

    public void setMutator(CompositeCollection.CollectionMutator collectionMutator) {
        super.setMutator(collectionMutator);
    }

    public boolean remove(Object object) {
        Iterator iterator = this.getCollections().iterator();
        while (iterator.hasNext()) {
            Set set = (Set)iterator.next();
            if (!set.contains(object)) continue;
            return set.remove(object);
        }
        return false;
    }

    public boolean equals(Object object) {
        Set set;
        return object instanceof Set && (set = (Set)object).containsAll(this) && set.size() == this.size();
    }

    public int hashCode() {
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            n += e != null ? e.hashCode() : 0;
        }
        return n;
    }

    public static interface SetMutator
    extends CompositeCollection.CollectionMutator {
        public void resolveCollision(CompositeSet var1, Set var2, Set var3, Collection var4);
    }
}

