/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.commons.collections.Unmodifiable;
import org.apache.commons.collections.collection.UnmodifiableCollection;
import org.apache.commons.collections.map.AbstractSortedMapDecorator;
import org.apache.commons.collections.map.UnmodifiableEntrySet;
import org.apache.commons.collections.set.UnmodifiableSet;

public final class UnmodifiableSortedMap
extends AbstractSortedMapDecorator
implements Serializable,
Unmodifiable {
    private static final long serialVersionUID = 5805344239827376360L;

    public static SortedMap decorate(SortedMap sortedMap) {
        if (sortedMap instanceof Unmodifiable) {
            return sortedMap;
        }
        return new UnmodifiableSortedMap(sortedMap);
    }

    private UnmodifiableSortedMap(SortedMap sortedMap) {
        super(sortedMap);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.map);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.map = (Map)objectInputStream.readObject();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object put(Object object, Object object2) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map map) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object object) {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        Set set = super.entrySet();
        return UnmodifiableEntrySet.decorate(set);
    }

    public Set keySet() {
        Set set = super.keySet();
        return UnmodifiableSet.decorate(set);
    }

    public Collection values() {
        Collection collection = super.values();
        return UnmodifiableCollection.decorate(collection);
    }

    public Object firstKey() {
        return this.getSortedMap().firstKey();
    }

    public Object lastKey() {
        return this.getSortedMap().lastKey();
    }

    public Comparator comparator() {
        return this.getSortedMap().comparator();
    }

    public SortedMap subMap(Object object, Object object2) {
        SortedMap sortedMap = this.getSortedMap().subMap(object, object2);
        return new UnmodifiableSortedMap(sortedMap);
    }

    public SortedMap headMap(Object object) {
        SortedMap sortedMap = this.getSortedMap().headMap(object);
        return new UnmodifiableSortedMap(sortedMap);
    }

    public SortedMap tailMap(Object object) {
        SortedMap sortedMap = this.getSortedMap().tailMap(object);
        return new UnmodifiableSortedMap(sortedMap);
    }
}

