/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.OrderedMapIterator;
import org.apache.commons.collections.Unmodifiable;
import org.apache.commons.collections.collection.UnmodifiableCollection;
import org.apache.commons.collections.iterators.UnmodifiableMapIterator;
import org.apache.commons.collections.iterators.UnmodifiableOrderedMapIterator;
import org.apache.commons.collections.map.AbstractOrderedMapDecorator;
import org.apache.commons.collections.map.UnmodifiableEntrySet;
import org.apache.commons.collections.set.UnmodifiableSet;

public final class UnmodifiableOrderedMap
extends AbstractOrderedMapDecorator
implements Serializable,
Unmodifiable {
    private static final long serialVersionUID = 8136428161720526266L;

    public static OrderedMap decorate(OrderedMap orderedMap) {
        if (orderedMap instanceof Unmodifiable) {
            return orderedMap;
        }
        return new UnmodifiableOrderedMap(orderedMap);
    }

    private UnmodifiableOrderedMap(OrderedMap orderedMap) {
        super(orderedMap);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.map);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.map = (Map)objectInputStream.readObject();
    }

    public MapIterator mapIterator() {
        MapIterator mapIterator = this.getOrderedMap().mapIterator();
        return UnmodifiableMapIterator.decorate(mapIterator);
    }

    public OrderedMapIterator orderedMapIterator() {
        OrderedMapIterator orderedMapIterator = this.getOrderedMap().orderedMapIterator();
        return UnmodifiableOrderedMapIterator.decorate(orderedMapIterator);
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object put(Object object, Object object2) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map map) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object object) {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        Set set = super.entrySet();
        return UnmodifiableEntrySet.decorate(set);
    }

    public Set keySet() {
        Set set = super.keySet();
        return UnmodifiableSet.decorate(set);
    }

    public Collection values() {
        Collection collection = super.values();
        return UnmodifiableCollection.decorate(collection);
    }
}

