/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.TransformedMap;

public class TransformedSortedMap
extends TransformedMap
implements SortedMap {
    private static final long serialVersionUID = -8751771676410385778L;

    public static SortedMap decorate(SortedMap sortedMap, Transformer transformer, Transformer transformer2) {
        return new TransformedSortedMap(sortedMap, transformer, transformer2);
    }

    public static SortedMap decorateTransform(SortedMap sortedMap, Transformer transformer, Transformer transformer2) {
        TransformedSortedMap transformedSortedMap = new TransformedSortedMap(sortedMap, transformer, transformer2);
        if (sortedMap.size() > 0) {
            Map map = transformedSortedMap.transformMap(sortedMap);
            transformedSortedMap.clear();
            transformedSortedMap.getMap().putAll(map);
        }
        return transformedSortedMap;
    }

    protected TransformedSortedMap(SortedMap sortedMap, Transformer transformer, Transformer transformer2) {
        super(sortedMap, transformer, transformer2);
    }

    protected SortedMap getSortedMap() {
        return (SortedMap)this.map;
    }

    public Object firstKey() {
        return this.getSortedMap().firstKey();
    }

    public Object lastKey() {
        return this.getSortedMap().lastKey();
    }

    public Comparator comparator() {
        return this.getSortedMap().comparator();
    }

    public SortedMap subMap(Object object, Object object2) {
        SortedMap sortedMap = this.getSortedMap().subMap(object, object2);
        return new TransformedSortedMap(sortedMap, this.keyTransformer, this.valueTransformer);
    }

    public SortedMap headMap(Object object) {
        SortedMap sortedMap = this.getSortedMap().headMap(object);
        return new TransformedSortedMap(sortedMap, this.keyTransformer, this.valueTransformer);
    }

    public SortedMap tailMap(Object object) {
        SortedMap sortedMap = this.getSortedMap().tailMap(object);
        return new TransformedSortedMap(sortedMap, this.keyTransformer, this.valueTransformer);
    }
}

