/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.AbstractInputCheckedMapDecorator;
import org.apache.commons.collections.map.LinkedMap;

public class TransformedMap
extends AbstractInputCheckedMapDecorator
implements Serializable {
    private static final long serialVersionUID = 7023152376788900464L;
    protected final Transformer keyTransformer;
    protected final Transformer valueTransformer;

    public static Map decorate(Map map, Transformer transformer, Transformer transformer2) {
        return new TransformedMap(map, transformer, transformer2);
    }

    public static Map decorateTransform(Map map, Transformer transformer, Transformer transformer2) {
        TransformedMap transformedMap = new TransformedMap(map, transformer, transformer2);
        if (map.size() > 0) {
            Map map2 = transformedMap.transformMap(map);
            transformedMap.clear();
            transformedMap.getMap().putAll(map2);
        }
        return transformedMap;
    }

    protected TransformedMap(Map map, Transformer transformer, Transformer transformer2) {
        super(map);
        this.keyTransformer = transformer;
        this.valueTransformer = transformer2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.map);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.map = (Map)objectInputStream.readObject();
    }

    protected Object transformKey(Object object) {
        if (this.keyTransformer == null) {
            return object;
        }
        return this.keyTransformer.transform(object);
    }

    protected Object transformValue(Object object) {
        if (this.valueTransformer == null) {
            return object;
        }
        return this.valueTransformer.transform(object);
    }

    protected Map transformMap(Map map) {
        if (map.isEmpty()) {
            return map;
        }
        LinkedMap linkedMap = new LinkedMap(map.size());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            linkedMap.put(this.transformKey(entry.getKey()), this.transformValue(entry.getValue()));
        }
        return linkedMap;
    }

    protected Object checkSetValue(Object object) {
        return this.valueTransformer.transform(object);
    }

    protected boolean isSetValueChecking() {
        return this.valueTransformer != null;
    }

    public Object put(Object object, Object object2) {
        object = this.transformKey(object);
        object2 = this.transformValue(object2);
        return this.getMap().put(object, object2);
    }

    public void putAll(Map map) {
        map = this.transformMap(map);
        this.getMap().putAll(map);
    }
}

