/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.KeyValue;

public final class StaticBucketMap
implements Map {
    private static final int DEFAULT_BUCKETS = 255;
    private Node[] buckets;
    private Lock[] locks;

    public StaticBucketMap() {
        this(255);
    }

    public StaticBucketMap(int n) {
        int n2 = Math.max(17, n);
        if (n2 % 2 == 0) {
            --n2;
        }
        this.buckets = new Node[n2];
        this.locks = new Lock[n2];
        for (int i = 0; i < n2; ++i) {
            this.locks[i] = new Lock(null);
        }
    }

    private final int getHash(Object object) {
        if (object == null) {
            return 0;
        }
        int n = object.hashCode();
        n += ~(n << 15);
        n ^= n >>> 10;
        n += n << 3;
        n ^= n >>> 6;
        n += ~(n << 11);
        n ^= n >>> 16;
        return (n %= this.buckets.length) < 0 ? n * -1 : n;
    }

    public int size() {
        int n = 0;
        for (int i = 0; i < this.buckets.length; ++i) {
            n += this.locks[i].size;
        }
        return n;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) {
        int n = this.getHash(object);
        Lock lock = this.locks[n];
        synchronized (lock) {
            Node node = this.buckets[n];
            while (node != null) {
                if (node.key == object || node.key != null && node.key.equals(object)) {
                    return node.value;
                }
                node = node.next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object object) {
        int n = this.getHash(object);
        Lock lock = this.locks[n];
        synchronized (lock) {
            Node node = this.buckets[n];
            while (node != null) {
                if (node.key == object || node.key != null && node.key.equals(object)) {
                    return true;
                }
                node = node.next;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object object) {
        for (int i = 0; i < this.buckets.length; ++i) {
            Lock lock = this.locks[i];
            synchronized (lock) {
                Node node = this.buckets[i];
                while (node != null) {
                    if (node.value == object || node.value != null && node.value.equals(object)) {
                        return true;
                    }
                    node = node.next;
                }
                continue;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2) {
        int n = this.getHash(object);
        Lock lock = this.locks[n];
        synchronized (lock) {
            Node node = this.buckets[n];
            if (node == null) {
                node = new Node(null);
                node.key = object;
                node.value = object2;
                this.buckets[n] = node;
                ++this.locks[n].size;
                return null;
            }
            Node node2 = node;
            while (node2 != null) {
                node = node2;
                if (node.key == object || node.key != null && node.key.equals(object)) {
                    Object object3 = node.value;
                    node.value = object2;
                    return object3;
                }
                node2 = node2.next;
            }
            node2 = new Node(null);
            node2.key = object;
            node2.value = object2;
            node.next = node2;
            ++this.locks[n].size;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object object) {
        int n = this.getHash(object);
        Lock lock = this.locks[n];
        synchronized (lock) {
            Node node = this.buckets[n];
            Node node2 = null;
            while (node != null) {
                if (node.key == object || node.key != null && node.key.equals(object)) {
                    if (null == node2) {
                        this.buckets[n] = node.next;
                    } else {
                        node2.next = node.next;
                    }
                    --this.locks[n].size;
                    return node.value;
                }
                node2 = node;
                node = node.next;
            }
        }
        return null;
    }

    public Set keySet() {
        return new KeySet(this, null);
    }

    public Collection values() {
        return new Values(this, null);
    }

    public Set entrySet() {
        return new EntrySet(this, null);
    }

    public void putAll(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            this.put(k, map.get(k));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        for (int i = 0; i < this.buckets.length; ++i) {
            Lock lock;
            Lock lock2 = lock = this.locks[i];
            synchronized (lock2) {
                this.buckets[i] = null;
                lock.size = 0;
                continue;
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        return ((Object)this.entrySet()).equals(map.entrySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.buckets.length; ++i) {
            Lock lock = this.locks[i];
            synchronized (lock) {
                Node node = this.buckets[i];
                while (node != null) {
                    n += node.hashCode();
                    node = node.next;
                }
                continue;
            }
        }
        return n;
    }

    public void atomic(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        this.atomic(runnable, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atomic(Runnable runnable, int n) {
        if (n >= this.buckets.length) {
            runnable.run();
            return;
        }
        Lock lock = this.locks[n];
        synchronized (lock) {
            this.atomic(runnable, n + 1);
        }
    }

    static Node[] access$500(StaticBucketMap staticBucketMap) {
        return staticBucketMap.buckets;
    }

    static Lock[] access$600(StaticBucketMap staticBucketMap) {
        return staticBucketMap.locks;
    }

    static int access$800(StaticBucketMap staticBucketMap, Object object) {
        return staticBucketMap.getHash(object);
    }

    static class 1 {
    }

    private class Values
    extends AbstractCollection {
        private final StaticBucketMap this$0;

        private Values(StaticBucketMap staticBucketMap) {
            this.this$0 = staticBucketMap;
        }

        public int size() {
            return this.this$0.size();
        }

        public void clear() {
            this.this$0.clear();
        }

        public Iterator iterator() {
            return new ValueIterator(this.this$0, null);
        }

        Values(StaticBucketMap staticBucketMap, 1 var2_2) {
            this(staticBucketMap);
        }
    }

    private class KeySet
    extends AbstractSet {
        private final StaticBucketMap this$0;

        private KeySet(StaticBucketMap staticBucketMap) {
            this.this$0 = staticBucketMap;
        }

        public int size() {
            return this.this$0.size();
        }

        public void clear() {
            this.this$0.clear();
        }

        public Iterator iterator() {
            return new KeyIterator(this.this$0, null);
        }

        public boolean contains(Object object) {
            return this.this$0.containsKey(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object object) {
            int n = StaticBucketMap.access$800(this.this$0, object);
            Lock lock = StaticBucketMap.access$600(this.this$0)[n];
            synchronized (lock) {
                Node node = StaticBucketMap.access$500(this.this$0)[n];
                while (node != null) {
                    Object object2 = node.getKey();
                    if (object2 == object || object2 != null && object2.equals(object)) {
                        this.this$0.remove(object2);
                        return true;
                    }
                    node = node.next;
                }
            }
            return false;
        }

        KeySet(StaticBucketMap staticBucketMap, 1 var2_2) {
            this(staticBucketMap);
        }
    }

    private class EntrySet
    extends AbstractSet {
        private final StaticBucketMap this$0;

        private EntrySet(StaticBucketMap staticBucketMap) {
            this.this$0 = staticBucketMap;
        }

        public int size() {
            return this.this$0.size();
        }

        public void clear() {
            this.this$0.clear();
        }

        public Iterator iterator() {
            return new EntryIterator(this.this$0, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Object object) {
            Map.Entry entry = (Map.Entry)object;
            int n = StaticBucketMap.access$800(this.this$0, entry.getKey());
            Lock lock = StaticBucketMap.access$600(this.this$0)[n];
            synchronized (lock) {
                Node node = StaticBucketMap.access$500(this.this$0)[n];
                while (node != null) {
                    if (node.equals(entry)) {
                        return true;
                    }
                    node = node.next;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            int n = StaticBucketMap.access$800(this.this$0, entry.getKey());
            Lock lock = StaticBucketMap.access$600(this.this$0)[n];
            synchronized (lock) {
                Node node = StaticBucketMap.access$500(this.this$0)[n];
                while (node != null) {
                    if (node.equals(entry)) {
                        this.this$0.remove(node.getKey());
                        return true;
                    }
                    node = node.next;
                }
            }
            return false;
        }

        EntrySet(StaticBucketMap staticBucketMap, 1 var2_2) {
            this(staticBucketMap);
        }
    }

    private class KeyIterator
    extends EntryIterator {
        private final StaticBucketMap this$0;

        private KeyIterator(StaticBucketMap staticBucketMap) {
            super(staticBucketMap, null);
            this.this$0 = staticBucketMap;
        }

        public Object next() {
            return this.nextEntry().getKey();
        }

        KeyIterator(StaticBucketMap staticBucketMap, 1 var2_2) {
            this(staticBucketMap);
        }
    }

    private class ValueIterator
    extends EntryIterator {
        private final StaticBucketMap this$0;

        private ValueIterator(StaticBucketMap staticBucketMap) {
            super(staticBucketMap, null);
            this.this$0 = staticBucketMap;
        }

        public Object next() {
            return this.nextEntry().getValue();
        }

        ValueIterator(StaticBucketMap staticBucketMap, 1 var2_2) {
            this(staticBucketMap);
        }
    }

    private class EntryIterator
    implements Iterator {
        private ArrayList current;
        private int bucket;
        private Map.Entry last;
        private final StaticBucketMap this$0;

        private EntryIterator(StaticBucketMap staticBucketMap) {
            this.this$0 = staticBucketMap;
            this.current = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            if (this.current.size() > 0) {
                return true;
            }
            while (this.bucket < StaticBucketMap.access$500(this.this$0).length) {
                Lock lock = StaticBucketMap.access$600(this.this$0)[this.bucket];
                synchronized (lock) {
                    Node node = StaticBucketMap.access$500(this.this$0)[this.bucket];
                    while (node != null) {
                        this.current.add(node);
                        node = node.next;
                    }
                    ++this.bucket;
                    if (this.current.size() > 0) {
                        return true;
                    }
                }
            }
            return false;
        }

        protected Map.Entry nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = (Map.Entry)this.current.remove(this.current.size() - 1);
            return this.last;
        }

        public Object next() {
            return this.nextEntry();
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.this$0.remove(this.last.getKey());
            this.last = null;
        }

        EntryIterator(StaticBucketMap staticBucketMap, 1 var2_2) {
            this(staticBucketMap);
        }
    }

    private static final class Lock {
        public int size;

        private Lock() {
        }

        Lock(1 var1_1) {
            this();
        }
    }

    private static final class Node
    implements Map.Entry,
    KeyValue {
        protected Object key;
        protected Object value;
        protected Node next;

        private Node() {
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        Node(1 var1_1) {
            this();
        }
    }
}

