/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.BoundedMap;
import org.apache.commons.collections.KeyValue;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.OrderedMapIterator;
import org.apache.commons.collections.ResettableIterator;
import org.apache.commons.collections.iterators.SingletonIterator;
import org.apache.commons.collections.keyvalue.TiedMapEntry;

public class SingletonMap
implements Serializable,
Cloneable,
BoundedMap,
KeyValue,
OrderedMap {
    private static final long serialVersionUID = -8931271118676803261L;
    private final Object key;
    private Object value;

    public SingletonMap() {
        this.key = null;
    }

    public SingletonMap(Object object, Object object2) {
        this.key = object;
        this.value = object2;
    }

    public SingletonMap(KeyValue keyValue) {
        this.key = keyValue.getKey();
        this.value = keyValue.getValue();
    }

    public SingletonMap(Map.Entry entry) {
        this.key = entry.getKey();
        this.value = entry.getValue();
    }

    public SingletonMap(Map map) {
        if (map.size() != 1) {
            throw new IllegalArgumentException("The map size must be 1");
        }
        Map.Entry entry = map.entrySet().iterator().next();
        this.key = entry.getKey();
        this.value = entry.getValue();
    }

    public Object getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public Object setValue(Object object) {
        Object object2 = this.value;
        this.value = object;
        return object2;
    }

    public boolean isFull() {
        return true;
    }

    public int maxSize() {
        return 1;
    }

    public Object get(Object object) {
        if (this.isEqualKey(object)) {
            return this.value;
        }
        return null;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean containsKey(Object object) {
        return this.isEqualKey(object);
    }

    public boolean containsValue(Object object) {
        return this.isEqualValue(object);
    }

    public Object put(Object object, Object object2) {
        if (this.isEqualKey(object)) {
            return this.setValue(object2);
        }
        throw new IllegalArgumentException("Cannot put new key/value pair - Map is fixed size singleton");
    }

    public void putAll(Map map) {
        switch (map.size()) {
            case 0: {
                return;
            }
            case 1: {
                Map.Entry entry = map.entrySet().iterator().next();
                this.put(entry.getKey(), entry.getValue());
                return;
            }
        }
        throw new IllegalArgumentException("The map size must be 0 or 1");
    }

    public Object remove(Object object) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        TiedMapEntry tiedMapEntry = new TiedMapEntry(this, this.getKey());
        return Collections.singleton(tiedMapEntry);
    }

    public Set keySet() {
        return Collections.singleton(this.key);
    }

    public Collection values() {
        return new SingletonValues(this);
    }

    public MapIterator mapIterator() {
        return new SingletonMapIterator(this);
    }

    public OrderedMapIterator orderedMapIterator() {
        return new SingletonMapIterator(this);
    }

    public Object firstKey() {
        return this.getKey();
    }

    public Object lastKey() {
        return this.getKey();
    }

    public Object nextKey(Object object) {
        return null;
    }

    public Object previousKey(Object object) {
        return null;
    }

    protected boolean isEqualKey(Object object) {
        return object == null ? this.getKey() == null : object.equals(this.getKey());
    }

    protected boolean isEqualValue(Object object) {
        return object == null ? this.getValue() == null : object.equals(this.getValue());
    }

    public Object clone() {
        try {
            SingletonMap singletonMap = (SingletonMap)super.clone();
            return singletonMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (map.size() != 1) {
            return false;
        }
        Map.Entry entry = map.entrySet().iterator().next();
        return this.isEqualKey(entry.getKey()) && this.isEqualValue(entry.getValue());
    }

    public int hashCode() {
        return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
    }

    public String toString() {
        return new StringBuffer(128).append('{').append(this.getKey() == this ? "(this Map)" : this.getKey()).append('=').append(this.getValue() == this ? "(this Map)" : this.getValue()).append('}').toString();
    }

    static class SingletonValues
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = -3689524741863047872L;
        private final SingletonMap parent;

        SingletonValues(SingletonMap singletonMap) {
            this.parent = singletonMap;
        }

        public int size() {
            return 1;
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean contains(Object object) {
            return this.parent.containsValue(object);
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Iterator iterator() {
            return new SingletonIterator(this.parent.getValue(), false);
        }
    }

    static class SingletonMapIterator
    implements OrderedMapIterator,
    ResettableIterator {
        private final SingletonMap parent;
        private boolean hasNext = true;
        private boolean canGetSet = false;

        SingletonMapIterator(SingletonMap singletonMap) {
            this.parent = singletonMap;
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public Object next() {
            if (!this.hasNext) {
                throw new NoSuchElementException("No next() entry in the iteration");
            }
            this.hasNext = false;
            this.canGetSet = true;
            return this.parent.getKey();
        }

        public boolean hasPrevious() {
            return !this.hasNext;
        }

        public Object previous() {
            if (this.hasNext) {
                throw new NoSuchElementException("No previous() entry in the iteration");
            }
            this.hasNext = true;
            return this.parent.getKey();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Object getKey() {
            if (!this.canGetSet) {
                throw new IllegalStateException("getKey() can only be called after next() and before remove()");
            }
            return this.parent.getKey();
        }

        public Object getValue() {
            if (!this.canGetSet) {
                throw new IllegalStateException("getValue() can only be called after next() and before remove()");
            }
            return this.parent.getValue();
        }

        public Object setValue(Object object) {
            if (!this.canGetSet) {
                throw new IllegalStateException("setValue() can only be called after next() and before remove()");
            }
            return this.parent.setValue(object);
        }

        public void reset() {
            this.hasNext = true;
        }

        public String toString() {
            if (this.hasNext) {
                return "Iterator[]";
            }
            return "Iterator[" + this.getKey() + "=" + this.getValue() + "]";
        }
    }
}

