/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.map.AbstractInputCheckedMapDecorator;

public class PredicatedMap
extends AbstractInputCheckedMapDecorator
implements Serializable {
    private static final long serialVersionUID = 7412622456128415156L;
    protected final Predicate keyPredicate;
    protected final Predicate valuePredicate;

    public static Map decorate(Map map, Predicate predicate, Predicate predicate2) {
        return new PredicatedMap(map, predicate, predicate2);
    }

    protected PredicatedMap(Map map, Predicate predicate, Predicate predicate2) {
        super(map);
        this.keyPredicate = predicate;
        this.valuePredicate = predicate2;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            this.validate(k, v);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.map);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.map = (Map)objectInputStream.readObject();
    }

    protected void validate(Object object, Object object2) {
        if (this.keyPredicate != null && !this.keyPredicate.evaluate(object)) {
            throw new IllegalArgumentException("Cannot add key - Predicate rejected it");
        }
        if (this.valuePredicate != null && !this.valuePredicate.evaluate(object2)) {
            throw new IllegalArgumentException("Cannot add value - Predicate rejected it");
        }
    }

    protected Object checkSetValue(Object object) {
        if (!this.valuePredicate.evaluate(object)) {
            throw new IllegalArgumentException("Cannot set value - Predicate rejected it");
        }
        return object;
    }

    protected boolean isSetValueChecking() {
        return this.valuePredicate != null;
    }

    public Object put(Object object, Object object2) {
        this.validate(object, object2);
        return this.map.put(object, object2);
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            this.validate(k, v);
        }
        this.map.putAll(map);
    }
}

